/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.util;

import org.runejs.client.language.English;
import org.runejs.client.language.Native;

public class TextUtils {
    private static char[] message = new char[100];
    public static final char[] VALID_CHARACTERS = new char[]{'_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static long nameToLong(String name) {
        long longName = 0L;
        for (int i = 0; i < name.length() && i < 12; ++i) {
            char ch = name.charAt(i);
            longName *= 37L;
            if (ch >= 'A' && ch <= 'Z') {
                longName += (long)('\u0001' + ch - 65);
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                longName += (long)('\u0001' + ch - 97);
                continue;
            }
            if (ch < '0' || ch > '9') continue;
            longName += (long)(27 + ch - 48);
        }
        while (longName % 37L == 0L && longName != 0L) {
            longName /= 37L;
        }
        return longName;
    }

    public static String longToName(long longName) {
        if (longName <= 0L || longName >= 6582952005840035281L) {
            return "invalid_name";
        }
        if (longName % 37L == 0L) {
            return "invalid_name";
        }
        int length = 0;
        char[] name = new char[12];
        while (longName != 0L) {
            long tmp = longName;
            name[11 - length++] = VALID_CHARACTERS[(int)(tmp - (longName /= 37L) * 37L)];
        }
        return new String(name, 12 - length, length);
    }

    public static long spriteToHash(String sprite) {
        sprite = sprite.toUpperCase();
        long spriteHash = 0L;
        for (int index = 0; index < sprite.length(); ++index) {
            spriteHash = spriteHash * 61L + (long)sprite.charAt(index) - 32L;
            spriteHash = spriteHash + (spriteHash >> 56) & 0xFFFFFFFFFFFFFFL;
        }
        return spriteHash;
    }

    public static String decodeAddress(int address) {
        return (address >> 24 & 0xFF) + "." + (address >> 16 & 0xFF) + "." + (address >> 8 & 0xFF) + "." + (address & 0xFF);
    }

    public static String formatName(String name) {
        if (name.length() > 0) {
            char[] formatedName = name.toCharArray();
            for (int pos = 0; pos < formatedName.length; ++pos) {
                if (formatedName[pos] != '_') continue;
                formatedName[pos] = 32;
                if (pos + 1 >= formatedName.length || formatedName[pos + 1] < 'a' || formatedName[pos + 1] > 'z') continue;
                formatedName[pos + 1] = (char)(formatedName[pos + 1] + 65 - 97);
            }
            if (formatedName[0] >= 'a' && formatedName[0] <= 'z') {
                formatedName[0] = (char)(formatedName[0] + 65 - 97);
            }
            return new String(formatedName);
        }
        return name;
    }

    public static String censorPassword(String password) {
        if (password == null || password.length() < 1) {
            return "";
        }
        StringBuffer censoredPassword = new StringBuffer();
        for (int index = 0; index < password.length(); ++index) {
            censoredPassword.append("*");
        }
        return censoredPassword.toString();
    }

    public static String formatAmountString(int amount) {
        String amountString = Integer.toString(amount);
        for (int i = -3 + amountString.length(); i > 0; i -= 3) {
            amountString = amountString.substring(0, i) + Native.comma_b + amountString.substring(i);
        }
        if (amountString.length() > 8) {
            amountString = Native.green + amountString.substring(0, -8 + amountString.length()) + English.suffixMillion + Native.whiteOpeningParenthesis + amountString + Native.rightParenthesis;
        } else if (amountString.length() > 4) {
            amountString = Native.cyan + amountString.substring(0, amountString.length() + -4) + Native.suffixK + Native.whiteOpeningParenthesis + amountString + Native.rightParenthesis;
        }
        return Native.whitespace_b + amountString;
    }
}

