/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import org.runejs.client.GameShell;
import org.runejs.client.SizedAccessFile;
import org.runejs.client.cache.system.CacheLocator;
import org.runejs.client.cache.system.JagexCacheLocator;
import org.runejs.client.util.SignlinkNode;

public class Signlink
implements Runnable {
    public static Method setFocusCycleRoot;
    private static String homeDirectory;
    public static Method setFocusTraversalKeysEnabled;
    public static String javaVendor;
    public static int anInt737;
    public static String javaVersion;
    public boolean killed;
    public int uid = 0;
    public SizedAccessFile[] dataIndexAccessFiles;
    public SignlinkNode current = null;
    public SizedAccessFile metaIndexAccessFile = null;
    public InetAddress netAddress;
    public SignlinkNode next = null;
    public Thread signLinkThread;
    public SizedAccessFile cacheDataAccessFile = null;
    public GameShell gameShell;
    private CacheLocator cacheLocator = new JagexCacheLocator();

    public Signlink(boolean loadCache, GameShell gameShell, InetAddress netAddress, int fileStoreId, String cacheFolder, int cacheIndexes) throws IOException {
        this.gameShell = gameShell;
        this.netAddress = netAddress;
        javaVersion = "1.1";
        javaVendor = "Unknown";
        try {
            javaVendor = System.getProperty("java.vendor");
            javaVersion = System.getProperty("java.version");
            homeDirectory = System.getProperty("user.home");
            if (homeDirectory != null) {
                homeDirectory = homeDirectory + "/";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            setFocusTraversalKeysEnabled = gameShell == null ? Class.forName("java.awt.Component").getDeclaredMethod("setFocusTraversalKeysEnabled", Boolean.TYPE) : gameShell.getClass().getMethod("setFocusTraversalKeysEnabled", Boolean.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            setFocusCycleRoot = gameShell != null ? gameShell.getClass().getMethod("setFocusCycleRoot", Boolean.TYPE) : Class.forName("java.awt.Container").getDeclaredMethod("setFocusCycleRoot", Boolean.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loadCache) {
            String cachePath = this.cacheLocator.getCachePath(homeDirectory);
            this.cacheDataAccessFile = new SizedAccessFile(new File(cachePath + "main_file_cache.dat2"), "rw", 0x3200000L);
            this.dataIndexAccessFiles = new SizedAccessFile[cacheIndexes];
            for (int currentIndex = 0; currentIndex < cacheIndexes; ++currentIndex) {
                this.dataIndexAccessFiles[currentIndex] = new SizedAccessFile(new File(cachePath + "main_file_cache.idx" + currentIndex), "rw", 0x100000L);
            }
            this.metaIndexAccessFile = new SizedAccessFile(new File(cachePath + "main_file_cache.idx255"), "rw", 0x100000L);
            this.initializeUniqueIdentifier(cachePath);
        }
        this.killed = false;
        this.signLinkThread = new Thread(this);
        this.signLinkThread.setPriority(10);
        this.signLinkThread.setDaemon(true);
        this.signLinkThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killSignlinkThread() {
        Signlink signlink = this;
        synchronized (signlink) {
            this.killed = true;
            this.notifyAll();
        }
        try {
            this.signLinkThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.cacheDataAccessFile != null) {
            try {
                this.cacheDataAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.metaIndexAccessFile != null) {
            try {
                this.metaIndexAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.dataIndexAccessFiles != null) {
            for (int i = 0; i < this.dataIndexAccessFiles.length; ++i) {
                if (this.dataIndexAccessFiles[i] == null) continue;
                try {
                    this.dataIndexAccessFiles[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignlinkNode putNode(int integerData, SignlinkNode.Type type, Object objectData) {
        SignlinkNode signlinkNode = new SignlinkNode();
        signlinkNode.objectData = objectData;
        signlinkNode.integerData = integerData;
        signlinkNode.type = type;
        Signlink signlink = this;
        synchronized (signlink) {
            if (this.next == null) {
                this.next = this.current = signlinkNode;
            } else {
                this.next.prev = signlinkNode;
                this.next = signlinkNode;
            }
            this.notify();
        }
        return signlinkNode;
    }

    public SignlinkNode putMethodNode(Class[] argumentTypes, String functionName, Class functionType) {
        return this.putNode(0, SignlinkNode.Type.METHOD, new Object[]{functionType, functionName, argumentTypes});
    }

    public SignlinkNode putDataInputStreamNode(URL url) {
        return this.putNode(0, SignlinkNode.Type.DATA_INPUT_STREAM, url);
    }

    public SignlinkNode putFieldNode(Class variableType, String variableName) {
        return this.putNode(0, SignlinkNode.Type.FIELD, new Object[]{variableType, variableName});
    }

    public SignlinkNode putExceptionNode(int arg1) {
        return this.putNode(arg1, SignlinkNode.Type.EXCEPTION, null);
    }

    public SignlinkNode putThreadNode(int nodeId, Runnable runnableClass) {
        return this.putNode(nodeId, SignlinkNode.Type.THREAD, runnableClass);
    }

    public SignlinkNode putSocketNode(int port) {
        return this.putNode(port, SignlinkNode.Type.SOCKET, null);
    }

    public void initializeUniqueIdentifier(String cachePath) {
        try {
            File file = new File(cachePath + "uid.dat");
            if (!file.exists() || file.length() < 4L) {
                DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(cachePath + "uid.dat"));
                dataoutputstream.writeInt((int)(9.9999999E7 * Math.random()));
                dataoutputstream.close();
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        try {
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(cachePath + "uid.dat"));
            this.uid = 1 + datainputstream.readInt();
            datainputstream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            SignlinkNode currentNode;
            Signlink signlink = this;
            synchronized (signlink) {
                while (true) {
                    if (this.killed) {
                        return;
                    }
                    if (this.current != null) {
                        currentNode = this.current;
                        this.current = this.current.prev;
                        if (this.current != null) break;
                        this.next = null;
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                Object[] objects;
                SignlinkNode.Type type = currentNode.type;
                if (type == SignlinkNode.Type.SOCKET) {
                    currentNode.value = new Socket(this.netAddress, currentNode.integerData);
                } else if (type == SignlinkNode.Type.THREAD) {
                    Thread thread = new Thread((Runnable)currentNode.objectData);
                    thread.setDaemon(true);
                    thread.start();
                    thread.setPriority(currentNode.integerData);
                    currentNode.value = thread;
                } else if (type == SignlinkNode.Type.DATA_INPUT_STREAM) {
                    currentNode.value = new DataInputStream(((URL)currentNode.objectData).openStream());
                } else if (type == SignlinkNode.Type.METHOD) {
                    objects = (Object[])currentNode.objectData;
                    currentNode.value = ((Class)objects[0]).getDeclaredMethod((String)objects[1], (Class[])objects[2]);
                } else if (type == SignlinkNode.Type.FIELD) {
                    objects = (Object[])currentNode.objectData;
                    currentNode.value = ((Class)objects[0]).getDeclaredField((String)objects[1]);
                } else {
                    throw new Exception();
                }
                currentNode.status = SignlinkNode.Status.INITIALIZED;
                continue;
            }
            catch (Exception exception) {
                currentNode.status = SignlinkNode.Status.ERRORED;
                continue;
            }
            break;
        }
    }

    public SignlinkNode method396(int arg0) {
        if (arg0 < 81) {
            return null;
        }
        return null;
    }

    static {
        anInt737 = 3;
    }
}

