/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.util;

import org.runejs.client.MovedStatics;
import org.runejs.client.util.Timer;

public class NanoTimer
extends Timer {
    public long nextUpdate;

    public NanoTimer() {
        this.start();
    }

    @Override
    public void reset() {
        this.start();
    }

    @Override
    public void start() {
        this.nextUpdate = System.nanoTime();
    }

    @Override
    public int getTicks(int millisPerTick, int minSleep) {
        int ticks;
        long minSleepNano = (long)minSleep * 1000000L;
        long sleepNano = this.nextUpdate - System.nanoTime();
        if (sleepNano < minSleepNano) {
            sleepNano = minSleepNano;
        }
        MovedStatics.threadSleep(sleepNano / 1000000L);
        long currentNanoTime = System.nanoTime();
        for (ticks = 0; ticks < 10 && (ticks < 1 || this.nextUpdate < currentNanoTime); ++ticks) {
            this.nextUpdate += (long)millisPerTick * 1000000L;
        }
        if (this.nextUpdate < currentNanoTime) {
            this.nextUpdate = currentNanoTime;
        }
        return ticks;
    }
}

