/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.sound;

import org.runejs.client.LinkedList;
import org.runejs.client.audio.Effect;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.GameObjectDefinition;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.node.Node;
import org.runejs.client.sound.PcmPlayer;
import org.runejs.client.sound.PcmStreamMixer;
import org.runejs.client.sound.RawPcmStream;
import org.runejs.client.sound.RawSound;
import org.runejs.client.util.Signlink;

public class SoundSystem {
    static final int SAMPLE_RATE = 22050;
    static long timeMs;
    private static PcmStreamMixer pcmStreamMixer;
    private static int currentSound;
    private static PcmPlayer pcmPlayer;
    private static Effect[] effects;
    private static int[] sound;
    private static int[] soundDelay;
    private static int[] soundLocations;
    private static int[] soundVolume;
    private static int areaSoundEffectVolume;
    private static int soundEffectVolume;
    private static Class pcmClass;
    private static LinkedList objectSounds;

    public static void reset() {
        currentSound = 0;
    }

    public static void initialiseSound(Signlink signlink) {
        try {
            PcmPlayer player = new PcmPlayer();
            player.method222(signlink, 2048);
            pcmPlayer = player;
        }
        catch (Throwable player) {
            // empty catch block
        }
        PcmStreamMixer mixer = new PcmStreamMixer();
        PcmPlayer.setMixer(mixer);
        pcmStreamMixer = mixer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSounds() {
        long currentTime;
        if (pcmPlayer != null && timeMs < (currentTime = System.currentTimeMillis())) {
            pcmPlayer.method212(currentTime);
            int elapsed = (int)(currentTime - timeMs);
            timeMs = currentTime;
            Class<PcmPlayer> clazz = pcmClass != null ? pcmClass : (pcmClass = PcmPlayer.class);
            synchronized (clazz) {
                PcmPlayer.handle(elapsed);
            }
        }
    }

    public static void play(int soundId, int volume, int delay) {
        if (soundEffectVolume != 0 && volume != 0 && currentSound < 50) {
            SoundSystem.sound[SoundSystem.currentSound] = soundId;
            SoundSystem.soundVolume[SoundSystem.currentSound] = volume;
            SoundSystem.soundDelay[SoundSystem.currentSound] = delay;
            SoundSystem.effects[SoundSystem.currentSound] = null;
            SoundSystem.soundLocations[SoundSystem.currentSound] = 0;
            ++currentSound;
        }
    }

    public static void play(int soundId, int volume, int delay, int location) {
        if (areaSoundEffectVolume != 0 && volume > 0 && currentSound < 50) {
            SoundSystem.sound[SoundSystem.currentSound] = soundId;
            SoundSystem.soundVolume[SoundSystem.currentSound] = volume;
            SoundSystem.soundDelay[SoundSystem.currentSound] = delay;
            SoundSystem.effects[SoundSystem.currentSound] = null;
            SoundSystem.soundLocations[SoundSystem.currentSound] = location;
            ++currentSound;
        }
    }

    public static void stop() {
        if (pcmPlayer != null) {
            pcmPlayer.stop();
            pcmPlayer = null;
        }
    }

    public static void processSounds() {
        for (int index = 0; index < currentSound; ++index) {
            int volume;
            int n = index;
            soundDelay[n] = soundDelay[n] - 1;
            if (soundDelay[index] < -10) {
                --currentSound;
                for (int j = index; currentSound > j; ++j) {
                    SoundSystem.sound[j] = sound[j + 1];
                    SoundSystem.effects[j] = effects[1 + j];
                    SoundSystem.soundVolume[j] = soundVolume[1 + j];
                    SoundSystem.soundDelay[j] = soundDelay[1 + j];
                    SoundSystem.soundLocations[j] = soundLocations[1 + j];
                }
                --index;
                continue;
            }
            Effect effect = effects[index];
            if (effect == null) {
                effect = Effect.readSoundEffect(CacheArchive.soundEffectCacheArchive, sound[index], 0);
                if (effect == null) continue;
                int n2 = index;
                soundDelay[n2] = soundDelay[n2] + effect.delay();
                SoundSystem.effects[index] = effect;
            }
            if (soundDelay[index] >= 0) continue;
            if (soundLocations[index] != 0) {
                int i_16_;
                int i_11_ = 128 * (soundLocations[index] & 0xFF);
                int i_12_ = 0xFF & soundLocations[index] >> 16;
                int i_13_ = (soundLocations[index] & 0xFFB8) >> 8;
                int i_14_ = i_13_ * 128 + 64 + -Player.localPlayer.worldY;
                int i_15_ = i_12_ * 128 + 64 - Player.localPlayer.worldX;
                if (i_15_ < 0) {
                    i_15_ = -i_15_;
                }
                if (i_14_ < 0) {
                    i_14_ = -i_14_;
                }
                if ((i_16_ = -128 + i_15_ + i_14_) > i_11_) {
                    SoundSystem.soundDelay[index] = -100;
                    continue;
                }
                if (i_16_ < 0) {
                    i_16_ = 0;
                }
                volume = (i_11_ + -i_16_) * areaSoundEffectVolume / i_11_;
            } else {
                volume = soundEffectVolume;
            }
            RawSound class40_sub12_sub1 = effect.method428();
            RawPcmStream class40_sub9_sub2 = RawPcmStream.create(class40_sub12_sub1, 100, volume);
            class40_sub9_sub2.setNumLoops(-1 + soundVolume[index]);
            pcmStreamMixer.addSubStream(class40_sub9_sub2);
            SoundSystem.soundDelay[index] = -100;
        }
    }

    public static void updateSoundEffectVolume(int varPlayerValue) {
        if (varPlayerValue == 0) {
            soundEffectVolume = 127;
        }
        if (varPlayerValue == 1) {
            soundEffectVolume = 96;
        }
        if (varPlayerValue == 2) {
            soundEffectVolume = 64;
        }
        if (varPlayerValue == 3) {
            soundEffectVolume = 32;
        }
        if (varPlayerValue == 4) {
            soundEffectVolume = 0;
        }
    }

    public static void updateAreaSoundEffectVolume(int varPlayerValue) {
        if (varPlayerValue == 0) {
            areaSoundEffectVolume = 127;
        }
        if (varPlayerValue == 1) {
            areaSoundEffectVolume = 96;
        }
        if (varPlayerValue == 2) {
            areaSoundEffectVolume = 64;
        }
        if (varPlayerValue == 3) {
            areaSoundEffectVolume = 32;
        }
        if (varPlayerValue == 4) {
            areaSoundEffectVolume = 0;
        }
    }

    public static void addObjectSounds(int arg0, int arg2, int arg3, int arg4, GameObjectDefinition arg5) {
        ObjectSound class40_sub2 = new ObjectSound();
        class40_sub2.hearDistance = 128 * arg5.ambientSoundHearDistance;
        class40_sub2.unkn2 = arg5.unkn2;
        ObjectSound.access$302(class40_sub2, arg5.soundEffectIds);
        class40_sub2.unkn1 = arg5.unkn1;
        int i = arg5.sizeX;
        int i_17_ = arg5.sizeY;
        class40_sub2.plane = arg2;
        class40_sub2.minX = arg4 * 128;
        if (arg3 == 1 || arg3 == 3) {
            i = arg5.sizeY;
            i_17_ = arg5.sizeX;
        }
        class40_sub2.minY = 128 * arg0;
        class40_sub2.maxY = (i_17_ + arg0) * 128;
        class40_sub2.maxX = (arg4 + i) * 128;
        class40_sub2.soundEffectId = arg5.ambientSoundId;
        if (arg5.childIds != null) {
            class40_sub2.gameObjectDefinition = arg5;
            class40_sub2.set();
        }
        objectSounds.addLast(class40_sub2);
        if (class40_sub2.soundEffectIds != null) {
            class40_sub2.anInt2014 = (int)((double)(class40_sub2.unkn2 - class40_sub2.unkn1) * Math.random()) + class40_sub2.unkn1;
        }
    }

    public static void clearObjectSounds() {
        ObjectSound class40_sub2 = (ObjectSound)objectSounds.peekFirst();
        while (class40_sub2 != null) {
            if (class40_sub2.stream1 != null) {
                pcmStreamMixer.removeSubStream(class40_sub2.stream1);
                class40_sub2.stream1 = null;
            }
            if (class40_sub2.stream2 != null) {
                pcmStreamMixer.removeSubStream(class40_sub2.stream2);
                class40_sub2.stream2 = null;
            }
            class40_sub2 = (ObjectSound)objectSounds.pollFirst();
        }
        objectSounds.clear();
    }

    public static void setObjectSounds() {
        ObjectSound class40_sub2 = (ObjectSound)objectSounds.peekFirst();
        while (class40_sub2 != null) {
            if (class40_sub2.gameObjectDefinition != null) {
                class40_sub2.set();
            }
            class40_sub2 = (ObjectSound)objectSounds.pollFirst();
        }
    }

    public static void updateObjectSounds(int pwx, int pwl, int redrawRate, int pwy) {
        ObjectSound class40_sub2 = (ObjectSound)objectSounds.peekFirst();
        while (class40_sub2 != null) {
            if (class40_sub2.soundEffectId != -1 || class40_sub2.soundEffectIds != null) {
                int distance = 0;
                if (pwx <= class40_sub2.maxX) {
                    if (pwx < class40_sub2.minX) {
                        distance += class40_sub2.minX - pwx;
                    }
                } else {
                    distance += -class40_sub2.maxX + pwx;
                }
                if (pwy > class40_sub2.maxY) {
                    distance += -class40_sub2.maxY + pwy;
                } else if (pwy < class40_sub2.minY) {
                    distance += -pwy + class40_sub2.minY;
                }
                if (class40_sub2.hearDistance < -64 + distance || areaSoundEffectVolume == 0 || pwl != class40_sub2.plane) {
                    if (class40_sub2.stream1 != null) {
                        pcmStreamMixer.removeSubStream(class40_sub2.stream1);
                        class40_sub2.stream1 = null;
                    }
                    if (class40_sub2.stream2 != null) {
                        pcmStreamMixer.removeSubStream(class40_sub2.stream2);
                        class40_sub2.stream2 = null;
                    }
                } else {
                    Object effect;
                    if ((distance -= 64) < 0) {
                        distance = 0;
                    }
                    int volume = (-distance + class40_sub2.hearDistance) * areaSoundEffectVolume / class40_sub2.hearDistance;
                    if (class40_sub2.stream1 == null) {
                        if (class40_sub2.soundEffectId >= 0 && (effect = Effect.readSoundEffect(CacheArchive.soundEffectCacheArchive, class40_sub2.soundEffectId, 0)) != null) {
                            RawSound class40_sub12_sub1 = ((Effect)effect).method428();
                            RawPcmStream class40_sub9_sub2 = RawPcmStream.create(class40_sub12_sub1, 100, volume);
                            class40_sub9_sub2.setNumLoops(-1);
                            pcmStreamMixer.addSubStream(class40_sub9_sub2);
                            class40_sub2.stream1 = class40_sub9_sub2;
                        }
                    } else {
                        class40_sub2.stream1.method857(volume);
                    }
                    if (class40_sub2.stream2 == null) {
                        if (class40_sub2.soundEffectIds != null && (((ObjectSound)(effect = class40_sub2)).anInt2014 = ((ObjectSound)effect).anInt2014 - redrawRate) <= 0) {
                            int i_50_ = (int)((double)class40_sub2.soundEffectIds.length * Math.random());
                            Effect effect2 = Effect.readSoundEffect(CacheArchive.soundEffectCacheArchive, class40_sub2.soundEffectIds[i_50_], 0);
                            if (effect2 != null) {
                                RawSound class40_sub12_sub1 = effect2.method428();
                                RawPcmStream class40_sub9_sub2 = RawPcmStream.create(class40_sub12_sub1, 100, volume);
                                class40_sub9_sub2.setNumLoops(0);
                                pcmStreamMixer.addSubStream(class40_sub9_sub2);
                                class40_sub2.anInt2014 = class40_sub2.unkn1 + (int)((double)(-class40_sub2.unkn1 + class40_sub2.unkn2) * Math.random());
                                class40_sub2.stream2 = class40_sub9_sub2;
                            }
                        }
                    } else {
                        class40_sub2.stream2.method857(volume);
                        if (!class40_sub2.stream2.hasNext()) {
                            class40_sub2.stream2 = null;
                        }
                    }
                }
            }
            class40_sub2 = (ObjectSound)objectSounds.pollFirst();
        }
    }

    static {
        currentSound = 0;
        effects = new Effect[50];
        sound = new int[50];
        soundDelay = new int[50];
        soundLocations = new int[50];
        soundVolume = new int[50];
        areaSoundEffectVolume = 127;
        soundEffectVolume = 127;
        objectSounds = new LinkedList();
    }

    private static class ObjectSound
    extends Node {
        private int plane;
        private int minX;
        private int soundEffectId;
        private int hearDistance;
        private RawPcmStream stream1;
        private int unkn2;
        private int minY;
        private int[] soundEffectIds;
        private int maxY;
        private RawPcmStream stream2;
        private GameObjectDefinition gameObjectDefinition;
        private int unkn1;
        private int maxX;
        private int anInt2014;

        private ObjectSound() {
        }

        private void set() {
            int i = this.soundEffectId;
            GameObjectDefinition gameObjectDefinition = this.gameObjectDefinition.getChildDefinition();
            if (gameObjectDefinition == null) {
                this.hearDistance = 0;
                this.unkn1 = 0;
                this.unkn2 = 0;
                this.soundEffectIds = null;
                this.soundEffectId = -1;
            } else {
                this.hearDistance = 128 * gameObjectDefinition.ambientSoundHearDistance;
                this.unkn1 = gameObjectDefinition.unkn1;
                this.unkn2 = gameObjectDefinition.unkn2;
                this.soundEffectId = gameObjectDefinition.ambientSoundId;
                this.soundEffectIds = gameObjectDefinition.soundEffectIds;
            }
            if (i != this.soundEffectId && this.stream1 != null) {
                pcmStreamMixer.removeSubStream(this.stream1);
                this.stream1 = null;
            }
        }

        static /* synthetic */ int[] access$302(ObjectSound x0, int[] x1) {
            x0.soundEffectIds = x1;
            return x1;
        }
    }
}

