/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.sound;

import org.runejs.Configuration;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;
import org.runejs.client.sound.MidiPlayer;

public class MusicSystem {
    public static int currentSongId = -1;
    public static int musicVolume = Configuration.isSoundMuted() ? 0 : 255;
    public static int songTimeout = 0;
    private static boolean aBoolean1790;
    private static int anInt1806;
    private static int anInt2110;
    private static int volume3;
    private static int anInt255;
    private static int fileId;
    private static int childId;
    private static byte[] data_;
    private static boolean fetchMusic;
    private static boolean loop_;
    private static MidiPlayer midi;
    private static NodeCache musicCache;
    private static CacheArchive musicFetcher;
    private static int timer;
    private static int velocity;
    private static int velocity_increment;
    private static int volume1;
    private static int volume2;

    public static synchronized void handleMusic() {
        if (MusicSystem.musicIsntNull()) {
            byte[] is;
            if (fetchMusic && (is = MusicSystem.fetchMusic(childId, musicFetcher, fileId, anInt2110)) != null) {
                if (anInt255 < 0) {
                    if (anInt1806 < 0) {
                        MusicSystem.method56(aBoolean1790, is, volume3);
                    } else {
                        MusicSystem.method566(volume3, aBoolean1790, anInt1806, is);
                    }
                } else {
                    MusicSystem.method886(volume3, aBoolean1790, is, anInt255);
                }
                fetchMusic = false;
                musicFetcher = null;
            }
            MusicSystem.method984(0);
        }
    }

    public static boolean initialiseMusic(int size) {
        if (!MusicSystem.musicPlayerStarted()) {
            return false;
        }
        if (size > 0) {
            musicCache = new NodeCache(size);
        }
        return true;
    }

    public static synchronized void method402(boolean arg0) {
        if (MusicSystem.musicIsntNull()) {
            MusicSystem.method308();
            fetchMusic = arg0;
            musicFetcher = null;
        }
    }

    public static synchronized void method405(int arg1) {
        if (MusicSystem.musicIsntNull()) {
            MusicSystem.method557(arg1);
            musicFetcher = null;
            fetchMusic = false;
        }
    }

    public static synchronized void syncedStop(boolean arg0) {
        MusicSystem.stop_();
    }

    public static synchronized void playLoginScreenMusic(boolean always_false, CacheArchive archive, int always_zero, String songName, int always_ten, String always_empty, int volume) {
        if (MusicSystem.musicIsntNull()) {
            int groupId = archive.getGroupIdByName(songName);
            int fileId = archive.getFileIdByName(groupId, always_empty);
            MusicSystem.method403(volume, true, always_ten, groupId, archive, fileId, always_zero, always_false);
        }
    }

    public static void method456(int volume) {
        if (MusicSystem.musicIsntNull()) {
            if (fetchMusic) {
                volume3 = volume;
            } else {
                MusicSystem.method651(volume);
            }
        }
    }

    public static synchronized void playMusicTrack(boolean arg0, int arg1, int songid, int volume, int childId, CacheArchive arg5) {
        if (MusicSystem.musicIsntNull()) {
            fetchMusic = true;
            anInt1806 = -1;
            anInt255 = -1;
            volume3 = volume;
            MusicSystem.childId = childId;
            aBoolean1790 = arg0;
            anInt2110 = arg1;
            musicFetcher = arg5;
            fileId = songid;
        }
    }

    public static void playSong(int songId) {
        if (songId == -1 && songTimeout == 0) {
            MusicSystem.method402(false);
        } else if (songId != -1 && songId != currentSongId && musicVolume != 0 && songTimeout == 0) {
            MusicSystem.method403(musicVolume, true, 10, songId, CacheArchive.musicCacheArchive, 0, 0, false);
        }
        currentSongId = songId;
    }

    public static void playSoundJingle(int songTimeout, int songId) {
        if (musicVolume != 0 && songId != -1) {
            MusicSystem.playMusicTrack(false, 1, songId, musicVolume, 0, CacheArchive.jingleCacheArchive);
            MusicSystem.songTimeout = songTimeout;
        }
    }

    public static void processMusic() {
        if (songTimeout > 0) {
            if ((songTimeout -= 20) < 0) {
                songTimeout = 0;
            }
            if (songTimeout == 0 && musicVolume != 0 && currentSongId != -1) {
                MusicSystem.playMusicTrack(false, 0, currentSongId, musicVolume, 0, CacheArchive.musicCacheArchive);
            }
        }
    }

    static void stop_() {
        if (midi != null) {
            MusicSystem.method308();
            if (timer > 0) {
                midi.resetVolume(256);
                timer = 0;
            }
            midi.close0((byte)101);
            midi = null;
        }
    }

    private static byte[] fetchMusic(int childId, CacheArchive musicArchive, int fileId, int arg4) {
        Object data;
        long hash = (long)(childId + 37 * fileId & 0xFFFF) + ((long)arg4 << 32) + (long)(fileId << 16);
        if (musicCache != null && (data = (MusicData)musicCache.get(hash)) != null) {
            return ((MusicData)data).data;
        }
        data = musicArchive.getFile(fileId, childId);
        if (data == null) {
            return null;
        }
        if (musicCache != null) {
            musicCache.put(hash, new MusicData((byte[])data));
        }
        return data;
    }

    private static void method308() {
        MusicSystem.method56(false, null, 0);
    }

    private static int method372(int arg1) {
        return (int)(0.5 + Math.log(0.00390625 * (double)arg1) * 868.5889638065036);
    }

    private static synchronized void method403(int volume, boolean always_true, int always_ten, int cacheGroupId, CacheArchive archive, int cacheFileId, int always_zero, boolean always_false) {
        if (MusicSystem.musicIsntNull()) {
            aBoolean1790 = always_false;
            anInt255 = always_ten;
            childId = cacheFileId;
            fetchMusic = always_true;
            musicFetcher = archive;
            anInt1806 = -1;
            volume3 = volume;
            anInt2110 = always_zero;
            fileId = cacheGroupId;
        }
    }

    private static void method557(int arg0) {
        MusicSystem.method886(0, false, null, arg0);
    }

    private static void method56(boolean loop, byte[] arg2, int arg3) {
        if (midi != null) {
            if (volume2 >= 0) {
                midi.stop0();
                velocity = 0;
                data_ = null;
                timer = 20;
                volume2 = -1;
            }
            if (arg2 != null) {
                if (timer > 0) {
                    midi.resetVolume(arg3);
                    timer = 0;
                }
                volume2 = arg3;
                midi.play(arg2, loop, arg3);
            }
        }
    }

    private static void method566(int arg0, boolean arg1, int arg2, byte[] arg3) {
        if (midi != null) {
            if (volume2 >= 0) {
                if ((arg2 -= 20) < 1) {
                    arg2 = 1;
                }
                timer = arg2;
                if (volume2 == 0) {
                    velocity_increment = 0;
                } else {
                    int i = MusicSystem.method372(volume2);
                    velocity_increment = (-1 + arg2 + 3600 + (i -= velocity)) / arg2;
                }
                data_ = arg3;
                volume1 = arg0;
                loop_ = arg1;
            } else if (timer == 0) {
                MusicSystem.method56(arg1, arg3, arg0);
            } else {
                volume1 = arg0;
                loop_ = arg1;
                data_ = arg3;
            }
        }
    }

    private static void method651(int volume) {
        if (midi != null) {
            if (timer != 0) {
                if (data_ != null) {
                    volume1 = volume;
                }
            } else if (volume2 >= 0) {
                volume2 = volume;
                midi.setVolume(volume, 0);
            }
        }
    }

    private static void method886(int volume, boolean loop, byte[] data, int velocity) {
        if (midi != null) {
            if (volume2 < 0) {
                if (timer != 0) {
                    volume1 = volume;
                    data_ = data;
                    loop_ = loop;
                } else {
                    MusicSystem.method56(loop, data, volume);
                }
            } else {
                velocity_increment = velocity;
                if (volume2 != 0) {
                    int i = MusicSystem.method372(volume2);
                    timer = ((i -= MusicSystem.velocity) + 3600) / velocity;
                    if (timer < 1) {
                        timer = 1;
                    }
                } else {
                    timer = 1;
                }
                volume1 = volume;
                data_ = data;
                loop_ = loop;
            }
        }
    }

    private static void method984(int arg0) {
        if (arg0 == 0 && midi != null) {
            if (volume2 >= 0) {
                if (timer > 0) {
                    midi.setVolume(volume2, velocity += velocity_increment);
                    if (--timer == 0) {
                        midi.stop0();
                        volume2 = -1;
                        timer = 20;
                    }
                }
            } else if (timer > 0 && --timer == 0) {
                if (data_ == null) {
                    midi.resetVolume(256);
                } else {
                    midi.resetVolume(volume1);
                    volume2 = volume1;
                    midi.play(data_, loop_, volume1);
                    data_ = null;
                }
                velocity = 0;
            }
        }
    }

    private static boolean musicIsntNull() {
        return midi != null;
    }

    private static boolean musicPlayerStarted() {
        timer = 20;
        try {
            midi = new MidiPlayer();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        fetchMusic = false;
        timer = 0;
        velocity = 0;
        velocity_increment = 0;
        volume2 = -1;
    }

    private static class MusicData
    extends CachedNode {
        private byte[] data;

        private MusicData(byte[] data) {
            this.data = data;
        }
    }
}

