/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.sound;

import java.io.ByteArrayInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import org.runejs.client.sound.MusicSystem;

public class MidiPlayer
implements Receiver {
    private static volatile boolean active = false;
    private static int[] anIntArray889 = new int[128];
    private static final int PROGRAM_0 = 0;
    private static final int MSB_CHANNEL_VOLUME = 7;
    private static final int LSB_CHANNEL_VOLUME = 39;
    private static final int MSB_BANK_SELECT = 0;
    private static final int LSB_BANK_SELECT = 32;
    private static final int ALL_SOUND_OFF = 120;
    private static final int RESET_ALL_CONTROLLERS = 121;
    private static final int ALL_NOTES_OFF = 123;
    private static final int[] volumes = new int[]{12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800, 12800};
    private static int volume = 256;
    private static Receiver receiver;
    private static Sequencer sequencer;

    private static int getChannelVolume(int channel) {
        int data = volumes[channel];
        data = (data * volume >> 8) * data;
        return (int)(Math.sqrt(data) + 0.5);
    }

    public MidiPlayer() {
        try {
            receiver = MidiSystem.getReceiver();
            sequencer = MidiSystem.getSequencer(false);
            sequencer.getTransmitter().setReceiver(this);
            sequencer.open();
            this.reset(-1L);
        }
        catch (Exception exception) {
            MusicSystem.stop_();
        }
    }

    @Override
    public void close() {
    }

    public void play(byte[] arg0, boolean loop, int volume) {
        if (sequencer != null) {
            try {
                Sequence sequence = MidiSystem.getSequence(new ByteArrayInputStream(arg0));
                sequencer.setSequence(sequence);
                sequencer.setLoopCount(loop ? -1 : 0);
                this.setVolume(volume, 0, -1L);
                active = true;
                sequencer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetVolume(int volume) {
        if (null != sequencer) {
            this.resetVolume(-1L, volume);
        }
    }

    public void stop0() {
        if (sequencer != null) {
            active = false;
            sequencer.stop();
            this.reset(-1L);
        }
    }

    public synchronized void setVolume(int volume, int velocity) {
        if (sequencer != null) {
            this.setVolume(volume, velocity, -1L);
        }
    }

    public void close0(byte arg0) {
        if (null != sequencer) {
            sequencer.close();
            sequencer = null;
        }
        if (receiver != null) {
            receiver.close();
            receiver = null;
        }
    }

    public void send(int status, int data1, int data2, long timeStamp) {
        try {
            ShortMessage shortmessage = new ShortMessage();
            shortmessage.setMessage(status, data1, data2);
            receiver.send(shortmessage, timeStamp);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    public void setVolume(int volume, int velocity, long timeStamp) {
        if ((volume = (int)((double)volume * Math.pow(0.1, (double)velocity * 5.0E-4) + 0.5)) != MidiPlayer.volume) {
            MidiPlayer.volume = volume;
            for (int i = 0; i < 16; ++i) {
                int data = MidiPlayer.getChannelVolume(i);
                this.send(176 + i, 7, data >> 7, timeStamp);
                this.send(176 + i, 39, data & 0x7F, timeStamp);
            }
        }
    }

    public void resetVolume(long timeStamp, int volume) {
        int i;
        MidiPlayer.volume = volume;
        for (i = 0; i < 16; ++i) {
            MidiPlayer.volumes[i] = 12800;
        }
        for (i = 0; i < 16; ++i) {
            int data = MidiPlayer.getChannelVolume(i);
            this.send(176 + i, 7, data >> 7, timeStamp);
            this.send(176 + i, 39, 0x7F & data, timeStamp);
        }
    }

    public void reset(long timeStamp) {
        int i;
        for (i = 0; i < 128; ++i) {
            int i_6_ = anIntArray889[i];
            MidiPlayer.anIntArray889[i] = 0;
            for (int i_7_ = 0; i_7_ < 16; ++i_7_) {
                if ((i_6_ & 1 << i_7_) == 0) continue;
                this.send(144 + i_7_, i, 0, timeStamp);
            }
        }
        for (i = 0; i < 16; ++i) {
            this.send(i + 176, 123, 0, timeStamp);
        }
        for (i = 0; i < 16; ++i) {
            this.send(i + 176, 120, 0, timeStamp);
        }
        for (i = 0; i < 16; ++i) {
            this.send(i + 176, 121, 0, timeStamp);
        }
        for (i = 0; i < 16; ++i) {
            this.send(i + 176, 0, 0, timeStamp);
        }
        for (i = 0; i < 16; ++i) {
            this.send(i + 176, 32, 0, timeStamp);
        }
        for (i = 0; i < 16; ++i) {
            this.send(i + 192, 0, 0, timeStamp);
        }
    }

    public boolean send0(int status, int data1, int data2, long timeStamp) {
        if ((status & 0xE0) == 128) {
            int i = 1 << (status & 0xF);
            int i_8_ = anIntArray889[data1];
            if (status >= 144 && data2 != 0) {
                if ((i_8_ & i) != 0) {
                    this.send(status, data1, 0, timeStamp);
                } else {
                    MidiPlayer.anIntArray889[data1] = i_8_ | i;
                }
            } else {
                MidiPlayer.anIntArray889[data1] = i_8_ & ~i;
            }
            return false;
        }
        if ((status & 0xF0) == 176) {
            if (data1 == 121) {
                this.send(status, data1, data2, timeStamp);
                int i = status & 0xF;
                MidiPlayer.volumes[i] = 12800;
                int i_9_ = MidiPlayer.getChannelVolume(i);
                this.send(status, 7, i_9_ >> 7, timeStamp);
                this.send(status, 39, i_9_ & 0x7F, timeStamp);
                return true;
            }
            if (data1 == 7 || data1 == 39) {
                int i = status & 0xF;
                MidiPlayer.volumes[i] = data1 == 7 ? (volumes[i] & 0x7F) + (data2 << 7) : (volumes[i] & 0x3F80) + data2;
                int i_10_ = MidiPlayer.getChannelVolume(i);
                this.send(status, 7, i_10_ >> 7, timeStamp);
                this.send(status, 39, i_10_ & 0x7F, timeStamp);
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void send(MidiMessage message, long timeStamp) {
        byte[] is;
        if (active && !this.send0((is = message.getMessage())[0] & 0xFF, is[1], is.length >= 3 ? is[2] : (byte)0, timeStamp)) {
            receiver.send(message, timeStamp);
        }
    }
}

