/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.scene.util;

import org.runejs.client.Game;
import org.runejs.client.cache.def.GameObjectDefinition;
import org.runejs.client.media.renderable.GameObject;
import org.runejs.client.media.renderable.Renderable;
import org.runejs.client.scene.Scene;
import org.runejs.client.util.BitUtils;

public class CollisionMap {
    public int insetX;
    public int height;
    public int[][] clippingData;
    public int insetY;
    public int width;

    public CollisionMap(int arg0, int arg1) {
        this.height = arg1;
        this.insetY = 0;
        this.insetX = 0;
        this.width = arg0;
        this.clippingData = new int[this.width][this.height];
        this.reset();
    }

    public void addObject(int arg1, int arg2, int arg3, int arg4, Scene arg5, int arg7, int arg8, int arg9) {
        CollisionMap arg0 = this;
        int i = Game.currentScene.landscape.tile_height[arg2][arg9][arg8];
        int i_0_ = Game.currentScene.landscape.tile_height[arg2][1 + arg9][arg8];
        int i_1_ = Game.currentScene.landscape.tile_height[arg2][arg9][1 + arg8];
        int i_2_ = Game.currentScene.landscape.tile_height[arg2][arg9 + 1][arg8 + 1];
        GameObjectDefinition gameObjectDefinition = GameObjectDefinition.getDefinition(arg1);
        int i_3_ = i_2_ + i_0_ + i + i_1_ >> 2;
        int i_4_ = (arg7 << 6) + arg4;
        int i_5_ = arg9 - (-(arg8 << 7) - (arg1 << 14) - 0x40000000);
        if (gameObjectDefinition.hasActions == 0) {
            i_5_ -= Integer.MIN_VALUE;
        }
        if (gameObjectDefinition.supportsItems == 1) {
            i_4_ += 256;
        }
        if (arg4 == 22) {
            Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, 22, arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7, i, 22, i_0_);
            arg5.addGroundDecoration(arg9, arg8, arg3, i_3_, i_5_, renderable, i_4_);
            if (gameObjectDefinition.solid && gameObjectDefinition.hasActions == 1) {
                arg0.markBlocked(arg8, arg9);
            }
        } else if (arg4 == 10 || arg4 == 11) {
            Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, 10, arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7, i, 10, i_0_);
            if (renderable != null) {
                int i_7_;
                int i_6_;
                if (arg7 == 1 || arg7 == 3) {
                    i_6_ = gameObjectDefinition.sizeX;
                    i_7_ = gameObjectDefinition.sizeY;
                } else {
                    i_7_ = gameObjectDefinition.sizeX;
                    i_6_ = gameObjectDefinition.sizeY;
                }
                int i_8_ = 0;
                if (arg4 == 11) {
                    i_8_ += 256;
                }
                arg5.addEntityB(arg9, arg8, arg3, i_3_, i_8_, i_6_, i_7_, i_5_, renderable, i_4_);
            }
            if (gameObjectDefinition.solid) {
                arg0.unmarkSolidOccupant(arg9, arg8, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, arg7, gameObjectDefinition.walkable);
            }
        } else if (arg4 >= 12) {
            Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, arg4, arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7, i, arg4, i_0_);
            arg5.addEntityB(arg9, arg8, arg3, i_3_, 0, 1, 1, i_5_, renderable, i_4_);
            if (gameObjectDefinition.solid) {
                arg0.unmarkSolidOccupant(arg9, arg8, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, arg7, gameObjectDefinition.walkable);
            }
        } else if (arg4 == 0) {
            Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, 0, arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7, i, 0, i_0_);
            arg5.addWall(arg9, arg8, arg3, i_3_, Scene.ROTATION_WALL_TYPE[arg7], 0, i_5_, renderable, null, i_4_);
            if (gameObjectDefinition.solid) {
                arg0.unmarkWall(arg9, arg8, arg4, arg7, gameObjectDefinition.walkable);
            }
        } else if (arg4 == 1) {
            Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7, i, 1, i_0_) : new GameObject(arg1, 1, arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true);
            arg5.addWall(arg9, arg8, arg3, i_3_, Scene.ROTATION_WALL_CORNER_TYPE[arg7], 0, i_5_, renderable, null, i_4_);
            if (gameObjectDefinition.solid) {
                arg0.unmarkWall(arg9, arg8, arg4, arg7, gameObjectDefinition.walkable);
            }
        } else if (arg4 == 2) {
            Renderable renderable_10_;
            Renderable renderable;
            int i_9_ = arg7 + 1 & 3;
            if (gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null) {
                renderable = new GameObject(arg1, 2, 4 + arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true);
                renderable_10_ = new GameObject(arg1, 2, i_9_, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true);
            } else {
                renderable = gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7 + 4, i, 2, i_0_);
                renderable_10_ = gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, i_9_, i, 2, i_0_);
            }
            arg5.addWall(arg9, arg8, arg3, i_3_, Scene.ROTATION_WALL_TYPE[arg7], Scene.ROTATION_WALL_TYPE[i_9_], i_5_, renderable, renderable_10_, i_4_);
            if (gameObjectDefinition.solid) {
                arg0.unmarkWall(arg9, arg8, arg4, arg7, gameObjectDefinition.walkable);
            }
        } else if (arg4 == 3) {
            Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, 3, arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7, i, 3, i_0_);
            arg5.addWall(arg9, arg8, arg3, i_3_, Scene.ROTATION_WALL_CORNER_TYPE[arg7], 0, i_5_, renderable, null, i_4_);
            if (gameObjectDefinition.solid) {
                arg0.unmarkWall(arg9, arg8, arg4, arg7, gameObjectDefinition.walkable);
            }
        } else if (arg4 == 9) {
            Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, arg4, arg7, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, arg7, i, arg4, i_0_);
            arg5.addEntityB(arg9, arg8, arg3, i_3_, 0, 1, 1, i_5_, renderable, i_4_);
            if (gameObjectDefinition.solid) {
                arg0.unmarkSolidOccupant(arg9, arg8, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, arg7, gameObjectDefinition.walkable);
            }
        } else {
            if (gameObjectDefinition.adjustToTerrain) {
                if (arg7 == 1) {
                    int i_13_ = i_1_;
                    i_1_ = i_2_;
                    i_2_ = i_0_;
                    i_0_ = i;
                    i = i_13_;
                } else if (arg7 == 2) {
                    int i_12_ = i_1_;
                    i_1_ = i_0_;
                    i_0_ = i_12_;
                    i_12_ = i_2_;
                    i_2_ = i;
                    i = i_12_;
                } else if (arg7 == 3) {
                    int i_11_ = i_1_;
                    i_1_ = i;
                    i = i_0_;
                    i_0_ = i_2_;
                    i_2_ = i_11_;
                }
            }
            if (arg4 == 4) {
                Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, 4, 0, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, 0, i, 4, i_0_);
                arg5.addWallDecoration(arg9, arg8, arg3, i_3_, 0, 0, 512 * arg7, i_5_, renderable, i_4_, Scene.ROTATION_WALL_TYPE[arg7]);
            } else if (arg4 == 5) {
                int i_14_ = 16;
                int i_15_ = arg5.getWallHash(arg3, arg9, arg8);
                if (i_15_ > 0) {
                    i_14_ = GameObjectDefinition.getDefinition((int)(i_15_ >> 14 & Short.MAX_VALUE)).setDecorDisplacement;
                }
                Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, 0, i, 4, i_0_) : new GameObject(arg1, 4, 0, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true);
                arg5.addWallDecoration(arg9, arg8, arg3, i_3_, Scene.WALL_DECORATION_ROTATION_FORWARD_X[arg7] * i_14_, Scene.WALL_DECORATION_ROTATION_FORWARD_Z[arg7] * i_14_, 512 * arg7, i_5_, renderable, i_4_, Scene.ROTATION_WALL_TYPE[arg7]);
            } else if (arg4 == 6) {
                Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, 4, 0, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, 0, i, 4, i_0_);
                arg5.addWallDecoration(arg9, arg8, arg3, i_3_, 0, 0, arg7, i_5_, renderable, i_4_, 256);
            } else if (arg4 == 7) {
                Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, 0, i, 4, i_0_) : new GameObject(arg1, 4, 0, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true);
                arg5.addWallDecoration(arg9, arg8, arg3, i_3_, 0, 0, arg7, i_5_, renderable, i_4_, 512);
            } else if (arg4 == 8) {
                Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(arg1, 4, 0, i, i_0_, i_2_, i_1_, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(i_2_, i_1_, 0, i, 4, i_0_);
                arg5.addWallDecoration(arg9, arg8, arg3, i_3_, 0, 0, arg7, i_5_, renderable, i_4_, 768);
            }
        }
    }

    public void unset(int x, int y, int i) {
        this.clippingData[x][y] = BitUtils.bitWiseOR(this.clippingData[x][y], i);
    }

    public void unmarkConcealed(int x, int y) {
        this.clippingData[x -= this.insetX][y -= this.insetY] = BitUtils.bitWiseAND(this.clippingData[x][y], 0xDFFFFF);
    }

    public void reset() {
        for (int i = 0; this.width > i; ++i) {
            for (int i_0_ = 0; this.height > i_0_; ++i_0_) {
                this.clippingData[i][i_0_] = i != 0 && i_0_ != 0 && i != this.width - 1 && i_0_ != -1 + this.height ? 0x1000000 : 0xFFFFFF;
            }
        }
    }

    public void markWall(int x, int orientation, boolean impenetrable, int y, int position) {
        x -= this.insetX;
        y -= this.insetY;
        if (position == 0) {
            if (orientation == 0) {
                this.orClipTable(x, y, 128);
                this.orClipTable(-1 + x, y, 8);
            }
            if (orientation == 1) {
                this.orClipTable(x, y, 2);
                this.orClipTable(x, y + 1, 32);
            }
            if (orientation == 2) {
                this.orClipTable(x, y, 8);
                this.orClipTable(1 + x, y, 128);
            }
            if (orientation == 3) {
                this.orClipTable(x, y, 32);
                this.orClipTable(x, -1 + y, 2);
            }
        }
        if (position == 1 || position == 3) {
            if (orientation == 0) {
                this.orClipTable(x, y, 1);
                this.orClipTable(-1 + x, y + 1, 16);
            }
            if (orientation == 1) {
                this.orClipTable(x, y, 4);
                this.orClipTable(1 + x, 1 + y, 64);
            }
            if (orientation == 2) {
                this.orClipTable(x, y, 16);
                this.orClipTable(x + 1, -1 + y, 1);
            }
            if (orientation == 3) {
                this.orClipTable(x, y, 64);
                this.orClipTable(-1 + x, y - 1, 4);
            }
        }
        if (position == 2) {
            if (orientation == 0) {
                this.orClipTable(x, y, 130);
                this.orClipTable(-1 + x, y, 8);
                this.orClipTable(x, y + 1, 32);
            }
            if (orientation == 1) {
                this.orClipTable(x, y, 10);
                this.orClipTable(x, 1 + y, 32);
                this.orClipTable(1 + x, y, 128);
            }
            if (orientation == 2) {
                this.orClipTable(x, y, 40);
                this.orClipTable(x + 1, y, 128);
                this.orClipTable(x, -1 + y, 2);
            }
            if (orientation == 3) {
                this.orClipTable(x, y, 160);
                this.orClipTable(x, -1 + y, 2);
                this.orClipTable(x + -1, y, 8);
            }
        }
        if (impenetrable) {
            if (position == 0) {
                if (orientation == 0) {
                    this.orClipTable(x, y, 65536);
                    this.orClipTable(x + -1, y, 4096);
                }
                if (orientation == 1) {
                    this.orClipTable(x, y, 1024);
                    this.orClipTable(x, 1 + y, 16384);
                }
                if (orientation == 2) {
                    this.orClipTable(x, y, 4096);
                    this.orClipTable(1 + x, y, 65536);
                }
                if (orientation == 3) {
                    this.orClipTable(x, y, 16384);
                    this.orClipTable(x, -1 + y, 1024);
                }
            }
            if (position == 1 || position == 3) {
                if (orientation == 0) {
                    this.orClipTable(x, y, 512);
                    this.orClipTable(x + -1, y + 1, 8192);
                }
                if (orientation == 1) {
                    this.orClipTable(x, y, 2048);
                    this.orClipTable(1 + x, 1 + y, 32768);
                }
                if (orientation == 2) {
                    this.orClipTable(x, y, 8192);
                    this.orClipTable(1 + x, y - 1, 512);
                }
                if (orientation == 3) {
                    this.orClipTable(x, y, 32768);
                    this.orClipTable(x + -1, y - 1, 2048);
                }
            }
            if (position == 2) {
                if (orientation == 0) {
                    this.orClipTable(x, y, 66560);
                    this.orClipTable(x + -1, y, 4096);
                    this.orClipTable(x, y + 1, 16384);
                }
                if (orientation == 1) {
                    this.orClipTable(x, y, 5120);
                    this.orClipTable(x, y + 1, 16384);
                    this.orClipTable(1 + x, y, 65536);
                }
                if (orientation == 2) {
                    this.orClipTable(x, y, 20480);
                    this.orClipTable(1 + x, y, 65536);
                    this.orClipTable(x, y - 1, 1024);
                }
                if (orientation == 3) {
                    this.orClipTable(x, y, 81920);
                    this.orClipTable(x, -1 + y, 1024);
                    this.orClipTable(-1 + x, y, 4096);
                }
            }
        }
    }

    public void markSolidOccupant(int objectX, int objectY, int objectSizeX, int objectSizeY, int orient, boolean impenetrable) {
        int occupied = 256;
        if (impenetrable) {
            occupied += 131072;
        }
        objectX -= this.insetX;
        objectY -= this.insetY;
        if (orient == 1 || orient == 3) {
            int temp = objectSizeX;
            objectSizeX = objectSizeY;
            objectSizeY = temp;
        }
        for (int x = objectX; objectSizeX + objectX > x; ++x) {
            if (x < 0 || x >= this.width) continue;
            for (int y = objectY; objectSizeY + objectY > y; ++y) {
                if (y < 0 || this.height <= y) continue;
                this.orClipTable(x, y, occupied);
            }
        }
    }

    public void unmarkWall(int x, int y, int position, int orientation, boolean impenetrable) {
        x -= this.insetX;
        y -= this.insetY;
        if (position == 0) {
            if (orientation == 0) {
                this.unset(x, y, 128);
                this.unset(x - 1, y, 8);
            }
            if (orientation == 1) {
                this.unset(x, y, 2);
                this.unset(x, 1 + y, 32);
            }
            if (orientation == 2) {
                this.unset(x, y, 8);
                this.unset(1 + x, y, 128);
            }
            if (orientation == 3) {
                this.unset(x, y, 32);
                this.unset(x, y + -1, 2);
            }
        }
        if (position == 1 || position == 3) {
            if (orientation == 0) {
                this.unset(x, y, 1);
                this.unset(-1 + x, y + 1, 16);
            }
            if (orientation == 1) {
                this.unset(x, y, 4);
                this.unset(1 + x, 1 + y, 64);
            }
            if (orientation == 2) {
                this.unset(x, y, 16);
                this.unset(1 + x, -1 + y, 1);
            }
            if (orientation == 3) {
                this.unset(x, y, 64);
                this.unset(-1 + x, y + -1, 4);
            }
        }
        if (position == 2) {
            if (orientation == 0) {
                this.unset(x, y, 130);
                this.unset(-1 + x, y, 8);
                this.unset(x, 1 + y, 32);
            }
            if (orientation == 1) {
                this.unset(x, y, 10);
                this.unset(x, 1 + y, 32);
                this.unset(1 + x, y, 128);
            }
            if (orientation == 2) {
                this.unset(x, y, 40);
                this.unset(x + 1, y, 128);
                this.unset(x, -1 + y, 2);
            }
            if (orientation == 3) {
                this.unset(x, y, 160);
                this.unset(x, y - 1, 2);
                this.unset(x + -1, y, 8);
            }
        }
        if (impenetrable) {
            if (position == 0) {
                if (orientation == 0) {
                    this.unset(x, y, 65536);
                    this.unset(-1 + x, y, 4096);
                }
                if (orientation == 1) {
                    this.unset(x, y, 1024);
                    this.unset(x, 1 + y, 16384);
                }
                if (orientation == 2) {
                    this.unset(x, y, 4096);
                    this.unset(1 + x, y, 65536);
                }
                if (orientation == 3) {
                    this.unset(x, y, 16384);
                    this.unset(x, -1 + y, 1024);
                }
            }
            if (position == 1 || position == 3) {
                if (orientation == 0) {
                    this.unset(x, y, 512);
                    this.unset(-1 + x, 1 + y, 8192);
                }
                if (orientation == 1) {
                    this.unset(x, y, 2048);
                    this.unset(x + 1, y + 1, 32768);
                }
                if (orientation == 2) {
                    this.unset(x, y, 8192);
                    this.unset(1 + x, y - 1, 512);
                }
                if (orientation == 3) {
                    this.unset(x, y, 32768);
                    this.unset(x - 1, -1 + y, 2048);
                }
            }
            if (position == 2) {
                if (orientation == 0) {
                    this.unset(x, y, 66560);
                    this.unset(-1 + x, y, 4096);
                    this.unset(x, 1 + y, 16384);
                }
                if (orientation == 1) {
                    this.unset(x, y, 5120);
                    this.unset(x, y + 1, 16384);
                    this.unset(1 + x, y, 65536);
                }
                if (orientation == 2) {
                    this.unset(x, y, 20480);
                    this.unset(1 + x, y, 65536);
                    this.unset(x, -1 + y, 1024);
                }
                if (orientation == 3) {
                    this.unset(x, y, 81920);
                    this.unset(x, y + -1, 1024);
                    this.unset(x - 1, y, 4096);
                }
            }
        }
    }

    public void markBlocked(int y, int x) {
        this.clippingData[x -= this.insetX][y -= this.insetY] = BitUtils.bitWiseOR(this.clippingData[x][y], 0x200000);
    }

    public boolean reachedFacingObject(int currentX, int currentY, int goalX, int goalY, int goalDX, int goalDY, int surroundings) {
        int goalX2 = goalX + goalDX + -1;
        int goalY2 = -1 + goalY + goalDY;
        if (goalX <= currentX && goalX2 >= currentX && goalY <= currentY && goalY2 >= currentY) {
            return true;
        }
        if (goalX + -1 == currentX && goalY <= currentY && goalY2 >= currentY && (this.clippingData[-this.insetX + currentX][-this.insetY + currentY] & 8) == 0 && (surroundings & 8) == 0) {
            return true;
        }
        if (currentX == goalX2 + 1 && goalY <= currentY && currentY <= goalY2 && (this.clippingData[currentX - this.insetX][currentY + -this.insetY] & 0x80) == 0 && (2 & surroundings) == 0) {
            return true;
        }
        if (goalY - 1 == currentY && goalX <= currentX && goalX2 >= currentX && (this.clippingData[currentX - this.insetX][currentY - this.insetY] & 2) == 0 && (surroundings & 4) == 0) {
            return true;
        }
        return currentY == 1 + goalY2 && currentX >= goalX && currentX <= goalX2 && (this.clippingData[-this.insetX + currentX][currentY - this.insetY] & 0x20) == 0 && (1 & surroundings) == 0;
    }

    public void unmarkSolidOccupant(int x, int y, int width, int height, int orientation, boolean impenetrable) {
        int occupied = 256;
        x -= this.insetX;
        y -= this.insetY;
        if (impenetrable) {
            occupied += 131072;
        }
        if (orientation == 1 || orientation == 3) {
            int temp = width;
            width = height;
            height = temp;
        }
        for (int _x = x; _x < x + width; ++_x) {
            if (_x < 0 || _x >= this.width) continue;
            for (int _y = y; _y < height + y; ++_y) {
                if (_y < 0 || _y >= this.height) continue;
                this.unset(_x, _y, occupied);
            }
        }
    }

    public boolean reachedWall(int currentX, int currentY, int goalX, int goalY, int goalPosition, int goalOrientation) {
        if (goalX == currentX && goalY == currentY) {
            return true;
        }
        currentX -= this.insetX;
        goalX -= this.insetX;
        currentY -= this.insetY;
        goalY -= this.insetY;
        if (goalPosition == 0) {
            if (goalOrientation == 0) {
                if (goalX + -1 == currentX && currentY == goalY) {
                    return true;
                }
                if (goalX == currentX && currentY == goalY + 1 && (this.clippingData[currentX][currentY] & 0x1280120) == 0) {
                    return true;
                }
                if (goalX == currentX && -1 + goalY == currentY && (0x1280102 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
            } else if (goalOrientation == 1) {
                if (goalX == currentX && 1 + goalY == currentY) {
                    return true;
                }
                if (currentX == -1 + goalX && currentY == goalY && (this.clippingData[currentX][currentY] & 0x1280108) == 0) {
                    return true;
                }
                if (1 + goalX == currentX && currentY == goalY && (this.clippingData[currentX][currentY] & 0x1280180) == 0) {
                    return true;
                }
            } else if (goalOrientation == 2) {
                if (currentX == goalX + 1 && goalY == currentY) {
                    return true;
                }
                if (currentX == goalX && currentY == goalY + 1 && (this.clippingData[currentX][currentY] & 0x1280120) == 0) {
                    return true;
                }
                if (goalX == currentX && currentY == goalY + -1 && (this.clippingData[currentX][currentY] & 0x1280102) == 0) {
                    return true;
                }
            } else if (goalOrientation == 3) {
                if (goalX == currentX && goalY - 1 == currentY) {
                    return true;
                }
                if (-1 + goalX == currentX && goalY == currentY && (this.clippingData[currentX][currentY] & 0x1280108) == 0) {
                    return true;
                }
                if (currentX == 1 + goalX && currentY == goalY && (0x1280180 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
            }
        }
        if (goalPosition == 2) {
            if (goalOrientation == 0) {
                if (currentX == -1 + goalX && currentY == goalY) {
                    return true;
                }
                if (currentX == goalX && currentY == goalY + 1) {
                    return true;
                }
                if (currentX == goalX + 1 && goalY == currentY && (this.clippingData[currentX][currentY] & 0x1280180) == 0) {
                    return true;
                }
                if (goalX == currentX && currentY == goalY - 1 && (0x1280102 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
            } else if (goalOrientation == 1) {
                if (currentX == -1 + goalX && currentY == goalY && (this.clippingData[currentX][currentY] & 0x1280108) == 0) {
                    return true;
                }
                if (currentX == goalX && currentY == goalY + 1) {
                    return true;
                }
                if (currentX == goalX + 1 && goalY == currentY) {
                    return true;
                }
                if (currentX == goalX && currentY == goalY + -1 && (this.clippingData[currentX][currentY] & 0x1280102) == 0) {
                    return true;
                }
            } else if (goalOrientation == 2) {
                if (goalX + -1 == currentX && currentY == goalY && (this.clippingData[currentX][currentY] & 0x1280108) == 0) {
                    return true;
                }
                if (goalX == currentX && goalY + 1 == currentY && (0x1280120 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
                if (1 + goalX == currentX && goalY == currentY) {
                    return true;
                }
                if (currentX == goalX && goalY + -1 == currentY) {
                    return true;
                }
            } else if (goalOrientation == 3) {
                if (currentX == -1 + goalX && currentY == goalY) {
                    return true;
                }
                if (currentX == goalX && currentY == goalY + 1 && (0x1280120 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
                if (currentX == goalX + 1 && goalY == currentY && (0x1280180 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
                if (goalX == currentX && goalY + -1 == currentY) {
                    return true;
                }
            }
        }
        if (goalPosition == 9) {
            if (goalX == currentX && currentY == 1 + goalY && (0x20 & this.clippingData[currentX][currentY]) == 0) {
                return true;
            }
            if (currentX == goalX && currentY == -1 + goalY && (2 & this.clippingData[currentX][currentY]) == 0) {
                return true;
            }
            if (currentX == -1 + goalX && currentY == goalY && (8 & this.clippingData[currentX][currentY]) == 0) {
                return true;
            }
            return 1 + goalX == currentX && goalY == currentY && (this.clippingData[currentX][currentY] & 0x80) == 0;
        }
        return false;
    }

    public void orClipTable(int x, int y, int flag) {
        this.clippingData[x][y] = BitUtils.bitWiseAND(this.clippingData[x][y], -flag + 0xFFFFFF);
    }

    public boolean reachedWallDecoration(int currentX, int currentY, int goalX, int goalY, int goalPosition, int goalOrientation) {
        if (goalX == currentX && currentY == goalY) {
            return true;
        }
        currentX -= this.insetX;
        goalX -= this.insetX;
        currentY -= this.insetY;
        goalY -= this.insetY;
        if (goalPosition == 6 || goalPosition == 7) {
            if (goalPosition == 7) {
                goalOrientation = goalOrientation + 2 & 3;
            }
            if (goalOrientation == 0) {
                if (1 + goalX == currentX && currentY == goalY && (this.clippingData[currentX][currentY] & 0x80) == 0) {
                    return true;
                }
                if (goalX == currentX && -1 + goalY == currentY && (2 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
            } else if (goalOrientation == 1) {
                if (currentX == goalX + -1 && goalY == currentY && (this.clippingData[currentX][currentY] & 8) == 0) {
                    return true;
                }
                if (currentX == goalX && currentY == goalY + -1 && (this.clippingData[currentX][currentY] & 2) == 0) {
                    return true;
                }
            } else if (goalOrientation == 2) {
                if (currentX == goalX + -1 && goalY == currentY && (this.clippingData[currentX][currentY] & 8) == 0) {
                    return true;
                }
                if (currentX == goalX && currentY == 1 + goalY && (0x20 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
            } else if (goalOrientation == 3) {
                if (goalX + 1 == currentX && goalY == currentY && (this.clippingData[currentX][currentY] & 0x80) == 0) {
                    return true;
                }
                if (currentX == goalX && currentY == goalY + 1 && (0x20 & this.clippingData[currentX][currentY]) == 0) {
                    return true;
                }
            }
        }
        if (goalPosition == 8) {
            if (currentX == goalX && currentY == goalY + 1 && (this.clippingData[currentX][currentY] & 0x20) == 0) {
                return true;
            }
            if (goalX == currentX && currentY == goalY + -1 && (this.clippingData[currentX][currentY] & 2) == 0) {
                return true;
            }
            if (currentX == goalX - 1 && goalY == currentY && (this.clippingData[currentX][currentY] & 8) == 0) {
                return true;
            }
            return 1 + goalX == currentX && currentY == goalY && (0x80 & this.clippingData[currentX][currentY]) == 0;
        }
        return false;
    }
}

