/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.scene.camera;

import org.runejs.client.media.renderable.Model;
import org.runejs.client.scene.Point3d;
import org.runejs.client.scene.camera.CameraRotation;
import org.runejs.client.scene.camera.GameCamera;

public class SphericalCamera
extends GameCamera {
    private int originX = 0;
    private int originY = 0;
    private int originZ = 0;
    private int zoom = 600;
    private Point3d cartesian = new Point3d(0, 0, 0);

    @Override
    public Point3d getPosition() {
        return this.cartesian.add(this.offsetPosition);
    }

    @Override
    protected void onRotationUpdate(CameraRotation newRotation, CameraRotation oldRotation) {
        this.updateCartesian();
    }

    public void setOrigin(int x, int y, int z) {
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.updateCartesian();
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getOriginZ() {
        return this.originZ;
    }

    public int getYaw() {
        return this.rotation.yaw;
    }

    public int getPitch() {
        return this.rotation.pitch;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = Math.max(150, Math.min(zoom, 1600));
    }

    private void updateCartesian() {
        int temp;
        int sine;
        int cosine;
        int xOffset = 0;
        int yawDifference = 0x7FF & -this.rotation.yaw + 2048;
        int zOffset = 0;
        int pitchDifference = 2048 - this.rotation.pitch & 0x7FF;
        int yOffset = this.zoom + this.rotation.pitch * 3;
        if (pitchDifference != 0) {
            cosine = Model.COSINE[pitchDifference];
            sine = Model.SINE[pitchDifference];
            temp = zOffset * cosine + -(sine * yOffset) >> 16;
            yOffset = cosine * yOffset + sine * zOffset >> 16;
            zOffset = temp;
        }
        if (yawDifference != 0) {
            cosine = Model.COSINE[yawDifference];
            sine = Model.SINE[yawDifference];
            temp = cosine * xOffset + yOffset * sine >> 16;
            yOffset = -(xOffset * sine) + yOffset * cosine >> 16;
            xOffset = temp;
        }
        int cameraX = -xOffset + this.originX;
        int cameraY = this.originY + -yOffset;
        int cameraZ = -zOffset + this.originZ;
        this.cartesian = new Point3d(cameraX, cameraY, cameraZ);
    }
}

