/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.scene.camera;

import org.runejs.client.scene.Point3d;
import org.runejs.client.scene.camera.Camera;
import org.runejs.client.scene.camera.CameraRotation;

public abstract class GameCamera
implements Camera {
    protected CameraRotation rotation = new CameraRotation(0, 128);
    protected Point3d position = new Point3d(0, 0, 0);
    protected CameraRotation offsetRotation = new CameraRotation(0, 0);
    protected Point3d offsetPosition = new Point3d(0, 0, 0);

    protected abstract void onRotationUpdate(CameraRotation var1, CameraRotation var2);

    @Override
    public CameraRotation getRotation() {
        return this.rotation.add(this.offsetRotation);
    }

    public void setYaw(int yaw) {
        this.rotate(yaw, this.rotation.pitch);
    }

    public void setPitch(int pitch) {
        this.rotate(this.rotation.yaw, pitch);
    }

    @Override
    public void setOffsetPosition(Point3d newOffset) {
        this.offsetPosition = newOffset;
    }

    @Override
    public void setOffsetRotation(CameraRotation newOffset) {
        this.offsetRotation = newOffset;
    }

    public void rotate(int yaw, int pitch) {
        CameraRotation oldRotation = this.rotation;
        this.rotation = new CameraRotation(yaw, this.getClampedPitch(pitch));
        this.onRotationUpdate(this.rotation, oldRotation);
    }

    private int getClampedPitch(int pitch) {
        return Math.max(128, Math.min(pitch, 383));
    }

    @Override
    public Point3d getPosition() {
        return this.position.add(this.offsetPosition);
    }

    public void setPosition(Point3d position) {
        this.position = position;
    }
}

