/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.scene.camera;

import org.runejs.client.media.renderable.Model;

public class CameraRotation {
    public final int yaw;
    public final int yawSine;
    public final int yawCosine;
    public final int pitch;
    public final int pitchSine;
    public final int pitchCosine;

    public CameraRotation(int yaw, int pitch) {
        this.yaw = yaw & 0x7FF;
        this.pitch = pitch;
        this.pitchSine = Model.SINE[pitch];
        this.pitchCosine = Model.COSINE[pitch];
        this.yawSine = Model.SINE[yaw];
        this.yawCosine = Model.COSINE[yaw];
    }

    public CameraRotation add(CameraRotation other) {
        return new CameraRotation(this.yaw + other.yaw, this.pitch + other.pitch);
    }

    public CameraRotation addPitch(int pitch) {
        return new CameraRotation(this.yaw, this.pitch + pitch);
    }

    public CameraRotation addYaw(int yaw) {
        return new CameraRotation(this.yaw + yaw, this.pitch);
    }
}

