/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.scene;

import org.runejs.client.LinkedList;
import org.runejs.client.input.MouseHandler;
import org.runejs.client.media.Rasterizer3D;
import org.runejs.client.scene.CameraTileVisibility;
import org.runejs.client.scene.GroundItemTile;
import org.runejs.client.scene.InteractiveObject;
import org.runejs.client.scene.Point3d;
import org.runejs.client.scene.Scene;
import org.runejs.client.scene.SceneCluster;
import org.runejs.client.scene.Util3d;
import org.runejs.client.scene.camera.Camera;
import org.runejs.client.scene.camera.CameraRotation;
import org.runejs.client.scene.tile.ComplexTile;
import org.runejs.client.scene.tile.FloorDecoration;
import org.runejs.client.scene.tile.GenericTile;
import org.runejs.client.scene.tile.SceneTile;
import org.runejs.client.scene.tile.Wall;
import org.runejs.client.scene.tile.WallDecoration;

public class SceneRenderer {
    public static int[] WALL_DECORATION_INSET_X = new int[]{53, -53, -53, 53};
    public static int[] WALL_DECORATION_INSET_Y = new int[]{-53, -53, 53, 53};
    public static int[] WALL_DECORATION_OUTSET_X = new int[]{-45, 45, 45, -45};
    public static int[] WALL_DECORATION_OUTSET_Y = new int[]{45, 45, -45, -45};
    public static int[] FRONT_WALL_TYPES = new int[]{19, 55, 38, 155, 255, 110, 137, 205, 76};
    public static int[] DIRECTION_ALLOW_WALL_CORNER_TYPE = new int[]{160, 192, 80, 96, 0, 144, 80, 48, 160};
    public static int[] BACK_WALL_TYPES = new int[]{76, 8, 137, 4, 0, 1, 38, 2, 19};
    public static int[] WALL_CORNER_TYPE_16_BLOCK_OBJ_SPANS = new int[]{0, 0, 2, 0, 0, 2, 1, 1, 0};
    public static int[] WALL_CORNER_TYPE_32_BLOCK_OBJ_SPANS = new int[]{2, 0, 0, 2, 0, 0, 0, 4, 4};
    public static int[] WALL_CORNER_TYPE_64_BLOCK_OBJ_SPANS = new int[]{0, 4, 4, 8, 0, 0, 8, 0, 0};
    public static int[] WALL_CORNER_TYPE_128_BLOCK_OBJ_SPANS = new int[]{1, 1, 0, 0, 0, 8, 0, 0, 8};
    private static final int TILE_DRAW_DISTANCE = 75;
    private final Scene scene;
    private int drawFromTileX;
    private int drawFromTileY;
    private int drawToTileX;
    private int drawToTileY;
    private boolean[][] currentTileVisibilityMap;
    private LinkedList tileList = new LinkedList();
    private int[] screenX = new int[6];
    private int[] screenY = new int[6];
    private int[] viewspaceX = new int[6];
    private int[] viewspaceZ = new int[6];
    private int[] viewspaceY = new int[6];
    private Camera currentCamera;
    private CameraTileVisibility tileVisibilityInfo;

    public SceneRenderer(Scene scene) {
        this.scene = scene;
    }

    public void precalculateTileVisibility(int viewportWidth, int viewportHeight, int minHeight, int maxHeight, int[] heightsForPitch) {
        this.tileVisibilityInfo = new CameraTileVisibility(viewportWidth, viewportHeight, 75, minHeight, maxHeight, heightsForPitch);
    }

    public void render(Camera camera, int plane) {
        SceneTile sceneTile;
        int i;
        SceneTile[][] sceneTiles;
        Point3d cameraPos = camera.getPosition();
        CameraRotation cameraRotation = camera.getRotation();
        this.currentCamera = camera;
        int cameraPosX = cameraPos.x;
        int cameraPosY = cameraPos.y;
        int cameraPosZ = cameraPos.z;
        int yaw = cameraRotation.yaw;
        int pitch = cameraRotation.pitch;
        ++this.scene.cycle;
        this.currentTileVisibilityMap = this.tileVisibilityInfo.visibilityInfo[(pitch - 128) / 32][yaw / 64];
        this.drawFromTileX = this.currentCamera.getPosition().tileX - 75;
        if (this.drawFromTileX < 0) {
            this.drawFromTileX = 0;
        }
        this.drawFromTileY = this.currentCamera.getPosition().tileY - 75;
        if (this.drawFromTileY < 0) {
            this.drawFromTileY = 0;
        }
        this.drawToTileX = this.currentCamera.getPosition().tileX + 75;
        if (this.drawToTileX > this.scene.mapSizeX) {
            this.drawToTileX = this.scene.mapSizeX;
        }
        this.drawToTileY = this.currentCamera.getPosition().tileY + 75;
        if (this.drawToTileY > this.scene.mapSizeY) {
            this.drawToTileY = this.scene.mapSizeY;
        }
        this.processCulling(plane);
        this.scene.anInt109 = 0;
        for (int z = this.scene.plane; z < this.scene.mapSizeZ; ++z) {
            sceneTiles = this.scene.tileArray[z];
            for (int x = this.drawFromTileX; x < this.drawToTileX; ++x) {
                for (int y = this.drawFromTileY; y < this.drawToTileY; ++y) {
                    SceneTile sceneTile2 = sceneTiles[x][y];
                    if (sceneTile2 == null) continue;
                    if (sceneTile2.drawLevel > plane || !this.currentTileVisibilityMap[x - this.currentCamera.getPosition().tileX + 75][y - this.currentCamera.getPosition().tileY + 75] && this.scene.landscape.tile_height[z][x][y] - cameraPosZ < 70000) {
                        sceneTile2.draw = false;
                        sceneTile2.visible = false;
                        sceneTile2.wallCullDirection = 0;
                        continue;
                    }
                    sceneTile2.draw = true;
                    sceneTile2.visible = true;
                    sceneTile2.drawEntities = sceneTile2.entityCount > 0;
                    ++this.scene.anInt109;
                }
            }
        }
        for (i = this.scene.plane; i < this.scene.mapSizeZ; ++i) {
            sceneTiles = this.scene.tileArray[i];
            for (int i_25_ = -75; i_25_ <= 0; ++i_25_) {
                int i_26_ = this.currentCamera.getPosition().tileX + i_25_;
                int i_27_ = this.currentCamera.getPosition().tileX - i_25_;
                if (i_26_ < this.drawFromTileX && i_27_ >= this.drawToTileX) continue;
                for (int i_28_ = -75; i_28_ <= 0; ++i_28_) {
                    int i_29_ = this.currentCamera.getPosition().tileY + i_28_;
                    int i_30_ = this.currentCamera.getPosition().tileY - i_28_;
                    if (i_26_ >= this.drawFromTileX) {
                        if (i_29_ >= this.drawFromTileY && (sceneTile = sceneTiles[i_26_][i_29_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, true);
                        }
                        if (i_30_ < this.drawToTileY && (sceneTile = sceneTiles[i_26_][i_30_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, true);
                        }
                    }
                    if (i_27_ < this.drawToTileX) {
                        if (i_29_ >= this.drawFromTileY && (sceneTile = sceneTiles[i_27_][i_29_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, true);
                        }
                        if (i_30_ < this.drawToTileY && (sceneTile = sceneTiles[i_27_][i_30_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, true);
                        }
                    }
                    if (this.scene.anInt109 != 0) continue;
                    this.scene.clicked = false;
                    return;
                }
            }
        }
        for (i = this.scene.plane; i < this.scene.mapSizeZ; ++i) {
            sceneTiles = this.scene.tileArray[i];
            for (int i_31_ = -75; i_31_ <= 0; ++i_31_) {
                int i_32_ = this.currentCamera.getPosition().tileX + i_31_;
                int i_33_ = this.currentCamera.getPosition().tileX - i_31_;
                if (i_32_ < this.drawFromTileX && i_33_ >= this.drawToTileX) continue;
                for (int i_34_ = -75; i_34_ <= 0; ++i_34_) {
                    int i_35_ = this.currentCamera.getPosition().tileY + i_34_;
                    int i_36_ = this.currentCamera.getPosition().tileY - i_34_;
                    if (i_32_ >= this.drawFromTileX) {
                        if (i_35_ >= this.drawFromTileY && (sceneTile = sceneTiles[i_32_][i_35_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, false);
                        }
                        if (i_36_ < this.drawToTileY && (sceneTile = sceneTiles[i_32_][i_36_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, false);
                        }
                    }
                    if (i_33_ < this.drawToTileX) {
                        if (i_35_ >= this.drawFromTileY && (sceneTile = sceneTiles[i_33_][i_35_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, false);
                        }
                        if (i_36_ < this.drawToTileY && (sceneTile = sceneTiles[i_33_][i_36_]) != null && sceneTile.draw) {
                            this.renderTile(sceneTile, false);
                        }
                    }
                    if (this.scene.anInt109 != 0) continue;
                    this.scene.clicked = false;
                    return;
                }
            }
        }
        this.scene.clicked = false;
    }

    private void renderTile(SceneTile _tile, boolean arg1) {
        SceneTile groundTile;
        this.tileList.addLast(_tile);
        while ((groundTile = (SceneTile)this.tileList.removeFirst()) != null) {
            SceneTile sceneTile_143_;
            SceneTile sceneTile_142_;
            SceneTile sceneTile_141_;
            SceneTile sceneTile_140_;
            SceneTile sceneTile_139_;
            SceneTile sceneTile_128_;
            SceneTile sceneTile_127_;
            SceneTile sceneTile_126_;
            SceneTile sceneTile_125_;
            if (!groundTile.visible) continue;
            int x = groundTile.anInt2061;
            int y = groundTile.anInt2078;
            int z = groundTile.anInt2066;
            int i_78_ = groundTile.anInt2069;
            SceneTile[][] sceneTiles = this.scene.tileArray[z];
            if (groundTile.draw) {
                int i_98_;
                SceneTile tile;
                if (arg1) {
                    if (z > 0 && (tile = this.scene.tileArray[z - 1][x][y]) != null && tile.visible || x <= this.currentCamera.getPosition().tileX && x > this.drawFromTileX && (tile = sceneTiles[x - 1][y]) != null && tile.visible && (tile.draw || (groundTile.interactiveObjectsSizeOR & 1) == 0) || x >= this.currentCamera.getPosition().tileX && x < this.drawToTileX - 1 && (tile = sceneTiles[x + 1][y]) != null && tile.visible && (tile.draw || (groundTile.interactiveObjectsSizeOR & 4) == 0) || y <= this.currentCamera.getPosition().tileY && y > this.drawFromTileY && (tile = sceneTiles[x][y - 1]) != null && tile.visible && (tile.draw || (groundTile.interactiveObjectsSizeOR & 8) == 0) || y >= this.currentCamera.getPosition().tileY && y < this.drawToTileY - 1 && (tile = sceneTiles[x][y + 1]) != null && tile.visible && (tile.draw || (groundTile.interactiveObjectsSizeOR & 2) == 0)) {
                        continue;
                    }
                } else {
                    arg1 = true;
                }
                groundTile.draw = false;
                if (groundTile.aSceneTile_2058 != null) {
                    Wall wall;
                    tile = groundTile.aSceneTile_2058;
                    if (tile.plainTile != null) {
                        if (!this.scene.isTileOccluded(x, y, 0)) {
                            this.renderPlainTile(tile.plainTile, 0, x, y);
                        }
                    } else if (tile.shapedTile != null && !this.scene.isTileOccluded(x, y, 0)) {
                        this.renderShapedTile(tile.shapedTile, x, y);
                    }
                    if ((wall = tile.wall) != null) {
                        wall.primary.renderAtPoint(0, this.currentCamera.getRotation(), wall.x - this.currentCamera.getPosition().x, wall.z - this.currentCamera.getPosition().z, wall.y - this.currentCamera.getPosition().y, wall.hash);
                    }
                    for (int e = 0; e < tile.entityCount; ++e) {
                        InteractiveObject interactiveObject = tile.interactiveObjects[e];
                        if (interactiveObject == null) continue;
                        interactiveObject.renderable.renderAtPoint(interactiveObject.rotation, this.currentCamera.getRotation(), interactiveObject.worldX - this.currentCamera.getPosition().x, interactiveObject.worldZ - this.currentCamera.getPosition().z, interactiveObject.worldY - this.currentCamera.getPosition().y, interactiveObject.hash);
                    }
                }
                boolean bool = false;
                if (groundTile.plainTile != null) {
                    if (!this.scene.isTileOccluded(x, y, i_78_)) {
                        bool = true;
                        try {
                            this.renderPlainTile(groundTile.plainTile, i_78_, x, y);
                        }
                        catch (Exception wall) {}
                    }
                } else if (groundTile.shapedTile != null && !this.scene.isTileOccluded(x, y, i_78_)) {
                    bool = true;
                    this.renderShapedTile(groundTile.shapedTile, x, y);
                }
                int i_86_ = 0;
                int i_87_ = 0;
                Wall wall = groundTile.wall;
                WallDecoration wallDecoration = groundTile.wallDecoration;
                if (wall != null || wallDecoration != null) {
                    if (this.currentCamera.getPosition().tileX == x) {
                        ++i_86_;
                    } else if (this.currentCamera.getPosition().tileX < x) {
                        i_86_ += 2;
                    }
                    if (this.currentCamera.getPosition().tileY == y) {
                        i_86_ += 3;
                    } else if (this.currentCamera.getPosition().tileY > y) {
                        i_86_ += 6;
                    }
                    i_87_ = FRONT_WALL_TYPES[i_86_];
                    groundTile.anInt2064 = BACK_WALL_TYPES[i_86_];
                }
                if (wall != null) {
                    if ((wall.orientationA & DIRECTION_ALLOW_WALL_CORNER_TYPE[i_86_]) != 0) {
                        if (wall.orientationA == 16) {
                            groundTile.wallCullDirection = 3;
                            groundTile.wallUncullDirection = WALL_CORNER_TYPE_16_BLOCK_OBJ_SPANS[i_86_];
                            groundTile.wallCullOppositeDirection = 3 - groundTile.wallUncullDirection;
                        } else if (wall.orientationA == 32) {
                            groundTile.wallCullDirection = 6;
                            groundTile.wallUncullDirection = WALL_CORNER_TYPE_32_BLOCK_OBJ_SPANS[i_86_];
                            groundTile.wallCullOppositeDirection = 6 - groundTile.wallUncullDirection;
                        } else if (wall.orientationA == 64) {
                            groundTile.wallCullDirection = 12;
                            groundTile.wallUncullDirection = WALL_CORNER_TYPE_64_BLOCK_OBJ_SPANS[i_86_];
                            groundTile.wallCullOppositeDirection = 12 - groundTile.wallUncullDirection;
                        } else {
                            groundTile.wallCullDirection = 9;
                            groundTile.wallUncullDirection = WALL_CORNER_TYPE_128_BLOCK_OBJ_SPANS[i_86_];
                            groundTile.wallCullOppositeDirection = 9 - groundTile.wallUncullDirection;
                        }
                    } else {
                        groundTile.wallCullDirection = 0;
                    }
                    if ((wall.orientationA & i_87_) != 0 && !this.scene.isWallOccluded(this.currentCamera, i_78_, x, y, wall.orientationA)) {
                        wall.primary.renderAtPoint(0, this.currentCamera.getRotation(), wall.x - this.currentCamera.getPosition().x, wall.z - this.currentCamera.getPosition().z, wall.y - this.currentCamera.getPosition().y, wall.hash);
                    }
                    if ((wall.orientationB & i_87_) != 0 && !this.scene.isWallOccluded(this.currentCamera, i_78_, x, y, wall.orientationB)) {
                        wall.secondary.renderAtPoint(0, this.currentCamera.getRotation(), wall.x - this.currentCamera.getPosition().x, wall.z - this.currentCamera.getPosition().z, wall.y - this.currentCamera.getPosition().y, wall.hash);
                    }
                }
                if (wallDecoration != null && !this.scene.isOccluded(i_78_, x, y, wallDecoration.renderable.modelHeight)) {
                    if ((wallDecoration.configBits & i_87_) != 0) {
                        wallDecoration.renderable.renderAtPoint(wallDecoration.face, this.currentCamera.getRotation(), wallDecoration.x - this.currentCamera.getPosition().x, wallDecoration.z - this.currentCamera.getPosition().z, wallDecoration.y - this.currentCamera.getPosition().y, wallDecoration.hash);
                    } else if ((wallDecoration.configBits & 0x300) != 0) {
                        int i_88_ = wallDecoration.x - this.currentCamera.getPosition().x;
                        int i_89_ = wallDecoration.z - this.currentCamera.getPosition().z;
                        int i_90_ = wallDecoration.y - this.currentCamera.getPosition().y;
                        int i_91_ = wallDecoration.face;
                        int i_92_ = i_91_ == 1 || i_91_ == 2 ? -i_88_ : i_88_;
                        int i_93_ = i_91_ == 2 || i_91_ == 3 ? -i_90_ : i_90_;
                        if ((wallDecoration.configBits & 0x100) != 0 && i_93_ < i_92_) {
                            int i_94_ = i_88_ + WALL_DECORATION_INSET_X[i_91_];
                            int i_95_ = i_90_ + WALL_DECORATION_INSET_Y[i_91_];
                            wallDecoration.renderable.renderAtPoint(i_91_ * 512 + 256, this.currentCamera.getRotation(), i_94_, i_89_, i_95_, wallDecoration.hash);
                        }
                        if ((wallDecoration.configBits & 0x200) != 0 && i_93_ > i_92_) {
                            int i_96_ = i_88_ + WALL_DECORATION_OUTSET_X[i_91_];
                            int i_97_ = i_90_ + WALL_DECORATION_OUTSET_Y[i_91_];
                            wallDecoration.renderable.renderAtPoint(i_91_ * 512 + 1280 & 0x7FF, this.currentCamera.getRotation(), i_96_, i_89_, i_97_, wallDecoration.hash);
                        }
                    }
                }
                if (bool) {
                    GroundItemTile groundItemTile;
                    FloorDecoration floorDecoration = groundTile.floorDecoration;
                    if (floorDecoration != null) {
                        floorDecoration.renderable.renderAtPoint(0, this.currentCamera.getRotation(), floorDecoration.x - this.currentCamera.getPosition().x, floorDecoration.z - this.currentCamera.getPosition().z, floorDecoration.y - this.currentCamera.getPosition().y, floorDecoration.hash);
                    }
                    if ((groundItemTile = groundTile.groundItemTile) != null && groundItemTile.anInt1371 == 0) {
                        if (groundItemTile.secondGroundItem != null) {
                            groundItemTile.secondGroundItem.renderAtPoint(0, this.currentCamera.getRotation(), groundItemTile.x - this.currentCamera.getPosition().x, groundItemTile.z - this.currentCamera.getPosition().z, groundItemTile.y - this.currentCamera.getPosition().y, groundItemTile.hash);
                        }
                        if (groundItemTile.thirdGroundItem != null) {
                            groundItemTile.thirdGroundItem.renderAtPoint(0, this.currentCamera.getRotation(), groundItemTile.x - this.currentCamera.getPosition().x, groundItemTile.z - this.currentCamera.getPosition().z, groundItemTile.y - this.currentCamera.getPosition().y, groundItemTile.hash);
                        }
                        if (groundItemTile.firstGroundItem != null) {
                            groundItemTile.firstGroundItem.renderAtPoint(0, this.currentCamera.getRotation(), groundItemTile.x - this.currentCamera.getPosition().x, groundItemTile.z - this.currentCamera.getPosition().z, groundItemTile.y - this.currentCamera.getPosition().y, groundItemTile.hash);
                        }
                    }
                }
                if ((i_98_ = groundTile.interactiveObjectsSizeOR) != 0) {
                    SceneTile tile2;
                    SceneTile sceneTile_101_;
                    SceneTile sceneTile_100_;
                    SceneTile sceneTile_99_;
                    if (x < this.currentCamera.getPosition().tileX && (i_98_ & 4) != 0 && (sceneTile_99_ = sceneTiles[x + 1][y]) != null && sceneTile_99_.visible) {
                        this.tileList.addLast(sceneTile_99_);
                    }
                    if (y < this.currentCamera.getPosition().tileY && (i_98_ & 2) != 0 && (sceneTile_100_ = sceneTiles[x][y + 1]) != null && sceneTile_100_.visible) {
                        this.tileList.addLast(sceneTile_100_);
                    }
                    if (x > this.currentCamera.getPosition().tileX && (i_98_ & 1) != 0 && (sceneTile_101_ = sceneTiles[x - 1][y]) != null && sceneTile_101_.visible) {
                        this.tileList.addLast(sceneTile_101_);
                    }
                    if (y > this.currentCamera.getPosition().tileY && (i_98_ & 8) != 0 && (tile2 = sceneTiles[x][y - 1]) != null && tile2.visible) {
                        this.tileList.addLast(tile2);
                    }
                }
            }
            if (groundTile.wallCullDirection != 0) {
                boolean bool = true;
                for (int i_103_ = 0; i_103_ < groundTile.entityCount; ++i_103_) {
                    if (groundTile.interactiveObjects[i_103_].cycle == this.scene.cycle || (groundTile.sceneSpawnRequestsSize[i_103_] & groundTile.wallCullDirection) != groundTile.wallUncullDirection) continue;
                    bool = false;
                    break;
                }
                if (bool) {
                    Wall wall = groundTile.wall;
                    if (!this.scene.isWallOccluded(this.currentCamera, i_78_, x, y, wall.orientationA)) {
                        wall.primary.renderAtPoint(0, this.currentCamera.getRotation(), wall.x - this.currentCamera.getPosition().x, wall.z - this.currentCamera.getPosition().z, wall.y - this.currentCamera.getPosition().y, wall.hash);
                    }
                    groundTile.wallCullDirection = 0;
                }
            }
            if (groundTile.drawEntities) {
                try {
                    int i_104_ = groundTile.entityCount;
                    groundTile.drawEntities = false;
                    int i_105_ = 0;
                    block7: for (int i_106_ = 0; i_106_ < i_104_; ++i_106_) {
                        int i_113_;
                        int i_114_;
                        InteractiveObject entity = groundTile.interactiveObjects[i_106_];
                        if (entity.cycle == this.scene.cycle) continue;
                        for (int i_107_ = entity.tileLeft; i_107_ <= entity.tileRight; ++i_107_) {
                            for (int i_108_ = entity.tileTop; i_108_ <= entity.tileBottom; ++i_108_) {
                                SceneTile tile = sceneTiles[i_107_][i_108_];
                                if (tile.draw) {
                                    groundTile.drawEntities = true;
                                    continue block7;
                                }
                                if (tile.wallCullDirection == 0) continue;
                                int i_110_ = 0;
                                if (i_107_ > entity.tileLeft) {
                                    ++i_110_;
                                }
                                if (i_107_ < entity.tileRight) {
                                    i_110_ += 4;
                                }
                                if (i_108_ > entity.tileTop) {
                                    i_110_ += 8;
                                }
                                if (i_108_ < entity.tileBottom) {
                                    i_110_ += 2;
                                }
                                if ((i_110_ & tile.wallCullDirection) != groundTile.wallCullOppositeDirection) continue;
                                groundTile.drawEntities = true;
                                continue block7;
                            }
                        }
                        this.scene.interactiveObjects[i_105_++] = entity;
                        int i_112_ = entity.tileRight - this.currentCamera.getPosition().tileX;
                        int i_111_ = this.currentCamera.getPosition().tileX - entity.tileLeft;
                        if (i_112_ > i_111_) {
                            i_111_ = i_112_;
                        }
                        entity.anInt491 = (i_114_ = entity.tileBottom - this.currentCamera.getPosition().tileY) > (i_113_ = this.currentCamera.getPosition().tileY - entity.tileTop) ? i_111_ + i_114_ : i_111_ + i_113_;
                    }
                    while (i_105_ > 0) {
                        int i_115_ = -50;
                        int i_116_ = -1;
                        for (int i_117_ = 0; i_117_ < i_105_; ++i_117_) {
                            int i_121_;
                            int i_120_;
                            int i_119_;
                            int i_118_;
                            InteractiveObject interactiveObject = this.scene.interactiveObjects[i_117_];
                            if (interactiveObject.cycle == this.scene.cycle) continue;
                            if (interactiveObject.anInt491 > i_115_) {
                                i_115_ = interactiveObject.anInt491;
                                i_116_ = i_117_;
                                continue;
                            }
                            if (interactiveObject.anInt491 != i_115_ || (i_118_ = interactiveObject.worldX - this.currentCamera.getPosition().x) * i_118_ + (i_119_ = interactiveObject.worldY - this.currentCamera.getPosition().y) * i_119_ <= (i_120_ = this.scene.interactiveObjects[i_116_].worldX - this.currentCamera.getPosition().x) * i_120_ + (i_121_ = this.scene.interactiveObjects[i_116_].worldY - this.currentCamera.getPosition().y) * i_121_) continue;
                            i_116_ = i_117_;
                        }
                        if (i_116_ == -1) break;
                        InteractiveObject interactiveObject = this.scene.interactiveObjects[i_116_];
                        interactiveObject.cycle = this.scene.cycle;
                        if (!this.scene.isAreaOccluded(i_78_, interactiveObject.tileLeft, interactiveObject.tileRight, interactiveObject.tileTop, interactiveObject.tileBottom, interactiveObject.renderable.modelHeight)) {
                            interactiveObject.renderable.renderAtPoint(interactiveObject.rotation, this.currentCamera.getRotation(), interactiveObject.worldX - this.currentCamera.getPosition().x, interactiveObject.worldZ - this.currentCamera.getPosition().z, interactiveObject.worldY - this.currentCamera.getPosition().y, interactiveObject.hash);
                        }
                        for (int i_122_ = interactiveObject.tileLeft; i_122_ <= interactiveObject.tileRight; ++i_122_) {
                            for (int i_123_ = interactiveObject.tileTop; i_123_ <= interactiveObject.tileBottom; ++i_123_) {
                                SceneTile sceneTile_124_ = sceneTiles[i_122_][i_123_];
                                if (sceneTile_124_.wallCullDirection != 0) {
                                    this.tileList.addLast(sceneTile_124_);
                                    continue;
                                }
                                if (i_122_ == x && i_123_ == y || !sceneTile_124_.visible) continue;
                                this.tileList.addLast(sceneTile_124_);
                            }
                        }
                    }
                    if (groundTile.drawEntities) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    groundTile.drawEntities = false;
                }
            }
            if (!groundTile.visible || groundTile.wallCullDirection != 0 || x <= this.currentCamera.getPosition().tileX && x > this.drawFromTileX && (sceneTile_125_ = sceneTiles[x - 1][y]) != null && sceneTile_125_.visible || x >= this.currentCamera.getPosition().tileX && x < this.drawToTileX - 1 && (sceneTile_126_ = sceneTiles[x + 1][y]) != null && sceneTile_126_.visible || y <= this.currentCamera.getPosition().tileY && y > this.drawFromTileY && (sceneTile_127_ = sceneTiles[x][y - 1]) != null && sceneTile_127_.visible || y >= this.currentCamera.getPosition().tileY && y < this.drawToTileY - 1 && (sceneTile_128_ = sceneTiles[x][y + 1]) != null && sceneTile_128_.visible) continue;
            groundTile.visible = false;
            --this.scene.anInt109;
            GroundItemTile groundItemTile = groundTile.groundItemTile;
            if (groundItemTile != null && groundItemTile.anInt1371 != 0) {
                if (groundItemTile.secondGroundItem != null) {
                    groundItemTile.secondGroundItem.renderAtPoint(0, this.currentCamera.getRotation(), groundItemTile.x - this.currentCamera.getPosition().x, groundItemTile.z - this.currentCamera.getPosition().z - groundItemTile.anInt1371, groundItemTile.y - this.currentCamera.getPosition().y, groundItemTile.hash);
                }
                if (groundItemTile.thirdGroundItem != null) {
                    groundItemTile.thirdGroundItem.renderAtPoint(0, this.currentCamera.getRotation(), groundItemTile.x - this.currentCamera.getPosition().x, groundItemTile.z - this.currentCamera.getPosition().z - groundItemTile.anInt1371, groundItemTile.y - this.currentCamera.getPosition().y, groundItemTile.hash);
                }
                if (groundItemTile.firstGroundItem != null) {
                    groundItemTile.firstGroundItem.renderAtPoint(0, this.currentCamera.getRotation(), groundItemTile.x - this.currentCamera.getPosition().x, groundItemTile.z - this.currentCamera.getPosition().z - groundItemTile.anInt1371, groundItemTile.y - this.currentCamera.getPosition().y, groundItemTile.hash);
                }
            }
            if (groundTile.anInt2064 != 0) {
                Wall wall;
                WallDecoration wallDecoration = groundTile.wallDecoration;
                if (wallDecoration != null && !this.scene.isOccluded(i_78_, x, y, wallDecoration.renderable.modelHeight)) {
                    if ((wallDecoration.configBits & groundTile.anInt2064) != 0) {
                        wallDecoration.renderable.renderAtPoint(wallDecoration.face, this.currentCamera.getRotation(), wallDecoration.x - this.currentCamera.getPosition().x, wallDecoration.z - this.currentCamera.getPosition().z, wallDecoration.y - this.currentCamera.getPosition().y, wallDecoration.hash);
                    } else if ((wallDecoration.configBits & 0x300) != 0) {
                        int i_129_ = wallDecoration.x - this.currentCamera.getPosition().x;
                        int i_130_ = wallDecoration.z - this.currentCamera.getPosition().z;
                        int i_131_ = wallDecoration.y - this.currentCamera.getPosition().y;
                        int i_132_ = wallDecoration.face;
                        int i_133_ = i_132_ == 1 || i_132_ == 2 ? -i_129_ : i_129_;
                        int i_134_ = i_132_ == 2 || i_132_ == 3 ? -i_131_ : i_131_;
                        if ((wallDecoration.configBits & 0x100) != 0 && i_134_ >= i_133_) {
                            int i_135_ = i_129_ + WALL_DECORATION_INSET_X[i_132_];
                            int i_136_ = i_131_ + WALL_DECORATION_INSET_Y[i_132_];
                            wallDecoration.renderable.renderAtPoint(i_132_ * 512 + 256, this.currentCamera.getRotation(), i_135_, i_130_, i_136_, wallDecoration.hash);
                        }
                        if ((wallDecoration.configBits & 0x200) != 0 && i_134_ <= i_133_) {
                            int i_137_ = i_129_ + WALL_DECORATION_OUTSET_X[i_132_];
                            int i_138_ = i_131_ + WALL_DECORATION_OUTSET_Y[i_132_];
                            wallDecoration.renderable.renderAtPoint(i_132_ * 512 + 1280 & 0x7FF, this.currentCamera.getRotation(), i_137_, i_130_, i_138_, wallDecoration.hash);
                        }
                    }
                }
                if ((wall = groundTile.wall) != null) {
                    if ((wall.orientationB & groundTile.anInt2064) != 0 && !this.scene.isWallOccluded(this.currentCamera, i_78_, x, y, wall.orientationB)) {
                        wall.secondary.renderAtPoint(0, this.currentCamera.getRotation(), wall.x - this.currentCamera.getPosition().x, wall.z - this.currentCamera.getPosition().z, wall.y - this.currentCamera.getPosition().y, wall.hash);
                    }
                    if ((wall.orientationA & groundTile.anInt2064) != 0 && !this.scene.isWallOccluded(this.currentCamera, i_78_, x, y, wall.orientationA)) {
                        wall.primary.renderAtPoint(0, this.currentCamera.getRotation(), wall.x - this.currentCamera.getPosition().x, wall.z - this.currentCamera.getPosition().z, wall.y - this.currentCamera.getPosition().y, wall.hash);
                    }
                }
            }
            if (z < this.scene.mapSizeZ - 1 && (sceneTile_139_ = this.scene.tileArray[z + 1][x][y]) != null && sceneTile_139_.visible) {
                this.tileList.addLast(sceneTile_139_);
            }
            if (x < this.currentCamera.getPosition().tileX && (sceneTile_140_ = sceneTiles[x + 1][y]) != null && sceneTile_140_.visible) {
                this.tileList.addLast(sceneTile_140_);
            }
            if (y < this.currentCamera.getPosition().tileY && (sceneTile_141_ = sceneTiles[x][y + 1]) != null && sceneTile_141_.visible) {
                this.tileList.addLast(sceneTile_141_);
            }
            if (x > this.currentCamera.getPosition().tileX && (sceneTile_142_ = sceneTiles[x - 1][y]) != null && sceneTile_142_.visible) {
                this.tileList.addLast(sceneTile_142_);
            }
            if (y <= this.currentCamera.getPosition().tileY || (sceneTile_143_ = sceneTiles[x][y - 1]) == null || !sceneTile_143_.visible) continue;
            this.tileList.addLast(sceneTile_143_);
        }
    }

    public void processCulling(int plane) {
        int i = this.scene.cullingClusterPointer[plane];
        SceneCluster[] sceneClusters = this.scene.cullingClusters[plane];
        this.scene.activeOccluderCount = 0;
        for (int i_172_ = 0; i_172_ < i; ++i_172_) {
            int i_185_;
            int i_183_;
            int i_181_;
            boolean bool;
            SceneCluster sceneCluster = sceneClusters[i_172_];
            if (sceneCluster.searchMask == 1) {
                int i_175_;
                int i_173_ = sceneCluster.tileStartX - this.currentCamera.getPosition().tileX + 75;
                if (i_173_ < 0 || i_173_ > 50) continue;
                int i_174_ = sceneCluster.tileStartY - this.currentCamera.getPosition().tileY + 75;
                if (i_174_ < 0) {
                    i_174_ = 0;
                }
                if ((i_175_ = sceneCluster.tileEndY - this.currentCamera.getPosition().tileY + 75) > 50) {
                    i_175_ = 50;
                }
                bool = false;
                while (i_174_ <= i_175_) {
                    if (!this.currentTileVisibilityMap[i_173_][i_174_++]) continue;
                    bool = true;
                    break;
                }
                if (!bool) continue;
                int i_176_ = this.currentCamera.getPosition().x - sceneCluster.worldStartX;
                if (i_176_ > 32) {
                    sceneCluster.tileDistanceEnum = 1;
                } else {
                    if (i_176_ >= -32) continue;
                    sceneCluster.tileDistanceEnum = 2;
                    i_176_ = -i_176_;
                }
                sceneCluster.worldDistanceFromCameraStartY = (sceneCluster.worldStartY - this.currentCamera.getPosition().y << 8) / i_176_;
                sceneCluster.worldDistanceFromCameraEndY = (sceneCluster.worldEndY - this.currentCamera.getPosition().y << 8) / i_176_;
                sceneCluster.worldDistanceFromCameraStartZ = (sceneCluster.worldEndZ - this.currentCamera.getPosition().z << 8) / i_176_;
                sceneCluster.worldDistanceFromCameraEndZ = (sceneCluster.worldStartZ - this.currentCamera.getPosition().z << 8) / i_176_;
                this.scene.processedCullingClusters[this.scene.activeOccluderCount++] = sceneCluster;
                continue;
            }
            if (sceneCluster.searchMask == 2) {
                int i_179_;
                int i_177_ = sceneCluster.tileStartY - this.currentCamera.getPosition().tileY + 75;
                if (i_177_ < 0 || i_177_ > 50) continue;
                int i_178_ = sceneCluster.tileStartX - this.currentCamera.getPosition().tileX + 75;
                if (i_178_ < 0) {
                    i_178_ = 0;
                }
                if ((i_179_ = sceneCluster.tileEndX - this.currentCamera.getPosition().tileX + 75) > 50) {
                    i_179_ = 50;
                }
                bool = false;
                while (i_178_ <= i_179_) {
                    if (!this.currentTileVisibilityMap[i_178_++][i_177_]) continue;
                    bool = true;
                    break;
                }
                if (!bool) continue;
                int i_180_ = this.currentCamera.getPosition().y - sceneCluster.worldStartY;
                if (i_180_ > 32) {
                    sceneCluster.tileDistanceEnum = 3;
                } else {
                    if (i_180_ >= -32) continue;
                    sceneCluster.tileDistanceEnum = 4;
                    i_180_ = -i_180_;
                }
                sceneCluster.worldDistanceFromCameraStartX = (sceneCluster.worldStartX - this.currentCamera.getPosition().x << 8) / i_180_;
                sceneCluster.worldDistanceFromCameraEndX = (sceneCluster.worldEndX - this.currentCamera.getPosition().x << 8) / i_180_;
                sceneCluster.worldDistanceFromCameraStartZ = (sceneCluster.worldEndZ - this.currentCamera.getPosition().z << 8) / i_180_;
                sceneCluster.worldDistanceFromCameraEndZ = (sceneCluster.worldStartZ - this.currentCamera.getPosition().z << 8) / i_180_;
                this.scene.processedCullingClusters[this.scene.activeOccluderCount++] = sceneCluster;
                continue;
            }
            if (sceneCluster.searchMask != 4 || (i_181_ = sceneCluster.worldEndZ - this.currentCamera.getPosition().z) <= 128) continue;
            int i_182_ = sceneCluster.tileStartY - this.currentCamera.getPosition().tileY + 75;
            if (i_182_ < 0) {
                i_182_ = 0;
            }
            if ((i_183_ = sceneCluster.tileEndY - this.currentCamera.getPosition().tileY + 75) > 50) {
                i_183_ = 50;
            }
            if (i_182_ > i_183_) continue;
            int i_184_ = sceneCluster.tileStartX - this.currentCamera.getPosition().tileX + 75;
            if (i_184_ < 0) {
                i_184_ = 0;
            }
            if ((i_185_ = sceneCluster.tileEndX - this.currentCamera.getPosition().tileX + 75) > 50) {
                i_185_ = 50;
            }
            boolean bool2 = false;
            block3: for (int i_186_ = i_184_; i_186_ <= i_185_; ++i_186_) {
                for (int i_187_ = i_182_; i_187_ <= i_183_; ++i_187_) {
                    if (!this.currentTileVisibilityMap[i_186_][i_187_]) continue;
                    bool2 = true;
                    break block3;
                }
            }
            if (!bool2) continue;
            sceneCluster.tileDistanceEnum = 5;
            sceneCluster.worldDistanceFromCameraStartX = (sceneCluster.worldStartX - this.currentCamera.getPosition().x << 8) / i_181_;
            sceneCluster.worldDistanceFromCameraEndX = (sceneCluster.worldEndX - this.currentCamera.getPosition().x << 8) / i_181_;
            sceneCluster.worldDistanceFromCameraStartY = (sceneCluster.worldStartY - this.currentCamera.getPosition().y << 8) / i_181_;
            sceneCluster.worldDistanceFromCameraEndY = (sceneCluster.worldEndY - this.currentCamera.getPosition().y << 8) / i_181_;
            this.scene.processedCullingClusters[this.scene.activeOccluderCount++] = sceneCluster;
        }
    }

    private void renderPlainTile(GenericTile plainTile, int plane, int tileX, int tileY) {
        int nwY;
        int neX;
        int seY;
        int nwX;
        int swX = nwX = (tileX << 7) - this.currentCamera.getPosition().x;
        int swY = seY = (tileY << 7) - this.currentCamera.getPosition().y;
        int seX = neX = swX + 128;
        int neY = nwY = swY + 128;
        int swZ = this.scene.landscape.tile_height[plane][tileX][tileY] - this.currentCamera.getPosition().z;
        int seZ = this.scene.landscape.tile_height[plane][tileX + 1][tileY] - this.currentCamera.getPosition().z;
        int neZ = this.scene.landscape.tile_height[plane][tileX + 1][tileY + 1] - this.currentCamera.getPosition().z;
        int nwZ = this.scene.landscape.tile_height[plane][tileX][tileY + 1] - this.currentCamera.getPosition().z;
        int[] resultA = Util3d.getProjectedPoint(this.currentCamera, swX, swY, swZ);
        if (resultA == null) {
            return;
        }
        swX = resultA[0];
        swY = resultA[1];
        swZ = resultA[2];
        int[] resultB = Util3d.getProjectedPoint(this.currentCamera, seX, seY, seZ);
        if (resultB == null) {
            return;
        }
        seX = resultB[0];
        seY = resultB[1];
        seZ = resultB[2];
        int[] resultNE = Util3d.getProjectedPoint(this.currentCamera, neX, neY, neZ);
        if (resultNE == null) {
            return;
        }
        neX = resultNE[0];
        neY = resultNE[1];
        neZ = resultNE[2];
        int[] resultC = Util3d.getProjectedPoint(this.currentCamera, nwX, nwY, nwZ);
        if (resultC == null) {
            return;
        }
        nwX = resultC[0];
        nwY = resultC[1];
        nwZ = resultC[2];
        int screenXSW = Rasterizer3D.center_x + (swX << 9) / swY;
        int screenYSW = Rasterizer3D.center_y + (swZ << 9) / swY;
        int screenXSE = Rasterizer3D.center_x + (seX << 9) / seY;
        int screenYSE = Rasterizer3D.center_y + (seZ << 9) / seY;
        int screenXNE = Rasterizer3D.center_x + (neX << 9) / neY;
        int screenYNE = Rasterizer3D.center_y + (neZ << 9) / neY;
        int screenXNW = Rasterizer3D.center_x + (nwX << 9) / nwY;
        int screenYNW = Rasterizer3D.center_y + (nwZ << 9) / nwY;
        Rasterizer3D.alpha = 0;
        if ((screenXNE - screenXNW) * (screenYSE - screenYNW) - (screenYNE - screenYNW) * (screenXSE - screenXNW) > 0) {
            boolean bl = Rasterizer3D.restrict_edges = screenXNE < 0 || screenXNW < 0 || screenXSE < 0 || screenXNE > Rasterizer3D.viewportRx || screenXNW > Rasterizer3D.viewportRx || screenXSE > Rasterizer3D.viewportRx;
            if (this.scene.clicked && this.isMouseWithinTriangle(this.scene.clickX, this.scene.clickY, screenYNE, screenYNW, screenYSE, screenXNE, screenXNW, screenXSE)) {
                this.scene.clickedTileX = tileX;
                this.scene.clickedTileY = tileY;
            }
            if (this.isMouseWithinTriangle(MouseHandler.mouseX, MouseHandler.mouseY, screenYNE, screenYNW, screenYSE, screenXNE, screenXNW, screenXSE)) {
                this.scene.hoveredTileX = tileX;
                this.scene.hoveredTileY = tileY;
            }
            if (plainTile.texture == -1) {
                if (plainTile.colourNE != 12345678) {
                    Rasterizer3D.drawShadedTriangle(screenYNE, screenYNW, screenYSE, screenXNE, screenXNW, screenXSE, plainTile.colourNE, plainTile.colourNW, plainTile.colourSE);
                }
            } else if (Scene.lowMemory) {
                int rgb = Rasterizer3D.interface3.getAverageTextureColour(plainTile.texture);
                Rasterizer3D.drawShadedTriangle(screenYNE, screenYNW, screenYSE, screenXNE, screenXNW, screenXSE, Scene.adjustLightness(rgb, plainTile.colourNE), Scene.adjustLightness(rgb, plainTile.colourNW), Scene.adjustLightness(rgb, plainTile.colourSE));
            } else if (plainTile.flat) {
                Rasterizer3D.drawTexturedTriangle(screenYNE, screenYNW, screenYSE, screenXNE, screenXNW, screenXSE, plainTile.colourNE, plainTile.colourNW, plainTile.colourSE, swX, seX, nwX, swZ, seZ, nwZ, swY, seY, nwY, plainTile.texture);
            } else {
                Rasterizer3D.drawTexturedTriangle(screenYNE, screenYNW, screenYSE, screenXNE, screenXNW, screenXSE, plainTile.colourNE, plainTile.colourNW, plainTile.colourSE, neX, nwX, seX, neZ, nwZ, seZ, neY, nwY, seY, plainTile.texture);
            }
        }
        if ((screenXSW - screenXSE) * (screenYNW - screenYSE) - (screenYSW - screenYSE) * (screenXNW - screenXSE) > 0) {
            boolean bl = Rasterizer3D.restrict_edges = screenXSW < 0 || screenXSE < 0 || screenXNW < 0 || screenXSW > Rasterizer3D.viewportRx || screenXSE > Rasterizer3D.viewportRx || screenXNW > Rasterizer3D.viewportRx;
            if (this.scene.clicked && this.isMouseWithinTriangle(this.scene.clickX, this.scene.clickY, screenYSW, screenYSE, screenYNW, screenXSW, screenXSE, screenXNW)) {
                this.scene.clickedTileX = tileX;
                this.scene.clickedTileY = tileY;
            }
            if (this.isMouseWithinTriangle(MouseHandler.mouseX, MouseHandler.mouseY, screenYSW, screenYSE, screenYNW, screenXSW, screenXSE, screenXNW)) {
                this.scene.hoveredTileX = tileX;
                this.scene.hoveredTileY = tileY;
            }
            if (plainTile.texture == -1) {
                if (plainTile.colourSW != 12345678) {
                    Rasterizer3D.drawShadedTriangle(screenYSW, screenYSE, screenYNW, screenXSW, screenXSE, screenXNW, plainTile.colourSW, plainTile.colourSE, plainTile.colourNW);
                }
            } else if (Scene.lowMemory) {
                int i_209_ = Rasterizer3D.interface3.getAverageTextureColour(plainTile.texture);
                Rasterizer3D.drawShadedTriangle(screenYSW, screenYSE, screenYNW, screenXSW, screenXSE, screenXNW, Scene.adjustLightness(i_209_, plainTile.colourSW), Scene.adjustLightness(i_209_, plainTile.colourSE), Scene.adjustLightness(i_209_, plainTile.colourNW));
            } else {
                Rasterizer3D.drawTexturedTriangle(screenYSW, screenYSE, screenYNW, screenXSW, screenXSE, screenXNW, plainTile.colourSW, plainTile.colourSE, plainTile.colourNW, swX, seX, nwX, swZ, seZ, nwZ, swY, seY, nwY, plainTile.texture);
            }
        }
    }

    public void renderShapedTile(ComplexTile shapedTile, int tileX, int tileY) {
        int triangle;
        int sineX = this.currentCamera.getRotation().yawSine;
        int cosineX = this.currentCamera.getRotation().yawCosine;
        int sineY = this.currentCamera.getRotation().pitchSine;
        int cosineY = this.currentCamera.getRotation().pitchCosine;
        int triangleCount = shapedTile.originalVertexX.length;
        for (triangle = 0; triangle < triangleCount; ++triangle) {
            int viewX = shapedTile.originalVertexX[triangle] - this.currentCamera.getPosition().x;
            int viewY = shapedTile.originalVertexY[triangle] - this.currentCamera.getPosition().z;
            int viewZ = shapedTile.originalVertexZ[triangle] - this.currentCamera.getPosition().y;
            int temp = viewZ * sineX + viewX * cosineX >> 16;
            viewZ = viewZ * cosineX - viewX * sineX >> 16;
            viewX = temp;
            temp = viewY * cosineY - viewZ * sineY >> 16;
            viewZ = viewY * sineY + viewZ * cosineY >> 16;
            viewY = temp;
            if (viewZ < 50) {
                return;
            }
            if (shapedTile.triangleTexture != null) {
                this.viewspaceX[triangle] = viewX;
                this.viewspaceY[triangle] = viewY;
                this.viewspaceZ[triangle] = viewZ;
            }
            this.screenX[triangle] = Rasterizer3D.center_x + (viewX << 9) / viewZ;
            this.screenY[triangle] = Rasterizer3D.center_y + (viewY << 9) / viewZ;
        }
        Rasterizer3D.alpha = 0;
        triangleCount = shapedTile.triangleA.length;
        for (triangle = 0; triangle < triangleCount; ++triangle) {
            int a = shapedTile.triangleA[triangle];
            int screenXA = this.screenX[a];
            int b = shapedTile.triangleB[triangle];
            int screenXB = this.screenX[b];
            int c = shapedTile.triangleC[triangle];
            int screenYC = this.screenY[c];
            int screenYB = this.screenY[b];
            int screenYA = this.screenY[a];
            int screenXC = this.screenX[c];
            if ((screenXA - screenXB) * (screenYC - screenYB) - (screenYA - screenYB) * (screenXC - screenXB) <= 0) continue;
            boolean bl = Rasterizer3D.restrict_edges = screenXA < 0 || screenXB < 0 || screenXC < 0 || screenXA > Rasterizer3D.viewportRx || screenXB > Rasterizer3D.viewportRx || screenXC > Rasterizer3D.viewportRx;
            if (this.scene.clicked && this.isMouseWithinTriangle(this.scene.clickX, this.scene.clickY, screenYA, screenYB, screenYC, screenXA, screenXB, screenXC)) {
                this.scene.clickedTileX = tileX;
                this.scene.clickedTileY = tileY;
            }
            if (this.isMouseWithinTriangle(MouseHandler.mouseX, MouseHandler.mouseY, screenYA, screenYB, screenYC, screenXA, screenXB, screenXC)) {
                this.scene.hoveredTileX = tileX;
                this.scene.hoveredTileY = tileY;
            }
            if (shapedTile.triangleTexture == null || shapedTile.triangleTexture[triangle] == -1) {
                if (shapedTile.triangleHSLA[triangle] == 12345678) continue;
                Rasterizer3D.drawShadedTriangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, shapedTile.triangleHSLA[triangle], shapedTile.triangleHSLB[triangle], shapedTile.triangleHSLC[triangle]);
                continue;
            }
            if (Scene.lowMemory) {
                int i_240_ = Rasterizer3D.interface3.getAverageTextureColour(shapedTile.triangleTexture[triangle]);
                Rasterizer3D.drawShadedTriangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, Scene.adjustLightness(i_240_, shapedTile.triangleHSLA[triangle]), Scene.adjustLightness(i_240_, shapedTile.triangleHSLB[triangle]), Scene.adjustLightness(i_240_, shapedTile.triangleHSLC[triangle]));
                continue;
            }
            if (shapedTile.flat) {
                Rasterizer3D.drawTexturedTriangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, shapedTile.triangleHSLA[triangle], shapedTile.triangleHSLB[triangle], shapedTile.triangleHSLC[triangle], this.viewspaceX[0], this.viewspaceX[1], this.viewspaceX[3], this.viewspaceY[0], this.viewspaceY[1], this.viewspaceY[3], this.viewspaceZ[0], this.viewspaceZ[1], this.viewspaceZ[3], shapedTile.triangleTexture[triangle]);
                continue;
            }
            Rasterizer3D.drawTexturedTriangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, shapedTile.triangleHSLA[triangle], shapedTile.triangleHSLB[triangle], shapedTile.triangleHSLC[triangle], this.viewspaceX[a], this.viewspaceX[b], this.viewspaceX[c], this.viewspaceY[a], this.viewspaceY[b], this.viewspaceY[c], this.viewspaceZ[a], this.viewspaceZ[b], this.viewspaceZ[c], shapedTile.triangleTexture[triangle]);
        }
    }

    private boolean isMouseWithinTriangle(int mouseX, int mouseY, int pointAY, int pointBY, int pointCY, int pointAX, int pointBX, int pointCX) {
        if (mouseY < pointAY && mouseY < pointBY && mouseY < pointCY) {
            return false;
        }
        if (mouseY > pointAY && mouseY > pointBY && mouseY > pointCY) {
            return false;
        }
        if (mouseX < pointAX && mouseX < pointBX && mouseX < pointCX) {
            return false;
        }
        if (mouseX > pointAX && mouseX > pointBX && mouseX > pointCX) {
            return false;
        }
        int b1 = (mouseY - pointAY) * (pointBX - pointAX) - (mouseX - pointAX) * (pointBY - pointAY);
        int b2 = (mouseY - pointCY) * (pointAX - pointCX) - (mouseX - pointCX) * (pointAY - pointCY);
        int b3 = (mouseY - pointBY) * (pointCX - pointBX) - (mouseX - pointBX) * (pointCY - pointBY);
        return b1 * b3 > 0 && b3 * b2 > 0;
    }
}

