/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.scene;

import java.util.Arrays;
import org.runejs.client.Landscape;
import org.runejs.client.MovedStatics;
import org.runejs.client.frame.Minimap;
import org.runejs.client.media.VertexNormal;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.media.renderable.Renderable;
import org.runejs.client.scene.GroundItemTile;
import org.runejs.client.scene.InteractiveObject;
import org.runejs.client.scene.SceneCluster;
import org.runejs.client.scene.camera.Camera;
import org.runejs.client.scene.tile.ComplexTile;
import org.runejs.client.scene.tile.FloorDecoration;
import org.runejs.client.scene.tile.GenericTile;
import org.runejs.client.scene.tile.SceneTile;
import org.runejs.client.scene.tile.Wall;
import org.runejs.client.scene.tile.WallDecoration;

public class Scene {
    public static int[] ROTATION_WALL_TYPE = new int[]{1, 2, 4, 8};
    public static int[] ROTATION_WALL_CORNER_TYPE = new int[]{16, 32, 64, 128};
    public static boolean lowMemory = true;
    public static int[] WALL_DECORATION_ROTATION_FORWARD_X = new int[]{1, 0, -1, 0};
    public static int[] WALL_DECORATION_ROTATION_FORWARD_Z = new int[]{0, -1, 0, 1};
    public final Landscape landscape;
    public SceneTile[][][] tileArray;
    public int[][][] tileOcclusionCycles;
    public int sceneSpawnRequestsCacheCurrentPos = 0;
    public InteractiveObject[] sceneSpawnRequestsCache = new InteractiveObject[5000];
    public int plane = 0;
    public int[][][] heightMap;
    public int mergeIndexTmp = 0;
    public int[] mergeIndexA = new int[10000];
    public int[] mergeIndexB = new int[10000];
    public int anInt109 = 0;
    public int cycle;
    public boolean clicked = false;
    public int clickX = 0;
    public int clickY = 0;
    public int clickedTileX = -1;
    public int clickedTileY = -1;
    public int hoveredTileX = -1;
    public int hoveredTileY = -1;
    public int mapSizeX = 104;
    public int mapSizeY = 104;
    public int mapSizeZ = 4;
    public int activeOccluderCount = 0;
    public SceneCluster[][] cullingClusters = new SceneCluster[this.mapSizeZ][500];
    public SceneCluster[] processedCullingClusters = new SceneCluster[500];
    public int[] cullingClusterPointer = new int[this.mapSizeZ];
    public InteractiveObject[] interactiveObjects = new InteractiveObject[100];

    public Scene() {
        this.landscape = new Landscape(this);
        this.tileArray = new SceneTile[this.mapSizeZ][this.mapSizeX][this.mapSizeY];
        this.tileOcclusionCycles = new int[this.mapSizeZ][this.mapSizeX + 1][this.mapSizeY + 1];
        this.heightMap = this.landscape.tile_height;
        this.initToNull();
    }

    public static int adjustLightness(int hsl, int lightness) {
        if ((lightness = (127 - lightness) * (hsl & 0x7F) >> 7) < 2) {
            lightness = 2;
        } else if (lightness > 126) {
            lightness = 126;
        }
        return (hsl & 0xFF80) + lightness;
    }

    public void createOccluder(int z, int searchMask, int lowestX, int highestX, int lowestY, int highestY, int highestZ, int lowestZ) {
        SceneCluster sceneCluster = new SceneCluster();
        sceneCluster.tileStartX = lowestX / 128;
        sceneCluster.tileEndX = highestX / 128;
        sceneCluster.tileStartY = lowestY / 128;
        sceneCluster.tileEndY = highestY / 128;
        sceneCluster.searchMask = searchMask;
        sceneCluster.worldStartX = lowestX;
        sceneCluster.worldEndX = highestX;
        sceneCluster.worldStartY = lowestY;
        sceneCluster.worldEndY = highestY;
        sceneCluster.worldEndZ = highestZ;
        sceneCluster.worldStartZ = lowestZ;
        int n = z;
        int n2 = this.cullingClusterPointer[n];
        this.cullingClusterPointer[n] = n2 + 1;
        this.cullingClusters[z][n2] = sceneCluster;
    }

    public int getWallDecorationHash(int arg0, int arg1, int arg2) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile == null || sceneTile.wallDecoration == null) {
            return 0;
        }
        return sceneTile.wallDecoration.hash;
    }

    public void setTileBridge(int x, int y) {
        SceneTile baseTile = this.tileArray[0][x][y];
        for (int plane = 0; plane < 3; ++plane) {
            this.tileArray[plane][x][y] = this.tileArray[plane + 1][x][y];
            SceneTile currentTile = this.tileArray[plane][x][y];
            if (currentTile == null) continue;
            --currentTile.anInt2066;
            for (int i = 0; i < currentTile.entityCount; ++i) {
                InteractiveObject interactiveObject = currentTile.interactiveObjects[i];
                if ((interactiveObject.hash >> 29 & 3) != 2 || interactiveObject.tileLeft != x || interactiveObject.tileTop != y) continue;
                --interactiveObject.z;
            }
        }
        if (this.tileArray[0][x][y] == null) {
            this.tileArray[0][x][y] = new SceneTile(0, x, y);
        }
        this.tileArray[0][x][y].aSceneTile_2058 = baseTile;
        this.tileArray[3][x][y] = null;
    }

    public int getFloorDecorationHash(int z, int x, int y) {
        SceneTile sceneTile = this.tileArray[z][x][y];
        if (sceneTile == null || sceneTile.floorDecoration == null) {
            return 0;
        }
        return sceneTile.floorDecoration.hash;
    }

    public void addWall(int x, int y, int z, int drawHeight, int orientation, int orientation2, int hash, Renderable primary, Renderable secondary, int config) {
        if (primary != null || secondary != null) {
            Wall wall = new Wall();
            wall.hash = hash;
            wall.config = config;
            wall.x = x * 128 + 64;
            wall.y = y * 128 + 64;
            wall.z = drawHeight;
            wall.primary = primary;
            wall.secondary = secondary;
            wall.orientationA = orientation;
            wall.orientationB = orientation2;
            for (int _z = z; _z >= 0; --_z) {
                if (this.tileArray[_z][x][y] != null) continue;
                this.tileArray[_z][x][y] = new SceneTile(_z, x, y);
            }
            this.tileArray[z][x][y].wall = wall;
        }
    }

    public void drawMinimapTile(int[] destPixels, int offset, int step, int plane, int tileX, int tileY) {
        block10: {
            GenericTile genericTile;
            block11: {
                SceneTile sceneTile = this.tileArray[plane][tileX][tileY];
                if (sceneTile == null) break block10;
                genericTile = sceneTile.plainTile;
                if (genericTile != null) break block11;
                ComplexTile complexTile = sceneTile.shapedTile;
                if (complexTile == null) break block10;
                int shape = complexTile.shape;
                int rotation = complexTile.rotation;
                int underlayColor = complexTile.underlayRGB;
                int overlayColor = complexTile.overlayRGB;
                int[] is = Minimap.MINIMAP_TILE_MASK[shape];
                int[] is_19_ = Minimap.MINIMAP_TILE_ROTATION_MAP[rotation];
                int pointer = 0;
                if (underlayColor == 0) {
                    for (int i_22_ = 0; i_22_ < 4; ++i_22_) {
                        if (is[is_19_[pointer++]] != 0) {
                            destPixels[offset] = overlayColor;
                        }
                        if (is[is_19_[pointer++]] != 0) {
                            destPixels[offset + 1] = overlayColor;
                        }
                        if (is[is_19_[pointer++]] != 0) {
                            destPixels[offset + 2] = overlayColor;
                        }
                        if (is[is_19_[pointer++]] != 0) {
                            destPixels[offset + 3] = overlayColor;
                        }
                        offset += step;
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                        destPixels[offset] = is[is_19_[pointer++]] == 0 ? underlayColor : overlayColor;
                        destPixels[offset + 1] = is[is_19_[pointer++]] == 0 ? underlayColor : overlayColor;
                        destPixels[offset + 2] = is[is_19_[pointer++]] == 0 ? underlayColor : overlayColor;
                        destPixels[offset + 3] = is[is_19_[pointer++]] == 0 ? underlayColor : overlayColor;
                        offset += step;
                    }
                }
                break block10;
            }
            int color = genericTile.rgbColor;
            if (color != 0) {
                for (int i = 0; i < 4; ++i) {
                    destPixels[offset] = color;
                    destPixels[offset + 1] = color;
                    destPixels[offset + 2] = color;
                    destPixels[offset + 3] = color;
                    offset += step;
                }
            }
        }
    }

    public void initToNull() {
        int i;
        for (int z = 0; z < this.mapSizeZ; ++z) {
            for (int x = 0; x < this.mapSizeX; ++x) {
                for (int y = 0; y < this.mapSizeY; ++y) {
                    this.tileArray[z][x][y] = null;
                }
            }
        }
        for (i = 0; i < this.mapSizeZ; ++i) {
            for (int i_39_ = 0; i_39_ < this.cullingClusterPointer[i]; ++i_39_) {
                this.cullingClusters[i][i_39_] = null;
            }
            this.cullingClusterPointer[i] = 0;
        }
        for (i = 0; i < this.sceneSpawnRequestsCacheCurrentPos; ++i) {
            this.sceneSpawnRequestsCache[i] = null;
        }
        this.sceneSpawnRequestsCacheCurrentPos = 0;
        Arrays.fill(this.interactiveObjects, null);
    }

    public void addTile(int plane, int x, int y, int shape, int clippingPathRotation, int textureId, int vertexHeightSW, int vertexHeightSE, int vertexHeightNE, int vertexHeightNW, int overlayColourA, int overlayColourB, int overlayColourD, int overlayColourC, int underlayColourA, int underlayColourB, int underlayColourD, int underlayColourC, int underlayRGB, int overlayRGB) {
        if (shape == 0) {
            GenericTile genericTile = new GenericTile(overlayColourA, overlayColourB, overlayColourC, overlayColourD, -1, underlayRGB, false);
            for (int _z = plane; _z >= 0; --_z) {
                if (this.tileArray[_z][x][y] != null) continue;
                this.tileArray[_z][x][y] = new SceneTile(_z, x, y);
            }
            this.tileArray[plane][x][y].plainTile = genericTile;
        } else if (shape == 1) {
            GenericTile genericTile = new GenericTile(underlayColourA, underlayColourB, underlayColourC, underlayColourD, textureId, overlayRGB, vertexHeightSW == vertexHeightSE && vertexHeightSW == vertexHeightNE && vertexHeightSW == vertexHeightNW);
            for (int _z = plane; _z >= 0; --_z) {
                if (this.tileArray[_z][x][y] != null) continue;
                this.tileArray[_z][x][y] = new SceneTile(_z, x, y);
            }
            this.tileArray[plane][x][y].plainTile = genericTile;
        } else {
            ComplexTile complexTile = new ComplexTile(x, vertexHeightSW, vertexHeightSE, vertexHeightNW, vertexHeightNE, y, clippingPathRotation, textureId, shape, overlayColourA, underlayColourA, overlayColourB, underlayColourB, overlayColourD, underlayColourD, overlayColourC, underlayColourC, overlayRGB, underlayRGB);
            for (int _z = plane; _z >= 0; --_z) {
                if (this.tileArray[_z][x][y] != null) continue;
                this.tileArray[_z][x][y] = new SceneTile(_z, x, y);
            }
            this.tileArray[plane][x][y].shapedTile = complexTile;
        }
    }

    public WallDecoration getWallDecoration(int level, int x, int y) {
        SceneTile sceneTile = this.tileArray[level][x][y];
        if (sceneTile == null) {
            return null;
        }
        return sceneTile.wallDecoration;
    }

    public boolean isTileOccluded(int x, int y, int z) {
        int i = this.tileOcclusionCycles[z][x][y];
        if (i == -this.cycle) {
            return false;
        }
        if (i == this.cycle) {
            return true;
        }
        int worldX = x << 7;
        int worldY = y << 7;
        if (this.isPointOccluded(worldX + 1, this.heightMap[z][x][y], worldY + 1) && this.isPointOccluded(worldX + 128 - 1, this.heightMap[z][x + 1][y], worldY + 1) && this.isPointOccluded(worldX + 128 - 1, this.heightMap[z][x + 1][y + 1], worldY + 128 - 1) && this.isPointOccluded(worldX + 1, this.heightMap[z][x][y + 1], worldY + 128 - 1)) {
            this.tileOcclusionCycles[z][x][y] = this.cycle;
            return true;
        }
        this.tileOcclusionCycles[z][x][y] = -this.cycle;
        return false;
    }

    public boolean isWallOccluded(Camera currentCamera, int level, int x, int y, int wallType) {
        if (!this.isTileOccluded(x, y, level)) {
            return false;
        }
        int posX = x << 7;
        int posY = y << 7;
        int posZ = this.heightMap[level][x][y] - 1;
        int z1 = posZ - 120;
        int z2 = posZ - 230;
        int z3 = posZ - 238;
        if (wallType < 16) {
            if (wallType == 1) {
                if (posX > currentCamera.getPosition().x) {
                    if (!this.isPointOccluded(posX, posZ, posY)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX, posZ, posY + 128)) {
                        return false;
                    }
                }
                if (level > 0) {
                    if (!this.isPointOccluded(posX, z1, posY)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX, z1, posY + 128)) {
                        return false;
                    }
                }
                if (!this.isPointOccluded(posX, z2, posY)) {
                    return false;
                }
                return this.isPointOccluded(posX, z2, posY + 128);
            }
            if (wallType == 2) {
                if (posY < currentCamera.getPosition().y) {
                    if (!this.isPointOccluded(posX, posZ, posY + 128)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX + 128, posZ, posY + 128)) {
                        return false;
                    }
                }
                if (level > 0) {
                    if (!this.isPointOccluded(posX, z1, posY + 128)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX + 128, z1, posY + 128)) {
                        return false;
                    }
                }
                if (!this.isPointOccluded(posX, z2, posY + 128)) {
                    return false;
                }
                return this.isPointOccluded(posX + 128, z2, posY + 128);
            }
            if (wallType == 4) {
                if (posX < currentCamera.getPosition().x) {
                    if (!this.isPointOccluded(posX + 128, posZ, posY)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX + 128, posZ, posY + 128)) {
                        return false;
                    }
                }
                if (level > 0) {
                    if (!this.isPointOccluded(posX + 128, z1, posY)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX + 128, z1, posY + 128)) {
                        return false;
                    }
                }
                if (!this.isPointOccluded(posX + 128, z2, posY)) {
                    return false;
                }
                return this.isPointOccluded(posX + 128, z2, posY + 128);
            }
            if (wallType == 8) {
                if (posY > currentCamera.getPosition().y) {
                    if (!this.isPointOccluded(posX, posZ, posY)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX + 128, posZ, posY)) {
                        return false;
                    }
                }
                if (level > 0) {
                    if (!this.isPointOccluded(posX, z1, posY)) {
                        return false;
                    }
                    if (!this.isPointOccluded(posX + 128, z1, posY)) {
                        return false;
                    }
                }
                if (!this.isPointOccluded(posX, z2, posY)) {
                    return false;
                }
                return this.isPointOccluded(posX + 128, z2, posY);
            }
        }
        if (!this.isPointOccluded(posX + 64, z3, posY + 64)) {
            return false;
        }
        if (wallType == 16) {
            return this.isPointOccluded(posX, z2, posY + 128);
        }
        if (wallType == 32) {
            return this.isPointOccluded(posX + 128, z2, posY + 128);
        }
        if (wallType == 64) {
            return this.isPointOccluded(posX + 128, z2, posY);
        }
        if (wallType == 128) {
            return this.isPointOccluded(posX, z2, posY);
        }
        return true;
    }

    public boolean isPointOccluded(int posX, int posZ, int posY) {
        for (int i = 0; i < this.activeOccluderCount; ++i) {
            int deltaX;
            SceneCluster sceneCluster = this.processedCullingClusters[i];
            if (sceneCluster.tileDistanceEnum == 1) {
                deltaX = sceneCluster.worldStartX - posX;
                if (deltaX <= 0) continue;
                int i_48_ = sceneCluster.worldStartY + (sceneCluster.worldDistanceFromCameraStartY * deltaX >> 8);
                int i_49_ = sceneCluster.worldEndY + (sceneCluster.worldDistanceFromCameraEndY * deltaX >> 8);
                int i_50_ = sceneCluster.worldEndZ + (sceneCluster.worldDistanceFromCameraStartZ * deltaX >> 8);
                int i_51_ = sceneCluster.worldStartZ + (sceneCluster.worldDistanceFromCameraEndZ * deltaX >> 8);
                if (posY < i_48_ || posY > i_49_ || posZ < i_50_ || posZ > i_51_) continue;
                return true;
            }
            if (sceneCluster.tileDistanceEnum == 2) {
                deltaX = posX - sceneCluster.worldStartX;
                if (deltaX <= 0) continue;
                int i_53_ = sceneCluster.worldStartY + (sceneCluster.worldDistanceFromCameraStartY * deltaX >> 8);
                int i_54_ = sceneCluster.worldEndY + (sceneCluster.worldDistanceFromCameraEndY * deltaX >> 8);
                int i_55_ = sceneCluster.worldEndZ + (sceneCluster.worldDistanceFromCameraStartZ * deltaX >> 8);
                int i_56_ = sceneCluster.worldStartZ + (sceneCluster.worldDistanceFromCameraEndZ * deltaX >> 8);
                if (posY < i_53_ || posY > i_54_ || posZ < i_55_ || posZ > i_56_) continue;
                return true;
            }
            if (sceneCluster.tileDistanceEnum == 3) {
                deltaX = sceneCluster.worldStartY - posY;
                if (deltaX <= 0) continue;
                int i_58_ = sceneCluster.worldStartX + (sceneCluster.worldDistanceFromCameraStartX * deltaX >> 8);
                int i_59_ = sceneCluster.worldEndX + (sceneCluster.worldDistanceFromCameraEndX * deltaX >> 8);
                int i_60_ = sceneCluster.worldEndZ + (sceneCluster.worldDistanceFromCameraStartZ * deltaX >> 8);
                int i_61_ = sceneCluster.worldStartZ + (sceneCluster.worldDistanceFromCameraEndZ * deltaX >> 8);
                if (posX < i_58_ || posX > i_59_ || posZ < i_60_ || posZ > i_61_) continue;
                return true;
            }
            if (sceneCluster.tileDistanceEnum == 4) {
                deltaX = posY - sceneCluster.worldStartY;
                if (deltaX <= 0) continue;
                int i_63_ = sceneCluster.worldStartX + (sceneCluster.worldDistanceFromCameraStartX * deltaX >> 8);
                int i_64_ = sceneCluster.worldEndX + (sceneCluster.worldDistanceFromCameraEndX * deltaX >> 8);
                int i_65_ = sceneCluster.worldEndZ + (sceneCluster.worldDistanceFromCameraStartZ * deltaX >> 8);
                int i_66_ = sceneCluster.worldStartZ + (sceneCluster.worldDistanceFromCameraEndZ * deltaX >> 8);
                if (posX < i_63_ || posX > i_64_ || posZ < i_65_ || posZ > i_66_) continue;
                return true;
            }
            if (sceneCluster.tileDistanceEnum != 5 || (deltaX = posZ - sceneCluster.worldEndZ) <= 0) continue;
            int i_68_ = sceneCluster.worldStartX + (sceneCluster.worldDistanceFromCameraStartX * deltaX >> 8);
            int i_69_ = sceneCluster.worldEndX + (sceneCluster.worldDistanceFromCameraEndX * deltaX >> 8);
            int i_70_ = sceneCluster.worldStartY + (sceneCluster.worldDistanceFromCameraStartY * deltaX >> 8);
            int i_71_ = sceneCluster.worldEndY + (sceneCluster.worldDistanceFromCameraEndY * deltaX >> 8);
            if (posX < i_68_ || posX > i_69_ || posY < i_70_ || posY > i_71_) continue;
            return true;
        }
        return false;
    }

    public void clearInteractiveObjectCache() {
        for (int i = 0; i < this.sceneSpawnRequestsCacheCurrentPos; ++i) {
            InteractiveObject interactiveObject = this.sceneSpawnRequestsCache[i];
            this.remove(interactiveObject);
            this.sceneSpawnRequestsCache[i] = null;
        }
        this.sceneSpawnRequestsCacheCurrentPos = 0;
    }

    public void remove(InteractiveObject entity) {
        for (int x = entity.tileLeft; x <= entity.tileRight; ++x) {
            for (int y = entity.tileTop; y <= entity.tileBottom; ++y) {
                SceneTile tile = this.tileArray[entity.z][x][y];
                if (tile == null) continue;
                for (int e = 0; e < tile.entityCount; ++e) {
                    if (tile.interactiveObjects[e] != entity) continue;
                    --tile.entityCount;
                    for (int e2 = e; e2 < tile.entityCount; ++e2) {
                        tile.interactiveObjects[e2] = tile.interactiveObjects[e2 + 1];
                        tile.sceneSpawnRequestsSize[e2] = tile.sceneSpawnRequestsSize[e2 + 1];
                    }
                    tile.interactiveObjects[tile.entityCount] = null;
                    break;
                }
                tile.interactiveObjectsSizeOR = 0;
                for (int i_75_ = 0; i_75_ < tile.entityCount; ++i_75_) {
                    tile.interactiveObjectsSizeOR |= tile.sceneSpawnRequestsSize[i_75_];
                }
            }
        }
    }

    public InteractiveObject getObject(int arg0, int arg1, int arg2) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile == null) {
            return null;
        }
        for (int i = 0; i < sceneTile.entityCount; ++i) {
            InteractiveObject interactiveObject = sceneTile.interactiveObjects[i];
            if ((interactiveObject.hash >> 29 & 3) != 2 || interactiveObject.tileLeft != arg1 || interactiveObject.tileTop != arg2) continue;
            return interactiveObject;
        }
        return null;
    }

    public void addWallDecoration(int x, int y, int z, int drawHeight, int offsetX, int offsetY, int face, int hash, Renderable renderable, int config, int configBits) {
        if (renderable != null) {
            WallDecoration wallDecoration = new WallDecoration();
            wallDecoration.hash = hash;
            wallDecoration.config = config;
            wallDecoration.x = x * 128 + 64 + offsetX;
            wallDecoration.y = y * 128 + 64 + offsetY;
            wallDecoration.z = drawHeight;
            wallDecoration.renderable = renderable;
            wallDecoration.configBits = configBits;
            wallDecoration.face = face;
            for (int plane = z; plane >= 0; --plane) {
                if (this.tileArray[plane][x][y] != null) continue;
                this.tileArray[plane][x][y] = new SceneTile(plane, x, y);
            }
            this.tileArray[z][x][y].wallDecoration = wallDecoration;
        }
    }

    public int getLocationHash(int z, int x, int y) {
        SceneTile sceneTile = this.tileArray[z][x][y];
        if (sceneTile == null) {
            return 0;
        }
        for (int i = 0; i < sceneTile.entityCount; ++i) {
            InteractiveObject interactiveObject = sceneTile.interactiveObjects[i];
            if ((interactiveObject.hash >> 29 & 3) != 2 || interactiveObject.tileLeft != x || interactiveObject.tileTop != y) continue;
            return interactiveObject.hash;
        }
        return 0;
    }

    public boolean isOccluded(int z, int x, int y, int arg3) {
        if (!this.isTileOccluded(x, y, z)) {
            return false;
        }
        int i = x << 7;
        int i_144_ = y << 7;
        return this.isPointOccluded(i + 1, this.heightMap[z][x][y] - arg3, i_144_ + 1) && this.isPointOccluded(i + 128 - 1, this.heightMap[z][x + 1][y] - arg3, i_144_ + 1) && this.isPointOccluded(i + 128 - 1, this.heightMap[z][x + 1][y + 1] - arg3, i_144_ + 128 - 1) && this.isPointOccluded(i + 1, this.heightMap[z][x][y + 1] - arg3, i_144_ + 128 - 1);
    }

    public boolean method112(int arg0, int arg1, int arg2, int arg3, int arg4, Renderable arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11) {
        if (arg5 == null) {
            return true;
        }
        return this.addRenderableC(arg8, arg9, arg0, arg1, arg2, arg3, arg6, arg11 - arg9 + 1, arg10 - arg8 + 1, arg7, arg5, true, 0);
    }

    public void setWallDecorationOffset(int plane, int tileX, int tileY, int offset) {
        WallDecoration wallDecoration;
        SceneTile sceneTile = this.tileArray[plane][tileX][tileY];
        if (sceneTile != null && (wallDecoration = sceneTile.wallDecoration) != null) {
            int sceneX = tileX * 128 + 64;
            int sceneY = tileY * 128 + 64;
            wallDecoration.x = sceneX + (wallDecoration.x - sceneX) * offset / 16;
            wallDecoration.y = sceneY + (wallDecoration.y - sceneY) * offset / 16;
        }
    }

    public void mergeFloorDecorationNormals(Model model, int z, int x, int y) {
        Model _model;
        SceneTile sceneTile;
        if (x < this.mapSizeX && (sceneTile = this.tileArray[z][x + 1][y]) != null && sceneTile.floorDecoration != null && sceneTile.floorDecoration.renderable instanceof Model) {
            _model = (Model)sceneTile.floorDecoration.renderable;
            if (_model.verticesNormal != null) {
                this.mergeNormals(model, _model, 128, 0, 0, true);
            }
        }
        if (y < this.mapSizeX && (sceneTile = this.tileArray[z][x][y + 1]) != null && sceneTile.floorDecoration != null && sceneTile.floorDecoration.renderable instanceof Model) {
            _model = (Model)sceneTile.floorDecoration.renderable;
            if (_model.verticesNormal != null) {
                this.mergeNormals(model, _model, 0, 0, 128, true);
            }
        }
        if (x < this.mapSizeX && y < this.mapSizeY && (sceneTile = this.tileArray[z][x + 1][y + 1]) != null && sceneTile.floorDecoration != null && sceneTile.floorDecoration.renderable instanceof Model) {
            _model = (Model)sceneTile.floorDecoration.renderable;
            if (_model.verticesNormal != null) {
                this.mergeNormals(model, _model, 128, 0, 128, true);
            }
        }
        if (x < this.mapSizeX && y > 0 && (sceneTile = this.tileArray[z][x + 1][y - 1]) != null && sceneTile.floorDecoration != null && sceneTile.floorDecoration.renderable instanceof Model) {
            _model = (Model)sceneTile.floorDecoration.renderable;
            if (_model.verticesNormal != null) {
                this.mergeNormals(model, _model, 128, 0, -128, true);
            }
        }
    }

    public void buildModels(int arg0, int arg1, int arg2) {
        for (int _z = 0; _z < this.mapSizeZ; ++_z) {
            for (int _x = 0; _x < this.mapSizeX; ++_x) {
                for (int _y = 0; _y < this.mapSizeY; ++_y) {
                    SceneTile tile = this.tileArray[_z][_x][_y];
                    if (tile == null) continue;
                    Wall wall = tile.wall;
                    if (wall != null && wall.primary instanceof Model) {
                        Model model = (Model)wall.primary;
                        if (model.verticesNormal != null) {
                            this.mergeObjectNormals(model, _z, _x, _y, 1, 1);
                            if (wall.secondary instanceof Model) {
                                Model _model = (Model)wall.secondary;
                                if (_model.verticesNormal != null) {
                                    this.mergeObjectNormals(_model, _z, _x, _y, 1, 1);
                                    this.mergeNormals(model, _model, 0, 0, 0, false);
                                    _model.handleShading(arg0, arg1, arg2);
                                }
                            }
                            model.handleShading(arg0, arg1, arg2);
                        }
                    }
                    for (int e = 0; e < tile.entityCount; ++e) {
                        InteractiveObject interactiveObject = tile.interactiveObjects[e];
                        if (interactiveObject == null || !(interactiveObject.renderable instanceof Model)) continue;
                        Model model = (Model)interactiveObject.renderable;
                        if (model.verticesNormal == null) continue;
                        this.mergeObjectNormals(model, _z, _x, _y, interactiveObject.tileRight - interactiveObject.tileLeft + 1, interactiveObject.tileBottom - interactiveObject.tileTop + 1);
                        model.handleShading(arg0, arg1, arg2);
                    }
                    FloorDecoration floorDecoration = tile.floorDecoration;
                    if (floorDecoration == null || !(floorDecoration.renderable instanceof Model)) continue;
                    Model model = (Model)floorDecoration.renderable;
                    if (model.verticesNormal == null) continue;
                    this.mergeFloorDecorationNormals(model, _z, _x, _y);
                    model.handleShading(arg0, arg1, arg2);
                }
            }
        }
    }

    public boolean isAreaOccluded(int z, int minimumX, int maximumX, int minimumY, int maximumY, int offsetZ) {
        if (minimumX == maximumX && minimumY == maximumY) {
            if (!this.isTileOccluded(minimumX, minimumY, z)) {
                return false;
            }
            int worldX = minimumX << 7;
            int worldY = minimumY << 7;
            return this.isPointOccluded(worldX + 1, this.heightMap[z][minimumX][minimumY] - offsetZ, worldY + 1) && this.isPointOccluded(worldX + 128 - 1, this.heightMap[z][minimumX + 1][minimumY] - offsetZ, worldY + 1) && this.isPointOccluded(worldX + 128 - 1, this.heightMap[z][minimumX + 1][minimumY + 1] - offsetZ, worldY + 128 - 1) && this.isPointOccluded(worldX + 1, this.heightMap[z][minimumX][minimumY + 1] - offsetZ, worldY + 128 - 1);
        }
        for (int x = minimumX; x <= maximumX; ++x) {
            for (int y = minimumY; y <= maximumY; ++y) {
                if (this.tileOcclusionCycles[z][x][y] != -this.cycle) continue;
                return false;
            }
        }
        int _x = (minimumX << 7) + 1;
        int _z = this.heightMap[z][minimumX][minimumY] - offsetZ;
        int _y = (minimumY << 7) + 2;
        if (!this.isPointOccluded(_x, _z, _y)) {
            return false;
        }
        int i_159_ = (maximumX << 7) - 1;
        if (!this.isPointOccluded(i_159_, _z, _y)) {
            return false;
        }
        int i_160_ = (maximumY << 7) - 1;
        if (!this.isPointOccluded(_x, _z, i_160_)) {
            return false;
        }
        return this.isPointOccluded(i_159_, _z, i_160_);
    }

    public void click(int arg0, int arg1) {
        this.clicked = true;
        this.clickX = arg0;
        this.clickY = arg1;
        this.clickedTileX = -1;
        this.clickedTileY = -1;
    }

    public void mergeNormals(Model modelA, Model modelB, int i, int j, int k, boolean arg5) {
        modelB.method822();
        ++this.mergeIndexTmp;
        int count = 0;
        int[] vertices = modelB.verticesX;
        int vertexCount = modelB.vertexCount;
        for (int vertex = 0; vertex < modelA.vertexCount; ++vertex) {
            int z;
            int x;
            int y;
            VertexNormal vertexNormal = modelA.verticesNormal[vertex];
            VertexNormal offsetVertexNormal = modelA.vertexNormalOffset[vertex];
            if (offsetVertexNormal.magnitude == 0 || (y = modelA.verticesY[vertex] - j) > modelB.maxY || (x = modelA.verticesX[vertex] - i) < modelB.diagonal2DAboveOrigin || x > modelB.diagonal3D || (z = modelA.verticesZ[vertex] - k) < modelB.anInt3177 || z > modelB.anInt3189) continue;
            for (int v = 0; v < vertexCount; ++v) {
                VertexNormal _vertexNormal = modelB.verticesNormal[v];
                VertexNormal _offsetVertexNormal = modelB.vertexNormalOffset[v];
                if (x != vertices[v] || z != modelB.verticesZ[v] || y != modelB.verticesY[v] || _offsetVertexNormal.magnitude == 0) continue;
                vertexNormal.x += _offsetVertexNormal.x;
                vertexNormal.y += _offsetVertexNormal.y;
                vertexNormal.z += _offsetVertexNormal.z;
                vertexNormal.magnitude += _offsetVertexNormal.magnitude;
                _vertexNormal.x += offsetVertexNormal.x;
                _vertexNormal.y += offsetVertexNormal.y;
                _vertexNormal.z += offsetVertexNormal.z;
                _vertexNormal.magnitude += offsetVertexNormal.magnitude;
                ++count;
                this.mergeIndexA[vertex] = this.mergeIndexTmp;
                this.mergeIndexB[v] = this.mergeIndexTmp;
            }
        }
        if (count >= 3 && arg5) {
            int tri;
            for (tri = 0; tri < modelA.triangleCount; ++tri) {
                if (this.mergeIndexA[modelA.trianglePointsX[tri]] != this.mergeIndexTmp || this.mergeIndexA[modelA.trianglePointsY[tri]] != this.mergeIndexTmp || this.mergeIndexA[modelA.trianglePointsZ[tri]] != this.mergeIndexTmp) continue;
                modelA.triangleDrawType[tri] = -1;
            }
            for (tri = 0; tri < modelB.triangleCount; ++tri) {
                if (this.mergeIndexB[modelB.trianglePointsX[tri]] != this.mergeIndexTmp || this.mergeIndexB[modelB.trianglePointsY[tri]] != this.mergeIndexTmp || this.mergeIndexB[modelB.trianglePointsZ[tri]] != this.mergeIndexTmp) continue;
                modelB.triangleDrawType[tri] = -1;
            }
        }
    }

    public int getWallHash(int arg0, int arg1, int arg2) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile == null || sceneTile.wall == null) {
            return 0;
        }
        return sceneTile.wall.hash;
    }

    public void removeWall(int arg0, int arg1, int arg2) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile != null) {
            sceneTile.wall = null;
        }
    }

    public void removeGroundItems(int arg0, int arg1, int arg2) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile != null) {
            sceneTile.groundItemTile = null;
        }
    }

    public Wall getWall(int arg0, int arg1, int arg2) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile == null) {
            return null;
        }
        return sceneTile.wall;
    }

    public void removeWallDecoration(int arg0, int arg1, int arg2) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile != null) {
            sceneTile.wallDecoration = null;
        }
    }

    public void mergeObjectNormals(Model arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        boolean bool = true;
        int i = arg2;
        int i_210_ = arg2 + arg4;
        int i_211_ = arg3 - 1;
        int i_212_ = arg3 + arg5;
        for (int i_213_ = arg1; i_213_ <= arg1 + 1; ++i_213_) {
            if (i_213_ == this.mapSizeZ) continue;
            for (int i_214_ = i; i_214_ <= i_210_; ++i_214_) {
                if (i_214_ < 0 || i_214_ >= this.mapSizeX) continue;
                for (int i_215_ = i_211_; i_215_ <= i_212_; ++i_215_) {
                    SceneTile sceneTile;
                    if (i_215_ < 0 || i_215_ >= this.mapSizeY || bool && i_214_ < i_210_ && i_215_ < i_212_ && (i_215_ >= arg3 || i_214_ == arg2) || (sceneTile = this.tileArray[i_213_][i_214_][i_215_]) == null) continue;
                    int i_216_ = (this.heightMap[i_213_][i_214_][i_215_] + this.heightMap[i_213_][i_214_ + 1][i_215_] + this.heightMap[i_213_][i_214_][i_215_ + 1] + this.heightMap[i_213_][i_214_ + 1][i_215_ + 1]) / 4 - (this.heightMap[arg1][arg2][arg3] + this.heightMap[arg1][arg2 + 1][arg3] + this.heightMap[arg1][arg2][arg3 + 1] + this.heightMap[arg1][arg2 + 1][arg3 + 1]) / 4;
                    Wall wall = sceneTile.wall;
                    if (wall != null) {
                        Model model;
                        if (wall.primary instanceof Model) {
                            model = (Model)wall.primary;
                            if (model.verticesNormal != null) {
                                this.mergeNormals(arg0, model, (i_214_ - arg2) * 128 + (1 - arg4) * 64, i_216_, (i_215_ - arg3) * 128 + (1 - arg5) * 64, bool);
                            }
                        }
                        if (wall.secondary instanceof Model) {
                            model = (Model)wall.secondary;
                            if (model.verticesNormal != null) {
                                this.mergeNormals(arg0, model, (i_214_ - arg2) * 128 + (1 - arg4) * 64, i_216_, (i_215_ - arg3) * 128 + (1 - arg5) * 64, bool);
                            }
                        }
                    }
                    for (int i_217_ = 0; i_217_ < sceneTile.entityCount; ++i_217_) {
                        InteractiveObject interactiveObject = sceneTile.interactiveObjects[i_217_];
                        if (interactiveObject == null || !(interactiveObject.renderable instanceof Model)) continue;
                        Model model = (Model)interactiveObject.renderable;
                        if (model.verticesNormal == null) continue;
                        int i_218_ = interactiveObject.tileRight - interactiveObject.tileLeft + 1;
                        int i_219_ = interactiveObject.tileBottom - interactiveObject.tileTop + 1;
                        this.mergeNormals(arg0, model, (interactiveObject.tileLeft - arg2) * 128 + (i_218_ - arg4) * 64, i_216_, (interactiveObject.tileTop - arg3) * 128 + (i_219_ - arg5) * 64, bool);
                    }
                }
            }
            --i;
            bool = false;
        }
    }

    public void setDrawLevel(int arg0, int arg1, int arg2, int arg3) {
        SceneTile sceneTile = this.tileArray[arg0][arg1][arg2];
        if (sceneTile != null) {
            this.tileArray[arg0][arg1][arg2].drawLevel = arg3;
        }
    }

    public void removeFloorDecoration(int level, int x, int y) {
        SceneTile sceneTile = this.tileArray[level][x][y];
        if (sceneTile != null) {
            sceneTile.floorDecoration = null;
        }
    }

    public void addGroundDecoration(int x, int y, int z, int drawHeight, int hash, Renderable renderable, int config) {
        if (renderable != null) {
            FloorDecoration floorDecoration = new FloorDecoration();
            floorDecoration.renderable = renderable;
            floorDecoration.x = x * 128 + 64;
            floorDecoration.y = y * 128 + 64;
            floorDecoration.z = drawHeight;
            floorDecoration.hash = hash;
            floorDecoration.config = config;
            if (this.tileArray[z][x][y] == null) {
                this.tileArray[z][x][y] = new SceneTile(z, x, y);
            }
            this.tileArray[z][x][y].floorDecoration = floorDecoration;
        }
    }

    public FloorDecoration getFloorDecoration(int level, int x, int y) {
        SceneTile sceneTile = this.tileArray[level][x][y];
        if (sceneTile == null || sceneTile.floorDecoration == null) {
            return null;
        }
        return sceneTile.floorDecoration;
    }

    public boolean method134(int arg0, int arg1, int arg2, int arg3, int arg4, Renderable arg5, int arg6, int arg7, boolean arg8) {
        if (arg5 == null) {
            return true;
        }
        int i = arg1 - arg4;
        int i_220_ = arg2 - arg4;
        int i_221_ = arg1 + arg4;
        int i_222_ = arg2 + arg4;
        if (arg8) {
            if (arg6 > 640 && arg6 < 1408) {
                i_222_ += 128;
            }
            if (arg6 > 1152 && arg6 < 1920) {
                i_221_ += 128;
            }
            if (arg6 > 1664 || arg6 < 384) {
                i_220_ -= 128;
            }
            if (arg6 > 128 && arg6 < 896) {
                i -= 128;
            }
        }
        return this.addRenderableC(i /= 128, i_220_ /= 128, arg0, arg1, arg2, arg3, arg6, (i_222_ /= 128) - i_220_ + 1, (i_221_ /= 128) - i + 1, arg7, arg5, true, 0);
    }

    public void removeInteractiveObject(int z, int x, int y) {
        SceneTile sceneTile = this.tileArray[z][x][y];
        if (sceneTile == null) {
            return;
        }
        for (int e = 0; e < sceneTile.entityCount; ++e) {
            InteractiveObject interactiveObject = sceneTile.interactiveObjects[e];
            if ((interactiveObject.hash >> 29 & 3) != 2 || interactiveObject.tileLeft != x || interactiveObject.tileTop != y) continue;
            this.remove(interactiveObject);
            break;
        }
    }

    public void setPlane(int plane) {
        this.plane = plane;
        for (int x = 0; x < this.mapSizeX; ++x) {
            for (int y = 0; y < this.mapSizeY; ++y) {
                if (this.tileArray[plane][x][y] != null) continue;
                this.tileArray[plane][x][y] = new SceneTile(plane, x, y);
            }
        }
    }

    public boolean addEntityB(int x, int y, int z, int worldZ, int rotation, int tileWidth, int tileHeight, int uid, Renderable entity, int config) {
        if (entity == null) {
            return true;
        }
        int worldX = x * 128 + 64 * tileHeight;
        int worldY = y * 128 + 64 * tileWidth;
        return this.addRenderableC(x, y, z, worldX, worldY, worldZ, rotation, tileWidth, tileHeight, uid, entity, false, config);
    }

    public void addGroundItemTile(int x, int y, int z, int drawHeight, int hash, Renderable firstGroundItem, Renderable secondGroundItem, Renderable thirdGroundItem) {
        GroundItemTile groundItemTile = new GroundItemTile();
        groundItemTile.firstGroundItem = firstGroundItem;
        groundItemTile.x = x * 128 + 64;
        groundItemTile.y = y * 128 + 64;
        groundItemTile.z = drawHeight;
        groundItemTile.hash = hash;
        groundItemTile.secondGroundItem = secondGroundItem;
        groundItemTile.thirdGroundItem = thirdGroundItem;
        int i = 0;
        SceneTile sceneTile = this.tileArray[z][x][y];
        if (sceneTile != null) {
            for (int e = 0; e < sceneTile.entityCount; ++e) {
                if ((sceneTile.interactiveObjects[e].config & 0x100) != 256 || !(sceneTile.interactiveObjects[e].renderable instanceof Model)) continue;
                Model model = (Model)sceneTile.interactiveObjects[e].renderable;
                model.method799();
                if (model.modelHeight <= i) continue;
                i = model.modelHeight;
            }
        }
        groundItemTile.anInt1371 = i;
        if (this.tileArray[z][x][y] == null) {
            this.tileArray[z][x][y] = new SceneTile(z, x, y);
        }
        this.tileArray[z][x][y].groundItemTile = groundItemTile;
    }

    public boolean addRenderableC(int minX, int minY, int z, int worldX, int worldY, int worldZ, int rotation, int tileWidth, int tileHeight, int hash, Renderable renderable, boolean isDynamic, int config) {
        for (int x = minX; x < minX + tileHeight; ++x) {
            for (int y = minY; y < minY + tileWidth; ++y) {
                if (x < 0 || y < 0 || x >= this.mapSizeX || y >= this.mapSizeY) {
                    return false;
                }
                SceneTile sceneTile = this.tileArray[z][x][y];
                if (sceneTile == null || sceneTile.entityCount < 5) continue;
                return false;
            }
        }
        InteractiveObject interactiveObject = new InteractiveObject();
        interactiveObject.hash = hash;
        interactiveObject.config = config;
        interactiveObject.z = z;
        interactiveObject.worldX = worldX;
        interactiveObject.worldY = worldY;
        interactiveObject.worldZ = worldZ;
        interactiveObject.renderable = renderable;
        interactiveObject.rotation = rotation;
        interactiveObject.tileLeft = minX;
        interactiveObject.tileTop = minY;
        interactiveObject.tileRight = minX + tileHeight - 1;
        interactiveObject.tileBottom = minY + tileWidth - 1;
        for (int i = minX; i < minX + tileHeight; ++i) {
            for (int i_243_ = minY; i_243_ < minY + tileWidth; ++i_243_) {
                int i_244_ = 0;
                if (i > minX) {
                    ++i_244_;
                }
                if (i < minX + tileHeight - 1) {
                    i_244_ += 4;
                }
                if (i_243_ > minY) {
                    i_244_ += 8;
                }
                if (i_243_ < minY + tileWidth - 1) {
                    i_244_ += 2;
                }
                for (int i_245_ = z; i_245_ >= 0; --i_245_) {
                    if (this.tileArray[i_245_][i][i_243_] != null) continue;
                    this.tileArray[i_245_][i][i_243_] = new SceneTile(i_245_, i, i_243_);
                }
                SceneTile sceneTile = this.tileArray[z][i][i_243_];
                sceneTile.interactiveObjects[sceneTile.entityCount] = interactiveObject;
                sceneTile.sceneSpawnRequestsSize[sceneTile.entityCount] = i_244_;
                sceneTile.interactiveObjectsSizeOR |= i_244_;
                ++sceneTile.entityCount;
            }
        }
        if (isDynamic) {
            this.sceneSpawnRequestsCache[this.sceneSpawnRequestsCacheCurrentPos++] = interactiveObject;
        }
        return true;
    }

    public int getArrangement(int z, int x, int y, int hash) {
        SceneTile sceneTile = this.tileArray[z][x][y];
        if (sceneTile == null) {
            return -1;
        }
        if (sceneTile.wall != null && sceneTile.wall.hash == hash) {
            return sceneTile.wall.config & 0xFF;
        }
        if (sceneTile.wallDecoration != null && sceneTile.wallDecoration.hash == hash) {
            return sceneTile.wallDecoration.config & 0xFF;
        }
        if (sceneTile.floorDecoration != null && sceneTile.floorDecoration.hash == hash) {
            return sceneTile.floorDecoration.config & 0xFF;
        }
        for (int i = 0; i < sceneTile.entityCount; ++i) {
            if (sceneTile.interactiveObjects[i].hash != hash) continue;
            return sceneTile.interactiveObjects[i].config & 0xFF;
        }
        return -1;
    }

    public int getFloorDrawHeight(int plane, int x, int y, byte[][][] tileFlags) {
        int groundX = x >> 7;
        int groundY = y >> 7;
        if (groundX < 0 || groundY < 0 || groundX > 103 || groundY > 103) {
            return 0;
        }
        int groundZ = plane;
        if (groundZ < 3 && (tileFlags[1][groundX][groundY] & 2) == 2) {
            ++groundZ;
        }
        int tilePositionX = x & 0x7F;
        int tilePositionY = y & 0x7F;
        int interpolatedHeightX1 = (128 - tilePositionX) * this.landscape.tile_height[groundZ][groundX][groundY] + tilePositionX * this.landscape.tile_height[groundZ][groundX + 1][groundY] >> 7;
        int interpolatedHeightX2 = tilePositionX * this.landscape.tile_height[groundZ][groundX + 1][groundY + 1] + this.landscape.tile_height[groundZ][groundX][groundY + 1] * (128 - tilePositionX) >> 7;
        return (128 - tilePositionY) * interpolatedHeightX1 + interpolatedHeightX2 * tilePositionY >> 7;
    }

    public int getFloorDrawHeight(int plane, int x, int y) {
        return this.getFloorDrawHeight(plane, x, y, MovedStatics.tile_flags);
    }
}

