/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.scene;

import org.runejs.client.scene.camera.CameraRotation;

public class CameraTileVisibility {
    private int viewportWidth;
    private int viewportWidthMidpoint;
    private int viewportHeight;
    private int viewportHeightMidpoint;
    private int drawDistance;
    public final boolean[][][][] visibilityInfo;

    public CameraTileVisibility(int viewportWidth, int viewportHeight, int drawDistance, int minHeight, int maxHeight, int[] heightsForPitch) {
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
        this.viewportWidthMidpoint = viewportWidth / 2;
        this.viewportHeightMidpoint = viewportHeight / 2;
        this.drawDistance = drawDistance;
        this.visibilityInfo = new boolean[8][32][drawDistance * 2 + 1][drawDistance * 2 + 1];
        this.computeTileVisibilityMaps(minHeight, maxHeight, heightsForPitch);
    }

    private void computeTileVisibilityMaps(int minHeight, int maxHeight, int[] arg0) {
        int cameraAngles = 9;
        int rotationsPerCircle = 32;
        boolean[][][][] visibilityMaps = new boolean[9][32][this.drawDistance * 2 + 3][this.drawDistance * 2 + 3];
        for (int pitch = 128; pitch <= 384; pitch += 32) {
            for (int yaw = 0; yaw < 2048; yaw += 64) {
                CameraRotation camera = new CameraRotation(yaw, pitch);
                int pitchIndex = (pitch - 128) / 32;
                int yawIndex = yaw / 64;
                for (int tileX = -26; tileX <= 26; ++tileX) {
                    for (int tileY = -26; tileY <= 26; ++tileY) {
                        int absoluteTileX = tileX * 128;
                        int absoluteTileY = tileY * 128;
                        boolean isVisible = false;
                        for (int h = -minHeight; h <= maxHeight; h += 128) {
                            if (!this.isPointVisibleOnScreen(absoluteTileX, arg0[pitchIndex] + h, absoluteTileY, camera)) continue;
                            isVisible = true;
                            break;
                        }
                        visibilityMaps[pitchIndex][yawIndex][tileX + this.drawDistance + 1][tileY + this.drawDistance + 1] = isVisible;
                    }
                }
            }
        }
        int maxPitchIndex = 8;
        int maxYawIndex = 32;
        for (int pitchIndex = 0; pitchIndex < 8; ++pitchIndex) {
            for (int yawIndex = 0; yawIndex < 32; ++yawIndex) {
                for (int tileX = -this.drawDistance; tileX < this.drawDistance; ++tileX) {
                    for (int tileY = -this.drawDistance; tileY < this.drawDistance; ++tileY) {
                        boolean isVisible = false;
                        block9: for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                                if (visibilityMaps[pitchIndex][yawIndex][tileX + xOffset + this.drawDistance + 1][tileY + yOffset + this.drawDistance + 1]) {
                                    isVisible = true;
                                    break block9;
                                }
                                if (visibilityMaps[pitchIndex][(yawIndex + 1) % 31][tileX + xOffset + this.drawDistance + 1][tileY + yOffset + this.drawDistance + 1]) {
                                    isVisible = true;
                                    break block9;
                                }
                                if (visibilityMaps[pitchIndex + 1][yawIndex][tileX + xOffset + this.drawDistance + 1][tileY + yOffset + this.drawDistance + 1]) {
                                    isVisible = true;
                                    break block9;
                                }
                                if (!visibilityMaps[pitchIndex + 1][(yawIndex + 1) % 31][tileX + xOffset + this.drawDistance + 1][tileY + yOffset + this.drawDistance + 1]) continue;
                                isVisible = true;
                                break block9;
                            }
                        }
                        this.visibilityInfo[pitchIndex][yawIndex][tileX + this.drawDistance][tileY + this.drawDistance] = isVisible;
                    }
                }
            }
        }
    }

    public boolean isPointVisibleOnScreen(int x, int y, int z, CameraRotation cameraRotation) {
        int rotatedX = z * cameraRotation.yawSine + x * cameraRotation.yawCosine >> 16;
        int rotatedZ = z * cameraRotation.yawCosine - x * cameraRotation.yawSine >> 16;
        int rotatedY = y * cameraRotation.pitchSine + rotatedZ * cameraRotation.pitchCosine >> 16;
        int finalZ = y * cameraRotation.pitchCosine - rotatedZ * cameraRotation.pitchSine >> 16;
        if (rotatedY < 50) {
            return false;
        }
        int screenX = this.viewportWidthMidpoint + (rotatedX << 9) / rotatedY;
        int screenY = this.viewportHeightMidpoint + (finalZ << 9) / rotatedY;
        return screenX >= 0 && screenX <= this.viewportWidth && screenY >= 0 && screenY <= this.viewportHeight;
    }
}

