/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.ondemand.js5;

import java.io.IOException;
import java.net.Socket;
import org.runejs.client.GameSocket;
import org.runejs.client.io.Buffer;
import org.runejs.client.net.UpdateServer;
import org.runejs.client.ondemand.js5.exceptions.JS5CRCException;
import org.runejs.client.ondemand.js5.exceptions.JS5ConnectException;
import org.runejs.client.ondemand.js5.exceptions.JS5ConnectFullException;
import org.runejs.client.ondemand.js5.exceptions.JS5ConnectOutOfDateException;
import org.runejs.client.ondemand.js5.exceptions.JS5Exception;
import org.runejs.client.ondemand.js5.exceptions.JS5IOException;
import org.runejs.client.util.Signlink;
import org.runejs.client.util.SignlinkNode;

public class JS5UpdateServerConnectionManager {
    public final UpdateServer updateServer = new UpdateServer();
    private int cyclesToConnectionAttempt;
    private int connectionStage;
    private SignlinkNode socketRequest;
    private GameSocket socket;
    private long handshakeSentAtMs;
    private int failureCount;
    private int port = -1;
    private int primaryPort = -1;
    private int secondaryPort = -1;
    private Signlink signlink;

    public JS5UpdateServerConnectionManager(Signlink signlink, int primaryPort, int secondaryPort) {
        this.signlink = signlink;
        this.primaryPort = primaryPort;
        this.secondaryPort = secondaryPort;
        this.port = primaryPort;
    }

    public void process(int gameStatus) throws JS5Exception {
        boolean connected = this.updateServer.poll();
        if (!connected) {
            this.connectUpdateServer(gameStatus);
        }
    }

    public void close() {
        this.updateServer.close();
    }

    private void connectUpdateServer(int gameStatus) throws JS5Exception {
        if (this.updateServer.crcMismatchesCount >= 4) {
            throw new JS5CRCException();
        }
        if (this.updateServer.ioExceptionsCount >= 4) {
            if (gameStatus > 5) {
                this.updateServer.ioExceptionsCount = 3;
                this.cyclesToConnectionAttempt = 3000;
                return;
            }
            throw new JS5IOException();
        }
        --this.cyclesToConnectionAttempt;
        if (this.cyclesToConnectionAttempt > 0) {
            return;
        }
        try {
            if (this.connectionStage == 0) {
                this.socketRequest = this.signlink.putSocketNode(this.port);
                ++this.connectionStage;
            }
            if (this.connectionStage == 1) {
                if (this.socketRequest.status == SignlinkNode.Status.ERRORED) {
                    this.handleConnectionError(gameStatus, -1);
                    return;
                }
                if (this.socketRequest.status == SignlinkNode.Status.INITIALIZED) {
                    ++this.connectionStage;
                }
            }
            if (this.connectionStage == 2) {
                this.socket = new GameSocket((Socket)this.socketRequest.value, this.signlink);
                Buffer buffer = new Buffer(5);
                buffer.putByte(15);
                buffer.putIntBE(435);
                this.socket.sendDataFromBuffer(5, 0, buffer.buffer);
                ++this.connectionStage;
                this.handshakeSentAtMs = System.currentTimeMillis();
            }
            if (this.connectionStage == 3) {
                if (gameStatus > 5 && this.socket.inputStreamAvailable() <= 0) {
                    if (System.currentTimeMillis() - this.handshakeSentAtMs > 30000L) {
                        this.handleConnectionError(gameStatus, -2);
                        return;
                    }
                } else {
                    int i = this.socket.read();
                    if (i != 0) {
                        this.handleConnectionError(gameStatus, i);
                        return;
                    }
                    ++this.connectionStage;
                }
            }
            if (this.connectionStage != 4) {
                return;
            }
            this.updateServer.receiveConnection(this.socket, gameStatus > 20);
            this.socketRequest = null;
            this.connectionStage = 0;
            this.socket = null;
            this.failureCount = 0;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            this.handleConnectionError(gameStatus, -3);
            return;
        }
    }

    private void switchPorts() {
        this.port = this.port != this.primaryPort ? this.primaryPort : this.secondaryPort;
    }

    private void handleConnectionError(int gameStatus, int errorCode) throws JS5Exception {
        this.switchPorts();
        this.socket = null;
        this.socketRequest = null;
        this.connectionStage = 0;
        ++this.failureCount;
        if (this.failureCount >= 2 && (errorCode == 7 || errorCode == 9)) {
            if (gameStatus > 5) {
                this.cyclesToConnectionAttempt = 3000;
                return;
            }
            throw new JS5ConnectFullException();
        }
        if (this.failureCount >= 2 && errorCode == 6) {
            throw new JS5ConnectOutOfDateException();
        }
        if (this.failureCount < 4) {
            return;
        }
        this.cyclesToConnectionAttempt = 3000;
        if (gameStatus <= 5) {
            throw new JS5ConnectException();
        }
    }
}

