/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.node;

import org.runejs.client.node.CachedNode;
import org.runejs.client.node.HashTable;
import org.runejs.client.node.NodeQueue;

public class NodeCache {
    public CachedNode cachedNode = new CachedNode();
    public int remaining;
    public int size;
    public HashTable hashTable;
    public NodeQueue nodeQueue = new NodeQueue();

    public NodeCache(int size) {
        this.size = size;
        int i = 1;
        while (i + i < size) {
            i += i;
        }
        this.remaining = size;
        this.hashTable = new HashTable(i);
    }

    public void put(long key, CachedNode node) {
        if (this.remaining == 0) {
            CachedNode cachedNode = this.nodeQueue.pop();
            cachedNode.unlink();
            cachedNode.clear();
            if (cachedNode == this.cachedNode) {
                cachedNode = this.nodeQueue.pop();
                cachedNode.unlink();
                cachedNode.clear();
            }
        } else {
            --this.remaining;
        }
        this.hashTable.put(key, node);
        this.nodeQueue.push(node);
    }

    public CachedNode get(long key) {
        CachedNode cachedNode = (CachedNode)this.hashTable.getNode(key);
        if (cachedNode != null) {
            this.nodeQueue.push(cachedNode);
        }
        return cachedNode;
    }

    public void remove(long key) {
        CachedNode cachedNode = (CachedNode)this.hashTable.getNode(key);
        if (cachedNode == null) {
            return;
        }
        cachedNode.unlink();
        cachedNode.clear();
        ++this.remaining;
    }

    public void clear() {
        CachedNode cachedNode;
        while ((cachedNode = this.nodeQueue.pop()) != null) {
            cachedNode.unlink();
            cachedNode.clear();
        }
        this.remaining = this.size;
    }
}

