/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec.runejs435.encoder.interactions;

import org.runejs.client.message.outbound.interactions.PlayerInteractionOutboundMessage;
import org.runejs.client.net.OutgoingPackets;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.net.codec.MessageEncoder;

public class PlayerInteractionMessageEncoder
implements MessageEncoder<PlayerInteractionOutboundMessage> {
    @Override
    public PacketBuffer encode(PlayerInteractionOutboundMessage message) {
        switch (message.option) {
            case 1: {
                return this.encodeOption1Interaction(message);
            }
            case 2: {
                return this.encodeOption2Interaction(message);
            }
            case 3: {
                return this.encodeOption3Interaction(message);
            }
            case 4: {
                return this.encodeOption4Interaction(message);
            }
            case 5: {
                return this.encodeOption5Interaction(message);
            }
        }
        throw new RuntimeException("Invalid option: " + message.option);
    }

    private PacketBuffer encodeOption1Interaction(PlayerInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 68);
        buffer.putShortLE(message.playerIndex);
        return buffer;
    }

    private PacketBuffer encodeOption2Interaction(PlayerInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 211);
        buffer.putShortLE(message.playerIndex);
        return buffer;
    }

    private PacketBuffer encodeOption3Interaction(PlayerInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 220);
        buffer.putShortBE(message.playerIndex);
        return buffer;
    }

    private PacketBuffer encodeOption4Interaction(PlayerInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 96);
        buffer.putShortBE(message.playerIndex);
        return buffer;
    }

    private PacketBuffer encodeOption5Interaction(PlayerInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 187);
        buffer.putShortLE(message.playerIndex);
        return buffer;
    }
}

