/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec.runejs435.encoder.interactions;

import org.runejs.client.message.outbound.interactions.NPCInteractionOutboundMessage;
import org.runejs.client.net.OutgoingPackets;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.net.codec.MessageEncoder;

public class NPCInteractionMessageEncoder
implements MessageEncoder<NPCInteractionOutboundMessage> {
    @Override
    public PacketBuffer encode(NPCInteractionOutboundMessage message) {
        switch (message.option) {
            case 1: {
                return this.encodeOption1Interaction(message);
            }
            case 2: {
                return this.encodeOption2Interaction(message);
            }
            case 3: {
                return this.encodeOption3Interaction(message);
            }
            case 4: {
                return this.encodeOption4Interaction(message);
            }
            case 5: {
                return this.encodeOption5Interaction(message);
            }
        }
        throw new RuntimeException("Invalid option: " + message.option);
    }

    private PacketBuffer encodeOption1Interaction(NPCInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 63);
        buffer.putShortLE(message.npcIndex);
        return buffer;
    }

    private PacketBuffer encodeOption2Interaction(NPCInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 57);
        buffer.putShortBE(message.npcIndex);
        return buffer;
    }

    private PacketBuffer encodeOption3Interaction(NPCInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 116);
        buffer.putShortLE(message.npcIndex);
        return buffer;
    }

    private PacketBuffer encodeOption4Interaction(NPCInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 0);
        buffer.putShortBE(message.npcIndex);
        return buffer;
    }

    private PacketBuffer encodeOption5Interaction(NPCInteractionOutboundMessage message) {
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 153);
        buffer.putShortLE(message.npcIndex);
        return buffer;
    }
}

