/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec.runejs435.encoder.chat;

import org.runejs.client.message.outbound.chat.AcceptRequestOutboundMessage;
import org.runejs.client.net.OutgoingPackets;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.net.codec.MessageEncoder;

public class AcceptRequestMessageEncoder
implements MessageEncoder<AcceptRequestOutboundMessage> {
    @Override
    public PacketBuffer encode(AcceptRequestOutboundMessage message) {
        switch (message.type) {
            case TRADE: {
                return this.encodeTrade(message);
            }
            case CHALLENGE: {
                return this.encodeChallenge(message);
            }
        }
        throw new RuntimeException("Invalid request type: " + (Object)((Object)message.type));
    }

    private PacketBuffer encodeTrade(AcceptRequestOutboundMessage message) {
        if (message.type != AcceptRequestOutboundMessage.RequestType.TRADE) {
            throw new RuntimeException("Attempted to handle request type '" + (Object)((Object)message.type) + "' with TRADE handler");
        }
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 96);
        buffer.putShortBE(message.playerId);
        return buffer;
    }

    private PacketBuffer encodeChallenge(AcceptRequestOutboundMessage message) {
        if (message.type != AcceptRequestOutboundMessage.RequestType.CHALLENGE) {
            throw new RuntimeException("Attempted to handle request type '" + (Object)((Object)message.type) + "' with CHALLENGE handler");
        }
        PacketBuffer buffer = OutgoingPackets.openFixedSizePacket(2, 68);
        buffer.putShortLE(message.playerId);
        return buffer;
    }
}

