/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec.runejs435.decoder.widget.container;

import java.util.ArrayList;
import org.runejs.client.message.inbound.widget.container.UpdateAllWidgetItemsInboundMessage;
import org.runejs.client.message.inbound.widget.container.WidgetItem;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.net.codec.MessageDecoder;

public class UpdateAllWidgetItemsMessageDecoder
implements MessageDecoder<UpdateAllWidgetItemsInboundMessage> {
    @Override
    public UpdateAllWidgetItemsInboundMessage decode(PacketBuffer buffer) {
        int interfaceData = buffer.getIntBE();
        int widgetId = interfaceData >> 16 & 0xFFFF;
        int childId = interfaceData & 0xFFFF;
        int size = buffer.getUnsignedShortBE();
        ArrayList<WidgetItem> items = new ArrayList<WidgetItem>();
        for (int index = 0; index < size; index += 8) {
            byte bitset = buffer.getByte();
            for (int offset = 0; offset < 8; ++offset) {
                int id;
                int amount;
                boolean empty;
                boolean bl = empty = (bitset & 1 << offset) == 0;
                if (empty) {
                    amount = 0;
                    id = 0;
                } else {
                    int peek = buffer.getUnsignedByte();
                    amount = peek == 255 ? buffer.getIntBE() : peek;
                    id = buffer.getUnsignedShortBE();
                }
                int idx = index + offset;
                items.add(new WidgetItem(idx, id, amount));
            }
        }
        return new UpdateAllWidgetItemsInboundMessage(widgetId, childId, items.toArray(new WidgetItem[items.size()]));
    }
}

