/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec.runejs435.decoder.updating;

import java.util.ArrayList;
import org.runejs.client.message.inbound.updating.UpdatePlayersInboundMessage;
import org.runejs.client.message.inbound.updating.movement.ActorGroupMovementUpdate;
import org.runejs.client.message.inbound.updating.movement.LocalPlayerMovementUpdate;
import org.runejs.client.message.inbound.updating.movement.MovementUpdate;
import org.runejs.client.message.inbound.updating.registration.ActorGroupRegistrationUpdate;
import org.runejs.client.message.inbound.updating.registration.ActorRegistration;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.net.codec.MessageDecoder;
import org.runejs.client.net.codec.runejs435.decoder.updating.UpdateDecoderHelpers;

public class UpdatePlayersMessageDecoder
implements MessageDecoder<UpdatePlayersInboundMessage> {
    @Override
    public UpdatePlayersInboundMessage decode(PacketBuffer buffer) {
        buffer.initBitAccess();
        LocalPlayerMovementUpdate localPlayerMovement = this.decodeLocalPlayerMovementUpdate(buffer);
        ActorGroupMovementUpdate otherPlayersMovement = UpdateDecoderHelpers.decodeGroupMovementUpdate(buffer);
        ActorGroupRegistrationUpdate<ActorRegistration> registerNewPlayers = this.decodeRegisterNewPlayersUpdate(buffer);
        buffer.finishBitAccess();
        PacketBuffer appearanceUpdate = UpdateDecoderHelpers.decodeRemainingBytes(buffer);
        return new UpdatePlayersInboundMessage(localPlayerMovement, otherPlayersMovement, registerNewPlayers, appearanceUpdate);
    }

    private LocalPlayerMovementUpdate decodeLocalPlayerMovementUpdate(PacketBuffer buffer) {
        boolean updateRequired;
        boolean bl = updateRequired = buffer.getBits(1) == 1;
        if (!updateRequired) {
            return null;
        }
        int movementType = buffer.getBits(2);
        if (movementType == 0) {
            return new LocalPlayerMovementUpdate(null, null);
        }
        if (movementType == 1) {
            int walkDirection = buffer.getBits(3);
            boolean runUpdateBlock = buffer.getBits(1) == 1;
            return new LocalPlayerMovementUpdate(new MovementUpdate(walkDirection, null, runUpdateBlock), null);
        }
        if (movementType == 2) {
            int walkDirection = buffer.getBits(3);
            int runDirection = buffer.getBits(3);
            boolean runUpdateBlock = buffer.getBits(1) == 1;
            return new LocalPlayerMovementUpdate(new MovementUpdate(walkDirection, runDirection, runUpdateBlock), null);
        }
        if (movementType == 3) {
            boolean teleporting = buffer.getBits(1) == 1;
            int worldLevel = buffer.getBits(2);
            boolean runUpdateBlock = buffer.getBits(1) == 1;
            int localChunkX = buffer.getBits(7);
            int localChunkY = buffer.getBits(7);
            return new LocalPlayerMovementUpdate(null, new LocalPlayerMovementUpdate.LocalPlayerMapRegionChangeUpdate(teleporting, worldLevel, runUpdateBlock, localChunkX, localChunkY));
        }
        throw new IllegalStateException("Invalid movement type: " + movementType);
    }

    private ActorGroupRegistrationUpdate<ActorRegistration> decodeRegisterNewPlayersUpdate(PacketBuffer buffer) {
        int newPlayerIndex;
        ArrayList<ActorRegistration> updates = new ArrayList<ActorRegistration>();
        while (buffer.getRemainingBits(buffer.getSize()) >= 11 && (newPlayerIndex = buffer.getBits(11)) != 2047) {
            int offsetX = buffer.getBits(5);
            int offsetY = buffer.getBits(5);
            if (offsetX > 15) {
                offsetX -= 32;
            }
            if (offsetY > 15) {
                offsetY -= 32;
            }
            int initialFaceDirection = buffer.getBits(3);
            boolean updateRequired = buffer.getBits(1) == 1;
            boolean discardWalkingQueue = buffer.getBits(1) == 1;
            updates.add(new ActorRegistration(newPlayerIndex, offsetX, offsetY, initialFaceDirection, updateRequired, discardWalkingQueue));
        }
        return new ActorGroupRegistrationUpdate(updates.toArray(new ActorRegistration[updates.size()]));
    }
}

