/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec.runejs435.decoder.updating;

import java.util.ArrayList;
import org.runejs.client.message.inbound.updating.UpdateNPCsInboundMessage;
import org.runejs.client.message.inbound.updating.movement.ActorGroupMovementUpdate;
import org.runejs.client.message.inbound.updating.registration.ActorGroupRegistrationUpdate;
import org.runejs.client.message.inbound.updating.registration.ActorRegistration;
import org.runejs.client.message.inbound.updating.registration.NPCRegistration;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.net.codec.MessageDecoder;
import org.runejs.client.net.codec.runejs435.decoder.updating.UpdateDecoderHelpers;

public class UpdateNPCsMessageDecoder
implements MessageDecoder<UpdateNPCsInboundMessage> {
    @Override
    public UpdateNPCsInboundMessage decode(PacketBuffer buffer) {
        buffer.initBitAccess();
        ActorGroupMovementUpdate trackedMovement = UpdateDecoderHelpers.decodeGroupMovementUpdate(buffer);
        ActorGroupRegistrationUpdate<NPCRegistration> newNPCs = this.decodeRegistration(buffer);
        buffer.finishBitAccess();
        PacketBuffer appearanceUpdate = UpdateDecoderHelpers.decodeRemainingBytes(buffer);
        return new UpdateNPCsInboundMessage(trackedMovement, newNPCs, appearanceUpdate);
    }

    private ActorGroupRegistrationUpdate<NPCRegistration> decodeRegistration(PacketBuffer buffer) {
        int index;
        ArrayList<NPCRegistration> updates = new ArrayList<NPCRegistration>();
        while (buffer.getRemainingBits(buffer.getSize()) >= 27 && (index = buffer.getBits(15)) != Short.MAX_VALUE) {
            int initialFaceDirection = buffer.getBits(3);
            int offsetX = buffer.getBits(5);
            int offsetY = buffer.getBits(5);
            if (offsetX > 15) {
                offsetX -= 32;
            }
            if (offsetY > 15) {
                offsetY -= 32;
            }
            boolean updateRequired = buffer.getBits(1) == 1;
            boolean discardWalkingQueue = buffer.getBits(1) == 1;
            int definitionId = buffer.getBits(13);
            updates.add(new NPCRegistration(index, offsetX, offsetY, initialFaceDirection, updateRequired, discardWalkingQueue, definitionId));
        }
        return new ActorGroupRegistrationUpdate((ActorRegistration[])updates.toArray(new NPCRegistration[updates.size()]));
    }
}

