/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec.runejs435.decoder.updating;

import java.util.ArrayList;
import org.runejs.client.message.inbound.updating.movement.ActorGroupMovementUpdate;
import org.runejs.client.message.inbound.updating.movement.MovementUpdate;
import org.runejs.client.net.PacketBuffer;

public class UpdateDecoderHelpers {
    public static PacketBuffer decodeRemainingBytes(PacketBuffer buffer) {
        int REMAINING_BYTES_LENGTH = 5000;
        int remainingBytes = buffer.getSize() - buffer.currentPosition;
        PacketBuffer remainingBuffer = new PacketBuffer(REMAINING_BYTES_LENGTH);
        System.arraycopy(buffer.buffer, buffer.currentPosition, remainingBuffer.buffer, 0, remainingBytes);
        remainingBuffer.currentPosition = 0;
        return remainingBuffer;
    }

    public static ActorGroupMovementUpdate decodeGroupMovementUpdate(PacketBuffer buffer) {
        int trackedPlayerCount = buffer.getBits(8);
        ArrayList<ActorGroupMovementUpdate.ActorMovementUpdate> updates = new ArrayList<ActorGroupMovementUpdate.ActorMovementUpdate>();
        for (int i = 0; trackedPlayerCount > i; ++i) {
            int walkDirection;
            boolean updateRequired;
            boolean bl = updateRequired = buffer.getBits(1) == 1;
            if (!updateRequired) {
                updates.add(null);
                continue;
            }
            int movementType = buffer.getBits(2);
            if (movementType == 0) {
                updates.add(new ActorGroupMovementUpdate.ActorMovementUpdate(null, false));
                continue;
            }
            if (movementType == 3) {
                updates.add(new ActorGroupMovementUpdate.ActorMovementUpdate(null, true));
                continue;
            }
            if (movementType == 1) {
                walkDirection = buffer.getBits(3);
                boolean runUpdateBlock = buffer.getBits(1) == 1;
                updates.add(new ActorGroupMovementUpdate.ActorMovementUpdate(new MovementUpdate(walkDirection, null, runUpdateBlock), false));
                continue;
            }
            if (movementType == 2) {
                walkDirection = buffer.getBits(3);
                int runDirection = buffer.getBits(3);
                boolean runUpdateBlock = buffer.getBits(1) == 1;
                updates.add(new ActorGroupMovementUpdate.ActorMovementUpdate(new MovementUpdate(walkDirection, runDirection, runUpdateBlock), false));
                continue;
            }
            throw new IllegalStateException("Invalid movement type: " + movementType);
        }
        return new ActorGroupMovementUpdate(trackedPlayerCount, updates.toArray(new ActorGroupMovementUpdate.ActorMovementUpdate[updates.size()]));
    }
}

