/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net.codec;

import java.util.HashMap;
import java.util.Map;
import org.runejs.client.message.InboundMessage;
import org.runejs.client.message.OutboundMessage;
import org.runejs.client.net.codec.MessageDecoder;
import org.runejs.client.net.codec.MessageEncoder;

public class MessagePacketCodec {
    private int[] packetLengths;
    private final MessageDecoder<?>[] decoders = new MessageDecoder[256];
    private final Map<Class<? extends OutboundMessage>, MessageEncoder<?>> encoders = new HashMap();

    public MessagePacketCodec(int[] packetLengths) {
        this.packetLengths = packetLengths;
    }

    public int getPacketLength(int opcode) {
        return this.packetLengths[opcode];
    }

    public <TMessage extends OutboundMessage> MessageEncoder<TMessage> getMessageEncoder(Class<TMessage> type) {
        return this.encoders.get(type);
    }

    public MessageDecoder<?> getMessageDecoder(int opcode) {
        if (opcode >= this.decoders.length) {
            throw new IndexOutOfBoundsException("Opcode out of bounds");
        }
        return this.decoders[opcode];
    }

    public <M extends OutboundMessage> void register(Class<M> messageType, MessageEncoder<M> encoder) {
        this.encoders.put(messageType, encoder);
    }

    public <M extends InboundMessage> void register(int opcode, MessageDecoder<M> decoder) {
        if (opcode >= this.decoders.length) {
            throw new IndexOutOfBoundsException("Opcode out of bounds");
        }
        this.decoders[opcode] = decoder;
    }
}

