/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net;

import org.runejs.client.net.PacketBuffer;

public class VariableLengthPacketBuffer
extends PacketBuffer {
    private static int MAX_PACKET_SIZE = 255;
    private boolean isOpcodeWritten = false;
    private boolean isSizeWritten = false;

    public VariableLengthPacketBuffer() {
        super(MAX_PACKET_SIZE + 2);
    }

    @Override
    public int getSize() {
        if (!this.isSizeWritten) {
            throw new IllegalStateException("Size has not been written");
        }
        return this.buffer[1] + 2;
    }

    @Override
    public void putPacket(int opcode) {
        if (this.isOpcodeWritten) {
            throw new IllegalStateException("Opcode has already been written");
        }
        super.putPacket(opcode);
        super.putByte(0);
        this.isOpcodeWritten = true;
    }

    public void writePacketLength() {
        if (!this.isOpcodeWritten) {
            throw new IllegalStateException("Opcode has not been written");
        }
        if (this.isSizeWritten) {
            throw new IllegalStateException("Size has already been written");
        }
        int size = this.currentPosition - 2;
        if (size > MAX_PACKET_SIZE) {
            throw new IllegalStateException("Packet size is too large");
        }
        this.buffer[1] = (byte)size;
        this.isSizeWritten = true;
    }
}

