/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net;

import java.io.IOException;
import java.util.zip.CRC32;
import org.runejs.client.GameSocket;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.io.Buffer;
import org.runejs.client.net.IUpdateServer;
import org.runejs.client.net.UpdateServerNode;
import org.runejs.client.node.HashTable;
import org.runejs.client.node.NodeQueue;

public class UpdateServer
implements IUpdateServer {
    public int ioExceptionsCount = 0;
    public int crcMismatchesCount = 0;
    private GameSocket updateServerSocket;
    private Buffer fileDataBuffer = new Buffer(8);
    private Buffer js5ResponseData;
    private Buffer crcTableBuffer;
    private HashTable urgentRequestTable = new HashTable(4096);
    private HashTable urgentInFlightRequests = new HashTable(32);
    private HashTable prefetchInFlightRequests = new HashTable(4096);
    private HashTable prefetchRequestTable = new HashTable(4096);
    private UpdateServerNode currentResponse;
    private CRC32 crc32 = new CRC32();
    private byte encryption = 0;
    private int urgentInFlightRequestCount = 0;
    private int prefetchPendingRequestCount = 0;
    private int urgentPendingRequestCount = 0;
    private int prefetchInFlightRequestCount = 0;
    private boolean urgentRequest;
    private NodeQueue prefetchRequestQueue = new NodeQueue();
    private int blockOffset = 0;
    private int msSinceLastUpdate = 0;
    private long lastUpdateInMillis;
    private CacheArchive[] cacheArchiveLoaders = new CacheArchive[256];

    @Override
    public void receiveConnection(GameSocket socket, boolean isLoggedIn) {
        UpdateServerNode updateServerNode;
        if (this.updateServerSocket != null) {
            try {
                this.updateServerSocket.kill();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.updateServerSocket = null;
        }
        this.updateServerSocket = socket;
        this.resetRequests(isLoggedIn);
        this.fileDataBuffer.currentPosition = 0;
        this.js5ResponseData = null;
        this.blockOffset = 0;
        this.currentResponse = null;
        while ((updateServerNode = (UpdateServerNode)this.urgentInFlightRequests.getNextNode()) != null) {
            this.urgentRequestTable.put(updateServerNode.key, updateServerNode);
            --this.urgentInFlightRequestCount;
            ++this.urgentPendingRequestCount;
        }
        while ((updateServerNode = (UpdateServerNode)this.prefetchInFlightRequests.getNextNode()) != null) {
            this.prefetchRequestQueue.unshift(updateServerNode);
            this.prefetchRequestTable.put(updateServerNode.key, updateServerNode);
            --this.prefetchInFlightRequestCount;
            ++this.prefetchPendingRequestCount;
        }
        if (this.encryption != 0) {
            try {
                Buffer fileRequestBuffer = new Buffer(4);
                fileRequestBuffer.putByte(Opcode.NEW_ENCRYPTION.getValue());
                fileRequestBuffer.putByte(this.encryption);
                fileRequestBuffer.putShortBE(0);
                this.updateServerSocket.sendDataFromBuffer(4, 0, fileRequestBuffer.buffer);
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
                try {
                    this.updateServerSocket.kill();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.updateServerSocket = null;
                ++this.ioExceptionsCount;
            }
        }
        this.msSinceLastUpdate = 0;
        this.lastUpdateInMillis = System.currentTimeMillis();
    }

    private void sendPendingUrgentRequests() throws IOException {
        while (this.urgentInFlightRequestCount < 20 && this.urgentPendingRequestCount > 0) {
            UpdateServerNode updateServerNode = (UpdateServerNode)this.urgentRequestTable.getNextNode();
            Buffer buffer = new Buffer(4);
            buffer.putByte(Opcode.URGENT_REQUEST.getValue());
            buffer.putMediumBE((int)updateServerNode.key);
            this.updateServerSocket.sendDataFromBuffer(4, 0, buffer.buffer);
            this.urgentInFlightRequests.put(updateServerNode.key, updateServerNode);
            --this.urgentPendingRequestCount;
            ++this.urgentInFlightRequestCount;
        }
    }

    private void sendPendingPrefetchRequests() throws IOException {
        while (this.prefetchInFlightRequestCount < 20 && this.prefetchPendingRequestCount > 0) {
            UpdateServerNode updateServerNode = (UpdateServerNode)this.prefetchRequestQueue.next();
            Buffer buffer = new Buffer(4);
            buffer.putByte(Opcode.PREFETCH_REQUEST.getValue());
            buffer.putMediumBE((int)updateServerNode.key);
            this.updateServerSocket.sendDataFromBuffer(4, 0, buffer.buffer);
            updateServerNode.clear();
            this.prefetchInFlightRequests.put(updateServerNode.key, updateServerNode);
            ++this.prefetchInFlightRequestCount;
            --this.prefetchPendingRequestCount;
        }
    }

    private void readJS5ResponseHeader(Buffer buffer) throws IOException {
        buffer.currentPosition = 0;
        int archiveId = buffer.getUnsignedByte();
        int groupId = buffer.getUnsignedShortBE();
        int type = buffer.getUnsignedByte();
        int length = buffer.getIntBE();
        long fileKey = ((long)archiveId << 16) + (long)groupId;
        UpdateServerNode updateServerNode = (UpdateServerNode)this.urgentInFlightRequests.getNode(fileKey);
        this.urgentRequest = true;
        if (updateServerNode == null) {
            updateServerNode = (UpdateServerNode)this.prefetchInFlightRequests.getNode(fileKey);
            this.urgentRequest = false;
        }
        if (updateServerNode == null) {
            throw new IOException();
        }
        this.currentResponse = updateServerNode;
        int compressionSizeOffset = type == 0 ? 5 : 9;
        this.js5ResponseData = new Buffer(this.currentResponse.padding + compressionSizeOffset + length);
        this.js5ResponseData.putByte(type);
        this.js5ResponseData.putIntBE(length);
        this.blockOffset = 8;
        buffer.currentPosition = 0;
    }

    private void readJS5CRCTableResponse(Buffer buffer) {
        this.crcTableBuffer = buffer;
        for (int i = 0; i < 256; ++i) {
            int targetPosition;
            CacheArchive archive = this.cacheArchiveLoaders[i];
            if (archive == null) continue;
            this.crcTableBuffer.currentPosition = targetPosition = i * 4 + 5;
            int indexCrcValue = this.crcTableBuffer.getIntBE();
            archive.requestLatestVersion(indexCrcValue);
        }
    }

    private boolean readJS5ArchiveFileResponse(Buffer buffer, int inboundFileLength) {
        this.crc32.reset();
        this.crc32.update(buffer.buffer, 0, inboundFileLength);
        int fileRealCrcValue = (int)this.crc32.getValue();
        if (~this.currentResponse.crc != ~fileRealCrcValue) {
            try {
                this.updateServerSocket.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.encryption = (byte)(Math.random() * 255.0 + 1.0);
            this.updateServerSocket = null;
            ++this.crcMismatchesCount;
            return false;
        }
        this.ioExceptionsCount = 0;
        this.crcMismatchesCount = 0;
        this.currentResponse.cacheArchive.receiveContent((this.currentResponse.key & 0xFF0000L) == 0xFF0000L, (int)(this.currentResponse.key & 0xFFFFL), this.urgentRequest, buffer.buffer);
        return true;
    }

    @Override
    public boolean poll() {
        long l = System.currentTimeMillis();
        int currentMsSinceLastUpdate = (int)(l - this.lastUpdateInMillis);
        this.lastUpdateInMillis = l;
        if (currentMsSinceLastUpdate > 200) {
            currentMsSinceLastUpdate = 200;
        }
        this.msSinceLastUpdate += currentMsSinceLastUpdate;
        if (this.prefetchInFlightRequestCount == 0 && this.urgentInFlightRequestCount == 0 && this.prefetchPendingRequestCount == 0 && this.urgentPendingRequestCount == 0) {
            return true;
        }
        if (this.updateServerSocket == null) {
            return false;
        }
        try {
            if (this.msSinceLastUpdate > 30000) {
                throw new IOException();
            }
            this.sendPendingUrgentRequests();
            this.sendPendingPrefetchRequests();
            for (int i1 = 0; i1 < 100; ++i1) {
                int i;
                int amountToRead;
                int dataAvailable = this.updateServerSocket.inputStreamAvailable();
                if (dataAvailable < 0) {
                    throw new IOException();
                }
                if (dataAvailable == 0) break;
                this.msSinceLastUpdate = 0;
                if (this.currentResponse == null || this.blockOffset == 0) {
                    int read = this.currentResponse == null ? 8 : 1;
                    amountToRead = read - this.fileDataBuffer.currentPosition;
                    if (amountToRead > dataAvailable) {
                        amountToRead = dataAvailable;
                    }
                    this.updateServerSocket.readDataToBuffer(this.fileDataBuffer.buffer, this.fileDataBuffer.currentPosition, amountToRead);
                    if (this.encryption != 0) {
                        for (i = 0; amountToRead > i; ++i) {
                            this.fileDataBuffer.buffer[this.fileDataBuffer.currentPosition + i] = (byte)UpdateServer.xor(this.fileDataBuffer.buffer[this.fileDataBuffer.currentPosition + i], this.encryption);
                        }
                    }
                    this.fileDataBuffer.currentPosition += amountToRead;
                    if (read > this.fileDataBuffer.currentPosition) break;
                    if (this.currentResponse == null) {
                        this.readJS5ResponseHeader(this.fileDataBuffer);
                        continue;
                    }
                    if (this.blockOffset != 0) continue;
                    if (this.fileDataBuffer.buffer[0] == -1) {
                        this.fileDataBuffer.currentPosition = 0;
                        this.blockOffset = 1;
                        continue;
                    }
                    this.currentResponse = null;
                    continue;
                }
                amountToRead = 512 - this.blockOffset;
                int inboundFileLength = this.js5ResponseData.buffer.length - this.currentResponse.padding;
                if (amountToRead > inboundFileLength - this.js5ResponseData.currentPosition) {
                    amountToRead = inboundFileLength - this.js5ResponseData.currentPosition;
                }
                if (amountToRead > dataAvailable) {
                    amountToRead = dataAvailable;
                }
                this.updateServerSocket.readDataToBuffer(this.js5ResponseData.buffer, this.js5ResponseData.currentPosition, amountToRead);
                if (this.encryption != 0) {
                    for (i = 0; amountToRead > i; ++i) {
                        this.js5ResponseData.buffer[this.js5ResponseData.currentPosition + i] = (byte)UpdateServer.xor(this.js5ResponseData.buffer[this.js5ResponseData.currentPosition + i], this.encryption);
                    }
                }
                this.js5ResponseData.currentPosition += amountToRead;
                this.blockOffset += amountToRead;
                if (inboundFileLength != this.js5ResponseData.currentPosition) {
                    if (this.blockOffset != 512) break;
                    this.blockOffset = 0;
                    continue;
                }
                if (this.currentResponse.key == 0xFF00FFL) {
                    this.readJS5CRCTableResponse(this.js5ResponseData);
                } else {
                    this.readJS5ArchiveFileResponse(this.js5ResponseData, inboundFileLength);
                }
                this.currentResponse.unlink();
                this.currentResponse = null;
                this.js5ResponseData = null;
                this.blockOffset = 0;
                if (this.urgentRequest) {
                    --this.urgentInFlightRequestCount;
                    continue;
                }
                --this.prefetchInFlightRequestCount;
            }
            return true;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            try {
                this.updateServerSocket.kill();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++this.ioExceptionsCount;
            this.updateServerSocket = null;
            return false;
        }
    }

    public void enqueueFileRequest(CacheArchive archive, int archiveId, int groupId, byte padding, int expectedCrc, boolean urgent) {
        long fileKey = ((long)archiveId << 16) + (long)groupId;
        UpdateServerNode updateServerNode = (UpdateServerNode)this.urgentRequestTable.getNode(fileKey);
        if (updateServerNode == null && (updateServerNode = (UpdateServerNode)this.urgentInFlightRequests.getNode(fileKey)) == null) {
            updateServerNode = (UpdateServerNode)this.prefetchRequestTable.getNode(fileKey);
            if (updateServerNode == null) {
                if (!urgent && (updateServerNode = (UpdateServerNode)this.prefetchInFlightRequests.getNode(fileKey)) != null) {
                    return;
                }
                updateServerNode = new UpdateServerNode();
                updateServerNode.crc = expectedCrc;
                updateServerNode.padding = padding;
                updateServerNode.cacheArchive = archive;
                if (urgent) {
                    this.urgentRequestTable.put(fileKey, updateServerNode);
                    ++this.urgentPendingRequestCount;
                } else {
                    this.prefetchRequestQueue.push(updateServerNode);
                    this.prefetchRequestTable.put(fileKey, updateServerNode);
                    ++this.prefetchPendingRequestCount;
                }
            } else if (urgent) {
                updateServerNode.clear();
                this.urgentRequestTable.put(fileKey, updateServerNode);
                --this.prefetchPendingRequestCount;
                ++this.urgentPendingRequestCount;
            }
        }
    }

    public void prioritisePrefetchRequest(int archiveId, int groupId) {
        long fileKey = (archiveId << 16) + groupId;
        UpdateServerNode updateServerNode = (UpdateServerNode)this.prefetchRequestTable.getNode(fileKey);
        if (updateServerNode != null) {
            this.prefetchRequestQueue.unshift(updateServerNode);
        }
    }

    public void requestArchiveChecksum(CacheArchive cacheArchive, int cacheIndexId) {
        if (this.crcTableBuffer == null) {
            this.enqueueFileRequest(null, 255, 255, (byte)0, 0, true);
            this.cacheArchiveLoaders[cacheIndexId] = cacheArchive;
        } else {
            this.crcTableBuffer.currentPosition = 5 + cacheIndexId * 4;
            int i = this.crcTableBuffer.getIntBE();
            cacheArchive.requestLatestVersion(i);
        }
    }

    private static int xor(int arg0, int arg1) {
        return arg0 ^ arg1;
    }

    @Override
    public void resetRequests(boolean loggedIn) {
        if (this.updateServerSocket != null) {
            try {
                Buffer buffer = new Buffer(4);
                buffer.putByte(loggedIn ? Opcode.LOGGED_IN.getValue() : Opcode.LOGGED_OUT.getValue());
                buffer.putMediumBE(0);
                this.updateServerSocket.sendDataFromBuffer(4, 0, buffer.buffer);
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
                try {
                    this.updateServerSocket.kill();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.updateServerSocket = null;
                ++this.ioExceptionsCount;
            }
        }
    }

    @Override
    public void close() {
        if (this.updateServerSocket != null) {
            this.updateServerSocket.kill();
        }
    }

    @Override
    public int getLoadedPercentage(int groupId, int fileId) {
        long l = (groupId << 16) + fileId;
        if (this.currentResponse == null || this.currentResponse.key != l) {
            return 0;
        }
        return 1 + this.js5ResponseData.currentPosition * 99 / (this.js5ResponseData.buffer.length + -this.currentResponse.padding);
    }

    @Override
    public int getActiveTaskCount(boolean includePrefetch, boolean includeUrgent) {
        int total = 0;
        if (includeUrgent) {
            total += this.urgentInFlightRequestCount + this.urgentPendingRequestCount;
        }
        if (includePrefetch) {
            total += this.prefetchInFlightRequestCount + this.prefetchPendingRequestCount;
        }
        return total;
    }

    private static enum Opcode {
        PREFETCH_REQUEST(0),
        URGENT_REQUEST(1),
        LOGGED_IN(2),
        LOGGED_OUT(3),
        NEW_ENCRYPTION(4);

        private final int value;

        private Opcode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

