/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net;

import org.runejs.client.io.Buffer;
import org.runejs.client.net.ISAAC;

public class PacketBuffer
extends Buffer {
    public static int[] BITMASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    public ISAAC inCipher;
    public ISAAC outCipher;
    public int bitoffset;
    private final int size;

    public PacketBuffer(int size) {
        super(size);
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getRemainingBits(int packetSize) {
        return 8 * packetSize - this.bitoffset;
    }

    public void finishBitAccess() {
        this.currentPosition = (7 + this.bitoffset) / 8;
    }

    public int getPacket() {
        return 0xFF & this.buffer[this.currentPosition++] - this.inCipher.nextInt();
    }

    public int getBits(int arg0) {
        int i = this.bitoffset >> 3;
        int i_0_ = 0;
        int i_1_ = 8 - (7 & this.bitoffset);
        this.bitoffset += arg0;
        while (i_1_ < arg0) {
            i_0_ += (BITMASK[i_1_] & this.buffer[i++]) << -i_1_ + arg0;
            arg0 -= i_1_;
            i_1_ = 8;
        }
        i_0_ = arg0 != i_1_ ? (i_0_ += BITMASK[arg0] & this.buffer[i] >> -arg0 + i_1_) : (i_0_ += this.buffer[i] & BITMASK[i_1_]);
        return i_0_;
    }

    public void putPacket(int packetId) {
        this.buffer[this.currentPosition++] = (byte)(packetId + this.outCipher.nextInt() & 0xFF);
    }

    public void initInCipher(int[] seed) {
        this.inCipher = new ISAAC(seed);
    }

    public void initOutCipher(int[] seed) {
        this.outCipher = new ISAAC(seed);
    }

    public void initBitAccess() {
        this.bitoffset = this.currentPosition * 8;
    }
}

