/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.net;

import org.runejs.client.Game;
import org.runejs.client.message.OutboundMessage;
import org.runejs.client.net.ISAAC;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.net.VariableLengthPacketBuffer;
import org.runejs.client.net.codec.MessageEncoder;

public class OutgoingPackets {
    public static PacketBuffer buffer = new PacketBuffer(5000);
    private static ISAAC outCipher;

    public static void init(ISAAC outCipher) {
        OutgoingPackets.outCipher = outCipher;
    }

    public static PacketBuffer openFixedSizePacket(int size, int opcode) {
        int totalSize = size + 1;
        PacketBuffer buffer = new PacketBuffer(totalSize);
        buffer.outCipher = outCipher;
        buffer.putPacket(opcode);
        return buffer;
    }

    public static VariableLengthPacketBuffer openVariableSizePacket(int opcode) {
        VariableLengthPacketBuffer buffer = new VariableLengthPacketBuffer();
        buffer.outCipher = outCipher;
        buffer.putPacket(opcode);
        return buffer;
    }

    public static <TMessage extends OutboundMessage> void sendMessage(TMessage message) {
        MessageEncoder<?> encoder = Game.packetCodec.getMessageEncoder(message.getClass());
        if (encoder == null) {
            throw new RuntimeException();
        }
        PacketBuffer buffer = encoder.encode(message);
        OutgoingPackets.buffer.putBytes(0, buffer.getSize(), buffer.buffer);
    }
}

