/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.message.handler.rs435.updating;

import org.runejs.client.MovedStatics;
import org.runejs.client.cache.def.ActorDefinition;
import org.runejs.client.media.renderable.actor.Actor;
import org.runejs.client.media.renderable.actor.Npc;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.message.handler.MessageHandler;
import org.runejs.client.message.inbound.updating.UpdateNPCsInboundMessage;
import org.runejs.client.message.inbound.updating.movement.ActorGroupMovementUpdate;
import org.runejs.client.message.inbound.updating.movement.MovementUpdate;
import org.runejs.client.message.inbound.updating.registration.ActorGroupRegistrationUpdate;
import org.runejs.client.message.inbound.updating.registration.NPCRegistration;

public class UpdateNPCsMessageHandler
implements MessageHandler<UpdateNPCsInboundMessage> {
    @Override
    public void handle(UpdateNPCsInboundMessage message) {
        int i;
        MovedStatics.deregisterActorCount = 0;
        Actor.actorUpdatingIndex = 0;
        this.handleTrackedMovement(message.trackedNPCMovement);
        this.handleRegisterNewNPCs(message.newNPCs);
        Npc.parseNpcUpdateMasks(message.appearanceUpdates);
        for (i = 0; i < MovedStatics.deregisterActorCount; ++i) {
            int trackedNpcIndex = Player.deregisterActorIndices[i];
            if (MovedStatics.pulseCycle == Player.npcs[trackedNpcIndex].anInt3134) continue;
            Player.npcs[trackedNpcIndex].actorDefinition = null;
            Player.npcs[trackedNpcIndex] = null;
        }
        for (i = 0; Player.npcCount > i; ++i) {
            if (Player.npcs[Player.npcIds[i]] != null) continue;
            throw new RuntimeException("gnp2 pos:" + i + " size:" + Player.npcCount);
        }
    }

    private void handleTrackedMovement(ActorGroupMovementUpdate update) {
        int i;
        int trackedNpcCount = update.actorCount;
        if (Player.npcCount > trackedNpcCount) {
            for (i = trackedNpcCount; i < Player.npcCount; ++i) {
                Player.deregisterActorIndices[MovedStatics.deregisterActorCount++] = Player.npcIds[i];
            }
        }
        if (Player.npcCount < trackedNpcCount) {
            System.out.println("gppov1 [npc] " + Player.npcCount + " " + trackedNpcCount);
            throw new RuntimeException("gppov1");
        }
        Player.npcCount = 0;
        for (i = 0; trackedNpcCount > i; ++i) {
            int trackedNpcIndex = Player.npcIds[i];
            Npc npc = Player.npcs[trackedNpcIndex];
            ActorGroupMovementUpdate.ActorMovementUpdate npcUpdate = update.movementUpdates[i];
            if (npcUpdate == null) {
                Player.npcIds[Player.npcCount++] = trackedNpcIndex;
                npc.anInt3134 = MovedStatics.pulseCycle;
                Player.actorUpdatingIndices[Npc.actorUpdatingIndex++] = trackedNpcIndex;
                continue;
            }
            if (npcUpdate.shouldDeregister) {
                Player.deregisterActorIndices[MovedStatics.deregisterActorCount++] = trackedNpcIndex;
                continue;
            }
            Player.npcIds[Player.npcCount++] = trackedNpcIndex;
            npc.anInt3134 = MovedStatics.pulseCycle;
            if (npcUpdate.movementUpdate == null) {
                Player.actorUpdatingIndices[Npc.actorUpdatingIndex++] = trackedNpcIndex;
                continue;
            }
            MovementUpdate movementUpdate = npcUpdate.movementUpdate;
            if (movementUpdate.runDirection != null) {
                npc.move(movementUpdate.walkDirection, true);
                npc.move(movementUpdate.runDirection, true);
            } else {
                npc.move(movementUpdate.walkDirection, false);
            }
            if (!movementUpdate.runUpdateBlock) continue;
            Player.actorUpdatingIndices[Npc.actorUpdatingIndex++] = trackedNpcIndex;
        }
    }

    private void handleRegisterNewNPCs(ActorGroupRegistrationUpdate<NPCRegistration> update) {
        for (NPCRegistration playerUpdate : (NPCRegistration[])update.players) {
            int i = playerUpdate.index;
            if (i == Short.MAX_VALUE) break;
            boolean initializing = false;
            if (Player.npcs[i] == null) {
                Player.npcs[i] = new Npc();
                initializing = true;
            }
            Npc npc = Player.npcs[i];
            Player.npcIds[Player.npcCount++] = i;
            npc.anInt3134 = MovedStatics.pulseCycle;
            int initialFaceDirection = playerUpdate.faceDirection;
            int faceDirection = MovedStatics.directions[initialFaceDirection];
            if (initializing) {
                npc.initialFaceDirection = faceDirection;
            }
            int offsetX = playerUpdate.offsetX;
            int offsetY = playerUpdate.offsetY;
            if (offsetX > 15) {
                offsetX -= 32;
            }
            if (offsetY > 15) {
                offsetY -= 32;
            }
            if (playerUpdate.updateRequired) {
                Player.actorUpdatingIndices[Npc.actorUpdatingIndex++] = i;
            }
            npc.actorDefinition = ActorDefinition.getDefinition(playerUpdate.definitionId);
            npc.turnLeftAnimationId = npc.actorDefinition.rotate90LeftAnimation;
            npc.idleAnimation = npc.actorDefinition.stanceAnimation;
            npc.anInt3083 = npc.actorDefinition.rotateRightAnimation;
            npc.walkAnimationId = npc.actorDefinition.walkAnimation;
            npc.size = npc.actorDefinition.boundaryDimension;
            npc.turnAroundAnimationId = npc.actorDefinition.rotate180Animation;
            npc.standTurnAnimationId = npc.actorDefinition.rotateLeftAnimation;
            npc.anInt3113 = npc.actorDefinition.degreesToTurn;
            if (npc.anInt3113 == 0) {
                npc.anInt3118 = 0;
            }
            npc.turnRightAnimationId = npc.actorDefinition.rotate90RightAnimation;
            npc.method787(Player.localPlayer.pathX[0] + offsetY, playerUpdate.updateRequired, Player.localPlayer.pathY[0] + offsetX);
        }
    }
}

