/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.message.handler.rs435.camera;

import org.runejs.client.Game;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.message.handler.MessageHandler;
import org.runejs.client.message.inbound.camera.CutsceneCameraLookToInboundMessage;
import org.runejs.client.scene.Point3d;

public class CutsceneCameraLookToMessageHandler
implements MessageHandler<CutsceneCameraLookToInboundMessage> {
    @Override
    public void handle(CutsceneCameraLookToInboundMessage message) {
        Player.cutsceneActive = true;
        Game.cutsceneCamera.setLookAt(new Point3d(64 + 128 * message.targetX, 64 + 128 * message.targetY, message.height));
        Game.cutsceneCamera.setTurnSpeed(message.speedBase, message.speedScale);
        if (message.speedScale >= 100) {
            int x = Game.cutsceneCamera.getLookAt().x;
            int y = Game.cutsceneCamera.getLookAt().y;
            int z = Game.currentScene.getFloorDrawHeight(Player.worldLevel, x, y) - Game.cutsceneCamera.getLookAt().z;
            Point3d cameraPos = Game.cutsceneCamera.getPosition();
            int deltaX = x - cameraPos.x;
            int deltaY = y - cameraPos.y;
            int deltaZ = z - cameraPos.z;
            int horizontalDistance = (int)Math.sqrt(deltaY * deltaY + deltaX * deltaX);
            Game.cutsceneCamera.setPitch((int)(325.949 * Math.atan2(deltaZ, horizontalDistance)) & 0x7FF);
            Game.cutsceneCamera.setYaw((int)(-325.949 * Math.atan2(deltaX, deltaY)) & 0x7FF);
        }
    }
}

