/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.media.renderable.actor;

import org.runejs.client.cache.def.ActorDefinition;
import org.runejs.client.cache.def.IdentityKit;
import org.runejs.client.cache.def.ItemDefinition;
import org.runejs.client.cache.media.AnimationSequence;
import org.runejs.client.io.Buffer;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.node.NodeCache;

public class PlayerAppearance {
    public static int[][] playerColours = new int[][]{{6798, 107, 10283, 16, 4797, 7744, 5799, 4634, 33697, 22433, 2983, 54193}, {8741, 12, 64030, 43162, 7735, 8404, 1701, 38430, 24094, 10153, 56621, 4783, 1341, 16578, 35003, 25239}, {25238, 8742, 12, 64030, 43162, 7735, 8404, 1701, 38430, 24094, 10153, 56621, 4783, 1341, 16578, 35003}, {4626, 11146, 6439, 12, 4758, 10270}, {4550, 4537, 5681, 5673, 5790, 6806, 8076, 4574}};
    public static int[] playerSkinColors = new int[]{9104, 10275, 7595, 3610, 7975, 8526, 918, 38802, 24466, 10145, 58654, 5027, 1457, 16565, 34991, 25486};
    public static int[] APPEARANCE_INDICES = new int[]{8, 11, 4, 6, 9, 7, 10};
    public static NodeCache playerModelCache = new NodeCache(260);
    public boolean isFemale;
    public int[] appearance;
    public int transformationNpcId;
    public int[] appearanceColors;
    public long appearanceHash;
    public long cachedModel;

    public static void clearPlayerModelCache() {
        playerModelCache.clear();
    }

    public int getHeadModelId() {
        if (this.transformationNpcId != -1) {
            return ActorDefinition.getDefinition((int)this.transformationNpcId).id + 305419896;
        }
        return this.appearance[1] + (this.appearance[11] << 5) + (this.appearanceColors[4] << 20) + (this.appearanceColors[0] << 25) + (this.appearance[0] << 15) + (this.appearance[8] << 10);
    }

    public void sendAppearanceData(int startIndex, Buffer buffer) {
        int i;
        buffer.putByte(this.isFemale ? 1 : 0);
        for (i = startIndex; i < 7; ++i) {
            int i_0_ = this.appearance[APPEARANCE_INDICES[i]];
            if (i_0_ != 0) {
                buffer.putByte(-256 + i_0_);
                continue;
            }
            buffer.putByte(-1);
        }
        for (i = 0; i < 5; ++i) {
            buffer.putByte(this.appearanceColors[i]);
        }
    }

    public Model getAnimatedModel(AnimationSequence animation1, AnimationSequence animation2, int unknown1, int unknown2) {
        Model finalModel;
        Model cachedModel;
        if (this.transformationNpcId != -1) {
            return ActorDefinition.getDefinition(this.transformationNpcId).getChildModel(animation1, animation2, unknown1, unknown2);
        }
        long hash = this.appearanceHash;
        int[] appearance = this.appearance;
        if (animation1 != null && (animation1.offHandModel >= 0 || animation1.mainHandModel >= 0)) {
            appearance = new int[12];
            for (int i = 0; i < 12; ++i) {
                appearance[i] = this.appearance[i];
            }
            if (animation1.offHandModel >= 0) {
                hash += (long)(animation1.offHandModel - this.appearance[5] << 8);
                appearance[5] = animation1.offHandModel;
            }
            if (animation1.mainHandModel >= 0) {
                hash += (long)(animation1.mainHandModel - this.appearance[3] << 16);
                appearance[3] = animation1.mainHandModel;
            }
        }
        if ((cachedModel = (Model)playerModelCache.get(hash)) == null) {
            boolean invalid = false;
            for (int bodyPart = 0; bodyPart < 12; ++bodyPart) {
                int appearanceModel = appearance[bodyPart];
                if (appearanceModel >= 256 && appearanceModel < 512 && !IdentityKit.cache(-256 + appearanceModel).isBodyModelCached()) {
                    invalid = true;
                }
                if (appearanceModel < 512 || ItemDefinition.forId(appearanceModel + -512, 10).equipmentReady(this.isFemale)) continue;
                invalid = true;
            }
            if (invalid) {
                if (this.cachedModel != -1L) {
                    cachedModel = (Model)playerModelCache.get(this.cachedModel);
                }
                if (cachedModel == null) {
                    return null;
                }
            }
            if (cachedModel == null) {
                Model[] models = new Model[12];
                int count = 0;
                for (int index = 0; index < 12; ++index) {
                    Model equipment;
                    Model bodyModel;
                    int part = appearance[index];
                    if (part >= 256 && part < 512 && (bodyModel = IdentityKit.cache(part - 256).getBodyModel()) != null) {
                        models[count++] = bodyModel;
                    }
                    if (part < 512 || (equipment = ItemDefinition.forId(part - 512, 10).asEquipment(this.isFemale)) == null) continue;
                    models[count++] = equipment;
                }
                cachedModel = new Model(models, count);
                for (int part = 0; part < 5; ++part) {
                    if (this.appearanceColors[part] == 0) continue;
                    cachedModel.replaceColor(playerColours[part][0], playerColours[part][this.appearanceColors[part]]);
                    if (part != 1) continue;
                    cachedModel.replaceColor(playerSkinColors[0], playerSkinColors[this.appearanceColors[part]]);
                }
                cachedModel.createBones();
                cachedModel.applyLighting(64, 850, -30, -50, -30, true);
                playerModelCache.put(hash, cachedModel);
                this.cachedModel = hash;
            }
        }
        if (animation1 != null || animation2 != null) {
            finalModel = animation1 == null || animation2 == null ? (animation1 == null ? animation2.method599(unknown1, cachedModel, false) : animation1.method599(unknown2, cachedModel, false)) : animation1.method590(cachedModel, animation2, unknown2, unknown1, (byte)63);
        } else {
            return cachedModel;
        }
        return finalModel;
    }

    public void updateAppearanceCache() {
        int appearance9 = this.appearance[9];
        int appearance5 = this.appearance[5];
        long originalAppearanceHash = this.appearanceHash;
        this.appearance[5] = appearance9;
        this.appearance[9] = appearance5;
        this.appearanceHash = 0L;
        for (int appearanceIndex = 0; appearanceIndex < 12; ++appearanceIndex) {
            this.appearanceHash <<= 4;
            if (this.appearance[appearanceIndex] < 256) continue;
            this.appearanceHash += (long)(this.appearance[appearanceIndex] + -256);
        }
        if (this.appearance[0] >= 256) {
            this.appearanceHash += (long)(-256 + this.appearance[0] >> 4);
        }
        if (this.appearance[1] >= 256) {
            this.appearanceHash += (long)(-256 + this.appearance[1] >> 8);
        }
        for (int colorIndex = 0; colorIndex < 5; ++colorIndex) {
            this.appearanceHash <<= 3;
            this.appearanceHash += (long)this.appearanceColors[colorIndex];
        }
        this.appearanceHash <<= 1;
        this.appearanceHash += (long)(this.isFemale ? 1 : 0);
        this.appearance[5] = appearance5;
        this.appearance[9] = appearance9;
        if (originalAppearanceHash != 0L && originalAppearanceHash != this.appearanceHash) {
            playerModelCache.remove(originalAppearanceHash);
        }
    }

    public Model getStaticModel() {
        if (this.transformationNpcId != -1) {
            return ActorDefinition.getDefinition(this.transformationNpcId).getHeadModel();
        }
        boolean bool = false;
        for (int i = 0; i < 12; ++i) {
            int appearanceId = this.appearance[i];
            if (appearanceId >= 256 && appearanceId < 512 && !IdentityKit.cache(appearanceId - 256).method624()) {
                bool = true;
            }
            if (appearanceId < 512 || ItemDefinition.forId(-512 + appearanceId, 10).headPieceReady(this.isFemale)) continue;
            bool = true;
        }
        if (bool) {
            return null;
        }
        Model[] models = new Model[12];
        int i = 0;
        for (int equipmentSlot = 0; equipmentSlot < 12; ++equipmentSlot) {
            Model model;
            int slotAppearance = this.appearance[equipmentSlot];
            if (slotAppearance >= 256 && slotAppearance < 512 && (model = IdentityKit.cache(-256 + slotAppearance).method629()) != null) {
                models[i++] = model;
            }
            if (slotAppearance < 512 || (model = ItemDefinition.forId(slotAppearance - 512, 10).asHeadPiece(this.isFemale)) == null) continue;
            models[i++] = model;
        }
        Model finalModel = new Model(models, i);
        for (int colorIndex = 0; colorIndex < 5; ++colorIndex) {
            if (this.appearanceColors[colorIndex] == 0) continue;
            finalModel.replaceColor(playerColours[colorIndex][0], playerColours[colorIndex][this.appearanceColors[colorIndex]]);
            if (colorIndex != 1) continue;
            finalModel.replaceColor(playerSkinColors[0], playerSkinColors[this.appearanceColors[colorIndex]]);
        }
        return finalModel;
    }

    public void setPlayerAppearance(int[] appearance, boolean gender, int[] appearanceColors, int transformationNpcId) {
        if (appearance == null) {
            appearance = new int[12];
            block0: for (int appearanceIndex = 0; appearanceIndex < 7; ++appearanceIndex) {
                for (int identityKitIndex = 0; IdentityKit.count > identityKitIndex; ++identityKitIndex) {
                    IdentityKit identityKit = IdentityKit.cache(identityKitIndex);
                    if (identityKit.nonSelectable || identityKit.bodyPartId != appearanceIndex + (!gender ? 0 : 7)) continue;
                    appearance[PlayerAppearance.APPEARANCE_INDICES[appearanceIndex]] = identityKitIndex + 256;
                    continue block0;
                }
            }
        }
        this.transformationNpcId = transformationNpcId;
        this.isFemale = gender;
        this.appearance = appearance;
        this.appearanceColors = appearanceColors;
        this.updateAppearanceCache();
    }

    public void loadCachedAppearance(int unknown1, boolean unknown2) {
        int i;
        if (!(unknown1 == 1 && this.isFemale || (i = this.appearance[APPEARANCE_INDICES[unknown1]]) == 0)) {
            IdentityKit identityKit;
            i -= 256;
            do {
                if (unknown2) {
                    if (++i < IdentityKit.count) continue;
                    i = 0;
                    continue;
                }
                if (--i >= 0) continue;
                i = -1 + IdentityKit.count;
            } while ((identityKit = IdentityKit.cache(i)) == null || identityKit.nonSelectable || identityKit.bodyPartId != unknown1 + (!this.isFemale ? 0 : 7));
            this.appearance[PlayerAppearance.APPEARANCE_INDICES[unknown1]] = i + 256;
            this.updateAppearanceCache();
        }
    }

    public void setFemale(boolean female) {
        if (this.isFemale == !female) {
            this.setPlayerAppearance(null, female, this.appearanceColors, -1);
        }
    }

    public void updateAppearanceColors(boolean reset, int appearanceIndex) {
        int appearanceColor = this.appearanceColors[appearanceIndex];
        if (!reset) {
            if (--appearanceColor < 0) {
                appearanceColor = -1 + playerColours[appearanceIndex].length;
            }
        } else if (playerColours[appearanceIndex].length <= ++appearanceColor) {
            appearanceColor = 0;
        }
        this.appearanceColors[appearanceIndex] = appearanceColor;
        this.updateAppearanceCache();
    }
}

