/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.media.renderable.actor;

import org.runejs.client.ActionRowType;
import org.runejs.client.Game;
import org.runejs.client.MovedStatics;
import org.runejs.client.RSString;
import org.runejs.client.cache.def.ItemDefinition;
import org.runejs.client.cache.def.SpotAnimDefinition;
import org.runejs.client.cache.media.AnimationSequence;
import org.runejs.client.cache.media.gameInterface.GameInterface;
import org.runejs.client.frame.ChatBox;
import org.runejs.client.io.Buffer;
import org.runejs.client.language.English;
import org.runejs.client.language.Native;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.media.renderable.actor.Actor;
import org.runejs.client.media.renderable.actor.Npc;
import org.runejs.client.media.renderable.actor.PlayerAppearance;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.util.TextUtils;

public class Player
extends Actor {
    public static int worldLevel;
    public static int[] viewportOffsets;
    public static Player localPlayer;
    public static int[] actorUpdatingIndices;
    public static Buffer[] trackedPlayerAppearanceCache;
    public static int[] deregisterActorIndices;
    public static Npc[] npcs;
    public static Player[] trackedPlayers;
    public static int[] npcIds;
    public static int[] trackedPlayerIndices;
    public static int npcCount;
    public static int localPlayerCount;
    public static boolean inTutorialIsland;
    public static Buffer chatBuffer;
    public static boolean cutsceneActive;
    public static int[] playerExperience;
    public static int[] playerLevels;
    public static int[] nextLevels;
    public static int[] experienceForLevels;
    public static long[] privateMessageIds;
    public static int privateMessageIndex;
    public static int friendListStatus;
    public static int worldId;
    public static PlayerAppearance activePlayerAppearance;
    public static int localPlayerId;
    public static String[] playerActions;
    public static boolean[] playerActionsLowPriority;
    private static byte[] aByteArray169;
    public int skillLevel = 0;
    public int anInt3258;
    public int combatLevel = 0;
    public int anInt3262;
    public Model playerModel;
    public int teamId = 0;
    public int isSkulled = -1;
    public int anInt3271;
    public int anInt3272;
    public int headIcon = -1;
    public int anInt3274 = 0;
    public int anInt3276;
    public String playerName;
    public int anInt3281;
    public PlayerAppearance playerAppearance;
    public int anInt3283 = 0;
    public boolean aBoolean3287 = false;
    public int anInt3289;
    public int anInt3291;

    public static void parsePlayerUpdateMasks(PacketBuffer appearanceBuffer, Player player, int mask, int playerIndex) {
        int damageType2;
        int damageType1;
        if ((0x100 & mask) != 0) {
            damageType1 = appearanceBuffer.getUnsignedByte();
            damageType2 = appearanceBuffer.getUnsignedByte();
            player.method785(damageType2, MovedStatics.pulseCycle, damageType1);
            player.anInt3139 = 300 + MovedStatics.pulseCycle;
            player.remainingHitpoints = appearanceBuffer.getUnsignedByte();
            player.maximumHitpoints = appearanceBuffer.getUnsignedByte();
        }
        if ((mask & 0x10) != 0) {
            player.facePositionX = appearanceBuffer.getUnsignedShortBE();
            player.facePositionY = appearanceBuffer.getUnsignedShortLE();
        }
        if ((mask & 1) != 0) {
            int animationId = appearanceBuffer.getUnsignedShortLE();
            if (animationId == 65535) {
                animationId = -1;
            }
            int animationDelay = appearanceBuffer.getUnsignedByte();
            Player.playAnimation(animationId, animationDelay, player);
        }
        if ((mask & 4) != 0) {
            player.facingActorIndex = appearanceBuffer.getUnsignedShortBE();
            if (player.facingActorIndex == 65535) {
                player.facingActorIndex = -1;
            }
        }
        if ((0x40 & mask) != 0) {
            damageType1 = appearanceBuffer.getUnsignedByte();
            damageType2 = appearanceBuffer.getUnsignedByte();
            player.method785(damageType2, MovedStatics.pulseCycle, damageType1);
            player.anInt3139 = 300 + MovedStatics.pulseCycle;
            player.remainingHitpoints = appearanceBuffer.getUnsignedByte();
            player.maximumHitpoints = appearanceBuffer.getUnsignedByte();
        }
        if ((mask & 0x400) != 0) {
            player.forceMoveStartX = appearanceBuffer.getUnsignedByte();
            player.forceMoveStartY = appearanceBuffer.getUnsignedByte();
            player.forceMoveEndX = appearanceBuffer.getUnsignedByte();
            player.forceMoveEndY = appearanceBuffer.getUnsignedByte();
            player.forceMoveEndCycle = appearanceBuffer.getUnsignedShortBE() + MovedStatics.pulseCycle;
            player.forceMoveStartCycle = appearanceBuffer.getUnsignedShortLE() + MovedStatics.pulseCycle;
            player.forceMoveFaceDirection = appearanceBuffer.getUnsignedByte();
            player.method790(0);
        }
        if ((8 & mask) != 0) {
            int chatEffectsAndColors = appearanceBuffer.getUnsignedShortBE();
            int playerRights = appearanceBuffer.getUnsignedByte();
            int messageLength = appearanceBuffer.getUnsignedByte();
            int bufferPosition = appearanceBuffer.currentPosition;
            if (player.playerName != null && player.playerAppearance != null) {
                boolean bool;
                long l = TextUtils.nameToLong(player.playerName);
                boolean bl = bool = playerRights <= 1 && Game.ignoreList.containsPlayer(l);
                if (!bool && !inTutorialIsland) {
                    Player.chatBuffer.currentPosition = 0;
                    appearanceBuffer.getBytes(0, messageLength, Player.chatBuffer.buffer);
                    Player.chatBuffer.currentPosition = 0;
                    String incomming = MovedStatics.method956(appearanceBuffer);
                    String class1 = RSString.formatChatString(incomming);
                    player.forcedChatMessage = class1.trim();
                    player.chatTimer = 150;
                    player.chatEffects = chatEffectsAndColors & 0xFF;
                    player.chatcolor = chatEffectsAndColors >> 8;
                    if (playerRights == 2 || playerRights == 3) {
                        ChatBox.addChatMessage(Native.goldCrown + player.playerName, class1, 1);
                    } else if (playerRights == 1) {
                        ChatBox.addChatMessage(Native.whiteCrown + player.playerName, class1, 1);
                    } else {
                        ChatBox.addChatMessage(player.playerName, class1, 2);
                    }
                }
            }
            appearanceBuffer.currentPosition = messageLength + bufferPosition;
        }
        if ((0x20 & mask) != 0) {
            int appearanceUpdateLength = appearanceBuffer.getUnsignedByte();
            byte[] is = new byte[appearanceUpdateLength];
            Buffer buffer = new Buffer(is);
            appearanceBuffer.getBytes(appearanceUpdateLength, 0, is);
            Player.trackedPlayerAppearanceCache[playerIndex] = buffer;
            player.parsePlayerAppearanceData(buffer);
        }
        if ((mask & 0x200) != 0) {
            player.graphicId = appearanceBuffer.getUnsignedShortLE();
            int graphicData = appearanceBuffer.getIntBE();
            player.anInt3129 = 0;
            player.graphicDelay = MovedStatics.pulseCycle + (graphicData & 0xFFFF);
            if (player.graphicId == 65535) {
                player.graphicId = -1;
            }
            player.anInt3140 = 0;
            player.graphicHeight = graphicData >> 16;
            if (player.graphicDelay > MovedStatics.pulseCycle) {
                player.anInt3140 = -1;
            }
        }
        if ((0x80 & mask) != 0) {
            player.forcedChatMessage = appearanceBuffer.getString();
            if (player.forcedChatMessage.charAt(0) == '~') {
                player.forcedChatMessage = player.forcedChatMessage.substring(1);
                ChatBox.addChatMessage(player.playerName, player.forcedChatMessage, 2);
            } else if (player == localPlayer) {
                ChatBox.addChatMessage(player.playerName, player.forcedChatMessage, 2);
            }
            player.chatTimer = 150;
            player.chatcolor = 0;
            player.chatEffects = 0;
        }
    }

    public static void parseTrackedPlayerUpdateMasks(PacketBuffer appearanceBuffer) {
        for (int i = 0; i < actorUpdatingIndex; ++i) {
            int trackedPlayerIndex = actorUpdatingIndices[i];
            Player player = trackedPlayers[trackedPlayerIndex];
            int mask = appearanceBuffer.getUnsignedByte();
            if ((mask & 2) != 0) {
                mask += appearanceBuffer.getUnsignedByte() << 8;
            }
            Player.parsePlayerUpdateMasks(appearanceBuffer, player, mask, trackedPlayerIndex);
        }
    }

    public static void setTutorialIslandFlag() {
        inTutorialIsland = false;
        int xPos = (Player.localPlayer.worldX >> 7) + MovedStatics.baseX;
        int yPos = MovedStatics.baseY + (Player.localPlayer.worldY >> 7);
        if (xPos >= 3053 && xPos <= 3156 && yPos >= 3056 && yPos <= 3136) {
            inTutorialIsland = true;
        }
        if (xPos >= 3072 && xPos <= 3118 && yPos >= 9492 && yPos <= 9535) {
            inTutorialIsland = true;
        }
        if (inTutorialIsland && xPos >= 3139 && xPos <= 3199 && yPos >= 3008 && yPos <= 3062) {
            inTutorialIsland = false;
        }
    }

    public static RSString longToUsername(long arg1) {
        if (arg1 <= 0L || arg1 >= 6582952005840035281L) {
            return null;
        }
        if (arg1 % 37L == 0L) {
            return null;
        }
        long l = arg1;
        int i = 0;
        while (l != 0L) {
            l /= 37L;
            ++i;
        }
        byte[] is = new byte[i];
        while (arg1 != 0L) {
            long l_10_ = arg1;
            is[--i] = aByteArray169[(int)(-((arg1 /= 37L) * 37L) + l_10_)];
        }
        RSString class1 = new RSString();
        class1.chars = is;
        class1.length = is.length;
        return class1;
    }

    public static void processPlayerMenuOptions(Player player, int x, int y, int index) {
        if (localPlayer != player && MovedStatics.menuActionRow < 400) {
            int i;
            String playerDisplayName = player.skillLevel == 0 ? player.playerName + MovedStatics.getCombatLevelColour(Player.localPlayer.combatLevel, player.combatLevel) + Native.leftParenthesisWithSpacePrefix + English.prefixLevel + player.combatLevel + Native.rightParenthesis : player.playerName + Native.leftParenthesisWithSpacePrefix + English.prefixSkill + player.skillLevel + Native.rightParenthesis;
            if (GameInterface.itemCurrentlySelected == 1) {
                MovedStatics.addActionRow(English.use, index, x, y, ActionRowType.USE_ITEM_ON_PLAYER.getId(), Native.selectedItemName + Native.arrowActionOnOther + playerDisplayName);
            } else if (Game.widgetSelected == 1) {
                if ((MovedStatics.selectedMask & 8) == 8) {
                    MovedStatics.addActionRow(Native.selectedSpellVerb, index, x, y, ActionRowType.CAST_MAGIC_ON_PLAYER.getId(), Native.selectedSpellName + Native.arrowActionOnOther + playerDisplayName);
                }
            } else {
                for (i = 4; i >= 0; --i) {
                    if (playerActions[i] == null) continue;
                    int actionType = 0;
                    int actionRowOffset = 0;
                    if (playerActions[i].equalsIgnoreCase(English.attack)) {
                        if (Player.localPlayer.combatLevel < player.combatLevel) {
                            actionRowOffset = 2000;
                        }
                        if (Player.localPlayer.teamId != 0 && player.teamId != 0) {
                            actionRowOffset = Player.localPlayer.teamId != player.teamId ? 0 : 2000;
                        }
                    } else if (playerActionsLowPriority[i]) {
                        actionRowOffset = 2000;
                    }
                    if (i == 0) {
                        actionType = ActionRowType.INTERACT_WITH_PLAYER_OPTION_1.getId() + actionRowOffset;
                    }
                    if (i == 1) {
                        actionType = ActionRowType.INTERACT_WITH_PLAYER_OPTION_2.getId() + actionRowOffset;
                    }
                    if (i == 2) {
                        actionType = ActionRowType.INTERACT_WITH_PLAYER_OPTION_3.getId() + actionRowOffset;
                    }
                    if (i == 3) {
                        actionType = ActionRowType.INTERACT_WITH_PLAYER_OPTION_4.getId() + actionRowOffset;
                    }
                    if (i == 4) {
                        actionType = ActionRowType.INTERACT_WITH_PLAYER_OPTION_5.getId() + actionRowOffset;
                    }
                    MovedStatics.addActionRow(playerActions[i], index, x, y, actionType, Native.white + playerDisplayName);
                }
            }
            for (i = 0; i < MovedStatics.menuActionRow; ++i) {
                if (MovedStatics.menuActionTypes[i] != 7) continue;
                MovedStatics.menuActionTexts[i] = English.walkHere + Native.whitespace + Native.white + playerDisplayName;
                break;
            }
        }
    }

    public static boolean hasFriend(String arg0) {
        if (arg0 == null) {
            return false;
        }
        if (Game.friendList.containsPlayerUsername(arg0)) {
            return true;
        }
        return arg0.equalsIgnoreCase(Player.localPlayer.playerName);
    }

    public static void playAnimation(int animationId, int animationDelay, Player player) {
        if (player.playingAnimation == animationId && animationId != -1) {
            int i = AnimationSequence.getAnimationSequence((int)animationId).replyMode;
            if (i == 1) {
                player.anInt3104 = 0;
                player.anInt3095 = 0;
                player.playingAnimationDelay = animationDelay;
                player.anInt3115 = 0;
            }
            if (i == 2) {
                player.anInt3095 = 0;
            }
        } else if (animationId == -1 || player.playingAnimation == -1 || AnimationSequence.getAnimationSequence((int)animationId).forcedPriority >= AnimationSequence.getAnimationSequence((int)player.playingAnimation).forcedPriority) {
            player.anInt3094 = player.anInt3109;
            player.anInt3104 = 0;
            player.anInt3115 = 0;
            player.anInt3095 = 0;
            player.playingAnimationDelay = animationDelay;
            player.playingAnimation = animationId;
        }
    }

    @Override
    public Model getRotatedModel() {
        Model[] models;
        Model model;
        AnimationSequence animationSequence_0_;
        if (this.playerAppearance == null) {
            return null;
        }
        AnimationSequence animationSequence = this.playingAnimation == -1 || this.playingAnimationDelay != 0 ? null : AnimationSequence.getAnimationSequence(this.playingAnimation);
        Model animatedModel = this.playerAppearance.getAnimatedModel(animationSequence, animationSequence_0_ = this.anInt3077 != -1 && !this.aBoolean3287 && (this.idleAnimation != this.anInt3077 || animationSequence == null) ? AnimationSequence.getAnimationSequence(this.anInt3077) : null, this.anInt3116, this.anInt3104);
        if (animatedModel == null) {
            return null;
        }
        animatedModel.method799();
        this.anInt3117 = animatedModel.modelHeight;
        if (!this.aBoolean3287 && this.graphicId != -1 && this.anInt3140 != -1 && (model = SpotAnimDefinition.forId(this.graphicId).getModel(this.anInt3140)) != null) {
            model.translate(0, -this.graphicHeight, 0);
            models = new Model[]{animatedModel, model};
            animatedModel = new Model(models, 2, true);
        }
        if (!this.aBoolean3287 && this.playerModel != null) {
            if (this.anInt3274 <= MovedStatics.pulseCycle) {
                this.playerModel = null;
            }
            if (this.anInt3283 <= MovedStatics.pulseCycle && MovedStatics.pulseCycle < this.anInt3274) {
                model = this.playerModel;
                model.translate(-this.worldX + this.anInt3271, -this.anInt3276 + this.anInt3272, this.anInt3291 + -this.worldY);
                if (this.initialFaceDirection == 512) {
                    model.method813();
                    model.method813();
                    model.method813();
                } else if (this.initialFaceDirection == 1024) {
                    model.method813();
                    model.method813();
                } else if (this.initialFaceDirection == 1536) {
                    model.method813();
                }
                models = new Model[]{animatedModel, model};
                animatedModel = new Model(models, 2, true);
                if (this.initialFaceDirection != 512) {
                    if (this.initialFaceDirection == 1024) {
                        model.method813();
                        model.method813();
                    } else if (this.initialFaceDirection == 1536) {
                        model.method813();
                        model.method813();
                        model.method813();
                    }
                } else {
                    model.method813();
                }
                model.translate(-this.anInt3271 + this.worldX, -this.anInt3272 + this.anInt3276, this.worldY - this.anInt3291);
            }
        }
        animatedModel.singleTile = true;
        return animatedModel;
    }

    @Override
    public boolean isInitialized() {
        return this.playerAppearance != null;
    }

    public void parsePlayerAppearanceData(Buffer buffer) {
        buffer.currentPosition = 0;
        int i = buffer.getUnsignedByte();
        this.isSkulled = buffer.getByte();
        this.headIcon = buffer.getByte();
        int npcDefId = -1;
        this.teamId = 0;
        int[] appearance = new int[12];
        for (int index = 0; index < 12; ++index) {
            int itemTeam;
            int upperByte = buffer.getUnsignedByte();
            if (upperByte == 0) {
                appearance[index] = 0;
                continue;
            }
            int lowerByte = buffer.getUnsignedByte();
            appearance[index] = (upperByte << 8) + lowerByte;
            if (index == 0 && appearance[0] == 65535) {
                npcDefId = buffer.getUnsignedShortBE();
                break;
            }
            if (appearance[index] < 512 || (itemTeam = ItemDefinition.forId((int)(-512 + appearance[index]), (int)10).teamIndex) == 0) continue;
            this.teamId = itemTeam;
        }
        int[] appearanceColors = new int[5];
        for (int l = 0; l < 5; ++l) {
            int j1 = buffer.getUnsignedByte();
            if (j1 < 0 || PlayerAppearance.playerColours[l].length <= j1) {
                j1 = 0;
            }
            appearanceColors[l] = j1;
        }
        this.idleAnimation = buffer.getUnsignedShortBE();
        if (this.idleAnimation == 65535) {
            this.idleAnimation = -1;
        }
        this.standTurnAnimationId = buffer.getUnsignedShortBE();
        if (this.standTurnAnimationId == 65535) {
            this.standTurnAnimationId = -1;
        }
        this.anInt3083 = this.standTurnAnimationId;
        this.walkAnimationId = buffer.getUnsignedShortBE();
        if (this.walkAnimationId == 65535) {
            this.walkAnimationId = -1;
        }
        this.turnAroundAnimationId = buffer.getUnsignedShortBE();
        if (this.turnAroundAnimationId == 65535) {
            this.turnAroundAnimationId = -1;
        }
        this.turnRightAnimationId = buffer.getUnsignedShortBE();
        if (this.turnRightAnimationId == 65535) {
            this.turnRightAnimationId = -1;
        }
        this.turnLeftAnimationId = buffer.getUnsignedShortBE();
        if (this.turnLeftAnimationId == 65535) {
            this.turnLeftAnimationId = -1;
        }
        this.runAnimationId = buffer.getUnsignedShortBE();
        if (this.runAnimationId == 65535) {
            this.runAnimationId = -1;
        }
        this.playerName = Player.longToUsername(buffer.getLongBE()).method85().toString();
        this.combatLevel = buffer.getUnsignedByte();
        this.skillLevel = buffer.getUnsignedShortBE();
        if (this.playerAppearance == null) {
            this.playerAppearance = new PlayerAppearance();
        }
        this.playerAppearance.setPlayerAppearance(appearance, i == 1, appearanceColors, npcDefId);
    }

    static {
        actorUpdatingIndices = new int[2048];
        trackedPlayerAppearanceCache = new Buffer[2048];
        deregisterActorIndices = new int[1000];
        npcs = new Npc[32768];
        trackedPlayers = new Player[2048];
        npcIds = new int[32768];
        trackedPlayerIndices = new int[2048];
        npcCount = 0;
        localPlayerCount = 0;
        inTutorialIsland = false;
        chatBuffer = new Buffer(new byte[5000]);
        cutsceneActive = false;
        playerExperience = new int[25];
        playerLevels = new int[25];
        nextLevels = new int[25];
        experienceForLevels = new int[99];
        privateMessageIds = new long[100];
        privateMessageIndex = 0;
        friendListStatus = 0;
        worldId = 1;
        activePlayerAppearance = new PlayerAppearance();
        localPlayerId = -1;
        playerActions = new String[5];
        playerActionsLowPriority = new boolean[5];
        aByteArray169 = new byte[]{95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        int i = 0;
        for (int idx = 0; idx < 99; ++idx) {
            int skillLevel = idx + 1;
            int experienceForLevel = (int)((double)skillLevel + 300.0 * Math.pow(2.0, (double)skillLevel / 7.0));
            Player.experienceForLevels[idx] = (i += experienceForLevel) / 4;
        }
    }
}

