/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.media.renderable.actor;

import java.util.ArrayList;
import org.runejs.client.Game;
import org.runejs.client.Landscape;
import org.runejs.client.MovedStatics;
import org.runejs.client.frame.DebugTools;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.message.outbound.WalkOutboundMessage;
import org.runejs.client.net.OutgoingPackets;

public class Pathfinding {
    public static int[][] distanceValues = new int[104][104];
    public static int[][] wayPoints = new int[104][104];
    public static int[] walkingQueueX = new int[4000];
    public static int[] walkingQueueY = new int[4000];
    public static int arbitraryDestination = 0;

    public static boolean doTileWalkTo(int startX, int startY, int endX, int endY) {
        return Pathfinding.doWalkTo(0, startX, startY, endX, endY, 0, 0, 0, 0, 0, true, null);
    }

    public static boolean doMinimapWalkTo(int startX, int startY, int endX, int endY, MinimapWalkAnalytics analytics) {
        return Pathfinding.doWalkTo(1, startX, startY, endX, endY, 0, 0, 0, 0, 0, true, analytics);
    }

    public static boolean doObjectWalkTo(int startX, int startY, int endX, int endY, int sizeX, int sizeY, int surroundingsMask, int type, int orientation) {
        return Pathfinding.doWalkTo(2, startX, startY, endX, endY, sizeX, sizeY, surroundingsMask, type, orientation, true, null);
    }

    public static boolean doEntityWalkTo(int startX, int startY, int endX, int endY, int sizeX, int sizeY) {
        return Pathfinding.doWalkTo(2, startX, startY, endX, endY, sizeX, sizeY, 0, 0, 0, false, null);
    }

    public static boolean doWorldItemWalkTo(int startX, int startY, int endX, int endY) {
        boolean success = Pathfinding.doEntityWalkTo(startX, startY, endX, endY, 0, 0);
        if (success) {
            return true;
        }
        return Pathfinding.doEntityWalkTo(startX, startY, endX, endY, 1, 1);
    }

    public static boolean doWalkTo(int clickType, int startX, int startY, int endX, int endY, int goalDX, int goalDY, int surroundingsMask, int objectType, int objectOrientation, boolean flag, MinimapWalkAnalytics analytics) {
        int initialSkipCheck;
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Pathfinding.wayPoints[x][y] = 0;
                Pathfinding.distanceValues[x][y] = 99999999;
            }
        }
        int currentX = startX;
        int currentY = startY;
        Pathfinding.wayPoints[startX][startY] = 99;
        Pathfinding.distanceValues[startX][startY] = 0;
        int nextIndex = 0;
        int currentIndex = 0;
        Pathfinding.walkingQueueX[nextIndex] = startX;
        Pathfinding.walkingQueueY[nextIndex++] = startY;
        boolean foundDestination = false;
        int maxPathSize = walkingQueueX.length;
        int[][] clippingPaths = Landscape.currentCollisionMap[Player.worldLevel].clippingData;
        while (currentIndex != nextIndex) {
            currentY = walkingQueueY[currentIndex];
            currentX = walkingQueueX[currentIndex];
            currentIndex = (currentIndex + 1) % maxPathSize;
            if (currentX == endX && currentY == endY) {
                foundDestination = true;
                break;
            }
            if (objectType != 0) {
                if (objectType >= 5 && objectType != 10 || !Landscape.currentCollisionMap[Player.worldLevel].reachedWall(currentX, currentY, endX, endY, objectType + -1, objectOrientation)) {
                    if (objectType < 10 && Landscape.currentCollisionMap[Player.worldLevel].reachedWallDecoration(currentX, currentY, endX, endY, -1 + objectType, objectOrientation)) {
                        foundDestination = true;
                        break;
                    }
                } else {
                    foundDestination = true;
                    break;
                }
            }
            if (goalDX != 0 && goalDY != 0 && Landscape.currentCollisionMap[Player.worldLevel].reachedFacingObject(currentX, currentY, endX, endY, goalDX, goalDY, surroundingsMask)) {
                foundDestination = true;
                break;
            }
            int newDistanceValue = distanceValues[currentX][currentY] + 1;
            if (currentX > 0 && wayPoints[-1 + currentX][currentY] == 0 && (0x1280108 & clippingPaths[currentX - 1][currentY]) == 0) {
                Pathfinding.walkingQueueX[nextIndex] = currentX - 1;
                Pathfinding.walkingQueueY[nextIndex] = currentY;
                nextIndex = (1 + nextIndex) % maxPathSize;
                Pathfinding.wayPoints[-1 + currentX][currentY] = 2;
                Pathfinding.distanceValues[currentX - 1][currentY] = newDistanceValue;
            }
            if (currentX < 103 && wayPoints[currentX + 1][currentY] == 0 && (clippingPaths[1 + currentX][currentY] & 0x1280180) == 0) {
                Pathfinding.walkingQueueX[nextIndex] = currentX + 1;
                Pathfinding.walkingQueueY[nextIndex] = currentY;
                nextIndex = (nextIndex + 1) % maxPathSize;
                Pathfinding.wayPoints[currentX + 1][currentY] = 8;
                Pathfinding.distanceValues[currentX + 1][currentY] = newDistanceValue;
            }
            if (currentY > 0 && wayPoints[currentX][currentY - 1] == 0 && (clippingPaths[currentX][-1 + currentY] & 0x1280102) == 0) {
                Pathfinding.walkingQueueX[nextIndex] = currentX;
                Pathfinding.walkingQueueY[nextIndex] = -1 + currentY;
                Pathfinding.wayPoints[currentX][-1 + currentY] = 1;
                nextIndex = (nextIndex + 1) % maxPathSize;
                Pathfinding.distanceValues[currentX][currentY - 1] = newDistanceValue;
            }
            if (currentY < 103 && wayPoints[currentX][currentY + 1] == 0 && (clippingPaths[currentX][currentY + 1] & 0x1280120) == 0) {
                Pathfinding.walkingQueueX[nextIndex] = currentX;
                Pathfinding.walkingQueueY[nextIndex] = 1 + currentY;
                Pathfinding.wayPoints[currentX][currentY + 1] = 4;
                Pathfinding.distanceValues[currentX][1 + currentY] = newDistanceValue;
                nextIndex = (nextIndex + 1) % maxPathSize;
            }
            if (currentX > 0 && currentY > 0 && wayPoints[-1 + currentX][currentY - 1] == 0 && (clippingPaths[currentX - 1][-1 + currentY] & 0x128010E) == 0 && (0x1280108 & clippingPaths[currentX + -1][currentY]) == 0 && (clippingPaths[currentX][-1 + currentY] & 0x1280102) == 0) {
                Pathfinding.walkingQueueX[nextIndex] = -1 + currentX;
                Pathfinding.walkingQueueY[nextIndex] = currentY - 1;
                nextIndex = (nextIndex + 1) % maxPathSize;
                Pathfinding.wayPoints[currentX + -1][-1 + currentY] = 3;
                Pathfinding.distanceValues[-1 + currentX][currentY + -1] = newDistanceValue;
            }
            if (currentX < 103 && currentY > 0 && wayPoints[currentX + 1][-1 + currentY] == 0 && (clippingPaths[1 + currentX][-1 + currentY] & 0x1280183) == 0 && (clippingPaths[currentX + 1][currentY] & 0x1280180) == 0 && (0x1280102 & clippingPaths[currentX][-1 + currentY]) == 0) {
                Pathfinding.walkingQueueX[nextIndex] = 1 + currentX;
                Pathfinding.walkingQueueY[nextIndex] = currentY - 1;
                nextIndex = (nextIndex + 1) % maxPathSize;
                Pathfinding.wayPoints[1 + currentX][-1 + currentY] = 9;
                Pathfinding.distanceValues[currentX + 1][-1 + currentY] = newDistanceValue;
            }
            if (currentX > 0 && currentY < 103 && wayPoints[currentX + -1][currentY + 1] == 0 && (0x1280138 & clippingPaths[-1 + currentX][1 + currentY]) == 0 && (0x1280108 & clippingPaths[currentX - 1][currentY]) == 0 && (clippingPaths[currentX][currentY + 1] & 0x1280120) == 0) {
                Pathfinding.walkingQueueX[nextIndex] = -1 + currentX;
                Pathfinding.walkingQueueY[nextIndex] = 1 + currentY;
                Pathfinding.wayPoints[currentX - 1][1 + currentY] = 6;
                Pathfinding.distanceValues[-1 + currentX][currentY + 1] = newDistanceValue;
                nextIndex = (1 + nextIndex) % maxPathSize;
            }
            if (currentX >= 103 || currentY >= 103 || wayPoints[1 + currentX][1 + currentY] != 0 || (0x12801E0 & clippingPaths[currentX + 1][currentY + 1]) != 0 || (0x1280180 & clippingPaths[1 + currentX][currentY]) != 0 || (clippingPaths[currentX][1 + currentY] & 0x1280120) != 0) continue;
            Pathfinding.walkingQueueX[nextIndex] = 1 + currentX;
            Pathfinding.walkingQueueY[nextIndex] = currentY + 1;
            nextIndex = (nextIndex + 1) % maxPathSize;
            Pathfinding.wayPoints[1 + currentX][1 + currentY] = 12;
            Pathfinding.distanceValues[1 + currentX][1 + currentY] = newDistanceValue;
        }
        arbitraryDestination = 0;
        if (!foundDestination) {
            if (flag) {
                int i_14_ = 1000;
                int deviation = 10;
                int maxStepsNonInclusive = 100;
                for (int deviationX = endX + -deviation; endX + deviation >= deviationX; ++deviationX) {
                    for (int deviationY = -deviation + endY; endY + deviation >= deviationY; ++deviationY) {
                        if (deviationX < 0 || deviationY < 0 || deviationX >= 104 || deviationY >= 104 || distanceValues[deviationX][deviationY] >= 100) continue;
                        int i_19_ = 0;
                        int i_20_ = 0;
                        if (deviationY < endY) {
                            i_19_ = endY - deviationY;
                        } else if (deviationY > endY - (-goalDY + 1)) {
                            i_19_ = deviationY + -goalDY + -endY + 1;
                        }
                        if (deviationX < endX) {
                            i_20_ = -deviationX + endX;
                        } else if (-1 + goalDX + endX < deviationX) {
                            i_20_ = deviationX + -goalDX + -endX + 1;
                        }
                        int i_21_ = i_19_ * i_19_ + i_20_ * i_20_;
                        if (i_14_ <= i_21_ && (i_21_ != i_14_ || distanceValues[deviationX][deviationY] >= maxStepsNonInclusive)) continue;
                        currentY = deviationY;
                        i_14_ = i_21_;
                        currentX = deviationX;
                        maxStepsNonInclusive = distanceValues[deviationX][deviationY];
                    }
                }
                if (i_14_ == 1000) {
                    return false;
                }
                if (startX == currentX && startY == currentY) {
                    return false;
                }
                arbitraryDestination = 1;
            } else {
                return false;
            }
        }
        currentIndex = 0;
        Pathfinding.walkingQueueX[currentIndex] = currentX;
        Pathfinding.walkingQueueY[currentIndex++] = currentY;
        int waypoint = initialSkipCheck = wayPoints[currentX][currentY];
        while (currentX != startX || startY != currentY) {
            if (waypoint != initialSkipCheck) {
                initialSkipCheck = waypoint;
                Pathfinding.walkingQueueX[currentIndex] = currentX;
                Pathfinding.walkingQueueY[currentIndex++] = currentY;
            }
            if ((waypoint & 1) != 0) {
                ++currentY;
            } else if ((waypoint & 4) != 0) {
                --currentY;
            }
            if ((waypoint & 2) != 0) {
                ++currentX;
            } else if ((waypoint & 8) != 0) {
                --currentX;
            }
            waypoint = wayPoints[currentX][currentY];
        }
        if (currentIndex > 0) {
            maxPathSize = currentIndex;
            if (maxPathSize > 25) {
                maxPathSize = 25;
            }
            int x = walkingQueueX[--currentIndex];
            int y = walkingQueueY[currentIndex];
            if (DebugTools.walkpathEnabled) {
                DebugTools.walkpathX = new int[maxPathSize + 1];
                DebugTools.walkpathY = new int[maxPathSize + 1];
                DebugTools.walkpathX[0] = startX;
                DebugTools.walkpathY[0] = startY;
                DebugTools.walkpathX[1] = x;
                DebugTools.walkpathY[1] = y;
            }
            WalkOutboundMessage.WalkType walkType = WalkOutboundMessage.WalkType.TILE;
            if (clickType == 0) {
                walkType = WalkOutboundMessage.WalkType.TILE;
            } else if (clickType == 1) {
                walkType = WalkOutboundMessage.WalkType.MAP;
            } else if (clickType == 2) {
                walkType = WalkOutboundMessage.WalkType.INTERACTION;
            }
            ArrayList<WalkOutboundMessage.WalkStep> steps = new ArrayList<WalkOutboundMessage.WalkStep>();
            for (int counter = 1; maxPathSize > counter; ++counter) {
                int stepX = walkingQueueX[--currentIndex] - x;
                int stepY = walkingQueueY[currentIndex] - y;
                if (DebugTools.walkpathEnabled) {
                    DebugTools.walkpathX[counter + 1] = walkingQueueX[currentIndex];
                    DebugTools.walkpathY[counter + 1] = walkingQueueY[currentIndex];
                }
                steps.add(new WalkOutboundMessage.WalkStep(stepX, stepY));
            }
            OutgoingPackets.sendMessage(new WalkOutboundMessage(walkType, MovedStatics.baseX + x, MovedStatics.baseY + y, MovedStatics.obfuscatedKeyStatus[82], steps.toArray(new WalkOutboundMessage.WalkStep[steps.size()]), analytics));
            MovedStatics.destinationX = walkingQueueX[0];
            Game.destinationY = walkingQueueY[0];
            return true;
        }
        boolean isMapClick = clickType == 1;
        return !isMapClick;
    }

    public static class MinimapWalkAnalytics {
        public final int minimapClickX;
        public final int minimapClickY;
        public final int minimapRandomZoom;
        public final int minimapRandomRotation;
        public final int cameraYaw;
        public final int worldX;
        public final int worldY;
        public final boolean usedDeepSearch;
        public final int magicA;
        public final int magicB;
        public final int magicC;

        public MinimapWalkAnalytics(int minimapClickX, int minimapClickY, int minimapRandomZoom, int minimapRandomRotation, int cameraYaw, int worldX, int worldY, boolean usedDeepSearch, int magicA, int magicB, int magicC) {
            this.minimapClickX = minimapClickX;
            this.minimapClickY = minimapClickY;
            this.minimapRandomZoom = minimapRandomZoom;
            this.minimapRandomRotation = minimapRandomRotation;
            this.cameraYaw = cameraYaw;
            this.worldX = worldX;
            this.worldY = worldY;
            this.usedDeepSearch = usedDeepSearch;
            this.magicA = magicA;
            this.magicB = magicB;
            this.magicC = magicC;
        }
    }
}

