/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.media.renderable;

import org.runejs.client.MovedStatics;
import org.runejs.client.cache.def.GameObjectDefinition;
import org.runejs.client.cache.media.AnimationSequence;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.media.renderable.Renderable;

public class GameObject
extends Renderable {
    public int vertexHeightTopRight;
    public int orientation;
    public int objectType;
    public int animationCycleDelay;
    public int animationFrame;
    public int vertexHeightTop;
    public int vertexHeight;
    public int vertexHeightRight;
    public AnimationSequence animationSequence;
    public int id;

    public GameObject(int objectId, int objectType, int orientation, int arg3, int arg4, int arg5, int arg6, int animationId, boolean arg8) {
        this.vertexHeight = arg3;
        this.id = objectId;
        this.vertexHeightTop = arg6;
        this.orientation = orientation;
        this.vertexHeightRight = arg4;
        this.vertexHeightTopRight = arg5;
        this.objectType = objectType;
        if (animationId != -1) {
            this.animationSequence = AnimationSequence.getAnimationSequence(animationId);
            this.animationFrame = 0;
            this.animationCycleDelay = -1 + MovedStatics.pulseCycle;
            if (arg8 && this.animationSequence.frameStep != -1) {
                this.animationFrame = (int)((double)this.animationSequence.frameIds.length * Math.random());
                this.animationCycleDelay -= (int)(Math.random() * (double)this.animationSequence.frameLengths[this.animationFrame]);
            }
        }
    }

    @Override
    public Model getRotatedModel() {
        if (this.animationSequence != null) {
            int step = -this.animationCycleDelay + MovedStatics.pulseCycle;
            if (step > 100 && this.animationSequence.frameStep > 0) {
                step = 100;
            }
            while (this.animationSequence.frameLengths[this.animationFrame] < step) {
                step -= this.animationSequence.frameLengths[this.animationFrame];
                ++this.animationFrame;
                if (this.animationSequence.frameIds.length > this.animationFrame) continue;
                this.animationFrame -= this.animationSequence.frameStep;
                if (this.animationFrame >= 0 && this.animationSequence.frameIds.length > this.animationFrame) continue;
                this.animationSequence = null;
                break;
            }
            this.animationCycleDelay = MovedStatics.pulseCycle - step;
        }
        GameObjectDefinition gameObjectDefinition = GameObjectDefinition.getDefinition(this.id);
        if (gameObjectDefinition.childIds != null) {
            gameObjectDefinition = gameObjectDefinition.getChildDefinition();
        }
        if (gameObjectDefinition == null) {
            return null;
        }
        return gameObjectDefinition.createAnimatedObjectModel(this.vertexHeight, this.vertexHeightRight, this.animationFrame, this.objectType, this.orientation, this.animationSequence, this.vertexHeightTop, this.vertexHeightTopRight);
    }
}

