/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.media;

import org.runejs.client.ProducingGraphicsBuffer;
import org.runejs.client.media.Rasterizer3D;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.node.CachedNode;

public class RasterizerInstanced
extends CachedNode {
    public int[] destinationPixels;
    public int viewportTop = 0;
    public int destinationWidth;
    public int destinationHeight;
    public int viewportBottom = 0;
    public int viewportLeft = 0;
    public int viewportRight = 0;
    public int viewportRightX = 0;
    public int viewportCenterX = 0;
    public int viewportCenterY = 0;
    private static final int[] tmpX = new int[64];
    private static final int[] tmpY = new int[64];

    public RasterizerInstanced(int[] pixels, int width, int height) {
        this.destinationPixels = pixels;
        this.destinationWidth = width;
        this.destinationHeight = height;
        this.setBounds(0, 0, height, width);
    }

    public RasterizerInstanced(ProducingGraphicsBuffer producingGraphicsBuffer) {
        this.destinationPixels = producingGraphicsBuffer.pixels;
        this.destinationWidth = producingGraphicsBuffer.width;
        this.destinationHeight = producingGraphicsBuffer.height;
        this.setBounds(0, 0, producingGraphicsBuffer.height, producingGraphicsBuffer.width);
    }

    public void prepare(int[] pixels, int width, int height) {
        this.destinationPixels = pixels;
        this.destinationWidth = width;
        this.destinationHeight = height;
        this.setBounds(0, 0, height, width);
    }

    public void resetBounds() {
        this.viewportLeft = 0;
        this.viewportTop = 0;
        this.viewportRight = this.destinationWidth;
        this.viewportBottom = this.destinationHeight;
        this.viewportRightX = this.viewportRight - 1;
        this.viewportCenterX = this.viewportRight / 2;
        this.viewportCenterY = this.viewportBottom / 2;
    }

    public void setBounds(int x0, int y0, int y1, int x1) {
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 > this.destinationWidth) {
            x1 = this.destinationWidth;
        }
        if (y1 > this.destinationHeight) {
            y1 = this.destinationHeight;
        }
        this.viewportLeft = x0;
        this.viewportTop = y0;
        this.viewportRight = x1;
        this.viewportBottom = y1;
        this.viewportRightX = this.viewportRight - 1;
        this.viewportCenterX = this.viewportRight / 2;
        this.viewportCenterY = this.viewportBottom / 2;
    }

    public void resetPixels() {
        int pixelCount = this.destinationWidth * this.destinationHeight;
        for (int pixel = 0; pixel < pixelCount; ++pixel) {
            this.destinationPixels[pixel] = 0;
        }
    }

    public void fillOval(int x, int y, int w, int h, int rgb, int segments) {
        int i;
        int cx = x + w / 2;
        int cy = y + h / 2;
        for (i = 0; i < segments; ++i) {
            int angle = (i << 11) / segments;
            RasterizerInstanced.tmpX[i] = x + (w * Model.COSINE[angle] >> 16);
            RasterizerInstanced.tmpY[i] = y + (h * Model.SINE[angle] >> 16);
        }
        for (i = 1; i < segments; ++i) {
            x = tmpX[i - 1];
            y = tmpY[i - 1];
            int x1 = tmpX[i];
            int y1 = tmpY[i];
            Rasterizer3D.drawFlatTriangle(cx, cy, x, y, x1, y1, rgb);
        }
    }

    public void drawUnfilledRectangleAlpha(int x, int y, int width, int height, int colour, int alpha) {
        this.drawHorizontalLineAlpha(x, y, width, colour, alpha);
        this.drawHorizontalLineAlpha(x, y + height - 1, width, colour, alpha);
        if (height >= 3) {
            this.drawVerticalLineAlpha(x, y + 1, height - 2, colour, alpha);
            this.drawVerticalLineAlpha(x + width - 1, y + 1, height - 2, colour, alpha);
        }
    }

    public void drawFilledRectangle(int x, int y, int width, int height, int colour) {
        if (x < this.viewportLeft) {
            width -= this.viewportLeft - x;
            x = this.viewportLeft;
        }
        if (y < this.viewportTop) {
            height -= this.viewportTop - y;
            y = this.viewportTop;
        }
        if (x + width > this.viewportRight) {
            width = this.viewportRight - x;
        }
        if (y + height > this.viewportBottom) {
            height = this.viewportBottom - y;
        }
        int pixelOffset = this.destinationWidth - width;
        int pixel = x + y * this.destinationWidth;
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            for (int widthCounter = -width; widthCounter < 0; ++widthCounter) {
                this.destinationPixels[pixel++] = colour;
            }
            pixel += pixelOffset;
        }
    }

    public void method657(int[] arg0) {
        this.viewportLeft = arg0[0];
        this.viewportTop = arg0[1];
        this.viewportRight = arg0[2];
        this.viewportBottom = arg0[3];
    }

    public void copyPixels(int[] pixels, int width, int height, int paintX, int paintY) {
        int sourcePixel = 0;
        if (paintX < this.viewportLeft) {
            width -= this.viewportLeft - paintX;
            paintX = this.viewportLeft;
        }
        if (paintY < this.viewportTop) {
            height -= this.viewportTop - paintY;
            paintY = this.viewportTop;
        }
        if (paintX + width > this.viewportRight) {
            width = this.viewportRight - paintX;
        }
        if (paintY + height > this.viewportBottom) {
            height = this.viewportBottom - paintY;
        }
        int pixelOffset = this.destinationWidth - width;
        int pixel = paintX + paintY * this.destinationWidth;
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            for (int widthCounter = -width; widthCounter < 0; ++widthCounter) {
                this.destinationPixels[pixel++] = pixels[sourcePixel++];
            }
            pixel += pixelOffset;
        }
    }

    public void copyPixelsCutOff(int[] pixels, int srcWidth, int srcHeight, int paintX, int paintY, int drawWidth, int drawHeight, int offsetX, int offsetY) {
        int sourcePixel = offsetX + offsetY * srcWidth;
        if (paintX < this.viewportLeft) {
            drawWidth -= this.viewportLeft - paintX;
            paintX = this.viewportLeft;
        }
        if (paintY < this.viewportTop) {
            drawHeight -= this.viewportTop - paintY;
            paintY = this.viewportTop;
        }
        if (paintX + drawWidth > this.viewportRight) {
            drawWidth = this.viewportRight - paintX;
        }
        if (paintY + drawHeight > this.viewportBottom) {
            drawHeight = this.viewportBottom - paintY;
        }
        int pixelOffset = this.destinationWidth - drawWidth;
        int pixel = paintX + paintY * this.destinationWidth;
        for (int heightCounter = -drawHeight; heightCounter < 0; ++heightCounter) {
            for (int widthCounter = -drawWidth; widthCounter < 0; ++widthCounter) {
                this.destinationPixels[pixel++] = pixels[sourcePixel++];
            }
            pixel += pixelOffset;
            sourcePixel += srcWidth - drawWidth;
        }
    }

    private void drawPixel(int x, int y, int color) {
        if (x >= this.viewportLeft && y >= this.viewportTop && x < this.viewportRight && y < this.viewportBottom) {
            this.destinationPixels[x + y * this.destinationWidth] = color;
        }
    }

    public void drawCircle(int x, int y, int radius, int color) {
        if (radius == 0) {
            this.drawPixel(x, y, color);
        } else {
            int var15;
            int var14;
            int var13;
            int var12;
            int var5;
            int var4;
            if (radius < 0) {
                radius = -radius;
            }
            if ((var4 = y - radius) < this.viewportTop) {
                var4 = this.viewportTop;
            }
            if ((var5 = y + radius + 1) > this.viewportBottom) {
                var5 = this.viewportBottom;
            }
            int var6 = var4;
            int var7 = radius * radius;
            int var8 = 0;
            int var9 = y - var4;
            int var10 = var9 * var9;
            int var11 = var10 - var9;
            if (y > var5) {
                y = var5;
            }
            while (var6 < y) {
                while (var11 <= var7 || var10 <= var7) {
                    var10 += var8 + var8;
                    var11 += var8++ + var8;
                }
                var12 = x - var8 + 1;
                if (var12 < this.viewportLeft) {
                    var12 = this.viewportLeft;
                }
                if ((var13 = x + var8) > this.viewportRight) {
                    var13 = this.viewportRight;
                }
                var14 = var12 + var6 * this.destinationWidth;
                for (var15 = var12; var15 < var13; ++var15) {
                    this.destinationPixels[var14++] = color;
                }
                ++var6;
                var10 -= var9-- + var9;
                var11 -= var9 + var9;
            }
            var8 = radius;
            var9 = var6 - y;
            var11 = var9 * var9 + var7;
            var10 = var11 - radius;
            var11 -= var9;
            while (var6 < var5) {
                while (var11 > var7 && var10 > var7) {
                    var11 -= var8-- + var8;
                    var10 -= var8 + var8;
                }
                var12 = x - var8;
                if (var12 < this.viewportLeft) {
                    var12 = this.viewportLeft;
                }
                if ((var13 = x + var8) > this.viewportRight - 1) {
                    var13 = this.viewportRight - 1;
                }
                var14 = var12 + var6 * this.destinationWidth;
                for (var15 = var12; var15 <= var13; ++var15) {
                    this.destinationPixels[var14++] = color;
                }
                ++var6;
                var11 += var9 + var9;
                var10 += var9++ + var9;
            }
        }
    }

    public void drawCircleAlpha(int x, int y, int radius, int color, int alpha) {
        if (alpha != 0) {
            if (alpha == 256) {
                this.drawCircle(x, y, radius, color);
            } else {
                int var24;
                int var11;
                int var10;
                int var9;
                int var23;
                int var22;
                int var21;
                int var20;
                int bottomY;
                if (radius < 0) {
                    radius = -radius;
                }
                int a = 256 - alpha;
                int r = (color >> 16 & 0xFF) * alpha;
                int g = (color >> 8 & 0xFF) * alpha;
                int b = (color & 0xFF) * alpha;
                int topY = y - radius;
                if (topY < this.viewportTop) {
                    topY = this.viewportTop;
                }
                if ((bottomY = y + radius + 1) > this.viewportBottom) {
                    bottomY = this.viewportBottom;
                }
                int var14 = topY;
                int var15 = radius * radius;
                int var16 = 0;
                int var17 = y - topY;
                int var18 = var17 * var17;
                int var19 = var18 - var17;
                if (y > bottomY) {
                    y = bottomY;
                }
                while (var14 < y) {
                    while (var19 <= var15 || var18 <= var15) {
                        var18 += var16 + var16;
                        var19 += var16++ + var16;
                    }
                    var20 = x - var16 + 1;
                    if (var20 < this.viewportLeft) {
                        var20 = this.viewportLeft;
                    }
                    if ((var21 = x + var16) > this.viewportRight) {
                        var21 = this.viewportRight;
                    }
                    var22 = var20 + var14 * this.destinationWidth;
                    for (var23 = var20; var23 < var21; ++var23) {
                        var9 = (this.destinationPixels[var22] >> 16 & 0xFF) * a;
                        var10 = (this.destinationPixels[var22] >> 8 & 0xFF) * a;
                        var11 = (this.destinationPixels[var22] & 0xFF) * a;
                        var24 = (r + var9 >> 8 << 16) + (g + var10 >> 8 << 8) + (b + var11 >> 8);
                        this.destinationPixels[var22++] = var24;
                    }
                    ++var14;
                    var18 -= var17-- + var17;
                    var19 -= var17 + var17;
                }
                var16 = radius;
                var17 = -var17;
                var19 = var17 * var17 + var15;
                var18 = var19 - radius;
                var19 -= var17;
                while (var14 < bottomY) {
                    while (var19 > var15 && var18 > var15) {
                        var19 -= var16-- + var16;
                        var18 -= var16 + var16;
                    }
                    var20 = x - var16;
                    if (var20 < this.viewportLeft) {
                        var20 = this.viewportLeft;
                    }
                    if ((var21 = x + var16) > this.viewportRight - 1) {
                        var21 = this.viewportRight - 1;
                    }
                    var22 = var20 + var14 * this.destinationWidth;
                    for (var23 = var20; var23 <= var21; ++var23) {
                        var9 = (this.destinationPixels[var22] >> 16 & 0xFF) * a;
                        var10 = (this.destinationPixels[var22] >> 8 & 0xFF) * a;
                        var11 = (this.destinationPixels[var22] & 0xFF) * a;
                        var24 = (r + var9 >> 8 << 16) + (g + var10 >> 8 << 8) + (b + var11 >> 8);
                        this.destinationPixels[var22++] = var24;
                    }
                    ++var14;
                    var19 += var17 + var17;
                    var18 += var17++ + var17;
                }
            }
        }
    }

    public void method661(int[] arg0) {
        arg0[0] = this.viewportLeft;
        arg0[1] = this.viewportTop;
        arg0[2] = this.viewportRight;
        arg0[3] = this.viewportBottom;
    }

    public void drawHorizontalLineAlpha(int x, int y, int length, int arg3, int alpha) {
        if (y < this.viewportTop || y >= this.viewportBottom) {
            return;
        }
        if (x < this.viewportLeft) {
            length -= this.viewportLeft - x;
            x = this.viewportLeft;
        }
        if (x + length > this.viewportRight) {
            length = this.viewportRight - x;
        }
        int a = 256 - alpha;
        int r = (arg3 >> 16 & 0xFF) * alpha;
        int g = (arg3 >> 8 & 0xFF) * alpha;
        int b = (arg3 & 0xFF) * alpha;
        int pixelOffset = x + y * this.destinationWidth;
        for (int lengthCounter = 0; lengthCounter < length; ++lengthCounter) {
            int red = (this.destinationPixels[pixelOffset] >> 16 & 0xFF) * a;
            int green = (this.destinationPixels[pixelOffset] >> 8 & 0xFF) * a;
            int blue = (this.destinationPixels[pixelOffset] & 0xFF) * a;
            int rgba = (r + red >> 8 << 16) + (g + green >> 8 << 8) + (b + blue >> 8);
            this.destinationPixels[pixelOffset++] = rgba;
        }
    }

    public void drawHorizontalLine(int x, int y, int length, int colour) {
        if (y < this.viewportTop || y >= this.viewportBottom) {
            return;
        }
        if (x < this.viewportLeft) {
            length -= this.viewportLeft - x;
            x = this.viewportLeft;
        }
        if (x + length > this.viewportRight) {
            length = this.viewportRight - x;
        }
        int pixelOffset = x + y * this.destinationWidth;
        for (int pixel = 0; pixel < length; ++pixel) {
            this.destinationPixels[pixelOffset + pixel] = colour;
        }
    }

    public void drawVerticalLineAlpha(int x, int y, int length, int colour, int alpha) {
        if (x < this.viewportLeft || x >= this.viewportRight) {
            return;
        }
        if (y < this.viewportTop) {
            length -= this.viewportTop - y;
            y = this.viewportTop;
        }
        if (y + length > this.viewportBottom) {
            length = this.viewportBottom - y;
        }
        int a = 256 - alpha;
        int r = (colour >> 16 & 0xFF) * alpha;
        int g = (colour >> 8 & 0xFF) * alpha;
        int b = (colour & 0xFF) * alpha;
        int pixelOffset = x + y * this.destinationWidth;
        for (int lengthCounter = 0; lengthCounter < length; ++lengthCounter) {
            int rgba;
            int red = (this.destinationPixels[pixelOffset] >> 16 & 0xFF) * a;
            int green = (this.destinationPixels[pixelOffset] >> 8 & 0xFF) * a;
            int blue = (this.destinationPixels[pixelOffset] & 0xFF) * a;
            this.destinationPixels[pixelOffset] = rgba = (r + red >> 8 << 16) + (g + green >> 8 << 8) + (b + blue >> 8);
            pixelOffset += this.destinationWidth;
        }
    }

    public void drawFilledRectangleAlpha(int x, int y, int width, int height, int colour, int alpha) {
        if (x < this.viewportLeft) {
            width -= this.viewportLeft - x;
            x = this.viewportLeft;
        }
        if (y < this.viewportTop) {
            height -= this.viewportTop - y;
            y = this.viewportTop;
        }
        if (x + width > this.viewportRight) {
            width = this.viewportRight - x;
        }
        if (y + height > this.viewportBottom) {
            height = this.viewportBottom - y;
        }
        int a = 256 - alpha;
        int r = (colour >> 16 & 0xFF) * alpha;
        int g = (colour >> 8 & 0xFF) * alpha;
        int b = (colour & 0xFF) * alpha;
        int widthOffset = this.destinationWidth - width;
        int pixel = x + y * this.destinationWidth;
        for (int heightCounter = 0; heightCounter < height; ++heightCounter) {
            for (int widthCounter = -width; widthCounter < 0; ++widthCounter) {
                int red = (this.destinationPixels[pixel] >> 16 & 0xFF) * a;
                int green = (this.destinationPixels[pixel] >> 8 & 0xFF) * a;
                int blue = (this.destinationPixels[pixel] & 0xFF) * a;
                int rgba = (r + red >> 8 << 16) + (g + green >> 8 << 8) + (b + blue >> 8);
                this.destinationPixels[pixel++] = rgba;
            }
            pixel += widthOffset;
        }
    }

    public void drawUnfilledRectangle(int x, int y, int width, int height, int colour) {
        this.drawHorizontalLine(x, y, width, colour);
        this.drawHorizontalLine(x, y + height - 1, width, colour);
        this.drawVerticalLine(x, y, height, colour);
        this.drawVerticalLine(x + width - 1, y, height, colour);
    }

    public void drawDiagonalLine(int x, int y, int destX, int destY, int colour) {
        destX -= x;
        if ((destY -= y) == 0) {
            if (destX >= 0) {
                this.drawHorizontalLine(x, y, destX + 1, colour);
            } else {
                this.drawHorizontalLine(x + destX, y, -destX + 1, colour);
            }
        } else if (destX == 0) {
            if (destY >= 0) {
                this.drawVerticalLine(x, y, destY + 1, colour);
            } else {
                this.drawVerticalLine(x, y + destY, -destY + 1, colour);
            }
        } else {
            if (destX + destY < 0) {
                x += destX;
                destX = -destX;
                y += destY;
                destY = -destY;
            }
            if (destX > destY) {
                y <<= 16;
                y += 32768;
                int i = (int)Math.floor((double)(destY <<= 16) / (double)destX + 0.5);
                destX += x;
                if (x < this.viewportLeft) {
                    y += i * (this.viewportLeft - x);
                    x = this.viewportLeft;
                }
                if (destX >= this.viewportRight) {
                    destX = this.viewportRight - 1;
                }
                while (x <= destX) {
                    int i_34_ = y >> 16;
                    if (i_34_ >= this.viewportTop && i_34_ < this.viewportBottom) {
                        this.destinationPixels[x + i_34_ * this.destinationWidth] = colour;
                    }
                    y += i;
                    ++x;
                }
            } else {
                x <<= 16;
                x += 32768;
                int i = (int)Math.floor((double)(destX <<= 16) / (double)destY + 0.5);
                destY += y;
                if (y < this.viewportTop) {
                    x += i * (this.viewportTop - y);
                    y = this.viewportTop;
                }
                if (destY >= this.viewportBottom) {
                    destY = this.viewportBottom - 1;
                }
                while (y <= destY) {
                    int i_35_ = x >> 16;
                    if (i_35_ >= this.viewportLeft && i_35_ < this.viewportRight) {
                        this.destinationPixels[i_35_ + y * this.destinationWidth] = colour;
                    }
                    x += i;
                    ++y;
                }
            }
        }
    }

    public void drawVerticalLine(int x, int y, int length, int colour) {
        if (x < this.viewportLeft || x >= this.viewportRight) {
            return;
        }
        if (y < this.viewportTop) {
            length -= this.viewportTop - y;
            y = this.viewportTop;
        }
        if (y + length > this.viewportBottom) {
            length = this.viewportBottom - y;
        }
        int pixelOffset = x + y * this.destinationWidth;
        for (int pixel = 0; pixel < length; ++pixel) {
            this.destinationPixels[pixelOffset + pixel * this.destinationWidth] = colour;
        }
    }
}

