/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.login;

import java.io.IOException;
import java.net.Socket;
import org.runejs.Configuration;
import org.runejs.client.Game;
import org.runejs.client.GameSocket;
import org.runejs.client.LoginScreen;
import org.runejs.client.MovedStatics;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.io.Buffer;
import org.runejs.client.language.English;
import org.runejs.client.language.Native;
import org.runejs.client.login.LoginProtocol;
import org.runejs.client.login.LoginRequest;
import org.runejs.client.login.LoginType;
import org.runejs.client.media.VertexNormal;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.message.handler.MessageHandler;
import org.runejs.client.net.IncomingPackets;
import org.runejs.client.net.OutgoingPackets;
import org.runejs.client.net.codec.MessageDecoder;
import org.runejs.client.util.RSAConfiguration;
import org.runejs.client.util.SignlinkNode;
import org.runejs.client.util.TextUtils;

public class RS435LoginProtocol
implements LoginProtocol {
    private Stage stage = Stage.DESTROY;
    private int unsuccessfulAttemptCount = 0;
    private long serverISAACKeys = 0L;
    private int timeUntilProfileTransfer = 0;
    private int portChangeAttemptCount = 0;
    private int postLoginPacketOpcode;
    private int postLoginPacketSize;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process() {
        try {
            block26: {
                block27: {
                    int responseCode;
                    if (this.stage == Stage.DESTROY) {
                        if (MovedStatics.gameServerSocket != null) {
                            MovedStatics.gameServerSocket.kill();
                            MovedStatics.gameServerSocket = null;
                        }
                        Game.aBoolean871 = false;
                        this.stage = Stage.CONNECT;
                        this.unsuccessfulAttemptCount = 0;
                        MovedStatics.gameServerSignlinkNode = null;
                    }
                    if (this.stage == Stage.CONNECT) {
                        if (MovedStatics.gameServerSignlinkNode == null) {
                            MovedStatics.gameServerSignlinkNode = Game.signlink.putSocketNode(Game.currentPort);
                        }
                        if (MovedStatics.gameServerSignlinkNode.status == SignlinkNode.Status.ERRORED) {
                            throw new IOException();
                        }
                        if (MovedStatics.gameServerSignlinkNode.status == SignlinkNode.Status.INITIALIZED) {
                            MovedStatics.gameServerSocket = new GameSocket((Socket)MovedStatics.gameServerSignlinkNode.value, Game.signlink);
                            this.stage = Stage.HANDSHAKE;
                            MovedStatics.gameServerSignlinkNode = null;
                        }
                    }
                    if (this.stage == Stage.HANDSHAKE) {
                        this.sendLoginHandshake();
                    }
                    if (this.stage == Stage.HANDSHAKE_RESPONSE) {
                        responseCode = MovedStatics.gameServerSocket.read();
                        if (responseCode != 0) {
                            LoginScreen.displayMessageForResponseCode(responseCode);
                            return;
                        }
                        IncomingPackets.incomingPacketBuffer.currentPosition = 0;
                        this.stage = Stage.SERVER_KEYS;
                    }
                    if (this.stage == Stage.SERVER_KEYS) {
                        this.receiveServerISAACKeys();
                    }
                    if (this.stage == Stage.LOGIN_REQUEST) {
                        this.sendLoginRequest();
                    }
                    if (this.stage != Stage.LOGIN_RESPONSE || MovedStatics.gameServerSocket.inputStreamAvailable() <= 0) break block26;
                    responseCode = MovedStatics.gameServerSocket.read();
                    if (responseCode == 21 && Game.gameStatusCode == 20) break block27;
                    if (responseCode == 2) {
                        this.stage = Stage.LOGIN_ACCEPTED;
                        break block26;
                    } else {
                        if (responseCode == 15 && Game.gameStatusCode == 40) {
                            MovedStatics.method434();
                            return;
                        }
                        if (responseCode == 23 && this.portChangeAttemptCount < 1) {
                            ++this.portChangeAttemptCount;
                            this.stage = Stage.DESTROY;
                            break block26;
                        } else {
                            LoginScreen.displayMessageForResponseCode(responseCode);
                            return;
                        }
                    }
                }
                this.stage = Stage.PROFILE_BEING_TRANSFERRED;
            }
            if (this.stage == Stage.PROFILE_BEING_TRANSFERRED && MovedStatics.gameServerSocket.inputStreamAvailable() > 0) {
                this.timeUntilProfileTransfer = 180 + MovedStatics.gameServerSocket.read() * 60;
                this.stage = Stage.WAIT_FOR_PROFILE_TRANSFER;
            }
            if (this.stage == Stage.WAIT_FOR_PROFILE_TRANSFER) {
                this.unsuccessfulAttemptCount = 0;
                LoginScreen.setLoginScreenMessage(English.youHaveJustLeftAnotherWorld, English.yourProfileWillBeTransferredIn, this.timeUntilProfileTransfer / 60 + English.suffixSeconds);
                if (--this.timeUntilProfileTransfer > 0) return;
                this.stage = Stage.DESTROY;
                return;
            }
            if (this.stage == Stage.LOGIN_ACCEPTED && MovedStatics.gameServerSocket.inputStreamAvailable() >= 8) {
                Configuration.USERNAME = Native.username.toString();
                Configuration.PASSWORD = Native.password.toString();
                Game.playerRights = MovedStatics.gameServerSocket.read();
                Game.accountFlagged = MovedStatics.gameServerSocket.read() == 1;
                Player.localPlayerId = MovedStatics.gameServerSocket.read();
                Player.localPlayerId <<= 8;
                Player.localPlayerId += MovedStatics.gameServerSocket.read();
                MovedStatics.isLocalPlayerMember = MovedStatics.gameServerSocket.read();
                MovedStatics.gameServerSocket.readDataToBuffer(IncomingPackets.incomingPacketBuffer.buffer, 0, 1);
                IncomingPackets.incomingPacketBuffer.currentPosition = 0;
                this.postLoginPacketOpcode = IncomingPackets.incomingPacketBuffer.getPacket();
                MovedStatics.gameServerSocket.readDataToBuffer(IncomingPackets.incomingPacketBuffer.buffer, 0, 2);
                IncomingPackets.incomingPacketBuffer.currentPosition = 0;
                this.postLoginPacketSize = IncomingPackets.incomingPacketBuffer.getUnsignedShortBE();
                this.stage = Stage.LOGIN_ACCEPTED_BODY;
            }
            if (this.stage == Stage.LOGIN_ACCEPTED_BODY) {
                if (MovedStatics.gameServerSocket.inputStreamAvailable() < this.postLoginPacketSize) return;
                IncomingPackets.incomingPacketBuffer.currentPosition = 0;
                MovedStatics.gameServerSocket.readDataToBuffer(IncomingPackets.incomingPacketBuffer.buffer, 0, this.postLoginPacketSize);
                Game.setConfigToDefaults();
                MovedStatics.regionX = -1;
                MessageDecoder<?> decoder = Game.packetCodec.getMessageDecoder(this.postLoginPacketOpcode);
                if (decoder == null) {
                    throw new RuntimeException("No MessageDecoder for post-login opcode: " + this.postLoginPacketOpcode);
                }
                Object message = decoder.decode(IncomingPackets.incomingPacketBuffer);
                MessageHandler<?> handler = Game.handlerRegistry.getMessageHandler(message.getClass());
                if (handler == null) {
                    throw new RuntimeException("No handler for message: " + message.getClass().getName());
                }
                handler.handle(message);
                return;
            }
            ++this.unsuccessfulAttemptCount;
            if (this.unsuccessfulAttemptCount <= 2000) return;
            if (this.portChangeAttemptCount >= 1) {
                LoginScreen.displayMessageForResponseCode(-3);
                return;
            }
            ++this.portChangeAttemptCount;
            Game.currentPort = Game.gameServerPort == Game.currentPort ? Game.someOtherPort : Game.gameServerPort;
            this.stage = Stage.DESTROY;
            return;
        }
        catch (IOException ioexception) {
            if (this.portChangeAttemptCount < 1) {
                Game.currentPort = Game.currentPort == Game.gameServerPort ? Game.someOtherPort : Game.gameServerPort;
                ++this.portChangeAttemptCount;
                this.stage = Stage.DESTROY;
                return;
            }
            LoginScreen.displayMessageForResponseCode(-2);
        }
    }

    private void sendLoginRequest() throws IOException {
        int[] seeds = new int[]{(int)(Math.random() * 9.9999999E7), (int)(Math.random() * 9.9999999E7), (int)(this.serverISAACKeys >> 32), (int)this.serverISAACKeys};
        LoginType connectionType = Game.gameStatusCode == 40 ? LoginType.RECONNECTION : LoginType.NEW_CONNECTION;
        RSAConfiguration rsa = Configuration.RSA_ENABLED ? new RSAConfiguration(Configuration.RSA_MODULUS, Configuration.RSA_PUBLIC_KEY) : null;
        int[] crcs = new int[13];
        int crcIndex = 0;
        crcs[crcIndex++] = CacheArchive.skeletonCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.skinDefinitionCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.gameDefinitionsCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.gameInterfaceCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.soundEffectCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.gameWorldMapCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.musicCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.modelCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.gameImageCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.gameTextureCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.huffmanCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.jingleCacheArchive.crc8;
        crcs[crcIndex++] = CacheArchive.clientScriptCacheArchive.crc8;
        Buffer loginPacket = this.encodeRequest(new LoginRequest(connectionType, seeds, Game.signlink.uid, Native.username, Native.password, rsa, 435, VertexNormal.lowMemory, crcs));
        MovedStatics.gameServerSocket.sendDataFromBuffer(loginPacket.currentPosition, 0, loginPacket.buffer);
        OutgoingPackets.buffer.initOutCipher(seeds);
        OutgoingPackets.init(OutgoingPackets.buffer.outCipher);
        int i = 0;
        while (i < 4) {
            int n = i++;
            seeds[n] = seeds[n] + 50;
        }
        IncomingPackets.incomingPacketBuffer.initInCipher(seeds);
        this.stage = Stage.LOGIN_RESPONSE;
    }

    private void sendLoginHandshake() throws IOException {
        long l = MovedStatics.localUsernameId = TextUtils.nameToLong(Native.username.toString());
        OutgoingPackets.buffer.currentPosition = 0;
        OutgoingPackets.buffer.putByte(14);
        int i = (int)(0x1FL & l >> 16);
        OutgoingPackets.buffer.putByte(i);
        MovedStatics.gameServerSocket.sendDataFromBuffer(2, 0, OutgoingPackets.buffer.buffer);
        this.stage = Stage.HANDSHAKE_RESPONSE;
        IncomingPackets.incomingPacketBuffer.currentPosition = 0;
    }

    private void receiveServerISAACKeys() throws IOException {
        if (IncomingPackets.incomingPacketBuffer.currentPosition < 8) {
            int i = MovedStatics.gameServerSocket.inputStreamAvailable();
            if (i > 8 - IncomingPackets.incomingPacketBuffer.currentPosition) {
                i = 8 - IncomingPackets.incomingPacketBuffer.currentPosition;
            }
            if (i > 0) {
                MovedStatics.gameServerSocket.readDataToBuffer(IncomingPackets.incomingPacketBuffer.buffer, IncomingPackets.incomingPacketBuffer.currentPosition, i);
                IncomingPackets.incomingPacketBuffer.currentPosition += i;
            }
        }
        if (IncomingPackets.incomingPacketBuffer.currentPosition == 8) {
            IncomingPackets.incomingPacketBuffer.currentPosition = 0;
            this.serverISAACKeys = IncomingPackets.incomingPacketBuffer.getLongBE();
            this.stage = Stage.LOGIN_REQUEST;
        }
    }

    @Override
    public void reset() {
        this.stage = Stage.DESTROY;
        this.unsuccessfulAttemptCount = 0;
        this.portChangeAttemptCount = 0;
    }

    private Buffer encodeRequest(LoginRequest request) {
        Buffer buffer = new Buffer(200);
        if (request.type == LoginType.RECONNECTION) {
            buffer.putByte(18);
        } else if (request.type == LoginType.NEW_CONNECTION) {
            buffer.putByte(16);
        } else {
            throw new RuntimeException("Unrecognised connection type");
        }
        Buffer encryptedLoginBuffer = this.getEncryptedLoginBuffer(request);
        buffer.putByte(57 + encryptedLoginBuffer.currentPosition);
        buffer.putIntBE(request.clientVersion);
        buffer.putByte(request.lowMemory ? 1 : 0);
        if (request.crcs.length != 13) {
            throw new RuntimeException("Unexpected CRC collection length of " + request.crcs.length + ", expected 13");
        }
        for (int i = 0; i < request.crcs.length; ++i) {
            buffer.putIntBE(request.crcs[i]);
        }
        buffer.putBytes(0, encryptedLoginBuffer.currentPosition, encryptedLoginBuffer.buffer);
        return buffer;
    }

    private Buffer getEncryptedLoginBuffer(LoginRequest message) {
        Buffer buffer = new Buffer(140);
        buffer.putByte(10);
        buffer.putIntBE(message.seeds[0]);
        buffer.putIntBE(message.seeds[1]);
        buffer.putIntBE(message.seeds[2]);
        buffer.putIntBE(message.seeds[3]);
        buffer.putIntBE(message.uid);
        buffer.putLongBE(TextUtils.nameToLong(message.username.toString()));
        buffer.method505(message.password);
        if (message.rsa != null) {
            buffer.applyRSA(message.rsa.modulus, message.rsa.publicKey);
        }
        return buffer;
    }

    static enum Stage {
        DESTROY,
        CONNECT,
        HANDSHAKE,
        HANDSHAKE_RESPONSE,
        SERVER_KEYS,
        LOGIN_REQUEST,
        LOGIN_RESPONSE,
        PROFILE_BEING_TRANSFERRED,
        WAIT_FOR_PROFILE_TRANSFER,
        LOGIN_ACCEPTED,
        LOGIN_ACCEPTED_BODY;

    }
}

