/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.io;

import java.math.BigInteger;
import org.runejs.client.MovedStatics;
import org.runejs.client.RSString;
import org.runejs.client.node.Node;

public class Buffer
extends Node {
    public int currentPosition;
    public byte[] buffer;

    public Buffer(int size) {
        this.buffer = new byte[size];
        this.currentPosition = 0;
    }

    public Buffer(byte[] buffer) {
        this.currentPosition = 0;
        this.buffer = buffer;
    }

    public int getShortLE() {
        this.currentPosition += 2;
        int i = ((this.buffer[this.currentPosition - 1] & 0xFF) << 8) + (this.buffer[this.currentPosition - 2] & 0xFF);
        if (i > Short.MAX_VALUE) {
            i -= 65536;
        }
        return i;
    }

    public int getShortBE() {
        this.currentPosition += 2;
        int i = ((this.buffer[this.currentPosition - 2] & 0xFF) << 8) + (this.buffer[this.currentPosition - 1] & 0xFF);
        if (i > Short.MAX_VALUE) {
            i -= 65536;
        }
        return i;
    }

    public RSString getRSString() {
        int i = this.currentPosition;
        while (this.buffer[this.currentPosition++] != 0) {
        }
        return RSString.method279(this.buffer, i, -1 + this.currentPosition + -i);
    }

    public String getString() {
        int start = this.currentPosition;
        while (this.buffer[this.currentPosition++] != 0) {
        }
        return new String(this.buffer, start, this.currentPosition - start - 1);
    }

    public void putByte(int value) {
        this.buffer[this.currentPosition++] = (byte)value;
    }

    public void applyRSA(BigInteger modulus, BigInteger key) {
        int i = this.currentPosition;
        this.currentPosition = 0;
        byte[] bytes = new byte[i];
        this.getBytes(i, 0, bytes);
        BigInteger data = new BigInteger(bytes);
        BigInteger rsaData = data.modPow(key, modulus);
        byte[] rsaBytes = rsaData.toByteArray();
        this.currentPosition = 0;
        this.putByte(rsaBytes.length);
        this.putBytes(0, rsaBytes.length, rsaBytes);
    }

    public int getUnsignedByte() {
        return 0xFF & this.buffer[this.currentPosition++];
    }

    public int getUnsignedShortBE() {
        this.currentPosition += 2;
        return ((0xFF & this.buffer[this.currentPosition - 2]) << 8) + (this.buffer[this.currentPosition - 1] & 0xFF);
    }

    public int getIntME1() {
        this.currentPosition += 4;
        return (0xFF00 & this.buffer[this.currentPosition - 1] << 8) + (this.buffer[this.currentPosition - 4] << 16 & 0xFF0000) + ((this.buffer[this.currentPosition - 3] & 0xFF) << 24) + (this.buffer[this.currentPosition - 2] & 0xFF);
    }

    public int getIntME2() {
        this.currentPosition += 4;
        return (this.buffer[this.currentPosition - 4] << 8 & 0xFF00) + (0xFF000000 & this.buffer[this.currentPosition - 2] << 24) + (this.buffer[this.currentPosition - 1] << 16 & 0xFF0000) + (this.buffer[this.currentPosition - 3] & 0xFF);
    }

    public void putIntME1(int value) {
        this.buffer[this.currentPosition++] = (byte)(value >> 16);
        this.buffer[this.currentPosition++] = (byte)(value >> 24);
        this.buffer[this.currentPosition++] = (byte)value;
        this.buffer[this.currentPosition++] = (byte)(value >> 8);
    }

    public void putIntME2(int value) {
        this.buffer[this.currentPosition++] = (byte)(value >> 8);
        this.buffer[this.currentPosition++] = (byte)value;
        this.buffer[this.currentPosition++] = (byte)(value >> 24);
        this.buffer[this.currentPosition++] = (byte)(value >> 16);
    }

    public int putCrc8(int value) {
        int crc = MovedStatics.calculateCrc8(value, this.currentPosition, this.buffer);
        this.putIntBE(crc);
        return crc;
    }

    public void putShortBE(int value) {
        this.buffer[this.currentPosition++] = (byte)(value >> 8);
        this.buffer[this.currentPosition++] = (byte)value;
    }

    public void putBytes(int startingIndex, int endingIndex, byte[] data) {
        for (int i = startingIndex; startingIndex + endingIndex > i; ++i) {
            this.buffer[this.currentPosition++] = data[i];
        }
    }

    public void getBytes(int endingIndex, int startingIndex, byte[] data) {
        for (int i = startingIndex; endingIndex + startingIndex > i; ++i) {
            data[i] = this.buffer[this.currentPosition++];
        }
    }

    public void putMediumBE(int value) {
        this.buffer[this.currentPosition++] = (byte)(value >> 16);
        this.buffer[this.currentPosition++] = (byte)(value >> 8);
        this.buffer[this.currentPosition++] = (byte)value;
    }

    public void finishVarByte(int length) {
        this.buffer[-1 + this.currentPosition - length] = (byte)length;
    }

    public void putLongBE(long arg0) {
        this.buffer[this.currentPosition++] = (byte)(arg0 >> 56);
        this.buffer[this.currentPosition++] = (byte)(arg0 >> 48);
        this.buffer[this.currentPosition++] = (byte)(arg0 >> 40);
        this.buffer[this.currentPosition++] = (byte)(arg0 >> 32);
        this.buffer[this.currentPosition++] = (byte)(arg0 >> 24);
        this.buffer[this.currentPosition++] = (byte)(arg0 >> 16);
        this.buffer[this.currentPosition++] = (byte)(arg0 >> 8);
        this.buffer[this.currentPosition++] = (byte)arg0;
    }

    public int getUnsignedSmart() {
        int peek = this.buffer[this.currentPosition] & 0xFF;
        if (peek >= 128) {
            return -49152 + this.getUnsignedShortBE();
        }
        return this.getUnsignedByte() + -64;
    }

    public int getSmart() {
        int i = this.buffer[this.currentPosition] & 0xFF;
        if (i >= 128) {
            return this.getUnsignedShortBE() + Short.MIN_VALUE;
        }
        return this.getUnsignedByte();
    }

    public void putSmart(int value) {
        if (value >= 0 && value < 128) {
            this.putByte(value);
        } else if (value >= 0 && value < 32768) {
            this.putShortBE(32768 + value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void decryptXTEA(int[] xteaKeys, int bufferStart, int bufferLength) {
        int ROUND_COUNT = 32;
        int blockCount = (bufferLength - bufferStart) / 8;
        int originalPosition = this.currentPosition;
        this.currentPosition = bufferStart;
        for (int block = 0; blockCount > block; ++block) {
            int v0 = this.getIntBE();
            int v1 = this.getIntBE();
            int delta = -1640531527;
            int sum = delta * ROUND_COUNT;
            for (int i = 0; i < ROUND_COUNT; ++i) {
                v0 -= ((v1 -= (v0 >>> 5 ^ v0 << 4) + v0 ^ sum + xteaKeys[0x8E200003 & sum >>> 11]) >>> 5 ^ v1 << 4) + v1 ^ xteaKeys[3 & (sum -= delta)] + sum;
            }
            this.currentPosition -= 8;
            this.putIntBE(v0);
            this.putIntBE(v1);
        }
        this.currentPosition = originalPosition;
    }

    public int getIntLE() {
        this.currentPosition += 4;
        return (this.buffer[this.currentPosition - 3] << 8 & 0xFF00) + ((0xFF & this.buffer[this.currentPosition - 1]) << 24) + (0xFF0000 & this.buffer[this.currentPosition - 2] << 16) + (this.buffer[this.currentPosition - 4] & 0xFF);
    }

    public void putShortLE(int value) {
        this.buffer[this.currentPosition++] = (byte)value;
        this.buffer[this.currentPosition++] = (byte)(value >> 8);
    }

    public int getMediumBE() {
        this.currentPosition += 3;
        return ((this.buffer[this.currentPosition - 3] & 0xFF) << 16) + ((this.buffer[this.currentPosition - 2] & 0xFF) << 8) + (0xFF & this.buffer[this.currentPosition - 1]);
    }

    public int getUnsignedShortLE() {
        this.currentPosition += 2;
        return (0xFF00 & this.buffer[this.currentPosition - 1] << 8) + (0xFF & this.buffer[this.currentPosition - 2]);
    }

    public int getIntBE() {
        this.currentPosition += 4;
        return (0xFF & this.buffer[this.currentPosition - 1]) + (this.buffer[this.currentPosition - 2] << 8 & 0xFF00) + (this.buffer[this.currentPosition - 3] << 16 & 0xFF0000) + (0xFF000000 & this.buffer[this.currentPosition - 4] << 24);
    }

    public void putIntLE(int value) {
        this.buffer[this.currentPosition++] = (byte)value;
        this.buffer[this.currentPosition++] = (byte)(value >> 8);
        this.buffer[this.currentPosition++] = (byte)(value >> 16);
        this.buffer[this.currentPosition++] = (byte)(value >> 24);
    }

    public long getLongBE() {
        long l = 0xFFFFFFFFL & (long)this.getIntBE();
        long l_10_ = (long)this.getIntBE() & 0xFFFFFFFFL;
        return l_10_ + (l << 32);
    }

    public int getIntVar() {
        byte i = this.buffer[this.currentPosition++];
        int i_11_ = 0;
        while (i < 0) {
            i_11_ = (0x7F & i | i_11_) << 7;
            i = this.buffer[this.currentPosition++];
        }
        return i | i_11_;
    }

    public void method505(RSString value) {
        this.currentPosition += value.method51(0, value.length(), this.buffer, this.currentPosition);
        this.buffer[this.currentPosition++] = 0;
    }

    public void putString(String str) {
        if (str == null) {
            str = "";
        }
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)str.charAt(i);
        }
        System.arraycopy(bytes, 0, this.buffer, this.currentPosition, bytes.length);
        this.currentPosition += str.length();
        this.buffer[this.currentPosition++] = 0;
    }

    public void putIntBE(int value) {
        this.buffer[this.currentPosition++] = (byte)(value >> 24);
        this.buffer[this.currentPosition++] = (byte)(value >> 16);
        this.buffer[this.currentPosition++] = (byte)(value >> 8);
        this.buffer[this.currentPosition++] = (byte)value;
    }

    public byte getByte() {
        return this.buffer[this.currentPosition++];
    }
}

