/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.frame.tab;

import org.runejs.client.Game;
import org.runejs.client.MovedStatics;
import org.runejs.client.ProducingGraphicsBuffer;
import org.runejs.client.cache.media.ImageRGB;
import org.runejs.client.cache.media.gameInterface.GameInterface;
import org.runejs.client.frame.FramePieceRenderer;
import org.runejs.client.frame.ScreenController;
import org.runejs.client.frame.tab.parts.TabParts;
import org.runejs.client.media.RasterizerInstanced;

public class TabProducer
extends FramePieceRenderer {
    private static ProducingGraphicsBuffer resizableSideBarImage;
    private ProducingGraphicsBuffer tempResizableSideBar = MovedStatics.createGraphicsBuffer(241, 334, Game.gameCanvas);
    private ImageRGB edgeLeft;
    private ImageRGB edgeRight;
    private ImageRGB combat;
    private ImageRGB stats;
    private ImageRGB quests;
    private ImageRGB inventory;
    private ImageRGB equipment;
    private ImageRGB prayer;
    private ImageRGB magic;
    private ImageRGB topRow;
    private ImageRGB friends;
    private ImageRGB ignores;
    private ImageRGB logout;
    private ImageRGB options;
    private ImageRGB emotes;
    private ImageRGB music;
    private ImageRGB bottomRow;
    private ImageRGB background;
    private ImageRGB stone_bottom_left_selected;
    private ImageRGB stone_bottom_right_selected;
    private ImageRGB stone_middle_selected;
    private ImageRGB stone_top_left_selected;
    private ImageRGB stone_top_right_selected;
    private boolean loaded = false;
    private static int workingWidth;
    private static int workingHeight;

    public TabProducer() {
        resizableSideBarImage = MovedStatics.createGraphicsBuffer(241, 334, Game.gameCanvas);
        this.rasterizerInstanced = new RasterizerInstanced(this.tempResizableSideBar);
        this.rasterizerInstanced.drawFilledRectangle(0, 0, 241, 334, Integer.MAX_VALUE);
    }

    private void drawActiveTab(int currentTabId, int currentY) {
        ImageRGB part;
        int x = 0;
        switch (currentTabId) {
            case 0: {
                part = this.stone_top_left_selected;
                break;
            }
            case 6: {
                part = this.stone_top_right_selected;
                break;
            }
            case 7: {
                part = this.stone_bottom_left_selected;
                break;
            }
            case 13: {
                part = this.stone_bottom_right_selected;
                break;
            }
            default: {
                part = this.stone_middle_selected;
            }
        }
        switch (currentTabId) {
            case 0: 
            case 7: {
                x = 0;
                break;
            }
            case 1: 
            case 8: {
                x = 38;
                break;
            }
            case 2: 
            case 9: {
                x = 70;
                break;
            }
            case 3: 
            case 10: {
                x = 104;
                break;
            }
            case 4: 
            case 11: {
                x = 136;
                break;
            }
            case 5: 
            case 12: {
                x = 170;
                break;
            }
            case 6: 
            case 13: {
                x = 202;
            }
        }
        this.drawImage(part, x, currentY);
    }

    public int[] getTabButtonStartCoords(int tabButtonIndex) {
        int x = 0;
        int y = 0;
        switch (tabButtonIndex) {
            case 0: 
            case 7: {
                x = 0;
                break;
            }
            case 1: 
            case 8: {
                x = 38;
                break;
            }
            case 2: 
            case 9: {
                x = 70;
                break;
            }
            case 3: 
            case 10: {
                x = 104;
                break;
            }
            case 4: 
            case 11: {
                x = 136;
                break;
            }
            case 5: 
            case 12: {
                x = 170;
                break;
            }
            case 6: 
            case 13: {
                x = 202;
            }
        }
        if (tabButtonIndex > 6) {
            y = workingHeight - this.bottomRow.imageHeight;
        }
        return new int[]{x, y};
    }

    public int[] getTabButtonBox(int tabButtonIndex) {
        int[] start = this.getTabButtonStartCoords(tabButtonIndex);
        int[] topbar = this.getTopBarCoordSize(0, 0);
        int[] end = tabButtonIndex != 13 && tabButtonIndex != 6 ? this.getTabButtonStartCoords(tabButtonIndex + 1) : new int[]{topbar[2], start[1]};
        return new int[]{start[0], start[1], end[0], start[1] + topbar[3]};
    }

    public void drawResizableSideBarArea(int x, int y) {
        ScreenController.drawFramePiece(resizableSideBarImage, x, y);
    }

    public int[] getTabInterfaceCoordSize(int baseX, int baseY) {
        if (MovedStatics.tabImageProducer == null) {
            return new int[]{0, 0, 0, 0};
        }
        return new int[]{(baseX += 5) + workingWidth / 2 - MovedStatics.tabImageProducer.width / 2, baseY + workingHeight / 2 - MovedStatics.tabImageProducer.height / 2, MovedStatics.tabImageProducer.width, MovedStatics.tabImageProducer.height};
    }

    public int[] getTopBarCoordSize(int baseX, int baseY) {
        if (this.topRow == null) {
            return new int[]{0, 0, 0, 0};
        }
        return new int[]{baseX, baseY, this.topRow.imageWidth, this.topRow.imageHeight};
    }

    public int[] getBottomBarCoordSize(int baseX, int baseY) {
        if (this.bottomRow == null) {
            return new int[]{0, 0, 0, 0};
        }
        return new int[]{baseX, baseY + workingHeight - this.bottomRow.imageHeight, this.bottomRow.imageWidth, this.bottomRow.imageHeight};
    }

    private void drawMiddlePiece(int baseX, int baseY, int width, int height) {
        if (MovedStatics.tabImageProducer == null) {
            return;
        }
        this.rasterizerInstanced.copyPixels(MovedStatics.tabImageProducer.pixels, MovedStatics.tabImageProducer.width, MovedStatics.tabImageProducer.height, baseX + width / 2 - MovedStatics.tabImageProducer.width / 2, baseY + height / 2 - MovedStatics.tabImageProducer.height / 2);
        this.drawImage(this.edgeLeft, baseX, baseY + height / 2 - this.edgeLeft.imageHeight / 2);
        this.drawImage(this.edgeRight, baseX + width - this.edgeRight.imageWidth, baseY + height / 2 - this.edgeRight.imageHeight / 2);
    }

    public void RenderResizableSideBarArea() {
        if (!this.loaded) {
            this.edgeLeft = TabParts.GetPart("side_panel_edge_left");
            this.edgeRight = TabParts.GetPart("side_panel_edge_right");
            this.combat = TabParts.GetPart("combat");
            this.stats = TabParts.GetPart("stats");
            this.quests = TabParts.GetPart("quests");
            this.inventory = TabParts.GetPart("inventory");
            this.equipment = TabParts.GetPart("equipment");
            this.prayer = TabParts.GetPart("prayer");
            this.magic = TabParts.GetPart("magic");
            this.topRow = TabParts.GetPart("tabs_top_row");
            this.friends = TabParts.GetPart("friends");
            this.ignores = TabParts.GetPart("ignores");
            this.logout = TabParts.GetPart("logout");
            this.options = TabParts.GetPart("options");
            this.emotes = TabParts.GetPart("emotes");
            this.music = TabParts.GetPart("music");
            this.bottomRow = TabParts.GetPart("tabs_bottom_row");
            this.background = TabParts.GetPart("side_panel_background");
            this.stone_bottom_left_selected = TabParts.GetPart("stone_bottom_left_selected");
            this.stone_bottom_right_selected = TabParts.GetPart("stone_bottom_right_selected");
            this.stone_middle_selected = TabParts.GetPart("stone_middle_selected");
            this.stone_top_left_selected = TabParts.GetPart("stone_top_left_selected");
            this.stone_top_right_selected = TabParts.GetPart("stone_top_right_selected");
            this.loaded = true;
        }
        int x = 5;
        int y = 0;
        this.drawImage(this.background, x + 24, y + 20);
        this.drawImage(this.background, x + 24 + this.background.imageWidth, y + 20);
        this.drawImage(this.background, x + 24 + this.background.imageWidth + 20, y + 20);
        this.drawImage(this.background, x + 24, y + workingHeight - this.background.imageHeight - 20);
        this.drawImage(this.background, x + 24 + this.background.imageWidth, y + workingHeight - this.background.imageHeight - 20);
        this.drawImage(this.background, x + 24 + this.background.imageWidth + 20, y + workingHeight - this.background.imageHeight - 20);
        this.drawMiddlePiece(x, y, workingWidth, workingHeight);
        this.drawTopRow(x, y, workingWidth, workingHeight);
        this.drawBottomRow(x, y, workingWidth, workingHeight);
        System.arraycopy(this.tempResizableSideBar.pixels, 0, TabProducer.resizableSideBarImage.pixels, 0, TabProducer.resizableSideBarImage.pixels.length);
    }

    private void drawBottomRow(int x, int y, int workingWidth, int workingHeight) {
        this.drawImage(this.bottomRow, x - 4, y + workingHeight - this.bottomRow.imageHeight);
        int currentX = x;
        int currentY = y + workingHeight - this.bottomRow.imageHeight;
        if (6 < Game.currentTabId) {
            this.drawActiveTab(Game.currentTabId, currentY);
        }
        this.drawImage(this.friends, currentX += this.combat.imageWidth, currentY);
        this.drawImage(this.ignores, currentX += this.combat.imageWidth, currentY);
        this.drawImage(this.logout, currentX += this.combat.imageWidth, currentY);
        this.drawImage(this.options, currentX += this.combat.imageWidth, currentY);
        this.drawImage(this.emotes, currentX += this.combat.imageWidth, currentY);
        this.drawImage(this.music, currentX += this.combat.imageWidth, currentY);
    }

    private void drawTopRow(int x, int y, int workingWidth, int workingHeight) {
        this.drawImage(this.topRow, x - 4, y);
        if (Game.currentTabId < 7) {
            this.drawActiveTab(Game.currentTabId, y);
        }
        int currentX = x;
        this.drawImage(this.combat, currentX, y);
        this.drawImage(this.stats, currentX += this.stats.imageWidth, y);
        this.drawImage(this.quests, currentX += this.stats.imageWidth, y);
        this.drawImage(this.inventory, currentX += this.stats.imageWidth, y);
        this.drawImage(this.equipment, currentX += this.stats.imageWidth, y);
        this.drawImage(this.prayer, currentX += this.stats.imageWidth, y);
        this.drawImage(this.magic, currentX += this.stats.imageWidth, y);
    }

    private static void RenderCustomTabArea(int baseX, int baseY) {
        int colourBorder = 2367511;
        int colourInnerBorder = 7826488;
        int colourInnerPrimary = 5063719;
        int colourInnerSecondary = 10721354;
        int width = 232;
        int height = 334;
    }

    public void clickTabButton(int x, int y, int baseX, int baseY) {
        for (int i = 0; i < 14; ++i) {
            int[] bounds = this.getTabButtonBox(i);
            if (x <= baseX + bounds[0] || x >= baseX + bounds[2] || y <= baseY + bounds[1] || y >= baseY + bounds[3] || i == 7) continue;
            Game.currentTabId = i;
            GameInterface.redrawTabArea = true;
            GameInterface.drawTabIcons = true;
            return;
        }
    }

    static {
        workingWidth = 232;
        workingHeight = 334;
    }
}

