/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.frame.console;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.runejs.Configuration;
import org.runejs.client.MovedStatics;
import org.runejs.client.cache.media.TypeFace;
import org.runejs.client.cache.media.gameInterface.GameInterface;
import org.runejs.client.frame.ChatBox;
import org.runejs.client.frame.console.Command;
import org.runejs.client.frame.console.CommandList;
import org.runejs.client.frame.console.Commands.AlphaCommand;
import org.runejs.client.frame.console.Commands.ClearCommand;
import org.runejs.client.frame.console.Commands.DebugClippingCommand;
import org.runejs.client.frame.console.Commands.DebugCommand;
import org.runejs.client.frame.console.Commands.DebugViewCommand;
import org.runejs.client.frame.console.Commands.DebugWalkCommand;
import org.runejs.client.frame.console.Commands.DebugWidgetsCommand;
import org.runejs.client.frame.console.Commands.EchoCommand;
import org.runejs.client.frame.console.Commands.FpsCommand;
import org.runejs.client.frame.console.Commands.HelpCommand;
import org.runejs.client.frame.console.Commands.HideFpsCommand;
import org.runejs.client.frame.console.Commands.IpCommand;
import org.runejs.client.frame.console.Commands.PlayerRightsCommand;
import org.runejs.client.frame.console.Commands.ResizableCommand;
import org.runejs.client.frame.console.Commands.RoofsCommand;
import org.runejs.client.frame.console.Commands.SearchCommand;
import org.runejs.client.frame.console.Commands.ServerCommand;
import org.runejs.client.frame.console.Commands.ShowFpsCommand;
import org.runejs.client.media.Rasterizer;
import org.runejs.client.message.outbound.console.ConsoleCommandOutboundMessage;
import org.runejs.client.net.OutgoingPackets;

public class Console {
    private static final String CONSOLE_VERSION = Configuration.SERVER_DISPLAY_NAME;
    public static Console console;
    private String[] consoleMessages = new String[5000];
    private int messageCount = 0;
    public String consoleInput;
    public boolean consoleOpen;
    private String[] previousCommands = new String[100];
    private int previousCommandIndex;
    private int previousCommandCount;
    private int currentChatIndex;
    public int currentScroll = 0;
    private boolean alpha = true;
    private List<Command> commands;
    private int versionWidth = -1;
    private int tabCount = 0;
    private CommandList autoCompleteList;

    public Console() {
        this.previousCommands[0] = "";
        this.consoleInput = "";
        this.currentChatIndex = 0;
        this.consoleOpen = false;
        this.previousCommandCount = 1;
        this.previousCommandIndex = 1;
        this.commands = new CommandList();
        this.log("Welcome to the " + Configuration.SERVER_DISPLAY_NAME + " console, type help for help.");
        this.initialiseCommands();
    }

    private void initialiseCommands() {
        this.commands.add(new HelpCommand(this.commands));
        this.commands.add(new AlphaCommand());
        this.commands.add(new ClearCommand());
        this.commands.add(new DebugCommand());
        this.commands.add(new DebugClippingCommand());
        this.commands.add(new DebugViewCommand());
        this.commands.add(new DebugWalkCommand());
        this.commands.add(new DebugWidgetsCommand());
        this.commands.add(new EchoCommand());
        this.commands.add(new PlayerRightsCommand());
        this.commands.add(new IpCommand());
        this.commands.add(new FpsCommand());
        this.commands.add(new RoofsCommand());
        this.commands.add(new ShowFpsCommand());
        this.commands.add(new HideFpsCommand());
        this.commands.add(new SearchCommand());
        this.commands.add(new ResizableCommand());
    }

    public int getMaxScroll() {
        return this.messageCount * 18 + 17;
    }

    public void drawConsole(int width, int height) {
        if (this.consoleOpen) {
            int scrollpos = this.getMaxScroll() - this.currentScroll - 310;
            if (this.messageCount > 17) {
                GameInterface.drawScrollBar(width - 18, 0, height - 21, scrollpos, this.getMaxScroll());
            }
            if (this.alpha) {
                Rasterizer.drawFilledRectangleAlpha(0, 0, width, height, 5320850, 97);
            } else {
                Rasterizer.drawFilledRectangle(0, 0, width, height, 5320850);
            }
            Rasterizer.drawHorizontalLine(1, height - 19, width, 0xFFFFFF);
            TypeFace.fontBold.setEffects(0xFFFFFF, -1);
            TypeFace.fontBold.drawBasicString(">", 11, height - 4);
            if (this.versionWidth == -1) {
                this.versionWidth = TypeFace.fontSmall.getStringWidth(CONSOLE_VERSION);
            }
            TypeFace.fontSmall.drawBasicString(CONSOLE_VERSION, width - 25 - this.versionWidth, height - 22);
            if (MovedStatics.pulseCycle % 20 < 10) {
                TypeFace.fontBold.drawBasicString(this.consoleInput.substring(0, this.currentChatIndex) + "|" + this.consoleInput.substring(this.currentChatIndex), 22, height - 4);
            } else {
                TypeFace.fontBold.drawBasicString(this.consoleInput.substring(0, this.currentChatIndex) + "<trans=0>|</trans>" + this.consoleInput.substring(this.currentChatIndex), 22, height - 4);
            }
        }
    }

    public void drawConsoleArea(int width, int height) {
        if (this.consoleOpen) {
            MovedStatics.fontNormal.setEffectsAlpha(0xFFFFFF, -1, 178);
            int i = this.messageCount;
            int j = 308;
            while (i > 0 && this.consoleMessages[i] != null) {
                int y = j;
                if (this.messageCount > 17) {
                    y = 290 - (this.messageCount - i) * 18 + 18 + this.currentScroll;
                }
                if (y > 2 && y < 315) {
                    MovedStatics.fontNormal.drawBasicString(this.consoleMessages[i], 9, y);
                }
                --i;
                j -= 18;
            }
        }
    }

    public void log(String s) {
        this.log(s, false);
    }

    public void log(String s, boolean userInput) {
        if (GameInterface.chatboxInterfaceId == -1) {
            ChatBox.redrawChatbox = true;
        }
        String[] strings = s.split("\n");
        boolean first = true;
        for (String line : strings) {
            this.consoleMessages[++this.messageCount] = first && userInput ? "> " + line : line;
            first = false;
        }
    }

    public void parseConsoleCommand(String cmd) {
        this.currentScroll = 0;
        this.addToFrontOfHistory(cmd);
        ++this.previousCommandCount;
        this.previousCommandIndex = 0;
        String[] cmdInput = cmd.split(" ");
        int index = this.commands.indexOf(cmdInput[0].toLowerCase());
        if (index == -1) {
            OutgoingPackets.sendMessage(new ConsoleCommandOutboundMessage(cmd));
        } else {
            this.commands.get(index).execute(this, cmdInput);
        }
    }

    public void loadPrev() {
        if (this.previousCommandIndex < this.previousCommandCount - 1) {
            this.consoleInput = this.previousCommands[++this.previousCommandIndex];
        }
        this.currentChatIndex = this.consoleInput.length();
    }

    public void loadNext() {
        if (this.previousCommandIndex > 0) {
            this.consoleInput = this.previousCommands[--this.previousCommandIndex];
        }
        this.currentChatIndex = this.consoleInput.length();
    }

    private void addToFrontOfHistory(String element) {
        String[] newArray = new String[this.previousCommands.length];
        newArray[0] = "";
        newArray[1] = element;
        for (int i = 2; i < this.previousCommands.length && this.previousCommands[i - 1] != null; ++i) {
            newArray[i] = this.previousCommands[i - 1];
        }
        this.previousCommands = newArray;
    }

    public void resetToCurrent() {
        this.previousCommandIndex = 0;
        this.consoleInput = "";
        this.currentChatIndex = 0;
    }

    public void handleInput() {
        if (MovedStatics.obfuscatedKeyStatus[82]) {
            if (MovedStatics.anInt2854 == 67) {
                boolean hasStringText;
                String result = "";
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = clipboard.getContents(null);
                boolean bl = hasStringText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                if (hasStringText) {
                    try {
                        result = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        System.out.println(ex);
                        ex.printStackTrace();
                    }
                }
                this.consoleInput = this.consoleInput + result;
                this.currentChatIndex = this.consoleInput.length();
            }
            ChatBox.redrawChatbox = true;
            return;
        }
        if (MovedStatics.anInt2854 == 80) {
            ++this.tabCount;
            if (this.tabCount >= 1) {
                if (this.tabCount == 1) {
                    this.buildAutoCompletionList();
                    ++this.tabCount;
                }
                if (this.tabCount - 2 > this.autoCompleteList.size() - 1) {
                    this.tabCount = 2;
                }
                if (this.autoCompleteList.size() > 0) {
                    this.consoleInput = ((Command)this.autoCompleteList.get(this.tabCount - 2)).getCommand();
                    this.currentChatIndex = this.consoleInput.length();
                }
            }
        } else {
            this.tabCount = 0;
        }
        if (MovedStatics.anInt2854 == 98) {
            this.loadPrev();
        }
        if (MovedStatics.anInt2854 == 99) {
            this.loadNext();
        }
        if (MovedStatics.anInt2854 == 96) {
            --this.currentChatIndex;
            if (this.currentChatIndex < 0) {
                this.currentChatIndex = 0;
            }
        }
        if (MovedStatics.anInt2854 == 97) {
            ++this.currentChatIndex;
            if (this.currentChatIndex > this.consoleInput.length()) {
                this.currentChatIndex = this.consoleInput.length();
            }
        }
        if (MovedStatics.anInt2854 == 0) {
            this.resetToCurrent();
        }
        if (MovedStatics.anInt2854 == 101 && this.consoleInput.length() != this.currentChatIndex) {
            this.consoleInput = this.consoleInput.substring(0, this.currentChatIndex) + this.consoleInput.substring(this.currentChatIndex + 1);
        }
        if (MovedStatics.anInt2854 == 102) {
            this.currentChatIndex = 0;
        }
        if (MovedStatics.anInt2854 == 103) {
            this.currentChatIndex = this.consoleInput.length();
        }
        if (MovedStatics.anInt2854 == 85 && this.consoleInput.length() > 0) {
            this.consoleInput = this.consoleInput.substring(0, this.currentChatIndex - 1) + this.consoleInput.substring(this.currentChatIndex);
            --this.currentChatIndex;
        }
        if (MovedStatics.isValidInputCharacter(MovedStatics.anInt1388) && this.consoleInput.length() < 80) {
            this.consoleInput = this.consoleInput.substring(0, this.currentChatIndex) + (char)MovedStatics.anInt1388 + this.consoleInput.substring(this.currentChatIndex);
            ++this.currentChatIndex;
        }
        if (MovedStatics.anInt2854 == 84 && this.consoleInput.length() > 0) {
            this.log(this.consoleInput, true);
            this.parseConsoleCommand(this.consoleInput);
            this.consoleInput = "";
            this.currentChatIndex = 0;
        }
        ChatBox.redrawChatbox = true;
    }

    private void buildAutoCompletionList() {
        CommandList autoCompletionList = new CommandList();
        for (Command command : this.commands) {
            if (!command.startsWith(this.consoleInput)) continue;
            autoCompletionList.add(command);
        }
        this.autoCompleteList = autoCompletionList;
    }

    public void toggleAlpha() {
        this.alpha = !this.alpha;
    }

    public void setMessageCount(int count) {
        this.messageCount = count;
    }

    public void log(int i) {
        this.log(String.valueOf(i));
    }

    public void addCommand(String command, String help) {
        int index = this.commands.indexOf(command.toLowerCase());
        if (index == -1) {
            this.commands.add(new ServerCommand(command, help));
        }
    }
}

