/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.frame;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.text.MessageFormat;
import org.runejs.client.ClientScriptRunner;
import org.runejs.client.Game;
import org.runejs.client.GameShell;
import org.runejs.client.MovedStatics;
import org.runejs.client.ProducingGraphicsBuffer;
import org.runejs.client.cache.media.gameInterface.GameInterface;
import org.runejs.client.cache.media.gameInterface.GameInterfaceArea;
import org.runejs.client.frame.ChatBox;
import org.runejs.client.frame.FrameRenderer;
import org.runejs.client.frame.Minimap;
import org.runejs.client.frame.ResizableFrameRenderer;
import org.runejs.client.frame.ScreenMode;
import org.runejs.client.frame.tab.TabProducer;
import org.runejs.client.input.MouseHandler;
import org.runejs.client.language.English;
import org.runejs.client.language.Native;
import org.runejs.client.media.Rasterizer;
import org.runejs.client.media.Rasterizer3D;
import org.runejs.client.media.renderable.actor.Pathfinding;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.message.outbound.chat.SetChatOptionsOutboundMessage;
import org.runejs.client.net.OutgoingPackets;

public class ScreenController {
    public static ScreenMode frameMode = null;
    public static int frameWidth = 765;
    public static int frameHeight = 540;
    public static int drawWidth = 765;
    public static int drawHeight = 540;
    public static Minimap minimap = new Minimap();
    public static TabProducer tabProducer = new TabProducer();
    private static Thread drawingThread;
    private static FrameRenderer renderer;
    public static boolean DebugView;

    public static void frameMode(ScreenMode screenMode) {
        if (frameMode != screenMode) {
            frameMode = screenMode;
            if (screenMode == ScreenMode.FIXED) {
                frameWidth = 765;
                frameHeight = 503;
                GameShell.clientFrame.setResizable(false);
                GameShell.clientFrame.setPreferredSize(new Dimension(frameWidth, frameHeight));
                GameShell.clientFrame.setMinimumSize(new Dimension(frameWidth, frameHeight));
            } else if (screenMode == ScreenMode.RESIZABLE) {
                frameWidth = 900;
                frameHeight = 637;
                GameShell.clientFrame.setResizable(true);
                GameShell.clientFrame.setPreferredSize(new Dimension(frameWidth, frameHeight));
                GameShell.clientFrame.setMinimumSize(new Dimension(frameWidth, frameHeight));
            } else if (screenMode == ScreenMode.FULLSCREEN) {
                frameWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
                frameHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            }
            GameShell.clientFrame.setSize(frameWidth, frameHeight);
            Dimension innerSize = ScreenController.getInnerSize(GameShell.clientFrame);
            drawHeight = innerSize.height;
            drawWidth = innerSize.width;
            ScreenController.setBounds();
        }
    }

    public static void refreshFrameSize() {
        if (Game.gameStatusCode == 5 || Game.gameStatusCode == 10 || Game.gameStatusCode == 20) {
            MovedStatics.clearScreen = true;
        }
        MovedStatics.width = drawWidth;
        MovedStatics.height = drawHeight;
        if (frameMode != ScreenMode.FIXED) {
            if (frameWidth != GameShell.clientFrame.getWidth()) {
                frameWidth = GameShell.clientFrame.getWidth();
                ScreenController.setBounds();
            }
            if (frameHeight != GameShell.clientFrame.getHeight()) {
                frameHeight = GameShell.clientFrame.getHeight();
                ScreenController.setBounds();
            }
        }
    }

    public static void setBounds() {
        if (Game.gameCanvas == null) {
            return;
        }
        Dimension innerSize = ScreenController.getInnerSize(GameShell.clientFrame);
        drawHeight = innerSize.height;
        drawWidth = innerSize.width;
        Rasterizer3D.prepare(null, frameMode == ScreenMode.FIXED ? 512 : drawWidth, frameMode == ScreenMode.FIXED ? 334 : drawHeight);
        MovedStatics.fullScreenTextureArray = Rasterizer3D.setLineOffsets(null);
        Rasterizer3D.prepare(null, frameMode == ScreenMode.FIXED ? 479 : drawWidth, frameMode == ScreenMode.FIXED ? 96 : drawHeight);
        MovedStatics.sidebarOffsets = Rasterizer3D.setLineOffsets(null);
        Rasterizer3D.prepare(null, frameMode == ScreenMode.FIXED ? 765 : drawWidth, frameMode == ScreenMode.FIXED ? 503 : drawHeight);
        Player.viewportOffsets = Rasterizer3D.setLineOffsets(null);
        int[] is = new int[9];
        for (int i = 0; i < 9; ++i) {
            int i_0_ = 15 + 32 * i + 128;
            int i_1_ = 3 * i_0_ + 600;
            int i_2_ = Rasterizer3D.sinetable[i_0_];
            is[i] = i_2_ * i_1_ >> 16;
        }
        Game.sceneRenderer.precalculateTileVisibility(frameMode == ScreenMode.FIXED ? 512 : drawWidth, frameMode == ScreenMode.FIXED ? 334 : drawHeight, 500, 800, is);
        Game.gameCanvas.setSize(frameMode == ScreenMode.FIXED ? 512 : drawWidth, frameMode == ScreenMode.FIXED ? 334 : drawHeight);
        if (Game.gameStatusCode <= 35 && Game.gameStatusCode >= 30) {
            MovedStatics.gameScreenImageProducer = MovedStatics.createGraphicsBuffer(frameMode == ScreenMode.FIXED ? 512 : drawWidth, frameMode == ScreenMode.FIXED ? 334 : drawHeight, GameShell.clientFrame);
        } else {
            Game.gameCanvas.setSize(MovedStatics.width, MovedStatics.height);
            Game.gameCanvas.setVisible(true);
            if (GameShell.clientFrame == null) {
                Game.gameCanvas.setLocation(0, 0);
            } else {
                Insets insets = GameShell.clientFrame.getInsets();
                Game.gameCanvas.setLocation(insets.left, insets.top);
            }
        }
    }

    public static void RenderResizableUI() {
        if (drawingThread == null) {
            renderer = new ResizableFrameRenderer(minimap, tabProducer);
            drawingThread = new Thread(renderer);
            drawingThread.start();
        }
        minimap.drawResizableMiniMapArea(drawWidth - 210, 0);
        ScreenController.RenderTabArea(drawWidth - 234, drawHeight - 337);
        ScreenController.RenderChatArea(0, drawHeight - 162);
        tabProducer.drawResizableSideBarArea(drawWidth - 241, drawHeight - 334);
        if (DebugView) {
            int mX = MouseHandler.mouseX;
            int mY = MouseHandler.mouseY;
            int[] tabInterFaceCoords = tabProducer.getTabInterfaceCoordSize(drawWidth - 241, drawHeight - 334);
            int[] tabInterFaceTop = tabProducer.getTopBarCoordSize(drawWidth - 241, drawHeight - 334);
            int[] tabInterFaceBottom = tabProducer.getBottomBarCoordSize(drawWidth - 241, drawHeight - 334);
            if (ScreenController.isCoordinatesIn3dScreen(mX, mY)) {
                Rasterizer.drawFilledRectangleAlpha(0, 0, drawWidth, drawHeight, 65280, 90);
            } else {
                Rasterizer.drawFilledRectangleAlpha(0, 0, drawWidth, drawHeight, 0xFF00FF, 90);
            }
            if (ScreenController.isCoordinatesInExtendedTabArea(mX, mY) && !ScreenController.isCoordinatesInTabArea(mX, mY)) {
                Rasterizer.drawFilledRectangleAlpha(tabInterFaceTop[0], tabInterFaceTop[1], tabInterFaceTop[2], tabInterFaceTop[3], 65280, 90);
                Rasterizer.drawFilledRectangleAlpha(tabInterFaceBottom[0], tabInterFaceBottom[1], tabInterFaceBottom[2], tabInterFaceBottom[3], 65280, 90);
            } else {
                Rasterizer.drawFilledRectangleAlpha(tabInterFaceTop[0], tabInterFaceTop[1], tabInterFaceTop[2], tabInterFaceTop[3], 255, 90);
                Rasterizer.drawFilledRectangleAlpha(tabInterFaceBottom[0], tabInterFaceBottom[1], tabInterFaceBottom[2], tabInterFaceBottom[3], 255, 90);
            }
            if (ScreenController.isCoordinatesInTabArea(mX, mY)) {
                Rasterizer.drawFilledRectangleAlpha(tabInterFaceCoords[0], tabInterFaceCoords[1], MovedStatics.tabImageProducer.width, MovedStatics.tabImageProducer.height, 65280, 90);
            } else {
                Rasterizer.drawFilledRectangleAlpha(tabInterFaceCoords[0], tabInterFaceCoords[1], MovedStatics.tabImageProducer.width, MovedStatics.tabImageProducer.height, 255, 90);
            }
            if (ScreenController.isCoordinatesInExtendedChatArea(mX, mY) && !ScreenController.isCoordinatesInChatArea(mX, mY)) {
                Rasterizer.drawFilledRectangleAlpha(0, drawHeight - 162, 516, drawHeight, 65280, 90);
            } else {
                Rasterizer.drawFilledRectangleAlpha(0, drawHeight - 162, 516, drawHeight, 255, 90);
            }
            if (ScreenController.isCoordinatesInChatArea(mX, mY)) {
                Rasterizer.drawFilledRectangleAlpha(17, drawHeight - 162 + 16, ChatBox.chatBoxImageProducer.width, ChatBox.chatBoxImageProducer.height, 65280, 90);
            } else {
                Rasterizer.drawFilledRectangleAlpha(17, drawHeight - 162 + 16, ChatBox.chatBoxImageProducer.width, ChatBox.chatBoxImageProducer.height, 255, 90);
            }
            if (ScreenController.isCoordinatesInMinimapArea(mX, mY)) {
                Rasterizer.drawFilledRectangleAlpha(drawWidth - 210, 0, 210, 210, 65280, 90);
            } else {
                Rasterizer.drawFilledRectangleAlpha(drawWidth - 210, 0, 210, 210, 255, 90);
            }
            Rasterizer.drawFilledRectangle(MouseHandler.mouseX - 4, MouseHandler.mouseY - 4, 4, 4, 0xFF0000);
        }
        if (MovedStatics.menuOpen) {
            MovedStatics.drawMenu(0, 0);
        }
    }

    public static Dimension getInnerSize(Frame frame) {
        Dimension size = frame.getSize();
        Insets insets = frame.getInsets();
        if (insets != null) {
            size.height -= insets.top + insets.bottom;
            size.width -= insets.left + insets.right;
        }
        return size;
    }

    public static void RenderTabArea(int x, int y) {
        ScreenController.drawFramePiece(MovedStatics.tabPieceLeft, x + 212, y + 39);
        ScreenController.drawFramePieceCutout(MovedStatics.tabPieceUpperRight, x, y + 39, MovedStatics.tabPieceUpperRight.width - 15, MovedStatics.tabPieceUpperRight.height, 15, 0);
        ScreenController.drawFramePieceCutout(MovedStatics.tabPieveLowerRight, x, y + 191, MovedStatics.tabPieveLowerRight.width - 35, MovedStatics.tabPieveLowerRight.height, 35, 0);
        ScreenController.drawFramePieceCutout(MovedStatics.chatboxTop, x, y + 172, MovedStatics.chatboxTop.width - 531, MovedStatics.chatboxTop.height, 531, 0);
        ScreenController.drawFramePieceCutout(MovedStatics.tabBottom, x, y + 300, MovedStatics.tabBottom.width - 35, MovedStatics.tabBottom.height, 35, 0);
        ScreenController.drawFramePieceCutout(MovedStatics.tabTop, x, y, MovedStatics.tabTop.width - 15, MovedStatics.tabTop.height - 6, 15, 6);
        ScreenController.drawFramePiece(MovedStatics.tabImageProducer, x + 22, y + 39);
    }

    public static void RenderChatArea(int x, int y) {
        ScreenController.drawFramePiece(ChatBox.chatBoxImageProducer, x + 17, y + 16);
        ScreenController.drawFramePiece(MovedStatics.chatModes, x, y + 112);
        ScreenController.drawFramePieceCutout(MovedStatics.tabBottom, x + 496, y + 125, 20, MovedStatics.tabBottom.height, 0, 0);
        ScreenController.drawFramePiece(MovedStatics.chatboxRight, x, y + 16);
        ScreenController.drawFramePieceCutout(MovedStatics.chatboxTop, x, y, MovedStatics.chatboxTop.width - 37, MovedStatics.chatboxTop.height - 3, 0, 3);
        ScreenController.drawFramePieceCutout(MovedStatics.tabPieveLowerRight, x + 496, y + 16, 20, MovedStatics.tabPieveLowerRight.height, 0, 0);
    }

    public static void drawFramePiece(ProducingGraphicsBuffer framePiece, int x, int y) {
        Rasterizer.copyPixels(framePiece.pixels, framePiece.width, framePiece.height, x, y);
    }

    public static void drawFramePieceCutout(ProducingGraphicsBuffer framePiece, int x, int y, int width, int height, int offsetX, int offsetY) {
        Rasterizer.copyPixelsCutOff(framePiece.pixels, framePiece.width, framePiece.height, x, y, width, height, offsetX, offsetY);
    }

    public static boolean isCoordinatesIn3dScreen(int x, int y) {
        if (frameMode == ScreenMode.FIXED) {
            return x > 4 && y > 4 && x < 516 && y < 338;
        }
        return x > 0 && y > 0 && x < drawWidth && y < drawHeight && !ScreenController.isCoordinatesInExtendedTabArea(x, y) && !ScreenController.isCoordinatesInTabArea(x, y) && !ScreenController.isCoordinatesInMinimapArea(x, y) && !ScreenController.isCoordinatesInExtendedChatArea(x, y);
    }

    public static boolean isCoordinatesInTabArea(int x, int y) {
        if (frameMode == ScreenMode.FIXED) {
            return x > 553 && y > 205 && x < 743 && y < 466;
        }
        int[] tabInterFaceCoords = tabProducer.getTabInterfaceCoordSize(drawWidth - 241, drawHeight - 334);
        int minX = tabInterFaceCoords[0];
        int minY = tabInterFaceCoords[1];
        int maxX = minX + tabInterFaceCoords[2];
        int maxY = minY + tabInterFaceCoords[3];
        return x > minX && y > minY && x < maxX && y < maxY;
    }

    public static boolean isCoordinatesInExtendedTabArea(int x, int y) {
        int[] top = tabProducer.getTopBarCoordSize(drawWidth - 241, drawHeight - 334);
        int[] bottom = tabProducer.getBottomBarCoordSize(drawWidth - 241, drawHeight - 334);
        if (x > top[0] && x < top[0] + top[2] && y > top[1] && y < top[1] + top[3]) {
            return true;
        }
        return x > bottom[0] && x < bottom[0] + bottom[2] && y > bottom[1] && y < bottom[1] + bottom[3];
    }

    public static boolean isCoordinatesInExtendedChatArea(int x, int y) {
        return x > 0 && y > drawHeight - 184 && x < 516;
    }

    public static boolean isCoordinatesInChatArea(int x, int y) {
        if (frameMode == ScreenMode.FIXED) {
            return x > 17 && y > 357 && x < 496 && y < 453;
        }
        int minX = 17;
        int minY = drawHeight - 162 + 16;
        int maxX = minX + ChatBox.chatBoxImageProducer.width;
        int maxY = minY + ChatBox.chatBoxImageProducer.height;
        return x > minX && y > minY && x < maxX && y < maxY;
    }

    public static boolean isCoordinatesInMinimapArea(int x, int y) {
        if (frameMode == ScreenMode.FIXED) {
            return x > 575 && y < 156;
        }
        return x > drawWidth - 210 && y < 210;
    }

    public static void handleTabClick(int mouseX, int mouseY) {
        if (frameMode == ScreenMode.FIXED) {
            if (GameInterface.tabAreaInterfaceId != -1) {
                MovedStatics.handleInterfaceActions(GameInterfaceArea.TAB_AREA, mouseX, mouseY, 553, 205, 743, 466, GameInterface.tabAreaInterfaceId);
            } else if (Game.tabWidgetIds[Game.currentTabId] != -1) {
                MovedStatics.handleInterfaceActions(GameInterfaceArea.TAB_AREA, mouseX, mouseY, 553, 205, 743, 466, Game.tabWidgetIds[Game.currentTabId]);
            }
        } else {
            int[] tabInterFaceCoords = tabProducer.getTabInterfaceCoordSize(drawWidth - 241, drawHeight - 334);
            if (GameInterface.tabAreaInterfaceId != -1) {
                MovedStatics.handleInterfaceActions(GameInterfaceArea.TAB_AREA, mouseX, mouseY, tabInterFaceCoords[0], tabInterFaceCoords[1], tabInterFaceCoords[0] + tabInterFaceCoords[2], tabInterFaceCoords[1] + tabInterFaceCoords[3], GameInterface.tabAreaInterfaceId);
            } else if (Game.tabWidgetIds[Game.currentTabId] != -1) {
                MovedStatics.handleInterfaceActions(GameInterfaceArea.TAB_AREA, mouseX, mouseY, tabInterFaceCoords[0], tabInterFaceCoords[1], tabInterFaceCoords[0] + tabInterFaceCoords[2], tabInterFaceCoords[1] + tabInterFaceCoords[3], Game.tabWidgetIds[Game.currentTabId]);
            }
        }
    }

    public static void handleChatBoxMouse(int x, int y) {
        int offsetLeft;
        int chatBoxWidth = 479;
        int chatBoxHeight = 96;
        int offsetBottom = 50;
        int minX = offsetLeft = 17;
        int minY = drawHeight - offsetBottom - chatBoxHeight;
        int maxX = minX + chatBoxWidth;
        int maxY = minY + chatBoxHeight;
        if (GameInterface.chatboxInterfaceId == -1 && ChatBox.dialogueId == -1 && y < maxY - 21 && x < maxX - 70) {
            ClientScriptRunner.handleChatNamesRightClick(y - minY);
            return;
        }
        if (ChatBox.dialogueId != -1) {
            MovedStatics.handleInterfaceActions(GameInterfaceArea.PERMANENT_CHAT_BOX_WIDGET, x, y, minX, minY, maxX, maxY, ChatBox.dialogueId);
            return;
        }
        if (GameInterface.chatboxInterfaceId != -1) {
            MovedStatics.handleInterfaceActions(GameInterfaceArea.CHAT_AREA, x, y, minX, minY, maxX, maxY, GameInterface.chatboxInterfaceId);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleMinimapMouse() {
        int minimapClickY;
        int minimapClickX;
        if (Minimap.minimapState != 0) {
            return;
        }
        if (MouseHandler.clickType != 1) return;
        if (frameMode == ScreenMode.FIXED) {
            minimapClickX = -575 + MouseHandler.clickX;
            minimapClickY = -5 + MouseHandler.clickY - 4;
            if (minimapClickX < 0 || minimapClickY < 0 || minimapClickX >= 146 || minimapClickY >= 151) return;
            minimapClickX -= 73;
            minimapClickY -= 75;
        } else {
            minimapClickX = -(frameWidth - 210) + MouseHandler.clickX;
            minimapClickY = -5 + MouseHandler.clickY - 4;
            if (minimapClickX < 0 || minimapClickY < 0 || minimapClickX >= 204 || minimapClickY >= 200) return;
            minimapClickX -= 107;
            minimapClickY -= 100;
        }
        int angle = 0x7FF & Game.getMinimapRotation();
        int sin = Rasterizer3D.sinetable[angle];
        int cos = Rasterizer3D.cosinetable[angle];
        int zoom = 0;
        cos = (zoom + 256) * cos >> 8;
        sin = (zoom + 256) * sin >> 8;
        int i_14_ = minimapClickY * sin + minimapClickX * cos >> 11;
        int i_15_ = cos * minimapClickY - minimapClickX * sin >> 11;
        int destX = Player.localPlayer.worldX + i_14_ >> 7;
        int destY = -i_15_ + Player.localPlayer.worldY >> 7;
        if (MovedStatics.obfuscatedKeyStatus[81] && Game.playerRights > 1) {
            OutgoingPackets.buffer.putPacket(246);
            OutgoingPackets.buffer.putString(MessageFormat.format(" move {0} {1}", Integer.toString(destX + MovedStatics.baseX), Integer.toString(destY + MovedStatics.baseY)));
            return;
        } else {
            Pathfinding.MinimapWalkAnalytics analytics = new Pathfinding.MinimapWalkAnalytics(minimapClickX, minimapClickY, 0, 0, Game.playerCamera.getYaw(), Player.localPlayer.worldX, Player.localPlayer.worldY, Pathfinding.arbitraryDestination == 1, 57, 89, 63);
            Pathfinding.doMinimapWalkTo(Player.localPlayer.pathY[0], Player.localPlayer.pathX[0], destX, destY, analytics);
        }
    }

    public static void handleChatButtonsClick() {
        int x = MouseHandler.clickX;
        int y = MouseHandler.clickY;
        if (frameMode == ScreenMode.FIXED) {
            x -= 6;
            y -= 467;
        } else {
            x -= 6;
            y -= drawHeight - 36;
        }
        if (MouseHandler.clickType == 1) {
            if (x >= 0 && x <= 100 && y >= 0 && y <= 32) {
                MovedStatics.redrawChatbox = true;
                ChatBox.publicChatMode = (1 + ChatBox.publicChatMode) % 4;
                ChatBox.redrawChatbox = true;
                OutgoingPackets.sendMessage(new SetChatOptionsOutboundMessage(ChatBox.publicChatMode, ChatBox.privateChatMode, ChatBox.tradeMode));
            }
            if (x >= 129 && x <= 229 && y >= 0 && y <= 32) {
                ChatBox.redrawChatbox = true;
                ChatBox.privateChatMode = (ChatBox.privateChatMode + 1) % 3;
                MovedStatics.redrawChatbox = true;
                OutgoingPackets.sendMessage(new SetChatOptionsOutboundMessage(ChatBox.publicChatMode, ChatBox.privateChatMode, ChatBox.tradeMode));
            }
            if (x >= 267 && x <= 367 && y >= 0 && y <= 32) {
                ChatBox.tradeMode = (ChatBox.tradeMode + 1) % 3;
                MovedStatics.redrawChatbox = true;
                ChatBox.redrawChatbox = true;
                OutgoingPackets.sendMessage(new SetChatOptionsOutboundMessage(ChatBox.publicChatMode, ChatBox.privateChatMode, ChatBox.tradeMode));
            }
            if (x >= 406 && x <= 506 && y >= 0 && y <= 32) {
                if (GameInterface.gameScreenInterfaceId == -1) {
                    GameInterface.closeAllWidgets();
                    if (GameInterface.reportAbuseWidgetId != -1) {
                        MovedStatics.reportMutePlayer = false;
                        GameInterface.reportAbuseInterfaceID = GameInterface.gameScreenInterfaceId = GameInterface.reportAbuseWidgetId;
                        Native.reportedName = "";
                    }
                } else {
                    ChatBox.addChatMessage("", English.pleaseCloseInterfaceBeforeReportAbuse, 0);
                }
            }
        }
    }

    public static void handleTabClick() {
        int x = MouseHandler.clickX;
        int y = MouseHandler.clickY;
        if (MouseHandler.clickType == 1) {
            if (frameMode == ScreenMode.FIXED) {
                if ((x -= 539) >= 0 && x <= 34 && (y -= 168) >= 1 && y < 37 && Game.tabWidgetIds[0] != -1) {
                    GameInterface.drawTabIcons = true;
                    GameInterface.redrawTabArea = true;
                    Game.currentTabId = 0;
                }
                if (x >= 30 && x <= 60 && y >= 0 && y < 37 && Game.tabWidgetIds[1] != -1) {
                    Game.currentTabId = 1;
                    GameInterface.redrawTabArea = true;
                    GameInterface.drawTabIcons = true;
                }
                if (x >= 58 && x <= 88 && y >= 0 && y < 37 && Game.tabWidgetIds[2] != -1) {
                    GameInterface.drawTabIcons = true;
                    Game.currentTabId = 2;
                    GameInterface.redrawTabArea = true;
                }
                if (x >= 86 && x <= 130 && y >= 0 && y < 35 && Game.tabWidgetIds[3] != -1) {
                    GameInterface.drawTabIcons = true;
                    GameInterface.redrawTabArea = true;
                    Game.currentTabId = 3;
                }
                if (x >= 127 && x <= 157 && y >= 0 && y < 37 && Game.tabWidgetIds[4] != -1) {
                    Game.currentTabId = 4;
                    GameInterface.redrawTabArea = true;
                    GameInterface.drawTabIcons = true;
                }
                if (x >= 155 && x <= 185 && y >= 0 && y < 37 && Game.tabWidgetIds[5] != -1) {
                    GameInterface.drawTabIcons = true;
                    GameInterface.redrawTabArea = true;
                    Game.currentTabId = 5;
                }
                if (x >= 183 && x <= 217 && y >= 1 && y < 37 && Game.tabWidgetIds[6] != -1) {
                    GameInterface.redrawTabArea = true;
                    Game.currentTabId = 6;
                    GameInterface.drawTabIcons = true;
                }
                if (x >= 1 && x <= 35 && y >= 298 && y < 334 && Game.tabWidgetIds[7] != -1) {
                    Game.currentTabId = 7;
                    GameInterface.drawTabIcons = true;
                    GameInterface.redrawTabArea = true;
                }
                if (x >= 33 && x <= 63 && y >= 298 && y < 335 && Game.tabWidgetIds[8] != -1) {
                    GameInterface.redrawTabArea = true;
                    GameInterface.drawTabIcons = true;
                    Game.currentTabId = 8;
                }
                if (x >= 60 && x <= 90 && y >= 298 && y < 335 && Game.tabWidgetIds[9] != -1) {
                    GameInterface.drawTabIcons = true;
                    Game.currentTabId = 9;
                    GameInterface.redrawTabArea = true;
                }
                if (x >= 88 && x <= 132 && y >= 299 && y < 334 && Game.tabWidgetIds[10] != -1) {
                    Game.currentTabId = 10;
                    GameInterface.drawTabIcons = true;
                    GameInterface.redrawTabArea = true;
                }
                if (x >= 130 && x <= 160 && y >= 298 && y < 335 && Game.tabWidgetIds[11] != -1) {
                    Game.currentTabId = 11;
                    GameInterface.redrawTabArea = true;
                    GameInterface.drawTabIcons = true;
                }
                if (x >= 157 && x <= 187 && y >= 298 && y < 335 && Game.tabWidgetIds[12] != -1) {
                    GameInterface.redrawTabArea = true;
                    GameInterface.drawTabIcons = true;
                    Game.currentTabId = 12;
                }
                if (x >= 185 && x <= 219 && y >= 298 && y < 334 && Game.tabWidgetIds[13] != -1) {
                    Game.currentTabId = 13;
                    GameInterface.redrawTabArea = true;
                    GameInterface.drawTabIcons = true;
                }
            } else if (ScreenController.isCoordinatesInExtendedTabArea(x, y)) {
                tabProducer.clickTabButton(x, y, drawWidth - 241, drawHeight - 334);
            }
        }
    }

    static {
        DebugView = false;
    }
}

