/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.frame;

import org.runejs.client.cache.media.ImageRGB;
import org.runejs.client.media.RasterizerInstanced;

public class FramePieceRenderer {
    public RasterizerInstanced rasterizerInstanced;

    public void shapeImageToPixels(ImageRGB image, int x, int y, int width, int height, int arg4, int arg5, int k1, int zoom, int[] arg8, int[] arg9) {
        try {
            int centerX = -width / 2;
            int centerY = -height / 2;
            int sine = (int)(Math.sin((double)k1 / 326.11) * 65536.0);
            int cosine = (int)(Math.cos((double)k1 / 326.11) * 65536.0);
            sine = sine * zoom >> 8;
            cosine = cosine * zoom >> 8;
            int i_125_ = (arg4 << 16) + centerY * sine + centerX * cosine;
            int i_126_ = (arg5 << 16) + centerY * cosine - centerX * sine;
            int destinationOffset = x + y * this.rasterizerInstanced.destinationWidth;
            for (y = 0; y < height; ++y) {
                int i_128_ = arg8[y];
                int i_129_ = destinationOffset + i_128_;
                int i_130_ = i_125_ + cosine * i_128_;
                int i_131_ = i_126_ - sine * i_128_;
                for (x = -arg9[y]; x < 0; ++x) {
                    int pixelToGet = (i_130_ >> 16) + (i_131_ >> 16) * image.imageWidth;
                    int colour = 0;
                    if (image.pixels.length >= pixelToGet && pixelToGet >= 0) {
                        colour = image.pixels[pixelToGet];
                    }
                    this.rasterizerInstanced.destinationPixels[i_129_++] = colour;
                    i_130_ += cosine;
                    i_131_ -= sine;
                }
                i_125_ += sine;
                i_126_ += cosine;
                destinationOffset += this.rasterizerInstanced.destinationWidth;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawImage(ImageRGB image, int x, int y) {
        int clip_width;
        int dest_offset = (x += image.offsetX) + (y += image.offsetY) * this.rasterizerInstanced.destinationWidth;
        int source_offset = 0;
        int line_count = image.imageHeight;
        int line_width = image.imageWidth;
        int line_offset_dest = this.rasterizerInstanced.destinationWidth - line_width;
        int line_offset_source = 0;
        if (y < this.rasterizerInstanced.viewportTop) {
            int clip_height = this.rasterizerInstanced.viewportTop - y;
            line_count -= clip_height;
            y = this.rasterizerInstanced.viewportTop;
            source_offset += clip_height * line_width;
            dest_offset += clip_height * this.rasterizerInstanced.destinationWidth;
        }
        if (y + line_count > this.rasterizerInstanced.viewportBottom) {
            line_count -= y + line_count - this.rasterizerInstanced.viewportBottom;
        }
        if (x < this.rasterizerInstanced.viewportLeft) {
            clip_width = this.rasterizerInstanced.viewportLeft - x;
            line_width -= clip_width;
            x = this.rasterizerInstanced.viewportLeft;
            source_offset += clip_width;
            dest_offset += clip_width;
            line_offset_source += clip_width;
            line_offset_dest += clip_width;
        }
        if (x + line_width > this.rasterizerInstanced.viewportRight) {
            clip_width = x + line_width - this.rasterizerInstanced.viewportRight;
            line_width -= clip_width;
            line_offset_source += clip_width;
            line_offset_dest += clip_width;
        }
        if (line_width > 0 && line_count > 0) {
            ImageRGB.blockCopyTrans(this.rasterizerInstanced.destinationPixels, image.pixels, 0, source_offset, dest_offset, line_width, line_count, line_offset_dest, line_offset_source);
        }
    }

    public void drawRotated(ImageRGB image, int x, int y, int pivotX, int pivotY, int width, int height, int zoom, double angle) {
        try {
            int centerX = -width / 2;
            int centerY = -height / 2;
            int sine = (int)(Math.sin(angle) * 65536.0);
            int cosine = (int)(Math.cos(angle) * 65536.0);
            sine = sine * zoom >> 8;
            cosine = cosine * zoom >> 8;
            int sourceOffsetX = (pivotX << 16) + centerY * sine + centerX * cosine;
            int sourceoffsetY = (pivotY << 16) + centerY * cosine - centerX * sine;
            int destinationOffset = x + y * this.rasterizerInstanced.destinationWidth;
            for (y = 0; y < height; ++y) {
                int i = destinationOffset;
                int offsetX = sourceOffsetX;
                int offsetY = sourceoffsetY;
                for (x = -width; x < 0; ++x) {
                    int i_166_ = image.pixels[(offsetX >> 16) + (offsetY >> 16) * image.imageWidth];
                    if (i_166_ != 0) {
                        this.rasterizerInstanced.destinationPixels[i++] = i_166_;
                    } else {
                        ++i;
                    }
                    offsetX += cosine;
                    offsetY -= sine;
                }
                sourceOffsetX += sine;
                sourceoffsetY += cosine;
                destinationOffset += this.rasterizerInstanced.destinationWidth;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

