/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.chat;

public class SocialList {
    protected long[] players;
    protected int count = 0;

    public SocialList(int size) {
        this.players = new long[size];
    }

    public int getSize() {
        return this.players.length;
    }

    public boolean isFull() {
        return this.count >= this.players.length;
    }

    public boolean isEmpty() {
        return this.count > 0;
    }

    public int getCount() {
        return this.count;
    }

    public boolean containsPlayer(long p) {
        return this.getPlayerIndex(p) != -1;
    }

    public int removePlayer(long p) {
        int index = this.getPlayerIndex(p);
        if (index == -1) {
            return -1;
        }
        --this.count;
        for (int i = index; i < this.count; ++i) {
            this.players[i] = this.players[i + 1];
        }
        return index;
    }

    public int getPlayerIndex(long p) {
        for (int i = 0; i < this.count; ++i) {
            if (this.players[i] != p) continue;
            return i;
        }
        return -1;
    }

    public long getPlayer(int index) {
        return this.players[index];
    }

    public void addPlayer(long p) {
        this.players[this.count++] = p;
    }

    public void setPlayers(long[] p) {
        this.count = p.length;
        for (int i = 0; i < p.length; ++i) {
            this.players[i] = p[i];
        }
    }
}

