/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.chat;

import org.runejs.client.cache.media.gameInterface.GameInterface;
import org.runejs.client.chat.SocialList;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.util.TextUtils;

public class FriendList
extends SocialList {
    private String[] playerUsernames;
    private int[] playerWorlds;
    private int limit;

    public FriendList(int size, int limit) {
        super(size);
        this.limit = limit;
        this.playerUsernames = new String[size];
        this.playerWorlds = new int[size];
    }

    @Override
    public int removePlayer(long p) {
        int index = super.removePlayer(p);
        if (index == -1) {
            return -1;
        }
        for (int i = index; i < this.count; ++i) {
            this.playerUsernames[i] = this.playerUsernames[i + 1];
            this.playerWorlds[i] = this.playerWorlds[i + 1];
        }
        return index;
    }

    @Override
    public void addPlayer(long p) {
        super.addPlayer(p);
        this.playerWorlds[this.count - 1] = 0;
        this.playerUsernames[this.count - 1] = TextUtils.formatName(TextUtils.longToName(p));
    }

    @Override
    public boolean isFull() {
        return this.count >= this.limit;
    }

    public void addPlayer(long p, String username, int world) {
        int newIndex = this.count++;
        this.players[newIndex] = p;
        this.playerUsernames[newIndex] = username;
        this.playerWorlds[newIndex] = world;
    }

    public String getPlayerUsername(int index) {
        return this.playerUsernames[index];
    }

    public int getPlayerWorld(int index) {
        return this.playerWorlds[index];
    }

    public boolean containsPlayerUsername(String username) {
        for (int i = 0; i < this.count; ++i) {
            if (!username.equalsIgnoreCase(this.playerUsernames[i])) continue;
            return true;
        }
        return false;
    }

    public void setPlayerWorld(int index, int world) {
        this.playerWorlds[index] = world;
    }

    public void sort() {
        boolean bool = false;
        while (!bool) {
            bool = true;
            for (int i = 0; this.count - 1 > i; ++i) {
                if ((Player.worldId == this.playerWorlds[i] || this.playerWorlds[1 + i] != Player.worldId) && (this.playerWorlds[i] != 0 || this.playerWorlds[i + 1] == 0)) continue;
                bool = false;
                int world = this.playerWorlds[i];
                this.playerWorlds[i] = this.playerWorlds[i + 1];
                this.playerWorlds[1 + i] = world;
                String name = this.playerUsernames[i];
                this.playerUsernames[i] = this.playerUsernames[1 + i];
                this.playerUsernames[1 + i] = name;
                long hash = this.players[i];
                this.players[i] = this.players[i + 1];
                this.players[1 + i] = hash;
                GameInterface.redrawTabArea = true;
            }
        }
    }
}

