/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.chat;

import java.util.Arrays;

public enum ChatShapeEffect {
    NONE(0, null),
    WAVE(1, "wave:"),
    WAVE2(2, "wave2:"),
    SHAKE(3, "shake:"),
    SCROLL(4, "scroll:"),
    SLIDE(5, "slide:");

    private final int networkCode;
    private final String prefix;

    private ChatShapeEffect(int networkCode, String prefix) {
        this.networkCode = networkCode;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getNetworkCode() {
        return this.networkCode;
    }

    public int getPrefixLength() {
        return this.prefix.length();
    }

    public static ChatShapeEffect fromString(String input) {
        return Arrays.stream(ChatShapeEffect.values()).filter(effect -> effect.getPrefix() != null).filter(effect -> input.startsWith(effect.getPrefix())).findFirst().orElse(null);
    }
}

