/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.chat;

import java.util.Arrays;

public enum ChatColorEffect {
    YELLOW(0, "yellow:"),
    RED(1, "red:"),
    GREEN(2, "green:"),
    CYAN(3, "cyan:"),
    PURPLE(4, "purple:"),
    WHITE(5, "white:"),
    FLASH1(6, "flash1:"),
    FLASH2(7, "flash2:"),
    FLASH3(8, "flash3:"),
    GLOW1(9, "glow1:"),
    GLOW2(10, "glow2:"),
    GLOW3(11, "glow3:");

    private final int networkCode;
    private final String prefix;

    private ChatColorEffect(int networkCode, String prefix) {
        this.networkCode = networkCode;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getNetworkCode() {
        return this.networkCode;
    }

    public int getPrefixLength() {
        return this.prefix.length();
    }

    public static ChatColorEffect fromString(String input) {
        return Arrays.stream(ChatColorEffect.values()).filter(effect -> input.startsWith(effect.getPrefix())).findFirst().orElse(null);
    }
}

