/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.media.textUtils;

import org.runejs.client.cache.media.textUtils.TextTagNode;

public class TextTagQueue {
    private TextTagNode head;
    private TextTagNode tail;
    private int size = 0;

    public TextTagNode peek() {
        return this.tail;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public void push(TextTagNode node) {
        if (this.tail == null) {
            this.head = node;
        } else {
            this.tail.setNext(node);
            node.setPrevious(this.tail);
        }
        this.tail = node;
    }

    public String applyAll(String targetText) {
        TextTagNode currentNode = this.head;
        while (currentNode != null) {
            targetText = currentNode.applyTo(targetText);
            currentNode = this.head.getNext();
        }
        return targetText;
    }

    public TextTagNode pop() {
        TextTagNode currentTail = this.tail;
        TextTagNode nextTail = this.tail.getPrevious();
        if (nextTail == null) {
            this.head = nextTail;
        }
        this.tail = nextTail;
        return currentTail;
    }
}

