/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.media;

import java.awt.Color;
import java.util.Random;
import org.runejs.client.MovedStatics;
import org.runejs.client.RSString;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.media.IndexedImage;
import org.runejs.client.cache.media.textUtils.TextColourNode;
import org.runejs.client.cache.media.textUtils.TextColourQueue;
import org.runejs.client.cache.media.textUtils.TextTagNode;
import org.runejs.client.cache.media.textUtils.TextTagQueue;
import org.runejs.client.media.Rasterizer;

public class TypeFace
extends Rasterizer {
    public static TypeFace fontBold;
    public static TypeFace fontSmall;
    private static String greaterThan;
    private static String lessThan;
    private static String euroSymbol;
    private static String startShadow;
    private static String softHyphen;
    private static String startTrans;
    private static String startUnderline;
    private static String startStrikethrough;
    private static String endColor;
    private static String endShadow;
    private static String endTrans;
    private static String endUnderline;
    private static String endStrikeThrough;
    private static String startDefaultUnderline;
    private static String startDefaultStrikeThrough;
    private static String startDefaultShadow;
    private static String startColor;
    private static String multiplicationSymbol;
    private static String nonBreakingSpace;
    private static String image;
    private static String copyright;
    private static String lineBreak;
    private static String italicsStart;
    private static String italicsEnd;
    private static String registeredTrademark;
    private static int strikethroughColor;
    private static boolean italics;
    private static int underlineColor;
    private static int defaultTextColor;
    private static int opacity;
    private static int defaultOpacity;
    private static int defaultShadowColor;
    private static int shadowColor;
    private static int textColor;
    private static int whiteSpace;
    private String[] aClass1Array2897 = new String[100];
    private Random random = new Random();
    private int[] characterScreenWidths;
    public int characterDefaultHeight = 0;
    private int[] characterYOffsets;
    private byte[][] characterPixels;
    private int[] characterHeights;
    private boolean strikethrough = false;
    private int anInt2919;
    private int anInt2920;
    private TextColourQueue textcolour;

    public TypeFace(int[] arg0, int[] arg1, int[] arg2, int[] arg3, byte[][] arg4) {
        this.characterYOffsets = arg0;
        this.characterScreenWidths = arg1;
        this.characterHeights = arg2;
        byte i = 0;
        for (int i_47_ = 1; i_47_ < arg3.length; ++i_47_) {
            if (arg3[i_47_] != 1) continue;
            i = (byte)i_47_;
        }
        this.characterPixels = arg4;
        int i_48_ = Integer.MAX_VALUE;
        int i_49_ = Integer.MIN_VALUE;
        for (int i_50_ = 0; i_50_ < 256; ++i_50_) {
            if (this.characterYOffsets[i_50_] < i_48_) {
                i_48_ = this.characterYOffsets[i_50_];
            }
            if (this.characterYOffsets[i_50_] + this.characterHeights[i_50_] > i_49_) {
                i_49_ = this.characterYOffsets[i_50_] + this.characterHeights[i_50_];
            }
            byte[] is = this.characterPixels[i_50_];
            int i_51_ = is.length;
            for (int i_52_ = 0; i_52_ < i_51_; ++i_52_) {
                is[i_52_] = is[i_52_] == i ? (byte)0 : 1;
            }
        }
        this.characterDefaultHeight = this.characterYOffsets[32] + this.characterHeights[32];
        this.anInt2920 = this.characterDefaultHeight - i_48_;
        this.anInt2919 = i_49_ - this.characterDefaultHeight;
    }

    public static TypeFace constructFont() {
        TypeFace class40_sub5_sub14_sub1 = new TypeFace(MovedStatics.spriteOffsetY, MovedStatics.spriteWidth, MovedStatics.spriteHeight, MovedStatics.spritePalette, MovedStatics.spritePixels);
        MovedStatics.clearDecodedSpriteData();
        return class40_sub5_sub14_sub1;
    }

    public static TypeFace getFont(CacheArchive archive, int groupId, int fileId) {
        if (!MovedStatics.decodeImageFromArchive(archive, groupId, fileId)) {
            return null;
        }
        return TypeFace.constructFont();
    }

    public static TypeFace loadTypeFace(CacheArchive imageArchive, String fontName, String always_empty) {
        int fontImageId = imageArchive.getGroupIdByName(fontName);
        int fontFileId = imageArchive.getFileIdByName(fontImageId, always_empty);
        return TypeFace.getFont(imageArchive, fontImageId, fontFileId);
    }

    public void drawText(String text, int x, int arg2, int arg3, int arg4, int colour, boolean shadow, int xAlignment, int yAlignment, int arg9) {
        if (text != null) {
            int y;
            int i = 0;
            int i_3_ = 0;
            String resultText = "";
            int i_4_ = -1;
            int i_5_ = 0;
            String stylingTag = null;
            String fontStyleTag = null;
            TextTagQueue stylingQueue = new TextTagQueue();
            TextTagQueue fontStyle = new TextTagQueue();
            if (arg9 == 0) {
                arg9 = this.anInt2920;
            }
            boolean bool = true;
            if (arg4 < this.anInt2920 + this.anInt2919 + arg9 && arg4 < arg9 + arg9) {
                bool = false;
            }
            int i_7_ = 0;
            int length = text.length();
            int index = -1;
            for (int idx = 0; idx < length; ++idx) {
                int character = text.charAt(idx);
                if (character == 92 && !this.isIgnored(idx, text)) continue;
                if (character == 60 && !this.isIgnored(idx, text)) {
                    index = idx;
                } else if (character == 62 && index != -1) {
                    String effect = text.substring(index + 1, idx);
                    int oldindex = index;
                    index = -1;
                    if (effect.equals(lessThan)) {
                        character = 60;
                    } else if (effect.equals(greaterThan)) {
                        character = 62;
                    } else if (effect.equals(nonBreakingSpace)) {
                        character = 160;
                    } else if (effect.equals(softHyphen)) {
                        character = 173;
                    } else if (effect.equals(multiplicationSymbol)) {
                        character = 215;
                    } else if (effect.equals(euroSymbol)) {
                        character = 128;
                    } else if (effect.equals(copyright)) {
                        character = 169;
                    } else {
                        if (!effect.equals(registeredTrademark)) {
                            if (effect.startsWith(image, 0)) {
                                int icon = Integer.parseInt(effect.substring(4));
                                destinationWidth += MovedStatics.moderatorIcon[icon].maxWidth;
                            }
                            if (effect.startsWith(startColor, 0)) {
                                TextTagNode stylingNode = new TextTagNode(text.substring(oldindex, idx + 1));
                                resultText = resultText + stylingNode.tag;
                                stylingQueue.push(stylingNode);
                            }
                            if (effect.startsWith(endColor, 0)) {
                                stylingTag = text.substring(oldindex, idx + 1);
                                resultText = resultText + stylingTag;
                                stylingQueue.pop();
                                stylingTag = null;
                            }
                            if (effect.startsWith(italicsStart, 0)) {
                                TextTagNode stylingNode = new TextTagNode(text.substring(oldindex, idx + 1));
                                resultText = resultText + stylingNode.tag;
                                fontStyle.push(stylingNode);
                            }
                            if (effect.startsWith(startStrikethrough, 0)) {
                                TextTagNode stylingNode = new TextTagNode(text.substring(oldindex, idx + 1));
                                resultText = resultText + stylingNode.tag;
                                fontStyle.push(stylingNode);
                            }
                            if (effect.startsWith(startDefaultStrikeThrough, 0)) {
                                TextTagNode stylingNode = new TextTagNode(text.substring(oldindex, idx + 1));
                                resultText = resultText + stylingNode.tag;
                                fontStyle.push(stylingNode);
                            }
                            if (effect.startsWith(italicsEnd, 0)) {
                                fontStyleTag = text.substring(oldindex, idx + 1);
                                resultText = resultText + fontStyleTag;
                                fontStyle.pop();
                                fontStyleTag = null;
                            }
                            if (!effect.startsWith(endStrikeThrough, 0)) continue;
                            fontStyleTag = text.substring(oldindex, idx + 1);
                            resultText = resultText + fontStyleTag;
                            fontStyle.pop();
                            fontStyleTag = null;
                            continue;
                        }
                        character = 174;
                    }
                }
                if (character == 64 && idx + 4 < length && text.charAt(idx + 4) == '@') {
                    stylingTag = text.substring(idx, idx + 5);
                    resultText = resultText + stylingTag;
                    idx += 4;
                    continue;
                }
                if (character == 92 && idx + 1 < length && text.charAt(idx + 1) == 'n') {
                    stylingTag = null;
                    fontStyleTag = null;
                    this.aClass1Array2897[i_7_++] = resultText.substring(i_3_).trim();
                    i_3_ = resultText.length();
                    i = 0;
                    i_4_ = -1;
                    ++idx;
                    continue;
                }
                if (index != -1) continue;
                resultText = resultText + (char)character;
                i += this.method689(character);
                if (character == 32 || character == 45) {
                    i_4_ = resultText.length();
                    i_5_ = i;
                }
                if (!bool || i <= arg3 || i_4_ < 0) continue;
                this.aClass1Array2897[i_7_++] = resultText.substring(i_3_, i_4_).trim();
                i_3_ = i_4_;
                i_4_ = -1;
                i -= i_5_;
                if (!stylingQueue.isEmpty() && i_3_ > 4 && !fontStyle.isEmpty()) {
                    resultText = stylingQueue.applyAll(resultText);
                    resultText = fontStyle.applyAll(resultText);
                    continue;
                }
                if (stylingTag == null || i_3_ <= 4) continue;
                RSString.prepend(resultText, stylingTag, i_3_ -= 5);
            }
            int strlenght = this.getStringTextWidth(resultText);
            if (strlenght > i_3_) {
                this.aClass1Array2897[i_7_++] = resultText.substring(i_3_, resultText.length()).trim();
            }
            if (yAlignment == 3 && i_7_ == 1) {
                yAlignment = 1;
            }
            if (yAlignment == 0) {
                y = arg2 + this.anInt2920;
            } else if (yAlignment == 1) {
                y = arg2 + this.anInt2920 + (arg4 - this.anInt2920 - this.anInt2919 - (i_7_ - 1) * arg9) / 2;
            } else if (yAlignment == 2) {
                y = arg2 + arg4 - this.anInt2919 - (i_7_ - 1) * arg9;
            } else {
                int i_12_ = (arg4 - this.anInt2920 - this.anInt2919 - (i_7_ - 1) * arg9) / (i_7_ + 1);
                if (i_12_ < 0) {
                    i_12_ = 0;
                }
                y = arg2 + this.anInt2920 + i_12_;
                arg9 += i_12_;
            }
            for (int i_13_ = 0; i_13_ < i_7_; ++i_13_) {
                if (xAlignment == 0) {
                    this.drawShadowedString(this.aClass1Array2897[i_13_], x, y, shadow, colour);
                } else if (xAlignment == 1) {
                    this.drawShadowedStringCenter(this.aClass1Array2897[i_13_], x + arg3 / 2, y, colour, shadow);
                } else if (xAlignment == 2) {
                    this.drawShadowedStringRight(this.aClass1Array2897[i_13_], x + arg3, y, colour, shadow);
                } else if (i_13_ == i_7_ - 1) {
                    this.drawShadowedString(this.aClass1Array2897[i_13_], x, y, shadow, colour);
                } else {
                    System.out.println("Using Weird print");
                }
                y += arg9;
            }
        }
    }

    public void drawText(RSString text, int arg1, int arg2, int arg3, int arg4, int arg5, boolean arg6, int arg7, int arg8, int arg9) {
        this.drawText(text.toString(), arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public void drawShadowedStringRight(String arg0, int arg1, int arg2, int arg3, boolean arg4) {
        this.drawShadowedString(arg0, arg1 - this.getTextDisplayedWidth(arg0), arg2, arg4, arg3);
    }

    public int getTextDisplayedWidth(RSString string) {
        return this.getStringWidth(string.toString());
    }

    public int getTextDisplayedWidth(String string) {
        return this.getStringWidth(string);
    }

    public void drawShadowedString(RSString string, int x, int y, boolean shadowed, int colour) {
        this.drawShadowedString(string.toString(), x, y, shadowed, colour);
    }

    public int getStringWidth(RSString string) {
        return this.getStringWidth(string.toString());
    }

    public void drawShadowedStringCenter(String str, int drawX, int drawY, int colour, boolean shadowed) {
        this.drawShadowedString(str, drawX - this.getStringWidth(str) / 2, drawY, shadowed, colour);
    }

    public int method689(int arg0) {
        return this.characterScreenWidths[arg0 & 0xFF];
    }

    public void drawString(RSString string, int x, int y, int colour) {
        this.drawString(string.toString(), x, y, colour);
    }

    public void drawStringRight(String string, int x, int y, int colour) {
        this.drawString(string, x - this.getStringWidth(string), y, colour);
    }

    public void drawStringLeft(String string, int x, int y, int colour) {
        this.drawString(string, x - this.getStringWidth(string) / 2, y, colour);
    }

    public int getStringEffectWidth(String string) {
        return this.getStringWidth(string);
    }

    public final int getStringWidth(String string) {
        if (string == null) {
            return 0;
        }
        int index = -1;
        int width = 0;
        int length = string.length();
        for (int idx = 0; idx < length; ++idx) {
            int character = string.charAt(idx);
            if (character == 92 && !this.isIgnored(idx, string)) continue;
            if (character == 60 && !this.isIgnored(idx, string)) {
                index = idx;
                continue;
            }
            if (character == 62 && index != -1) {
                String effect = string.substring(index + 1, idx);
                index = -1;
                if (effect.equals(lessThan)) {
                    character = 60;
                } else if (effect.equals(greaterThan)) {
                    character = 62;
                } else if (effect.equals(nonBreakingSpace)) {
                    character = 160;
                } else if (effect.equals(softHyphen)) {
                    character = 173;
                } else if (effect.equals(multiplicationSymbol)) {
                    character = 215;
                } else if (effect.equals(euroSymbol)) {
                    character = 128;
                } else if (effect.equals(copyright)) {
                    character = 169;
                } else {
                    if (!effect.equals(registeredTrademark)) {
                        if (!effect.startsWith(image, 0)) continue;
                        try {
                            int icon = Integer.parseInt(effect.substring(4));
                            width += MovedStatics.moderatorIcon[icon].maxWidth;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    character = 174;
                }
            }
            if (character == 64 && idx + 4 < string.length() && string.charAt(idx + 4) == '@') {
                idx += 4;
                continue;
            }
            if (index != -1) continue;
            width += this.characterScreenWidths[character];
        }
        return width;
    }

    public final int getStringTextWidth(String string) {
        if (string == null) {
            return 0;
        }
        int index = -1;
        int width = 0;
        int length = string.length();
        for (int idx = 0; idx < length; ++idx) {
            int character = string.charAt(idx);
            if (character == 92 && !this.isIgnored(idx, string)) continue;
            if (character == 60 && !this.isIgnored(idx, string)) {
                index = idx;
                continue;
            }
            if (character == 62 && index != -1) {
                String effect = string.substring(index + 1, idx);
                index = -1;
                if (effect.equals(lessThan)) {
                    character = 60;
                } else if (effect.equals(greaterThan)) {
                    character = 62;
                } else if (effect.equals(nonBreakingSpace)) {
                    character = 160;
                } else if (effect.equals(softHyphen)) {
                    character = 173;
                } else if (effect.equals(multiplicationSymbol)) {
                    character = 215;
                } else if (effect.equals(euroSymbol)) {
                    character = 128;
                } else if (effect.equals(copyright)) {
                    character = 169;
                } else {
                    if (!effect.equals(registeredTrademark)) {
                        if (!effect.startsWith(image, 0)) continue;
                        try {
                            int icon = Integer.parseInt(effect.substring(4));
                            width += MovedStatics.moderatorIcon[icon].maxWidth;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    character = 174;
                }
            }
            if (character == 64 && idx + 4 < string.length() && string.charAt(idx + 4) == '@') {
                idx += 4;
                continue;
            }
            if (index != -1 || character == 0) continue;
            ++width;
        }
        return width;
    }

    public void drawString(String string, int x, int y, int colour) {
        this.drawString(string, x, y, colour, -1);
    }

    public void drawCenteredStringWaveY(String string, int x, int y, int wave, int colour) {
        if (string == null) {
            return;
        }
        x -= this.getStringWidth(string) / 2;
        y -= this.characterDefaultHeight;
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            if (character != ' ') {
                this.drawCharacterLegacy(this.characterPixels[character], x, y + this.characterYOffsets[character] + (int)(Math.sin((double)index / 2.0 + (double)wave / 5.0) * 5.0), this.characterScreenWidths[character], this.characterHeights[character], colour);
            }
            x += this.characterScreenWidths[character];
        }
    }

    public void drawCenteredString(String text, int x, int y, int color, int shadow) {
        if (text != null) {
            this.setEffects(color, shadow);
            this.drawBasicString(text, x - this.getStringWidth(text) / 2, y);
        }
    }

    public void drawCenteredStringWaveXY(String string, int x, int y, int wave, int colour) {
        if (string == null) {
            return;
        }
        x -= this.getStringWidth(string) / 2;
        y -= this.characterDefaultHeight;
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            if (character != ' ') {
                this.drawCharacterLegacy(this.characterPixels[character], x + (int)(Math.sin((double)index / 5.0 + (double)wave / 5.0) * 5.0), y + this.characterYOffsets[character] + (int)(Math.sin((double)index / 3.0 + (double)wave / 5.0) * 5.0), this.characterScreenWidths[character], this.characterHeights[character], colour);
            }
            x += this.characterScreenWidths[character];
        }
    }

    public void drawCenteredStringWaveXYMove(String string, int x, int y, int waveAmount, int waveSpeed, int colour) {
        if (string == null) {
            return;
        }
        double speed = 7.0 - (double)waveSpeed / 8.0;
        if (speed < 0.0) {
            speed = 0.0;
        }
        x -= this.getStringWidth(string) / 2;
        y -= this.characterDefaultHeight;
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            if (character != ' ') {
                this.drawCharacterLegacy(this.characterPixels[character], x, y + this.characterYOffsets[character] + (int)(Math.sin((double)index / 1.5 + (double)waveAmount) * speed), this.characterScreenWidths[character], this.characterHeights[character], colour);
            }
            x += this.characterScreenWidths[character];
        }
    }

    public void drawShadowedString(String string, int x, int y, boolean shadow, int colour) {
        if (shadow) {
            this.setEffects(colour, 0);
        } else {
            this.setEffects(colour, -1);
        }
        this.drawBasicString(string, x, y);
    }

    public void drawShadowedSeededAlphaString(String string, int x, int y, int colour, boolean shadowed, int seed) {
        if (string == null) {
            return;
        }
        this.random.setSeed(seed);
        int alpha = 192 + (this.random.nextInt() & 0x1F);
        if (shadowed) {
            this.setEffectsAlpha(colour, 0, alpha);
        } else {
            this.setEffectsAlpha(colour, -1, alpha);
        }
        this.drawBasicString(string, x, y);
    }

    public int getColour(String code) {
        if (code.equals("red")) {
            return 0xFF0000;
        }
        if (code.equals("gre")) {
            return 65280;
        }
        if (code.equals("blu")) {
            return 255;
        }
        if (code.equals("yel")) {
            return 0xFFFF00;
        }
        if (code.equals("cya")) {
            return 65535;
        }
        if (code.equals("mag")) {
            return 0xFF00FF;
        }
        if (code.equals("whi")) {
            return 0xFFFFFF;
        }
        if (code.equals("bla")) {
            return 0;
        }
        if (code.equals("lre")) {
            return 16748608;
        }
        if (code.equals("dre")) {
            return 0x800000;
        }
        if (code.equals("dbl")) {
            return 128;
        }
        if (code.equals("or1")) {
            return 0xFFB000;
        }
        if (code.equals("or2")) {
            return 0xFF7000;
        }
        if (code.equals("or3")) {
            return 0xFF3000;
        }
        if (code.equals("gr1")) {
            return 0xC0FF00;
        }
        if (code.equals("gr2")) {
            return 0x80FF00;
        }
        if (code.equals("gr3")) {
            return 0x40FF00;
        }
        if (code.equals("str")) {
            strikethroughColor = 0;
        }
        if (code.equals("end")) {
            strikethroughColor = -1;
        }
        return -1;
    }

    public void drawCharacter(int character, int x, int y, int width, int height, int colour) {
        int rasterizerPixel = x + y * Rasterizer.destinationWidth;
        int rasterizerPixelOffset = Rasterizer.destinationWidth - width;
        int characterPixelOffset = 0;
        int characterPixel = 0;
        if (y < Rasterizer.viewportTop) {
            int offsetY = Rasterizer.viewportTop - y;
            height -= offsetY;
            y = Rasterizer.viewportTop;
            characterPixel += offsetY * width;
            rasterizerPixel += offsetY * Rasterizer.destinationWidth;
        }
        if (y + height > Rasterizer.viewportBottom) {
            height -= y + height - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            int offsetX = Rasterizer.viewportLeft - x;
            width -= offsetX;
            x = Rasterizer.viewportLeft;
            characterPixel += offsetX;
            rasterizerPixel += offsetX;
            characterPixelOffset += offsetX;
            rasterizerPixelOffset += offsetX;
        }
        if (x + width > Rasterizer.viewportRight) {
            int endOffsetX = x + width - Rasterizer.viewportRight;
            width -= endOffsetX;
            characterPixelOffset += endOffsetX;
            rasterizerPixelOffset += endOffsetX;
        }
        if (width > 0 && height > 0) {
            this.drawCharacterPixels(this.characterPixels[character], Rasterizer.destinationPixels, characterPixel, rasterizerPixel, characterPixelOffset, rasterizerPixelOffset, width, height, colour);
        }
    }

    public void drawCharacterItalics(int character, int x, int y, int width, int height, int colour) {
        int rasterizerPixel = x + y * Rasterizer.destinationWidth;
        int rasterizerPixelOffset = Rasterizer.destinationWidth - width;
        int characterPixelOffset = 0;
        int characterPixel = 0;
        if (y < Rasterizer.viewportTop) {
            int offsetY = Rasterizer.viewportTop - y;
            height -= offsetY;
            y = Rasterizer.viewportTop;
            characterPixel += offsetY * width;
            rasterizerPixel += offsetY * Rasterizer.destinationWidth;
        }
        if (y + height > Rasterizer.viewportBottom) {
            height -= y + height - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            int offsetX = Rasterizer.viewportLeft - x;
            width -= offsetX;
            x = Rasterizer.viewportLeft;
            characterPixel += offsetX;
            rasterizerPixel += offsetX;
            characterPixelOffset += offsetX;
            rasterizerPixelOffset += offsetX;
        }
        if (x + width > Rasterizer.viewportRight) {
            int endOffsetX = x + width - Rasterizer.viewportRight;
            width -= endOffsetX;
            characterPixelOffset += endOffsetX;
            rasterizerPixelOffset += endOffsetX;
        }
        if (width > 0 && height > 0) {
            this.drawCharacterPixelsItalic(this.characterPixels[character], Rasterizer.destinationPixels, characterPixel, rasterizerPixel, characterPixelOffset, rasterizerPixelOffset, width, height, colour);
        }
    }

    public void drawCharacterLegacy(byte[] pixels, int x, int y, int width, int height, int colour) {
        int rasterizerPixel = x + y * Rasterizer.destinationWidth;
        int remainingWidth = Rasterizer.destinationWidth - width;
        int characterPixelOffset = 0;
        int characterPixel = 0;
        if (y < Rasterizer.viewportTop) {
            int offsetY = Rasterizer.viewportTop - y;
            height -= offsetY;
            y = Rasterizer.viewportTop;
            characterPixel += offsetY * width;
            rasterizerPixel += offsetY * Rasterizer.destinationWidth;
        }
        if (y + height >= Rasterizer.viewportBottom) {
            height -= y + height - Rasterizer.viewportBottom + 1;
        }
        if (x < Rasterizer.viewportLeft) {
            int offsetX = Rasterizer.viewportLeft - x;
            width -= offsetX;
            x = Rasterizer.viewportLeft;
            characterPixel += offsetX;
            rasterizerPixel += offsetX;
            characterPixelOffset += offsetX;
            remainingWidth += offsetX;
        }
        if (x + width >= Rasterizer.viewportRight) {
            int endOffsetX = x + width - Rasterizer.viewportRight + 1;
            width -= endOffsetX;
            characterPixelOffset += endOffsetX;
            remainingWidth += endOffsetX;
        }
        if (width > 0 && height > 0) {
            this.drawCharacterPixels(pixels, Rasterizer.destinationPixels, characterPixel, rasterizerPixel, characterPixelOffset, remainingWidth, width, height, colour);
        }
    }

    public void drawCharacterPixelsItalic(byte[] characterPixels, int[] rasterizerPixels, int characterPixel, int rasterizerPixel, int characterPixelOffset, int rasterizerPixelOffset, int width, int height, int colour) {
        int shouldItalic = 0;
        int negativeQuaterWidth = -(width >> 2);
        width = -(width & 3);
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            int widthCounter;
            for (widthCounter = negativeQuaterWidth; widthCounter < 0; ++widthCounter) {
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                } else {
                    ++rasterizerPixel;
                }
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                } else {
                    ++rasterizerPixel;
                }
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                } else {
                    ++rasterizerPixel;
                }
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                    continue;
                }
                ++rasterizerPixel;
            }
            for (widthCounter = width; widthCounter < 0; ++widthCounter) {
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                    continue;
                }
                ++rasterizerPixel;
            }
            if (++shouldItalic > 3) {
                rasterizerPixel += rasterizerPixelOffset - 1;
                shouldItalic = 0;
            } else {
                rasterizerPixel += rasterizerPixelOffset;
            }
            characterPixel += characterPixelOffset;
        }
    }

    public void drawCharacterPixels(byte[] characterPixels, int[] rasterizerPixels, int characterPixel, int rasterizerPixel, int characterPixelOffset, int rasterizerPixelOffset, int width, int height, int colour) {
        int negativeQuaterWidth = -(width >> 2);
        width = -(width & 3);
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            int widthCounter;
            for (widthCounter = negativeQuaterWidth; widthCounter < 0; ++widthCounter) {
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                } else {
                    ++rasterizerPixel;
                }
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                } else {
                    ++rasterizerPixel;
                }
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                } else {
                    ++rasterizerPixel;
                }
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                    continue;
                }
                ++rasterizerPixel;
            }
            for (widthCounter = width; widthCounter < 0; ++widthCounter) {
                if (characterPixels[characterPixel++] != 0) {
                    rasterizerPixels[rasterizerPixel++] = colour;
                    continue;
                }
                ++rasterizerPixel;
            }
            rasterizerPixel += rasterizerPixelOffset;
            characterPixel += characterPixelOffset;
        }
    }

    public void setEffectsAlpha(int color, int shadow, int opac) {
        strikethroughColor = -1;
        underlineColor = -1;
        defaultShadowColor = shadow;
        shadowColor = shadow;
        defaultTextColor = color;
        textColor = color;
        defaultOpacity = opac;
        opacity = opac;
        whiteSpace = 0;
    }

    public void parseStringForEffects(String string) {
        try {
            if (string.startsWith(startColor)) {
                String color = string.substring(4);
                textColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
                this.textcolour.push(new TextColourNode(textColor));
            } else if (string.equals(endColor)) {
                this.textcolour.pop();
                textColor = this.textcolour.getColour();
            } else if (string.startsWith(startTrans)) {
                opacity = Integer.valueOf(string.substring(6));
            } else if (string.equals(endTrans)) {
                opacity = defaultOpacity;
            } else if (string.startsWith(startStrikethrough)) {
                String color = string.substring(4);
                strikethroughColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.startsWith(italicsStart)) {
                italics = true;
            } else if (string.startsWith(italicsEnd)) {
                italics = false;
            } else if (string.equals(startDefaultStrikeThrough)) {
                strikethroughColor = 0x800000;
            } else if (string.equals(endStrikeThrough)) {
                strikethroughColor = -1;
            } else if (string.startsWith(startUnderline)) {
                String color = string.substring(2);
                underlineColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(startDefaultUnderline)) {
                underlineColor = 0;
            } else if (string.equals(endUnderline)) {
                underlineColor = -1;
            } else if (string.startsWith(startShadow)) {
                String color = string.substring(5);
                shadowColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(startDefaultShadow)) {
                shadowColor = 0;
            } else if (string.equals(endShadow)) {
                shadowColor = defaultShadowColor;
            } else {
                if (!string.equals(lineBreak)) {
                    return;
                }
                this.setEffectsAlpha(defaultTextColor, defaultShadowColor, defaultOpacity);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void drawBasicStringXYMods(String string, int drawX, int drawY, int[] xmodifiers, int[] ymodifiers) {
        drawY -= this.characterDefaultHeight;
        int effect = -1;
        int var7 = 0;
        int modifier = 0;
        int length = string.length();
        for (int pos = 0; pos < length; ++pos) {
            int symbolWidth;
            int yOffset;
            int xOff;
            int character = string.charAt(pos);
            if (character == 92 && !this.isIgnored(pos, string)) continue;
            if (character == 60 && !this.isIgnored(pos, string)) {
                effect = pos;
                continue;
            }
            if (character == 62 && effect != -1) {
                String symbol = string.substring(pos, effect + 1);
                effect = -1;
                if (symbol.equals(lessThan)) {
                    character = 60;
                } else if (symbol.equals(greaterThan)) {
                    character = 62;
                } else if (symbol.equals(nonBreakingSpace)) {
                    character = 160;
                } else if (symbol.equals(softHyphen)) {
                    character = 173;
                } else if (symbol.equals(multiplicationSymbol)) {
                    character = 215;
                } else if (symbol.equals(euroSymbol)) {
                    character = 128;
                } else if (symbol.equals(copyright)) {
                    character = 169;
                } else {
                    if (!symbol.equals(registeredTrademark)) {
                        if (symbol.startsWith(image, 0)) {
                            try {
                                xOff = xmodifiers == null ? 0 : xmodifiers[modifier];
                                yOffset = ymodifiers == null ? 0 : ymodifiers[modifier];
                                ++modifier;
                                symbolWidth = Integer.parseInt(symbol.substring(4));
                                IndexedImage image = MovedStatics.moderatorIcon[symbolWidth];
                                int imageHeight = image.maxHeight;
                                if (opacity == 256) {
                                    image.drawImage(drawX + xOff, drawY + this.characterDefaultHeight - imageHeight + yOffset);
                                } else {
                                    image.drawImageAlpha(drawX + xOff, drawY + this.characterDefaultHeight - imageHeight + yOffset, opacity);
                                }
                                drawX += IndexedImage.destinationWidth;
                                var7 = 0;
                            }
                            catch (Exception image) {}
                            continue;
                        }
                        this.parseStringForEffects(symbol);
                        continue;
                    }
                    character = 174;
                }
            }
            if (character == 64 && character + 4 < string.length() && string.charAt(character + 4) == '@') {
                int stringColour = this.getColour(string.substring(character + 1, character + 4));
                if (stringColour != -1) {
                    textColor = stringColour;
                }
                pos += 4;
                continue;
            }
            if (effect != -1) continue;
            int cWidth = this.characterScreenWidths[character];
            xOff = this.characterHeights[character];
            yOffset = xmodifiers == null ? 0 : xmodifiers[modifier];
            symbolWidth = ymodifiers == null ? 0 : ymodifiers[modifier];
            ++modifier;
            if (character != 32) {
                if (opacity == 256) {
                    if (shadowColor != -1) {
                        this.drawCharacter(character, drawX + 1 + yOffset, drawY + this.characterYOffsets[character] + 1 + symbolWidth, cWidth, xOff, shadowColor);
                    }
                    this.drawCharacter(character, drawX + yOffset, drawY + this.characterYOffsets[character] + symbolWidth, cWidth, xOff, this.textcolour.getColour());
                } else {
                    if (shadowColor != -1) {
                        this.drawCharacterAlpha(character, drawX + 1 + yOffset, drawY + this.characterYOffsets[character] + 1 + symbolWidth, cWidth, xOff, shadowColor, opacity);
                    }
                    this.drawCharacterAlpha(character, drawX + yOffset, drawY + this.characterYOffsets[character] + symbolWidth, cWidth, xOff, this.textcolour.getColour(), opacity);
                }
            }
            int charWidth = this.characterScreenWidths[character];
            if (strikethroughColor != -1) {
                if (opacity > 255) {
                    Rasterizer.drawHorizontalLine(drawX, drawY + (int)((double)this.characterDefaultHeight * 0.7), charWidth, strikethroughColor);
                } else {
                    Rasterizer.drawHorizontalLineAlpha(drawX, drawY + (int)((double)this.characterDefaultHeight * 0.7), charWidth, strikethroughColor, opacity);
                }
            }
            if (underlineColor != -1) {
                if (opacity > 255) {
                    Rasterizer.drawHorizontalLine(drawX, drawY + this.characterDefaultHeight, charWidth, underlineColor);
                } else {
                    Rasterizer.drawHorizontalLineAlpha(drawX, drawY + this.characterDefaultHeight, charWidth, underlineColor, opacity);
                }
            }
            drawX += charWidth;
            var7 = character;
        }
    }

    public void drawString(String string, int x, int y, int color, int shadow) {
        if (string != null) {
            this.setEffects(color, shadow);
            this.drawBasicString(string, x, y);
        }
    }

    public void drawStringAlignedLeft(String string, int x, int y, int color, int shadow) {
        if (string != null) {
            this.setEffects(color, shadow);
            this.drawBasicString(string, x - this.getStringWidth(string), y);
        }
    }

    public void drawStringWave(String string, int x, int y, int color, int shadow, int var6) {
        if (string != null) {
            this.setEffects(color, shadow);
            int length = string.length();
            int[] var8 = new int[length];
            int[] var9 = new int[length];
            for (int pos = 0; pos < length; ++pos) {
                var8[pos] = (int)(Math.sin((double)pos / 5.0 + (double)var6 / 5.0) * 5.0);
                var9[pos] = (int)(Math.sin((double)pos / 3.0 + (double)var6 / 5.0) * 5.0);
            }
            this.drawBasicStringXYMods(string, x - this.getStringWidth(string) / 2, y, var8, var9);
        }
    }

    public void drawStringWaveY(String string, int x, int y, int color, int shadow, int tick) {
        if (string != null) {
            this.setEffects(color, shadow);
            int var7 = string.length();
            int[] vertWaveOffset = new int[var7];
            for (int whichChar = 0; whichChar < var7; ++whichChar) {
                vertWaveOffset[whichChar] = (int)(Math.sin((double)whichChar / 2.0 + (double)tick / 5.0) * 5.0);
            }
            this.drawBasicStringXYMods(string, x - this.getStringWidth(string) / 2, y, null, vertWaveOffset);
        }
    }

    public void drawCenteredStringXMod(String var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        if (var1 != null) {
            this.setEffects(var4, var5);
            double amplitude = 7.0 - (double)var7 / 8.0;
            if (amplitude < 0.0) {
                amplitude = 0.0;
            }
            int length = var1.length();
            int[] xmod = new int[length];
            for (int pos = 0; pos < length; ++pos) {
                xmod[pos] = (int)(Math.sin((double)pos / 1.5 + (double)var6 / 1.0) * amplitude);
            }
            this.drawBasicStringXYMods(var1, var2 - this.getStringWidth(var1) / 2, var3, null, xmod);
        }
    }

    public void setEffects(int color, int shadow) {
        strikethroughColor = -1;
        underlineColor = -1;
        defaultShadowColor = shadow;
        shadowColor = shadow;
        defaultTextColor = color;
        textColor = color;
        defaultOpacity = 256;
        opacity = 256;
        whiteSpace = 0;
    }

    public void drawBasicString(String string, int x, int y) {
        y -= this.characterDefaultHeight;
        int effectIndex = -1;
        int var5 = 0;
        int textLength = string.length();
        this.textcolour = new TextColourQueue(defaultTextColor);
        for (int character = 0; character < textLength; ++character) {
            int c = string.charAt(character);
            if (c > 255) {
                c = 32;
            }
            if (c == 92 && !this.isIgnored(character, string)) continue;
            if (c == 60 && !this.isIgnored(character, string)) {
                effectIndex = character;
                continue;
            }
            if (c == 62 && effectIndex != -1) {
                String effectString = string.substring(effectIndex + 1, character);
                effectIndex = -1;
                if (effectString.equals(lessThan)) {
                    c = 60;
                } else if (effectString.equals(greaterThan)) {
                    c = 62;
                } else if (effectString.equals(nonBreakingSpace)) {
                    c = 160;
                } else if (effectString.equals(softHyphen)) {
                    c = 173;
                } else if (effectString.equals(multiplicationSymbol)) {
                    c = 215;
                } else if (effectString.equals(euroSymbol)) {
                    c = 128;
                } else if (effectString.equals(copyright)) {
                    c = 169;
                } else {
                    if (!effectString.equals(registeredTrademark)) {
                        if (effectString.startsWith(image, 0)) {
                            try {
                                int icon = Integer.valueOf(effectString.substring(4));
                                IndexedImage nameIcon = MovedStatics.moderatorIcon[icon];
                                int imageHeight = nameIcon.maxHeight;
                                if (opacity == 256) {
                                    nameIcon.drawImage(x, y + this.characterDefaultHeight - imageHeight);
                                } else {
                                    nameIcon.drawImageAlpha(x, y + this.characterDefaultHeight - imageHeight, opacity);
                                }
                                x += nameIcon.maxWidth;
                                var5 = 0;
                            }
                            catch (Exception icon) {}
                            continue;
                        }
                        this.parseStringForEffects(effectString);
                        continue;
                    }
                    c = 174;
                }
            }
            if (c == 64 && character + 4 < string.length() && string.charAt(character + 4) == '@') {
                int stringColour = this.getColour(string.substring(character + 1, character + 4));
                if (stringColour != -1) {
                    textColor = stringColour;
                    this.textcolour.push(new TextColourNode(textColor));
                }
                character += 4;
                continue;
            }
            if (effectIndex != -1) continue;
            int width = this.characterScreenWidths[c];
            int height = this.characterHeights[c];
            if (c != 32) {
                if (opacity == 256) {
                    if (shadowColor != -1) {
                        if (italics) {
                            this.drawCharacterItalics(c, x + 1, y + this.characterYOffsets[c] + 1, width, height, shadowColor);
                        } else {
                            this.drawCharacter(c, x + 1, y + this.characterYOffsets[c] + 1, width, height, shadowColor);
                        }
                    }
                    if (italics) {
                        this.drawCharacterItalics(c, x, y + this.characterYOffsets[c], width, height, this.textcolour.getColour());
                    } else {
                        this.drawCharacter(c, x, y + this.characterYOffsets[c], width, height, this.textcolour.getColour());
                    }
                } else {
                    if (shadowColor != -1) {
                        if (italics) {
                            this.drawCharacterAlphaItalics(c, x + 1, y + this.characterYOffsets[c] + 1, width, height, shadowColor, opacity);
                        } else {
                            this.drawCharacterAlpha(c, x + 1, y + this.characterYOffsets[c] + 1, width, height, shadowColor, opacity);
                        }
                    }
                    if (italics) {
                        this.drawCharacterAlphaItalics(c, x, y + this.characterYOffsets[c], width, height, this.textcolour.getColour(), opacity);
                    } else {
                        this.drawCharacterAlpha(c, x, y + this.characterYOffsets[c], width, height, this.textcolour.getColour(), opacity);
                    }
                }
            }
            int charWidth = this.characterScreenWidths[c];
            if (strikethroughColor != -1) {
                Rasterizer.drawHorizontalLine(x, y + (int)((double)this.characterDefaultHeight * 0.7), charWidth, strikethroughColor);
            }
            if (underlineColor != -1) {
                Rasterizer.drawHorizontalLine(x, y + this.characterDefaultHeight + 1, charWidth, underlineColor);
            }
            x += charWidth;
            var5 = c;
        }
    }

    private boolean isIgnored(int index, String text) {
        boolean isTag = false;
        boolean isNextTag = false;
        if (index < text.length() && text.charAt(index) == '<') {
            isTag = true;
        }
        if (index < text.length() - 1 && text.charAt(index + 1) == '<') {
            isNextTag = true;
        }
        if (index > 0 && text.charAt(index - 1) == '\\') {
            return isTag;
        }
        if (isNextTag) {
            return false;
        }
        return !isTag;
    }

    public void drawBasicStringLegacy(String string, int x, int y) {
        y -= this.characterDefaultHeight;
        int effectIndex = -1;
        int var5 = 0;
        int textLength = string.length();
        this.textcolour = new TextColourQueue(defaultTextColor);
        for (int character = 0; character < textLength; ++character) {
            int c = string.charAt(character);
            if (c > 255) {
                c = 32;
            }
            if (c == 64 && character + 4 < string.length() && string.charAt(character + 4) == '@') {
                int stringColour = this.getColour(string.substring(character + 1, character + 4));
                if (stringColour != -1) {
                    textColor = stringColour;
                    this.textcolour.push(new TextColourNode(textColor));
                }
                character += 4;
                continue;
            }
            int width = this.characterScreenWidths[c];
            int height = this.characterHeights[c];
            if (c != 32) {
                if (opacity == 256) {
                    if (shadowColor != -1) {
                        this.drawCharacter(c, x + 1, y + this.characterYOffsets[c] + 1, width, height, shadowColor);
                    }
                    this.drawCharacter(c, x, y + this.characterYOffsets[c], width, height, this.textcolour.getColour());
                } else {
                    if (shadowColor != -1) {
                        this.drawCharacterAlpha(c, x + 1, y + this.characterYOffsets[c] + 1, width, height, shadowColor, opacity);
                    }
                    this.drawCharacterAlpha(c, x, y + this.characterYOffsets[c], width, height, this.textcolour.getColour(), opacity);
                }
            }
            int charWidth = this.characterScreenWidths[c];
            if (strikethroughColor != -1) {
                Rasterizer.drawHorizontalLine(x, y + (int)((double)this.characterDefaultHeight * 0.7), charWidth, strikethroughColor);
            }
            if (underlineColor != -1) {
                Rasterizer.drawHorizontalLine(x, y + this.characterDefaultHeight + 1, charWidth, underlineColor);
            }
            x += charWidth;
            var5 = c;
        }
    }

    public void drawCharacterAlpha(int character, int x, int y, int width, int height, int colour, int alpha) {
        this.drawAlphaCharacter(this.characterPixels[character], x, y, width, height, colour, alpha);
    }

    public void drawCharacterAlphaItalics(int character, int x, int y, int width, int height, int colour, int alpha) {
        this.drawAlphaCharacterItalics(this.characterPixels[character], x, y, width, height, colour, alpha);
    }

    public void drawAlphaCharacter(byte[] characterPixels, int x, int y, int width, int height, int colour, int alpha) {
        int rasterizerPixel = x + y * Rasterizer.destinationWidth;
        int rasterizerPixelOffset = Rasterizer.destinationWidth - width;
        int characterPixelOffset = 0;
        int characterPixel = 0;
        if (y < Rasterizer.viewportTop) {
            int yOffset = Rasterizer.viewportTop - y;
            height -= yOffset;
            y = Rasterizer.viewportTop;
            characterPixel += yOffset * width;
            rasterizerPixel += yOffset * Rasterizer.destinationWidth;
        }
        if (y + height >= Rasterizer.viewportBottom) {
            height -= y + height - Rasterizer.viewportBottom + 1;
        }
        if (x < Rasterizer.viewportLeft) {
            int xOffset = Rasterizer.viewportLeft - x;
            width -= xOffset;
            x = Rasterizer.viewportLeft;
            characterPixel += xOffset;
            rasterizerPixel += xOffset;
            characterPixelOffset += xOffset;
            rasterizerPixelOffset += xOffset;
        }
        if (x + width >= Rasterizer.viewportRight) {
            int widthoffset = x + width - Rasterizer.viewportRight + 1;
            width -= widthoffset;
            characterPixelOffset += widthoffset;
            rasterizerPixelOffset += widthoffset;
        }
        if (width > 0 && height > 0) {
            this.drawCharacterPixelsAlpha(characterPixel, rasterizerPixelOffset, characterPixelOffset, rasterizerPixel, alpha, Rasterizer.destinationPixels, colour, height, width, characterPixels);
        }
    }

    public void drawAlphaCharacterItalics(byte[] characterPixels, int x, int y, int width, int height, int colour, int alpha) {
        int rasterizerPixel = x + y * Rasterizer.destinationWidth;
        int rasterizerPixelOffset = Rasterizer.destinationWidth - width;
        int characterPixelOffset = 0;
        int characterPixel = 0;
        if (y < Rasterizer.viewportTop) {
            int yOffset = Rasterizer.viewportTop - y;
            height -= yOffset;
            y = Rasterizer.viewportTop;
            characterPixel += yOffset * width;
            rasterizerPixel += yOffset * Rasterizer.destinationWidth;
        }
        if (y + height >= Rasterizer.viewportBottom) {
            height -= y + height - Rasterizer.viewportBottom + 1;
        }
        if (x < Rasterizer.viewportLeft) {
            int xOffset = Rasterizer.viewportLeft - x;
            width -= xOffset;
            x = Rasterizer.viewportLeft;
            characterPixel += xOffset;
            rasterizerPixel += xOffset;
            characterPixelOffset += xOffset;
            rasterizerPixelOffset += xOffset;
        }
        if (x + width >= Rasterizer.viewportRight) {
            int widthoffset = x + width - Rasterizer.viewportRight + 1;
            width -= widthoffset;
            characterPixelOffset += widthoffset;
            rasterizerPixelOffset += widthoffset;
        }
        if (width > 0 && height > 0) {
            this.drawCharacterPixelsAlphaItalics(characterPixel, rasterizerPixelOffset, characterPixelOffset, rasterizerPixel, alpha, Rasterizer.destinationPixels, colour, height, width, characterPixels);
        }
    }

    public void drawCharacterPixelsAlpha(int characterPixel, int rasterizerPixelOffset, int characterPixelOffset, int rasterizerPixel, int alpha, int[] rasterizerPixels, int colour, int height, int width, byte[] characterPixels) {
        colour = ((colour & 0xFF00FF) * alpha & 0xFF00FF00) + ((colour & 0xFF00) * alpha & 0xFF0000) >> 8;
        alpha = 256 - alpha;
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            for (int widthCounter = -width; widthCounter < 0; ++widthCounter) {
                if (characterPixels[characterPixel++] == 0) {
                    ++rasterizerPixel;
                    continue;
                }
                int rasterizerPixelColor = rasterizerPixels[rasterizerPixel];
                rasterizerPixels[rasterizerPixel++] = (((rasterizerPixelColor & 0xFF00FF) * alpha & 0xFF00FF00) + ((rasterizerPixelColor & 0xFF00) * alpha & 0xFF0000) >> 8) + colour;
            }
            rasterizerPixel += rasterizerPixelOffset;
            characterPixel += characterPixelOffset;
        }
    }

    public void drawCharacterPixelsAlphaItalics(int characterPixel, int rasterizerPixelOffset, int characterPixelOffset, int rasterizerPixel, int alpha, int[] rasterizerPixels, int colour, int height, int width, byte[] characterPixels) {
        int shouldItalic = 0;
        colour = ((colour & 0xFF00FF) * alpha & 0xFF00FF00) + ((colour & 0xFF00) * alpha & 0xFF0000) >> 8;
        alpha = 256 - alpha;
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            for (int widthCounter = -width; widthCounter < 0; ++widthCounter) {
                if (characterPixels[characterPixel++] == 0) {
                    ++rasterizerPixel;
                    continue;
                }
                int rasterizerPixelColor = rasterizerPixels[rasterizerPixel];
                rasterizerPixels[rasterizerPixel++] = (((rasterizerPixelColor & 0xFF00FF) * alpha & 0xFF00FF00) + ((rasterizerPixelColor & 0xFF00) * alpha & 0xFF0000) >> 8) + colour;
            }
            if (++shouldItalic > 3) {
                rasterizerPixel += rasterizerPixelOffset - 1;
                shouldItalic = 0;
            } else {
                rasterizerPixel += rasterizerPixelOffset;
            }
            characterPixel += characterPixelOffset;
        }
    }

    static {
        greaterThan = "gt";
        lessThan = "lt";
        euroSymbol = "euro";
        startShadow = "shad=";
        softHyphen = "shy";
        startTrans = "trans=";
        startUnderline = "u=";
        startStrikethrough = "str=";
        endColor = "/col";
        endShadow = "/shad";
        endTrans = "/trans";
        endUnderline = "/u";
        endStrikeThrough = "/str";
        startDefaultUnderline = "u";
        startDefaultStrikeThrough = "str";
        startDefaultShadow = "shad";
        startColor = "col=";
        multiplicationSymbol = "times";
        nonBreakingSpace = "nbsp";
        image = "img=";
        copyright = "copy";
        lineBreak = "br";
        italicsStart = "i";
        italicsEnd = "/i";
        registeredTrademark = "reg";
        strikethroughColor = -1;
        italics = false;
        underlineColor = -1;
        defaultTextColor = 0;
        opacity = 256;
        defaultOpacity = 256;
        defaultShadowColor = -1;
        shadowColor = -1;
        textColor = 0xFF00FF;
        whiteSpace = 0;
    }
}

