/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.media;

import org.runejs.client.MovedStatics;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.media.ImageRGB;
import org.runejs.client.media.Rasterizer;

public class IndexedImage
extends Rasterizer {
    public int imgWidth;
    public int[] palette;
    public int maxWidth;
    public int maxHeight;
    public byte[] imgPixels;
    public int imgHeight;
    public int yDrawOffset;
    public int xDrawOffset;

    public IndexedImage() {
    }

    public IndexedImage(int width, int height, int arg2) {
        this.maxWidth = this.imgWidth = width;
        this.maxHeight = this.imgHeight = height;
        this.yDrawOffset = 0;
        this.xDrawOffset = 0;
        this.imgPixels = new byte[width * height];
        this.palette = new int[arg2];
    }

    public static IndexedImage[] getMultipleIndexedImages(CacheArchive archive, String groupName, String always_empty) {
        int groupId = archive.getGroupIdByName(groupName);
        int fileId = archive.getFileIdByName(groupId, always_empty);
        return IndexedImage.method337(archive, fileId, groupId);
    }

    private static IndexedImage[] method337(CacheArchive archive, int fileId, int groupId) {
        if (!MovedStatics.decodeImageFromArchive(archive, groupId, fileId)) {
            return null;
        }
        return IndexedImage.method315();
    }

    public static IndexedImage[] method315() {
        IndexedImage[] class40_sub5_sub14_sub2s = new IndexedImage[MovedStatics.childCount];
        for (int i = 0; MovedStatics.childCount > i; ++i) {
            IndexedImage class40_sub5_sub14_sub2 = class40_sub5_sub14_sub2s[i] = new IndexedImage();
            class40_sub5_sub14_sub2.maxWidth = MovedStatics.imageMaxWidth;
            class40_sub5_sub14_sub2.maxHeight = MovedStatics.imageMaxHeight;
            class40_sub5_sub14_sub2.xDrawOffset = MovedStatics.spriteOffsetX[i];
            class40_sub5_sub14_sub2.yDrawOffset = MovedStatics.spriteOffsetY[i];
            class40_sub5_sub14_sub2.imgWidth = MovedStatics.spriteWidth[i];
            class40_sub5_sub14_sub2.imgHeight = MovedStatics.spriteHeight[i];
            class40_sub5_sub14_sub2.palette = MovedStatics.spritePalette;
            class40_sub5_sub14_sub2.imgPixels = MovedStatics.spritePixels[i];
        }
        MovedStatics.clearDecodedSpriteData();
        return class40_sub5_sub14_sub2s;
    }

    public IndexedImage cloneImage() {
        int i;
        IndexedImage newImage = new IndexedImage(this.imgWidth, this.imgHeight, this.palette.length);
        newImage.maxWidth = this.maxWidth;
        newImage.maxHeight = this.maxHeight;
        newImage.xDrawOffset = this.xDrawOffset;
        newImage.yDrawOffset = this.yDrawOffset;
        for (i = 0; i < this.imgPixels.length; ++i) {
            newImage.imgPixels[i] = this.imgPixels[i];
        }
        for (i = 0; i < this.palette.length; ++i) {
            newImage.palette[i] = this.palette[i];
        }
        return newImage;
    }

    public void drawImage(int x, int y) {
        int xOffset;
        int rasterizerOffset = (x += this.xDrawOffset) + (y += this.yDrawOffset) * Rasterizer.destinationWidth;
        int pixelOffset = 0;
        int imageHeight = this.imgHeight;
        int imageWidth = this.imgWidth;
        int deviation = Rasterizer.destinationWidth - imageWidth;
        int originalDeviation = 0;
        if (y < Rasterizer.viewportTop) {
            int yOffset = Rasterizer.viewportTop - y;
            imageHeight -= yOffset;
            y = Rasterizer.viewportTop;
            pixelOffset += yOffset * imageWidth;
            rasterizerOffset += yOffset * Rasterizer.destinationWidth;
        }
        if (y + imageHeight > Rasterizer.viewportBottom) {
            imageHeight -= y + imageHeight - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            xOffset = Rasterizer.viewportLeft - x;
            imageWidth -= xOffset;
            x = Rasterizer.viewportLeft;
            pixelOffset += xOffset;
            rasterizerOffset += xOffset;
            originalDeviation += xOffset;
            deviation += xOffset;
        }
        if (x + imageWidth > Rasterizer.viewportRight) {
            xOffset = x + imageWidth - Rasterizer.viewportRight;
            imageWidth -= xOffset;
            originalDeviation += xOffset;
            deviation += xOffset;
        }
        if (imageWidth > 0 && imageHeight > 0) {
            ImageRGB.shapeImageToPixels(this.imgPixels, Rasterizer.destinationPixels, pixelOffset, rasterizerOffset, imageWidth, imageHeight, deviation, originalDeviation, this.palette);
        }
    }

    public void drawImageAlpha(int x, int y, int alpha) {
        int xOffset;
        int rasterizerPixel = (x += this.xDrawOffset) + (y += this.yDrawOffset) * Rasterizer.destinationWidth;
        int pixel = 0;
        int newHeight = this.imgHeight;
        int newWidth = this.imgWidth;
        int rasterizerPixelOffset = Rasterizer.destinationWidth - newWidth;
        int pixelOffset = 0;
        if (y < Rasterizer.viewportTop) {
            int yOffset = Rasterizer.viewportTop - y;
            newHeight -= yOffset;
            y = Rasterizer.viewportTop;
            pixel += yOffset * newWidth;
            rasterizerPixel += yOffset * Rasterizer.destinationWidth;
        }
        if (y + newHeight > Rasterizer.viewportBottom) {
            newHeight -= y + newHeight - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            xOffset = Rasterizer.viewportLeft - x;
            newWidth -= xOffset;
            x = Rasterizer.viewportLeft;
            pixel += xOffset;
            rasterizerPixel += xOffset;
            pixelOffset += xOffset;
            rasterizerPixelOffset += xOffset;
        }
        if (x + newWidth > Rasterizer.viewportRight) {
            xOffset = x + newWidth - Rasterizer.viewportRight;
            newWidth -= xOffset;
            pixelOffset += xOffset;
            rasterizerPixelOffset += xOffset;
        }
        if (newWidth > 0 && newHeight > 0) {
            this.copyPixelsAlpha(destinationPixels, Rasterizer.destinationPixels, pixel, rasterizerPixel, pixelOffset, rasterizerPixelOffset, newWidth, newHeight, 0, alpha);
        }
    }

    public void copyPixelsAlpha(int[] pixels, int[] rasterizerPixels, int pixel, int rasterizerPixel, int pixelOffset, int rasterizerPixelOffset, int width, int height, int color, int alpha) {
        int alphaValue = 256 - alpha;
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            for (int widthCounter = -width; widthCounter < 0; ++widthCounter) {
                if ((color = pixels[pixel++]) == 0) {
                    ++rasterizerPixel;
                    continue;
                }
                int rasterizerPixelColor = rasterizerPixels[rasterizerPixel];
                rasterizerPixels[rasterizerPixel++] = ((color & 0xFF00FF) * alpha + (rasterizerPixelColor & 0xFF00FF) * alphaValue & 0xFF00FF00) + ((color & 0xFF00) * alpha + (rasterizerPixelColor & 0xFF00) * alphaValue & 0xFF0000) >> 8;
            }
            rasterizerPixel += rasterizerPixelOffset;
            pixel += pixelOffset;
        }
    }

    public void resizeToLibSize() {
        if (this.imgWidth != this.maxWidth || this.imgHeight != this.maxHeight) {
            byte[] resizedPixels = new byte[this.maxWidth * this.maxHeight];
            int pixelCount = 0;
            for (int y = 0; y < this.imgHeight; ++y) {
                for (int x = 0; x < this.imgWidth; ++x) {
                    resizedPixels[x + this.xDrawOffset + (y + this.yDrawOffset) * this.maxWidth] = this.imgPixels[pixelCount++];
                }
            }
            this.imgPixels = resizedPixels;
            this.imgWidth = this.maxWidth;
            this.imgHeight = this.maxHeight;
            this.xDrawOffset = 0;
            this.yDrawOffset = 0;
        }
    }

    public void flipHorizontal() {
        byte[] flippedPixels = new byte[this.imgWidth * this.imgHeight];
        int pixelCount = 0;
        for (int y = 0; y < this.imgHeight; ++y) {
            for (int x = this.imgWidth - 1; x >= 0; --x) {
                flippedPixels[pixelCount++] = this.imgPixels[x + y * this.imgWidth];
            }
        }
        this.imgPixels = flippedPixels;
        this.xDrawOffset = this.maxWidth - this.imgWidth - this.xDrawOffset;
    }

    public void flipVertical() {
        byte[] flippedPixels = new byte[this.imgWidth * this.imgHeight];
        int pixelCount = 0;
        for (int y = this.imgHeight - 1; y >= 0; --y) {
            for (int x = 0; x < this.imgWidth; ++x) {
                flippedPixels[pixelCount++] = this.imgPixels[x + y * this.imgWidth];
            }
        }
        this.imgPixels = flippedPixels;
        this.yDrawOffset = this.maxHeight - this.imgHeight - this.yDrawOffset;
    }

    public void mixPalette(int red, int green, int blue) {
        for (int index = 0; index < this.palette.length; ++index) {
            int r = this.palette[index] >> 16 & 0xFF;
            if ((r += red) < 0) {
                r = 0;
            } else if (r > 255) {
                r = 255;
            }
            int g = this.palette[index] >> 8 & 0xFF;
            if ((g += green) < 0) {
                g = 0;
            } else if (g > 255) {
                g = 255;
            }
            int b = this.palette[index] & 0xFF;
            if ((b += blue) < 0) {
                b = 0;
            } else if (b > 255) {
                b = 255;
            }
            this.palette[index] = (r << 16) + (g << 8) + b;
        }
    }
}

