/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.media;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import org.runejs.client.MovedStatics;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.media.IndexedImage;
import org.runejs.client.media.Rasterizer;
import org.runejs.client.util.BitUtils;

public class ImageRGB
extends Rasterizer {
    public int offsetY;
    public int imageHeight;
    public int imageWidth;
    public int maxHeight;
    public int offsetX;
    public int maxWidth;
    public int[] pixels;

    public ImageRGB() {
    }

    public ImageRGB(int width, int height) {
        this.pixels = new int[width * height];
        this.imageWidth = this.maxWidth = width;
        this.imageHeight = this.maxHeight = height;
        this.offsetY = 0;
        this.offsetX = 0;
    }

    public ImageRGB(byte[] imagedata, Component component) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(imagedata);
            MediaTracker mediatracker = new MediaTracker(component);
            mediatracker.addImage(image, 0);
            mediatracker.waitForAll();
            this.imageWidth = image.getWidth(component);
            this.imageHeight = image.getHeight(component);
            this.maxWidth = this.imageWidth;
            this.maxHeight = this.imageHeight;
            this.offsetX = 0;
            this.offsetY = 0;
            this.pixels = new int[this.imageWidth * this.imageHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.imageWidth, this.imageHeight, this.pixels, 0, this.imageWidth);
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException interruptedexception) {
            System.out.println("Error converting jpg");
        }
    }

    public static void method715(int[] arg0, int[] arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11) {
        int i = arg3;
        for (int i_0_ = -arg8; i_0_ < 0; ++i_0_) {
            int i_1_ = (arg4 >> 16) * arg11;
            for (int i_2_ = -arg7; i_2_ < 0; ++i_2_) {
                arg2 = arg1[(arg3 >> 16) + i_1_];
                if (arg2 != 0) {
                    arg0[arg5++] = arg2;
                } else {
                    ++arg5;
                }
                arg3 += arg9;
            }
            arg4 += arg10;
            arg3 = i;
            arg5 += arg6;
        }
    }

    public static void blockCopyMask(int[] arg0, int[] arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, byte[] arg9) {
        int i = -(arg5 >> 2);
        arg5 = -(arg5 & 3);
        for (int i_21_ = -arg6; i_21_ < 0; ++i_21_) {
            for (int i_22_ = i; i_22_ < 0; ++i_22_) {
                if ((arg2 = arg1[arg3++]) != 0 && arg9[arg4] == 0) {
                    arg0[arg4++] = arg2;
                } else {
                    ++arg4;
                }
                arg2 = arg1[arg3++];
                if (arg2 != 0 && arg9[arg4] == 0) {
                    arg0[arg4++] = arg2;
                } else {
                    ++arg4;
                }
                arg2 = arg1[arg3++];
                if (arg2 != 0 && arg9[arg4] == 0) {
                    arg0[arg4++] = arg2;
                } else {
                    ++arg4;
                }
                arg2 = arg1[arg3++];
                if (arg2 != 0 && arg9[arg4] == 0) {
                    arg0[arg4++] = arg2;
                    continue;
                }
                ++arg4;
            }
            for (int i_23_ = arg5; i_23_ < 0; ++i_23_) {
                if ((arg2 = arg1[arg3++]) != 0 && arg9[arg4] == 0) {
                    arg0[arg4++] = arg2;
                    continue;
                }
                ++arg4;
            }
            arg4 += arg7;
            arg3 += arg8;
        }
    }

    public static void blockCopyTrans(int[] arg0, int[] arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        int i = -(arg5 >> 2);
        arg5 = -(arg5 & 3);
        for (int i_24_ = -arg6; i_24_ < 0; ++i_24_) {
            for (int i_25_ = i; i_25_ < 0; ++i_25_) {
                if ((arg2 = arg1[arg3++]) != 0) {
                    arg0[arg4++] = arg2;
                } else {
                    ++arg4;
                }
                arg2 = arg1[arg3++];
                if (arg2 != 0) {
                    arg0[arg4++] = arg2;
                } else {
                    ++arg4;
                }
                arg2 = arg1[arg3++];
                if (arg2 != 0) {
                    arg0[arg4++] = arg2;
                } else {
                    ++arg4;
                }
                arg2 = arg1[arg3++];
                if (arg2 != 0) {
                    arg0[arg4++] = arg2;
                    continue;
                }
                ++arg4;
            }
            for (int i_26_ = arg5; i_26_ < 0; ++i_26_) {
                if ((arg2 = arg1[arg3++]) != 0) {
                    arg0[arg4++] = arg2;
                    continue;
                }
                ++arg4;
            }
            arg4 += arg7;
            arg3 += arg8;
        }
    }

    public static void method730(int[] arg0, int[] arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        int i = 256 - arg9;
        for (int i_167_ = -arg6; i_167_ < 0; ++i_167_) {
            for (int i_168_ = -arg5; i_168_ < 0; ++i_168_) {
                if ((arg2 = arg1[arg3++]) != 0) {
                    int i_169_ = arg0[arg4];
                    arg0[arg4++] = ((arg2 & 0xFF00FF) * arg9 + (i_169_ & 0xFF00FF) * i & 0xFF00FF00) + ((arg2 & 0xFF00) * arg9 + (i_169_ & 0xFF00) * i & 0xFF0000) >> 8;
                    continue;
                }
                ++arg4;
            }
            arg4 += arg7;
            arg3 += arg8;
        }
    }

    public static void copyPixels(int[] rasterizerPixels, int[] pixels, int pixel, int rasterizerPixel, int width, int height, int rasterizerPixelOffset, int pixelOffset) {
        for (int i = -height; i < 0; ++i) {
            int shiftedWidth = rasterizerPixel + width - 3;
            while (rasterizerPixel < shiftedWidth) {
                rasterizerPixels[rasterizerPixel++] = pixels[pixel++];
                rasterizerPixels[rasterizerPixel++] = pixels[pixel++];
                rasterizerPixels[rasterizerPixel++] = pixels[pixel++];
                rasterizerPixels[rasterizerPixel++] = pixels[pixel++];
            }
            shiftedWidth += 3;
            while (rasterizerPixel < shiftedWidth) {
                rasterizerPixels[rasterizerPixel++] = pixels[pixel++];
            }
            rasterizerPixel += rasterizerPixelOffset;
            pixel += pixelOffset;
        }
    }

    public static void method733(int[] arg0, int[] arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10, int arg11, int arg12) {
        int i = 256 - arg12;
        int i_185_ = arg3;
        for (int i_186_ = -arg8; i_186_ < 0; ++i_186_) {
            int i_187_ = (arg4 >> 16) * arg11;
            for (int i_188_ = -arg7; i_188_ < 0; ++i_188_) {
                arg2 = arg1[(arg3 >> 16) + i_187_];
                if (arg2 != 0) {
                    int i_189_ = arg0[arg5];
                    arg0[arg5++] = ((arg2 & 0xFF00FF) * arg12 + (i_189_ & 0xFF00FF) * i & 0xFF00FF00) + ((arg2 & 0xFF00) * arg12 + (i_189_ & 0xFF00) * i & 0xFF0000) >> 8;
                } else {
                    ++arg5;
                }
                arg3 += arg9;
            }
            arg4 += arg10;
            arg3 = i_185_;
            arg5 += arg6;
        }
    }

    public static void shapeImageToPixels(byte[] pixels, int[] rasterizerPixels, int pixel, int rasterizerPixel, int width, int height, int rasterizerPixelOffset, int pixelOffset, int[] palette) {
        int shiftedWidth = -(width >> 2);
        width = -(width & 3);
        for (int heightCounter = -height; heightCounter < 0; ++heightCounter) {
            byte pixelColor;
            int widthCounter;
            for (widthCounter = shiftedWidth; widthCounter < 0; ++widthCounter) {
                if ((pixelColor = pixels[pixel++]) != 0) {
                    rasterizerPixels[rasterizerPixel++] = palette[pixelColor & 0xFF];
                } else {
                    ++rasterizerPixel;
                }
                pixelColor = pixels[pixel++];
                if (pixelColor != 0) {
                    rasterizerPixels[rasterizerPixel++] = palette[pixelColor & 0xFF];
                } else {
                    ++rasterizerPixel;
                }
                pixelColor = pixels[pixel++];
                if (pixelColor != 0) {
                    rasterizerPixels[rasterizerPixel++] = palette[pixelColor & 0xFF];
                } else {
                    ++rasterizerPixel;
                }
                pixelColor = pixels[pixel++];
                if (pixelColor != 0) {
                    rasterizerPixels[rasterizerPixel++] = palette[pixelColor & 0xFF];
                    continue;
                }
                ++rasterizerPixel;
            }
            for (widthCounter = width; widthCounter < 0; ++widthCounter) {
                if ((pixelColor = pixels[pixel++]) != 0) {
                    rasterizerPixels[rasterizerPixel++] = palette[pixelColor & 0xFF];
                    continue;
                }
                ++rasterizerPixel;
            }
            rasterizerPixel += rasterizerPixelOffset;
            pixel += pixelOffset;
        }
    }

    public static ImageRGB[] method319() {
        ImageRGB[] class40_sub5_sub14_sub4s = new ImageRGB[MovedStatics.childCount];
        for (int i = 0; i < MovedStatics.childCount; ++i) {
            ImageRGB class40_sub5_sub14_sub4 = class40_sub5_sub14_sub4s[i] = new ImageRGB();
            class40_sub5_sub14_sub4.maxWidth = MovedStatics.imageMaxWidth;
            class40_sub5_sub14_sub4.maxHeight = MovedStatics.imageMaxHeight;
            class40_sub5_sub14_sub4.offsetX = MovedStatics.spriteOffsetX[i];
            class40_sub5_sub14_sub4.offsetY = MovedStatics.spriteOffsetY[i];
            class40_sub5_sub14_sub4.imageWidth = MovedStatics.spriteWidth[i];
            class40_sub5_sub14_sub4.imageHeight = MovedStatics.spriteHeight[i];
            byte[] is = MovedStatics.spritePixels[i];
            int i_4_ = class40_sub5_sub14_sub4.imageHeight * class40_sub5_sub14_sub4.imageWidth;
            class40_sub5_sub14_sub4.pixels = new int[i_4_];
            for (int i_5_ = 0; i_5_ < i_4_; ++i_5_) {
                class40_sub5_sub14_sub4.pixels[i_5_] = MovedStatics.spritePalette[BitUtils.bitWiseAND(255, is[i_5_])];
            }
        }
        MovedStatics.clearDecodedSpriteData();
        return class40_sub5_sub14_sub4s;
    }

    public static ImageRGB[] method944(CacheArchive archive, int groupId, int fileId, byte arg0) {
        if (!MovedStatics.decodeImageFromArchive(archive, groupId, fileId)) {
            return null;
        }
        int i = -59 % ((-60 - arg0) / 34);
        return ImageRGB.method319();
    }

    public static ImageRGB[] method526(CacheArchive arg0, String arg2, String always_empty) {
        int i = arg0.getGroupIdByName(arg2);
        int i_4_ = arg0.getFileIdByName(i, always_empty);
        return ImageRGB.method944(arg0, i, i_4_, (byte)-3);
    }

    public void method716(int arg0, int arg1, int arg2, int arg3, int arg4) {
        if (arg2 > 0 && arg3 > 0) {
            int i = this.imageWidth;
            int i_3_ = this.imageHeight;
            int i_4_ = 0;
            int i_5_ = 0;
            int i_6_ = this.maxWidth;
            int i_7_ = this.maxHeight;
            int i_8_ = (i_6_ << 16) / arg2;
            int i_9_ = (i_7_ << 16) / arg3;
            if (this.offsetX > 0) {
                int i_10_ = ((this.offsetX << 16) + i_8_ - 1) / i_8_;
                arg0 += i_10_;
                i_4_ += i_10_ * i_8_ - (this.offsetX << 16);
            }
            if (this.offsetY > 0) {
                int i_11_ = ((this.offsetY << 16) + i_9_ - 1) / i_9_;
                arg1 += i_11_;
                i_5_ += i_11_ * i_9_ - (this.offsetY << 16);
            }
            if (i < i_6_) {
                arg2 = ((i << 16) - i_4_ + i_8_ - 1) / i_8_;
            }
            if (i_3_ < i_7_) {
                arg3 = ((i_3_ << 16) - i_5_ + i_9_ - 1) / i_9_;
            }
            int i_12_ = arg0 + arg1 * Rasterizer.destinationWidth;
            int i_13_ = Rasterizer.destinationWidth - arg2;
            if (arg1 + arg3 > Rasterizer.viewportBottom) {
                arg3 -= arg1 + arg3 - Rasterizer.viewportBottom;
            }
            if (arg1 < Rasterizer.viewportTop) {
                int i_14_ = Rasterizer.viewportTop - arg1;
                arg3 -= i_14_;
                i_12_ += i_14_ * Rasterizer.destinationWidth;
                i_5_ += i_9_ * i_14_;
            }
            if (arg0 + arg2 > Rasterizer.viewportRight) {
                int i_15_ = arg0 + arg2 - Rasterizer.viewportRight;
                arg2 -= i_15_;
                i_13_ += i_15_;
            }
            if (arg0 < Rasterizer.viewportLeft) {
                int i_16_ = Rasterizer.viewportLeft - arg0;
                arg2 -= i_16_;
                i_12_ += i_16_;
                i_4_ += i_8_ * i_16_;
                i_13_ += i_16_;
            }
            ImageRGB.method733(Rasterizer.destinationPixels, this.pixels, 0, i_4_, i_5_, i_12_, i_13_, arg2, arg3, i_8_, i_9_, i, arg4);
        }
    }

    public void method717(int arg0, int arg1, int arg2) {
        for (int i = 0; i < this.pixels.length; ++i) {
            int i_17_ = this.pixels[i];
            if (i_17_ == 0) continue;
            int i_18_ = i_17_ >> 16 & 0xFF;
            if ((i_18_ += arg0) < 1) {
                i_18_ = 1;
            } else if (i_18_ > 255) {
                i_18_ = 255;
            }
            int i_19_ = i_17_ >> 8 & 0xFF;
            if ((i_19_ += arg1) < 1) {
                i_19_ = 1;
            } else if (i_19_ > 255) {
                i_19_ = 255;
            }
            int i_20_ = i_17_ & 0xFF;
            if ((i_20_ += arg2) < 1) {
                i_20_ = 1;
            } else if (i_20_ > 255) {
                i_20_ = 255;
            }
            this.pixels[i] = (i_18_ << 16) + (i_19_ << 8) + i_20_;
        }
    }

    public void drawImageWithTexture(int x, int y, int textureId, int arg3) {
        this.method722(this.maxWidth << 3, this.maxHeight << 3, x << 4, y << 4, textureId, arg3);
    }

    public void drawImage(int x, int y) {
        int clip_width;
        int dest_offset = (x += this.offsetX) + (y += this.offsetY) * Rasterizer.destinationWidth;
        int source_offset = 0;
        int line_count = this.imageHeight;
        int line_width = this.imageWidth;
        int line_offset_dest = Rasterizer.destinationWidth - line_width;
        int line_offset_source = 0;
        if (y < Rasterizer.viewportTop) {
            int clip_height = Rasterizer.viewportTop - y;
            line_count -= clip_height;
            y = Rasterizer.viewportTop;
            source_offset += clip_height * line_width;
            dest_offset += clip_height * Rasterizer.destinationWidth;
        }
        if (y + line_count > Rasterizer.viewportBottom) {
            line_count -= y + line_count - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            clip_width = Rasterizer.viewportLeft - x;
            line_width -= clip_width;
            x = Rasterizer.viewportLeft;
            source_offset += clip_width;
            dest_offset += clip_width;
            line_offset_source += clip_width;
            line_offset_dest += clip_width;
        }
        if (x + line_width > Rasterizer.viewportRight) {
            clip_width = x + line_width - Rasterizer.viewportRight;
            line_width -= clip_width;
            line_offset_source += clip_width;
            line_offset_dest += clip_width;
        }
        if (line_width > 0 && line_count > 0) {
            ImageRGB.blockCopyTrans(Rasterizer.destinationPixels, this.pixels, 0, source_offset, dest_offset, line_width, line_count, line_offset_dest, line_offset_source);
        }
    }

    public void method722(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        block97: {
            int i_47_;
            int i_46_;
            int i_45_;
            int i_44_;
            if (arg5 == 0) break block97;
            double d = (double)(arg4 & 0xFFFF) * 9.587379924285257E-5;
            int i = (int)Math.floor(Math.sin(d) * (double)arg5 + 0.5);
            int i_35_ = (int)Math.floor(Math.cos(d) * (double)arg5 + 0.5);
            int i_36_ = -(arg0 -= this.offsetX << 4) * i_35_ + -(arg1 -= this.offsetY << 4) * i;
            int i_37_ = arg0 * i + -arg1 * i_35_;
            int i_38_ = ((this.imageWidth << 4) - arg0) * i_35_ + -arg1 * i;
            int i_39_ = -((this.imageWidth << 4) - arg0) * i + -arg1 * i_35_;
            int i_40_ = -arg0 * i_35_ + ((this.imageHeight << 4) - arg1) * i;
            int i_41_ = arg0 * i + ((this.imageHeight << 4) - arg1) * i_35_;
            int i_42_ = ((this.imageWidth << 4) - arg0) * i_35_ + ((this.imageHeight << 4) - arg1) * i;
            int i_43_ = -((this.imageWidth << 4) - arg0) * i + ((this.imageHeight << 4) - arg1) * i_35_;
            if (i_36_ < i_38_) {
                i_44_ = i_36_;
                i_45_ = i_38_;
            } else {
                i_44_ = i_38_;
                i_45_ = i_36_;
            }
            if (i_40_ < i_44_) {
                i_44_ = i_40_;
            }
            if (i_42_ < i_44_) {
                i_44_ = i_42_;
            }
            if (i_40_ > i_45_) {
                i_45_ = i_40_;
            }
            if (i_42_ > i_45_) {
                i_45_ = i_42_;
            }
            if (i_37_ < i_39_) {
                i_46_ = i_37_;
                i_47_ = i_39_;
            } else {
                i_46_ = i_39_;
                i_47_ = i_37_;
            }
            if (i_41_ < i_46_) {
                i_46_ = i_41_;
            }
            if (i_43_ < i_46_) {
                i_46_ = i_43_;
            }
            if (i_41_ > i_47_) {
                i_47_ = i_41_;
            }
            if (i_43_ > i_47_) {
                i_47_ = i_43_;
            }
            i_44_ >>= 12;
            i_45_ = i_45_ + 4095 >> 12;
            i_46_ >>= 12;
            i_47_ = i_47_ + 4095 >> 12;
            i_44_ += arg2;
            i_45_ += arg2;
            i_46_ += arg3;
            i_47_ += arg3;
            i_45_ = i_45_ + 15 >> 4;
            i_46_ >>= 4;
            i_47_ = i_47_ + 15 >> 4;
            if ((i_44_ >>= 4) < Rasterizer.viewportLeft) {
                i_44_ = Rasterizer.viewportLeft;
            }
            if (i_45_ > Rasterizer.viewportRight) {
                i_45_ = Rasterizer.viewportRight;
            }
            if (i_46_ < Rasterizer.viewportTop) {
                i_46_ = Rasterizer.viewportTop;
            }
            if (i_47_ > Rasterizer.viewportBottom) {
                i_47_ = Rasterizer.viewportBottom;
            }
            if ((i_45_ = i_44_ - i_45_) < 0 && (i_47_ = i_46_ - i_47_) < 0) {
                int i_48_ = i_46_ * Rasterizer.destinationWidth + i_44_;
                double d_49_ = 1.6777216E7 / (double)arg5;
                int i_50_ = (int)Math.floor(Math.sin(d) * d_49_ + 0.5);
                int i_51_ = (int)Math.floor(Math.cos(d) * d_49_ + 0.5);
                int i_52_ = (i_44_ << 4) + 8 - arg2;
                int i_53_ = (i_46_ << 4) + 8 - arg3;
                int i_54_ = (arg0 << 8) - (i_53_ * i_50_ >> 4);
                int i_55_ = (arg1 << 8) + (i_53_ * i_51_ >> 4);
                if (i_51_ == 0) {
                    if (i_50_ == 0) {
                        int i_56_ = i_47_;
                        while (i_56_ < 0) {
                            int i_57_ = i_48_;
                            int i_58_ = i_54_;
                            int i_59_ = i_55_;
                            if (i_58_ >= 0 && i_59_ >= 0 && i_58_ - (this.imageWidth << 12) < 0 && i_59_ - (this.imageHeight << 12) < 0) {
                                for (int i_60_ = i_45_; i_60_ < 0; ++i_60_) {
                                    int i_61_ = this.pixels[(i_59_ >> 12) * this.imageWidth + (i_58_ >> 12)];
                                    if (i_61_ != 0) {
                                        Rasterizer.destinationPixels[i_57_++] = i_61_;
                                        continue;
                                    }
                                    ++i_57_;
                                }
                            }
                            ++i_56_;
                            i_48_ += Rasterizer.destinationWidth;
                        }
                    } else if (i_50_ < 0) {
                        int i_62_ = i_47_;
                        while (i_62_ < 0) {
                            int i_63_ = i_48_;
                            int i_64_ = i_54_;
                            int i_65_ = i_55_ + (i_52_ * i_50_ >> 4);
                            int i_66_ = i_45_;
                            if (i_64_ >= 0 && i_64_ - (this.imageWidth << 12) < 0) {
                                int i_67_ = i_65_ - (this.imageHeight << 12);
                                if (i_67_ >= 0) {
                                    i_67_ = (i_50_ - i_67_) / i_50_;
                                    i_66_ += i_67_;
                                    i_65_ += i_50_ * i_67_;
                                    i_63_ += i_67_;
                                }
                                if ((i_67_ = (i_65_ - i_50_) / i_50_) > i_66_) {
                                    i_66_ = i_67_;
                                }
                                while (i_66_ < 0) {
                                    int i_68_ = this.pixels[(i_65_ >> 12) * this.imageWidth + (i_64_ >> 12)];
                                    if (i_68_ != 0) {
                                        Rasterizer.destinationPixels[i_63_++] = i_68_;
                                    } else {
                                        ++i_63_;
                                    }
                                    i_65_ += i_50_;
                                    ++i_66_;
                                }
                            }
                            ++i_62_;
                            i_54_ -= i_50_;
                            i_48_ += Rasterizer.destinationWidth;
                        }
                    } else {
                        int i_69_ = i_47_;
                        while (i_69_ < 0) {
                            int i_70_ = i_48_;
                            int i_71_ = i_54_;
                            int i_72_ = i_55_ + (i_52_ * i_50_ >> 4);
                            int i_73_ = i_45_;
                            if (i_71_ >= 0 && i_71_ - (this.imageWidth << 12) < 0) {
                                int i_75_;
                                if (i_72_ < 0) {
                                    int i_74_ = (i_50_ - 1 - i_72_) / i_50_;
                                    i_73_ += i_74_;
                                    i_72_ += i_50_ * i_74_;
                                    i_70_ += i_74_;
                                }
                                if ((i_75_ = (1 + i_72_ - (this.imageHeight << 12) - i_50_) / i_50_) > i_73_) {
                                    i_73_ = i_75_;
                                }
                                while (i_73_ < 0) {
                                    int i_76_ = this.pixels[(i_72_ >> 12) * this.imageWidth + (i_71_ >> 12)];
                                    if (i_76_ != 0) {
                                        Rasterizer.destinationPixels[i_70_++] = i_76_;
                                    } else {
                                        ++i_70_;
                                    }
                                    i_72_ += i_50_;
                                    ++i_73_;
                                }
                            }
                            ++i_69_;
                            i_54_ -= i_50_;
                            i_48_ += Rasterizer.destinationWidth;
                        }
                    }
                } else if (i_51_ < 0) {
                    if (i_50_ == 0) {
                        int i_77_ = i_47_;
                        while (i_77_ < 0) {
                            int i_78_ = i_48_;
                            int i_79_ = i_54_ + (i_52_ * i_51_ >> 4);
                            int i_80_ = i_55_;
                            int i_81_ = i_45_;
                            if (i_80_ >= 0 && i_80_ - (this.imageHeight << 12) < 0) {
                                int i_82_ = i_79_ - (this.imageWidth << 12);
                                if (i_82_ >= 0) {
                                    i_82_ = (i_51_ - i_82_) / i_51_;
                                    i_81_ += i_82_;
                                    i_79_ += i_51_ * i_82_;
                                    i_78_ += i_82_;
                                }
                                if ((i_82_ = (i_79_ - i_51_) / i_51_) > i_81_) {
                                    i_81_ = i_82_;
                                }
                                while (i_81_ < 0) {
                                    int i_83_ = this.pixels[(i_80_ >> 12) * this.imageWidth + (i_79_ >> 12)];
                                    if (i_83_ != 0) {
                                        Rasterizer.destinationPixels[i_78_++] = i_83_;
                                    } else {
                                        ++i_78_;
                                    }
                                    i_79_ += i_51_;
                                    ++i_81_;
                                }
                            }
                            ++i_77_;
                            i_55_ += i_51_;
                            i_48_ += Rasterizer.destinationWidth;
                        }
                    } else if (i_50_ < 0) {
                        int i_84_ = i_47_;
                        while (i_84_ < 0) {
                            int i_85_ = i_48_;
                            int i_86_ = i_54_ + (i_52_ * i_51_ >> 4);
                            int i_87_ = i_55_ + (i_52_ * i_50_ >> 4);
                            int i_88_ = i_45_;
                            int i_89_ = i_86_ - (this.imageWidth << 12);
                            if (i_89_ >= 0) {
                                i_89_ = (i_51_ - i_89_) / i_51_;
                                i_88_ += i_89_;
                                i_86_ += i_51_ * i_89_;
                                i_87_ += i_50_ * i_89_;
                                i_85_ += i_89_;
                            }
                            if ((i_89_ = (i_86_ - i_51_) / i_51_) > i_88_) {
                                i_88_ = i_89_;
                            }
                            if ((i_89_ = i_87_ - (this.imageHeight << 12)) >= 0) {
                                i_89_ = (i_50_ - i_89_) / i_50_;
                                i_88_ += i_89_;
                                i_86_ += i_51_ * i_89_;
                                i_87_ += i_50_ * i_89_;
                                i_85_ += i_89_;
                            }
                            if ((i_89_ = (i_87_ - i_50_) / i_50_) > i_88_) {
                                i_88_ = i_89_;
                            }
                            while (i_88_ < 0) {
                                int i_90_ = this.pixels[(i_87_ >> 12) * this.imageWidth + (i_86_ >> 12)];
                                if (i_90_ != 0) {
                                    Rasterizer.destinationPixels[i_85_++] = i_90_;
                                } else {
                                    ++i_85_;
                                }
                                i_86_ += i_51_;
                                i_87_ += i_50_;
                                ++i_88_;
                            }
                            ++i_84_;
                            i_54_ -= i_50_;
                            i_55_ += i_51_;
                            i_48_ += Rasterizer.destinationWidth;
                        }
                    } else {
                        int i_91_ = i_47_;
                        while (i_91_ < 0) {
                            int i_92_ = i_48_;
                            int i_93_ = i_54_ + (i_52_ * i_51_ >> 4);
                            int i_94_ = i_55_ + (i_52_ * i_50_ >> 4);
                            int i_95_ = i_45_;
                            int i_96_ = i_93_ - (this.imageWidth << 12);
                            if (i_96_ >= 0) {
                                i_96_ = (i_51_ - i_96_) / i_51_;
                                i_95_ += i_96_;
                                i_93_ += i_51_ * i_96_;
                                i_94_ += i_50_ * i_96_;
                                i_92_ += i_96_;
                            }
                            if ((i_96_ = (i_93_ - i_51_) / i_51_) > i_95_) {
                                i_95_ = i_96_;
                            }
                            if (i_94_ < 0) {
                                i_96_ = (i_50_ - 1 - i_94_) / i_50_;
                                i_95_ += i_96_;
                                i_93_ += i_51_ * i_96_;
                                i_94_ += i_50_ * i_96_;
                                i_92_ += i_96_;
                            }
                            if ((i_96_ = (1 + i_94_ - (this.imageHeight << 12) - i_50_) / i_50_) > i_95_) {
                                i_95_ = i_96_;
                            }
                            while (i_95_ < 0) {
                                int i_97_ = this.pixels[(i_94_ >> 12) * this.imageWidth + (i_93_ >> 12)];
                                if (i_97_ != 0) {
                                    Rasterizer.destinationPixels[i_92_++] = i_97_;
                                } else {
                                    ++i_92_;
                                }
                                i_93_ += i_51_;
                                i_94_ += i_50_;
                                ++i_95_;
                            }
                            ++i_91_;
                            i_54_ -= i_50_;
                            i_55_ += i_51_;
                            i_48_ += Rasterizer.destinationWidth;
                        }
                    }
                } else if (i_50_ == 0) {
                    int i_98_ = i_47_;
                    while (i_98_ < 0) {
                        int i_99_ = i_48_;
                        int i_100_ = i_54_ + (i_52_ * i_51_ >> 4);
                        int i_101_ = i_55_;
                        int i_102_ = i_45_;
                        if (i_101_ >= 0 && i_101_ - (this.imageHeight << 12) < 0) {
                            int i_104_;
                            if (i_100_ < 0) {
                                int i_103_ = (i_51_ - 1 - i_100_) / i_51_;
                                i_102_ += i_103_;
                                i_100_ += i_51_ * i_103_;
                                i_99_ += i_103_;
                            }
                            if ((i_104_ = (1 + i_100_ - (this.imageWidth << 12) - i_51_) / i_51_) > i_102_) {
                                i_102_ = i_104_;
                            }
                            while (i_102_ < 0) {
                                int i_105_ = this.pixels[(i_101_ >> 12) * this.imageWidth + (i_100_ >> 12)];
                                if (i_105_ != 0) {
                                    Rasterizer.destinationPixels[i_99_++] = i_105_;
                                } else {
                                    ++i_99_;
                                }
                                i_100_ += i_51_;
                                ++i_102_;
                            }
                        }
                        ++i_98_;
                        i_55_ += i_51_;
                        i_48_ += Rasterizer.destinationWidth;
                    }
                } else if (i_50_ < 0) {
                    int i_106_ = i_47_;
                    while (i_106_ < 0) {
                        int i_112_;
                        int i_107_ = i_48_;
                        int i_108_ = i_54_ + (i_52_ * i_51_ >> 4);
                        int i_109_ = i_55_ + (i_52_ * i_50_ >> 4);
                        int i_110_ = i_45_;
                        if (i_108_ < 0) {
                            int i_111_ = (i_51_ - 1 - i_108_) / i_51_;
                            i_110_ += i_111_;
                            i_108_ += i_51_ * i_111_;
                            i_109_ += i_50_ * i_111_;
                            i_107_ += i_111_;
                        }
                        if ((i_112_ = (1 + i_108_ - (this.imageWidth << 12) - i_51_) / i_51_) > i_110_) {
                            i_110_ = i_112_;
                        }
                        if ((i_112_ = i_109_ - (this.imageHeight << 12)) >= 0) {
                            i_112_ = (i_50_ - i_112_) / i_50_;
                            i_110_ += i_112_;
                            i_108_ += i_51_ * i_112_;
                            i_109_ += i_50_ * i_112_;
                            i_107_ += i_112_;
                        }
                        if ((i_112_ = (i_109_ - i_50_) / i_50_) > i_110_) {
                            i_110_ = i_112_;
                        }
                        while (i_110_ < 0) {
                            int i_113_ = this.pixels[(i_109_ >> 12) * this.imageWidth + (i_108_ >> 12)];
                            if (i_113_ != 0) {
                                Rasterizer.destinationPixels[i_107_++] = i_113_;
                            } else {
                                ++i_107_;
                            }
                            i_108_ += i_51_;
                            i_109_ += i_50_;
                            ++i_110_;
                        }
                        ++i_106_;
                        i_54_ -= i_50_;
                        i_55_ += i_51_;
                        i_48_ += Rasterizer.destinationWidth;
                    }
                } else {
                    int i_114_ = i_47_;
                    while (i_114_ < 0) {
                        int i_120_;
                        int i_115_ = i_48_;
                        int i_116_ = i_54_ + (i_52_ * i_51_ >> 4);
                        int i_117_ = i_55_ + (i_52_ * i_50_ >> 4);
                        int i_118_ = i_45_;
                        if (i_116_ < 0) {
                            int i_119_ = (i_51_ - 1 - i_116_) / i_51_;
                            i_118_ += i_119_;
                            i_116_ += i_51_ * i_119_;
                            i_117_ += i_50_ * i_119_;
                            i_115_ += i_119_;
                        }
                        if ((i_120_ = (1 + i_116_ - (this.imageWidth << 12) - i_51_) / i_51_) > i_118_) {
                            i_118_ = i_120_;
                        }
                        if (i_117_ < 0) {
                            i_120_ = (i_50_ - 1 - i_117_) / i_50_;
                            i_118_ += i_120_;
                            i_116_ += i_51_ * i_120_;
                            i_117_ += i_50_ * i_120_;
                            i_115_ += i_120_;
                        }
                        if ((i_120_ = (1 + i_117_ - (this.imageHeight << 12) - i_50_) / i_50_) > i_118_) {
                            i_118_ = i_120_;
                        }
                        while (i_118_ < 0) {
                            int i_121_ = this.pixels[(i_117_ >> 12) * this.imageWidth + (i_116_ >> 12)];
                            if (i_121_ != 0) {
                                Rasterizer.destinationPixels[i_115_++] = i_121_;
                            } else {
                                ++i_115_;
                            }
                            i_116_ += i_51_;
                            i_117_ += i_50_;
                            ++i_118_;
                        }
                        ++i_114_;
                        i_54_ -= i_50_;
                        i_55_ += i_51_;
                        i_48_ += Rasterizer.destinationWidth;
                    }
                }
            }
        }
    }

    public void prepareRasterizer() {
        Rasterizer.prepare(this.pixels, this.imageWidth, this.imageHeight);
    }

    public void shapeImageToPixels(int x, int y, int width, int height, int arg4, int arg5, int k1, int zoom, int[] arg8, int[] arg9) {
        try {
            int centerX = -width / 2;
            int centerY = -height / 2;
            int sine = (int)(Math.sin((double)k1 / 326.11) * 65536.0);
            int cosine = (int)(Math.cos((double)k1 / 326.11) * 65536.0);
            sine = sine * zoom >> 8;
            cosine = cosine * zoom >> 8;
            int i_125_ = (arg4 << 16) + centerY * sine + centerX * cosine;
            int i_126_ = (arg5 << 16) + centerY * cosine - centerX * sine;
            int destinationOffset = x + y * Rasterizer.destinationWidth;
            for (y = 0; y < height; ++y) {
                int i_128_ = arg8[y];
                int i_129_ = destinationOffset + i_128_;
                int i_130_ = i_125_ + cosine * i_128_;
                int i_131_ = i_126_ - sine * i_128_;
                for (x = -arg9[y]; x < 0; ++x) {
                    int pixelToGet = (i_130_ >> 16) + (i_131_ >> 16) * this.imageWidth;
                    int colour = 0;
                    if (this.pixels.length >= pixelToGet && pixelToGet >= 0) {
                        colour = this.pixels[pixelToGet];
                    }
                    Rasterizer.destinationPixels[i_129_++] = colour;
                    i_130_ += cosine;
                    i_131_ -= sine;
                }
                i_125_ += sine;
                i_126_ += cosine;
                destinationOffset += Rasterizer.destinationWidth;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawTo(IndexedImage indexedImage, int x, int y) {
        int clip_width;
        int dest_ptr = (x += this.offsetX) + (y += this.offsetY) * Rasterizer.destinationWidth;
        int source_ptr = 0;
        int line_count = this.imageHeight;
        int line_width = this.imageWidth;
        int line_offset_dest = Rasterizer.destinationWidth - line_width;
        int line_offset_src = 0;
        if (y < Rasterizer.viewportTop) {
            int clip_height = Rasterizer.viewportTop - y;
            line_count -= clip_height;
            y = Rasterizer.viewportTop;
            source_ptr += clip_height * line_width;
            dest_ptr += clip_height * Rasterizer.destinationWidth;
        }
        if (y + line_count > Rasterizer.viewportBottom) {
            line_count -= y + line_count - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            clip_width = Rasterizer.viewportLeft - x;
            line_width -= clip_width;
            x = Rasterizer.viewportLeft;
            source_ptr += clip_width;
            dest_ptr += clip_width;
            line_offset_src += clip_width;
            line_offset_dest += clip_width;
        }
        if (x + line_width > Rasterizer.viewportRight) {
            clip_width = x + line_width - Rasterizer.viewportRight;
            line_width -= clip_width;
            line_offset_src += clip_width;
            line_offset_dest += clip_width;
        }
        if (line_width > 0 && line_count > 0) {
            ImageRGB.blockCopyMask(Rasterizer.destinationPixels, this.pixels, 0, source_ptr, dest_ptr, line_width, line_count, line_offset_dest, line_offset_src, indexedImage.imgPixels);
        }
    }

    public void trim() {
        if (this.imageWidth != this.maxWidth || this.imageHeight != this.maxHeight) {
            int[] newPixels = new int[this.maxWidth * this.maxHeight];
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    newPixels[(y + this.offsetY) * this.maxWidth + x + this.offsetX] = this.pixels[y * this.imageWidth + x];
                }
            }
            this.pixels = newPixels;
            this.imageWidth = this.maxWidth;
            this.imageHeight = this.maxHeight;
            this.offsetX = 0;
            this.offsetY = 0;
        }
    }

    public void drawInverse(int x, int y) {
        int rasterizerPixel = (x += this.offsetX) + (y += this.offsetY) * Rasterizer.destinationWidth;
        int pixel = 0;
        int newHeight = this.imageHeight;
        int newWidth = this.imageWidth;
        int rasterizerPixelOffset = Rasterizer.destinationWidth - newWidth;
        int pixelOffset = 0;
        if (y < Rasterizer.viewportTop) {
            int yOffset = Rasterizer.viewportTop - y;
            newHeight -= yOffset;
            y = Rasterizer.viewportTop;
            pixel += yOffset * newWidth;
            rasterizerPixel += yOffset * Rasterizer.destinationWidth;
        }
        if (y + newHeight > Rasterizer.viewportBottom) {
            newHeight -= y + newHeight - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            int xOffset = Rasterizer.viewportLeft - x;
            newWidth -= xOffset;
            x = Rasterizer.viewportLeft;
            pixel += xOffset;
            rasterizerPixel += xOffset;
            pixelOffset += xOffset;
            rasterizerPixelOffset += xOffset;
        }
        if (x + newWidth > Rasterizer.viewportRight) {
            int widthOffset = x + newWidth - Rasterizer.viewportRight;
            newWidth -= widthOffset;
            pixelOffset += widthOffset;
            rasterizerPixelOffset += widthOffset;
        }
        if (newWidth > 0 && newHeight > 0) {
            ImageRGB.copyPixels(Rasterizer.destinationPixels, this.pixels, pixel, rasterizerPixel, newWidth, newHeight, rasterizerPixelOffset, pixelOffset);
        }
    }

    public void drawImageWithOpacity(int x, int y, int opacity) {
        int i = (x += this.offsetX) + (y += this.offsetY) * Rasterizer.destinationWidth;
        int i_149_ = 0;
        int i_150_ = this.imageHeight;
        int i_151_ = this.imageWidth;
        int i_152_ = Rasterizer.destinationWidth - i_151_;
        int i_153_ = 0;
        if (y < Rasterizer.viewportTop) {
            int i_154_ = Rasterizer.viewportTop - y;
            i_150_ -= i_154_;
            y = Rasterizer.viewportTop;
            i_149_ += i_154_ * i_151_;
            i += i_154_ * Rasterizer.destinationWidth;
        }
        if (y + i_150_ > Rasterizer.viewportBottom) {
            i_150_ -= y + i_150_ - Rasterizer.viewportBottom;
        }
        if (x < Rasterizer.viewportLeft) {
            int i_155_ = Rasterizer.viewportLeft - x;
            i_151_ -= i_155_;
            x = Rasterizer.viewportLeft;
            i_149_ += i_155_;
            i += i_155_;
            i_153_ += i_155_;
            i_152_ += i_155_;
        }
        if (x + i_151_ > Rasterizer.viewportRight) {
            int i_156_ = x + i_151_ - Rasterizer.viewportRight;
            i_151_ -= i_156_;
            i_153_ += i_156_;
            i_152_ += i_156_;
        }
        if (i_151_ > 0 && i_150_ > 0) {
            ImageRGB.method730(Rasterizer.destinationPixels, this.pixels, 0, i_149_, i, i_151_, i_150_, i_152_, i_153_, opacity);
        }
    }

    public void drawRotated(int x, int y, int pivotX, int pivotY, int width, int height, int zoom, double angle) {
        try {
            int centerX = -width / 2;
            int centerY = -height / 2;
            int sine = (int)(Math.sin(angle) * 65536.0);
            int cosine = (int)(Math.cos(angle) * 65536.0);
            sine = sine * zoom >> 8;
            cosine = cosine * zoom >> 8;
            int sourceOffsetX = (pivotX << 16) + centerY * sine + centerX * cosine;
            int sourceoffsetY = (pivotY << 16) + centerY * cosine - centerX * sine;
            int destinationOffset = x + y * Rasterizer.destinationWidth;
            for (y = 0; y < height; ++y) {
                int i = destinationOffset;
                int offsetX = sourceOffsetX;
                int offsetY = sourceoffsetY;
                for (x = -width; x < 0; ++x) {
                    int i_166_ = this.pixels[(offsetX >> 16) + (offsetY >> 16) * this.imageWidth];
                    if (i_166_ != 0) {
                        Rasterizer.destinationPixels[i++] = i_166_;
                    } else {
                        ++i;
                    }
                    offsetX += cosine;
                    offsetY -= sine;
                }
                sourceOffsetX += sine;
                sourceoffsetY += cosine;
                destinationOffset += Rasterizer.destinationWidth;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method732(int arg0, int arg1, int arg2, int arg3) {
        if (arg2 > 0 && arg3 > 0) {
            int i = this.imageWidth;
            int i_171_ = this.imageHeight;
            int i_172_ = 0;
            int i_173_ = 0;
            int i_174_ = this.maxWidth;
            int i_175_ = this.maxHeight;
            int i_176_ = (i_174_ << 16) / arg2;
            int i_177_ = (i_175_ << 16) / arg3;
            if (this.offsetX > 0) {
                int i_178_ = ((this.offsetX << 16) + i_176_ - 1) / i_176_;
                arg0 += i_178_;
                i_172_ += i_178_ * i_176_ - (this.offsetX << 16);
            }
            if (this.offsetY > 0) {
                int i_179_ = ((this.offsetY << 16) + i_177_ - 1) / i_177_;
                arg1 += i_179_;
                i_173_ += i_179_ * i_177_ - (this.offsetY << 16);
            }
            if (i < i_174_) {
                arg2 = ((i << 16) - i_172_ + i_176_ - 1) / i_176_;
            }
            if (i_171_ < i_175_) {
                arg3 = ((i_171_ << 16) - i_173_ + i_177_ - 1) / i_177_;
            }
            int i_180_ = arg0 + arg1 * Rasterizer.destinationWidth;
            int i_181_ = Rasterizer.destinationWidth - arg2;
            if (arg1 + arg3 > Rasterizer.viewportBottom) {
                arg3 -= arg1 + arg3 - Rasterizer.viewportBottom;
            }
            if (arg1 < Rasterizer.viewportTop) {
                int i_182_ = Rasterizer.viewportTop - arg1;
                arg3 -= i_182_;
                i_180_ += i_182_ * Rasterizer.destinationWidth;
                i_173_ += i_177_ * i_182_;
            }
            if (arg0 + arg2 > Rasterizer.viewportRight) {
                int i_183_ = arg0 + arg2 - Rasterizer.viewportRight;
                arg2 -= i_183_;
                i_181_ += i_183_;
            }
            if (arg0 < Rasterizer.viewportLeft) {
                int i_184_ = Rasterizer.viewportLeft - arg0;
                arg2 -= i_184_;
                i_180_ += i_184_;
                i_172_ += i_176_ * i_184_;
                i_181_ += i_184_;
            }
            ImageRGB.method715(Rasterizer.destinationPixels, this.pixels, 0, i_172_, i_173_, i_180_, i_181_, arg2, arg3, i_176_, i_177_, i);
        }
    }
}

