/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def.loading.rs435;

import org.runejs.client.cache.def.GameObjectDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.io.Buffer;
import org.runejs.client.language.English;

public class GameObjectDefinitionLoader
implements DefinitionLoader<GameObjectDefinition> {
    private boolean lowMemory = false;

    @Override
    public GameObjectDefinition load(GameObjectDefinition definition, Buffer data) {
        int opcode;
        while ((opcode = data.getUnsignedByte()) != 0) {
            this.readValue(definition, data, opcode);
        }
        return definition;
    }

    private void readValue(GameObjectDefinition definition, Buffer buffer, int opcode) {
        block47: {
            block62: {
                block61: {
                    block60: {
                        block59: {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block54: {
                                                block53: {
                                                    block52: {
                                                        block51: {
                                                            block50: {
                                                                block49: {
                                                                    block48: {
                                                                        block46: {
                                                                            if (opcode != 1) break block46;
                                                                            int length = buffer.getUnsignedByte();
                                                                            if (length <= 0) break block47;
                                                                            if (definition.objectModels == null || this.lowMemory) {
                                                                                definition.objectTypes = new int[length];
                                                                                definition.objectModels = new int[length];
                                                                                for (int index = 0; length > index; ++index) {
                                                                                    definition.objectModels[index] = buffer.getUnsignedShortBE();
                                                                                    definition.objectTypes[index] = buffer.getUnsignedByte();
                                                                                }
                                                                            } else {
                                                                                buffer.currentPosition += length * 3;
                                                                            }
                                                                            break block47;
                                                                        }
                                                                        if (opcode != 2) break block48;
                                                                        definition.name = buffer.getString();
                                                                        break block47;
                                                                    }
                                                                    if (opcode != 5) break block49;
                                                                    int length = buffer.getUnsignedByte();
                                                                    if (length <= 0) break block47;
                                                                    if (definition.objectModels == null || this.lowMemory) {
                                                                        definition.objectTypes = null;
                                                                        definition.objectModels = new int[length];
                                                                        for (int index = 0; length > index; ++index) {
                                                                            definition.objectModels[index] = buffer.getUnsignedShortBE();
                                                                        }
                                                                    } else {
                                                                        buffer.currentPosition += 2 * length;
                                                                    }
                                                                    break block47;
                                                                }
                                                                if (opcode != 14) break block50;
                                                                definition.sizeX = buffer.getUnsignedByte();
                                                                break block47;
                                                            }
                                                            if (opcode != 15) break block51;
                                                            definition.sizeY = buffer.getUnsignedByte();
                                                            break block47;
                                                        }
                                                        if (opcode != 17) break block52;
                                                        definition.solid = false;
                                                        break block47;
                                                    }
                                                    if (opcode != 18) break block53;
                                                    definition.walkable = false;
                                                    break block47;
                                                }
                                                if (opcode != 19) break block54;
                                                definition.hasActions = buffer.getUnsignedByte();
                                                break block47;
                                            }
                                            if (opcode != 21) break block55;
                                            definition.adjustToTerrain = true;
                                            break block47;
                                        }
                                        if (opcode != 22) break block56;
                                        definition.nonFlatShading = true;
                                        break block47;
                                    }
                                    if (opcode != 23) break block57;
                                    definition.wall = true;
                                    break block47;
                                }
                                if (opcode != 24) break block58;
                                definition.animationId = buffer.getUnsignedShortBE();
                                if (definition.animationId != 65535) break block47;
                                definition.animationId = -1;
                                break block47;
                            }
                            if (opcode != 28) break block59;
                            definition.setDecorDisplacement = buffer.getUnsignedByte();
                            break block47;
                        }
                        if (opcode != 29) break block60;
                        definition.ambient = buffer.getByte();
                        break block47;
                    }
                    if (opcode != 39) break block61;
                    definition.contrast = 5 * buffer.getByte();
                    break block47;
                }
                if (opcode < 30 || opcode >= 35) break block62;
                definition.actions[opcode - 30] = buffer.getString();
                if (!definition.actions[opcode + -30].equalsIgnoreCase(English.hidden)) break block47;
                definition.actions[opcode + -30] = null;
                break block47;
            }
            if (opcode == 40) {
                int length = buffer.getUnsignedByte();
                definition.recolorToFind = new int[length];
                definition.recolorToReplace = new int[length];
                for (int index = 0; index < length; ++index) {
                    definition.recolorToFind[index] = buffer.getUnsignedShortBE();
                    definition.recolorToReplace[index] = buffer.getUnsignedShortBE();
                }
            } else if (opcode == 60) {
                definition.icon = buffer.getUnsignedShortBE();
            } else if (opcode == 62) {
                definition.rotated = true;
            } else if (opcode == 64) {
                definition.castsShadow = false;
            } else if (opcode == 65) {
                definition.modelSizeX = buffer.getUnsignedShortBE();
            } else if (opcode == 66) {
                definition.modelSizeHeight = buffer.getUnsignedShortBE();
            } else if (opcode == 67) {
                definition.modelSizeY = buffer.getUnsignedShortBE();
            } else if (opcode == 68) {
                definition.mapSceneID = buffer.getUnsignedShortBE();
            } else if (opcode == 69) {
                definition.blockingMask = buffer.getUnsignedByte();
            } else if (opcode == 70) {
                definition.offsetX = buffer.getShortBE();
            } else if (opcode == 71) {
                definition.offsetHeight = buffer.getShortBE();
            } else if (opcode == 72) {
                definition.offsetY = buffer.getShortBE();
            } else if (opcode == 73) {
                definition.obstructsGround = true;
            } else if (opcode == 74) {
                definition.hollow = true;
            } else if (opcode == 75) {
                definition.supportsItems = buffer.getUnsignedByte();
            } else if (opcode == 77) {
                definition.varbitId = buffer.getUnsignedShortBE();
                if (definition.varbitId == 65535) {
                    definition.varbitId = -1;
                }
                definition.configId = buffer.getUnsignedShortBE();
                if (definition.configId == 65535) {
                    definition.configId = -1;
                }
                int length = buffer.getUnsignedByte();
                definition.childIds = new int[1 + length];
                for (int index = 0; index <= length; ++index) {
                    definition.childIds[index] = buffer.getUnsignedShortBE();
                    if (65535 != definition.childIds[index]) continue;
                    definition.childIds[index] = -1;
                }
            } else if (opcode == 78) {
                definition.ambientSoundId = buffer.getUnsignedShortBE();
                definition.ambientSoundHearDistance = buffer.getUnsignedByte();
            } else if (opcode == 79) {
                definition.unkn1 = buffer.getUnsignedShortBE();
                definition.unkn2 = buffer.getUnsignedShortBE();
                definition.ambientSoundHearDistance = buffer.getUnsignedByte();
                int length = buffer.getUnsignedByte();
                definition.soundEffectIds = new int[length];
                for (int index = 0; index < length; ++index) {
                    definition.soundEffectIds[index] = buffer.getUnsignedShortBE();
                }
            }
        }
    }
}

