/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.VarPlayerDefinition;
import org.runejs.client.cache.def.loading.CacheDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.VarbitDefinitionLoader;
import org.runejs.client.io.Buffer;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;
import org.runejs.client.util.BitUtils;

public class VarbitDefinition
extends CachedNode
implements CacheDefinition {
    public static DefinitionLoader<VarbitDefinition> loader = new VarbitDefinitionLoader();
    private static NodeCache varbitDefinitionCache = new NodeCache(64);
    private static CacheArchive gameDefinitionsCacheArchive;
    public static int[] varbitMasks;
    public int id;
    public int index;
    public int leastSignificantBit;
    public int mostSignificantBit;

    public static VarbitDefinition getDefinition(int id) {
        VarbitDefinition varbitDefinition = (VarbitDefinition)varbitDefinitionCache.get(id);
        if (varbitDefinition != null) {
            return varbitDefinition;
        }
        byte[] data = gameDefinitionsCacheArchive.getFile(14, id);
        varbitDefinition = new VarbitDefinition();
        varbitDefinition.id = id;
        if (data != null) {
            loader.load(varbitDefinition, new Buffer(data));
        }
        varbitDefinitionCache.put(id, varbitDefinition);
        return varbitDefinition;
    }

    public static int getVarbitValue(int varbitId) {
        VarbitDefinition varbitDefinition = VarbitDefinition.getDefinition(varbitId);
        int varPlayerIndex = varbitDefinition.index;
        int mostSignificantBit = varbitDefinition.mostSignificantBit;
        int leastSignificantBit = varbitDefinition.leastSignificantBit;
        int mask = varbitMasks[mostSignificantBit - leastSignificantBit];
        return VarPlayerDefinition.varPlayers[varPlayerIndex] >> leastSignificantBit & mask;
    }

    public static void setVarbitValue(int value, int varbitId) {
        VarbitDefinition varbitDefinition = VarbitDefinition.getDefinition(varbitId);
        int index = varbitDefinition.index;
        int leastSignificantBit = varbitDefinition.leastSignificantBit;
        int mostSignificantBit = varbitDefinition.mostSignificantBit;
        int mask = varbitMasks[mostSignificantBit + -leastSignificantBit];
        if (value < 0 || mask < value) {
            value = 0;
        }
        VarPlayerDefinition.varPlayers[index] = BitUtils.bitWiseOR(BitUtils.bitWiseAND(VarPlayerDefinition.varPlayers[index], ~(mask <<= leastSignificantBit)), BitUtils.bitWiseAND(mask, value << leastSignificantBit));
    }

    public static void initializeVarbitDefinitionCache(CacheArchive cacheArchive) {
        gameDefinitionsCacheArchive = cacheArchive;
    }

    public static void clearVarbitDefinitionCache() {
        varbitDefinitionCache.clear();
    }

    @Override
    public int getId() {
        return this.id;
    }

    static {
        varbitMasks = new int[32];
        int currentBitAsDecimal = 2;
        for (int currentBitPosition = 0; currentBitPosition < 32; ++currentBitPosition) {
            VarbitDefinition.varbitMasks[currentBitPosition] = currentBitAsDecimal - 1;
            currentBitAsDecimal += currentBitAsDecimal;
        }
    }
}

